/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som.training.basic.neighborhood;

import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MexicanHatFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodFunction;

public class NeighborhoodRBF1D
implements NeighborhoodFunction {
    private final RadialBasisFunction radial;

    public NeighborhoodRBF1D(RadialBasisFunction radial) {
        this.radial = radial;
    }

    public NeighborhoodRBF1D(RBFEnum type) {
        switch (type) {
            case Gaussian: {
                this.radial = new GaussianFunction(1);
                break;
            }
            case InverseMultiquadric: {
                this.radial = new InverseMultiquadricFunction(1);
                break;
            }
            case Multiquadric: {
                this.radial = new MultiquadricFunction(1);
                break;
            }
            case MexicanHat: {
                this.radial = new MexicanHatFunction(1);
                break;
            }
            default: {
                throw new NeuralNetworkError("Unknown RBF type: " + type.toString());
            }
        }
        this.radial.setWidth(1.0);
    }

    @Override
    public double function(int currentNeuron, int bestNeuron) {
        double[] d = new double[]{currentNeuron - bestNeuron};
        return this.radial.calculate(d);
    }

    @Override
    public double getRadius() {
        return this.radial.getWidth();
    }

    @Override
    public void setRadius(double radius) {
        this.radial.setWidth(radius);
    }
}

