/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som.training.basic;

import org.encog.mathutil.BoundMath;
import org.encog.mathutil.matrices.Matrix;
import org.encog.ml.data.MLData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.som.SOM;

public class BestMatchingUnit {
    private final SOM som;
    private double worstDistance;

    public BestMatchingUnit(SOM som) {
        this.som = som;
    }

    public int calculateBMU(MLData input) {
        int result = 0;
        if (input.size() > this.som.getInputCount()) {
            throw new NeuralNetworkError("Can't train SOM with input size of " + this.som.getInputCount() + " with input data of count " + input.size());
        }
        double lowestDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.som.getOutputCount(); ++i) {
            double distance = this.calculateEuclideanDistance(this.som.getWeights(), input, i);
            if (!(distance < lowestDistance)) continue;
            lowestDistance = distance;
            result = i;
        }
        if (lowestDistance > this.worstDistance) {
            this.worstDistance = lowestDistance;
        }
        return result;
    }

    public double calculateEuclideanDistance(Matrix matrix, MLData input, int outputNeuron) {
        double result = 0.0;
        for (int i = 0; i < input.size(); ++i) {
            double diff = input.getData(i) - matrix.get(outputNeuron, i);
            result += diff * diff;
        }
        return BoundMath.sqrt(result);
    }

    public double getWorstDistance() {
        return this.worstDistance;
    }

    public void reset() {
        this.worstDistance = Double.MIN_VALUE;
    }
}

