/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.graph.search;

import org.encog.ml.graph.BasicGraph;
import org.encog.ml.graph.BasicNode;
import org.encog.ml.graph.BasicPath;
import org.encog.ml.graph.search.AbstractGraphSearch;
import org.encog.ml.graph.search.CostEstimator;
import org.encog.ml.graph.search.SearchGoal;

public class AStarSearch
extends AbstractGraphSearch {
    private final CostEstimator estimator;

    public AStarSearch(BasicGraph theGraph, BasicNode startingPoint, SearchGoal theGoal, CostEstimator theEstimator) {
        super(theGraph, startingPoint, theGoal);
        this.estimator = theEstimator;
    }

    public CostEstimator getEstimator() {
        return this.estimator;
    }

    public double calculatePathCost(BasicPath path) {
        double result = 0.0;
        BasicNode lastNode = null;
        for (BasicNode node : path.getNodes()) {
            double hc = this.estimator.estimateCost(node, this.getGoal());
            double stepCost = 0.0;
            if (lastNode != null) {
                stepCost = lastNode.getCost(node);
            }
            result += hc + stepCost;
            lastNode = node;
        }
        return result;
    }

    @Override
    public boolean isHigherPriority(BasicPath first, BasicPath second) {
        double secondCost;
        double firstCost = this.calculatePathCost(first);
        return firstCost < (secondCost = this.calculatePathCost(second));
    }
}

