/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.RegExUtils;
import org.rssowl.core.util.ReparentInfo;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ImportAction;
import org.rssowl.ui.internal.actions.MoveCopyNewsToBinAction;
import org.rssowl.ui.internal.actions.NewBookMarkAction;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookMarkDNDImpl
extends ViewerDropAdapter
implements DragSourceListener {
    private final BookMarkExplorer fExplorer;
    private final IFolderDAO fFolderDAO;

    protected BookMarkDNDImpl(BookMarkExplorer explorer, Viewer viewer) {
        super(viewer);
        this.fExplorer = explorer;
        this.fFolderDAO = (IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class);
    }

    public void dragStart(final DragSourceEvent event) {
        if (!this.fExplorer.isGroupingEnabled()) {
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    LocalSelectionTransfer.getTransfer().setSelection(BookMarkDNDImpl.this.getNormalizedSelection());
                    LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                    event.doit = true;
                }
            });
        }
    }

    private ISelection getNormalizedSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        List selectedObjects = selection.toList();
        ArrayList<Object> draggedEntities = new ArrayList<Object>(selectedObjects.size());
        ArrayList<IFolder> draggedFolders = new ArrayList<IFolder>(selectedObjects.size());
        for (Object object : selectedObjects) {
            if (object instanceof IMark) {
                draggedEntities.add((IMark)object);
                continue;
            }
            if (!(object instanceof IFolder)) continue;
            draggedEntities.add((IFolder)object);
            draggedFolders.add((IFolder)object);
        }
        for (IFolder folder : draggedFolders) {
            CoreUtils.normalize((IFolder)folder, draggedEntities);
        }
        return new StructuredSelection(draggedEntities);
    }

    public void dragSetData(final DragSourceEvent event) {
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    BookMarkDNDImpl.this.setTextData(event);
                } else if (URLTransfer.getInstance().isSupportedType(event.dataType)) {
                    BookMarkDNDImpl.this.setURLData(event);
                }
            }
        });
    }

    private void setTextData(DragSourceEvent event) {
        StringBuilder str = new StringBuilder("");
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        List selectedObjects = selection.toList();
        for (Object selectedObject : selectedObjects) {
            if (selectedObject instanceof IBookMark) {
                IBookMark bookmark = (IBookMark)selectedObject;
                str.append(URIUtils.toHTTP((String)bookmark.getFeedLinkReference().getLinkAsText())).append("\n");
                str.append(bookmark.getName()).append("\n\n");
                continue;
            }
            if (selectedObject instanceof IFolderChild) {
                IFolderChild folderchild = (IFolderChild)selectedObject;
                str.append(folderchild.getName()).append("\n");
                continue;
            }
            if (!(selectedObject instanceof EntityGroup)) continue;
            EntityGroup entitygroup = (EntityGroup)selectedObject;
            str.append(entitygroup.getName()).append("\n");
        }
        if (str.length() > 0) {
            event.data = str.toString();
        }
    }

    private void setURLData(DragSourceEvent event) {
        StringBuilder str = new StringBuilder("");
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        List selectedObjects = selection.toList();
        for (Object selectedObject : selectedObjects) {
            if (!(selectedObject instanceof IBookMark)) continue;
            IBookMark bookmark = (IBookMark)selectedObject;
            str.append(URIUtils.toHTTP((String)bookmark.getFeedLinkReference().getLinkAsText())).append("\n");
        }
        if (str.length() > 0) {
            event.data = str.toString();
        }
    }

    public void dragFinished(DragSourceEvent event) {
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
            }
        });
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        Object currentTarget = this.getCurrentTarget();
        boolean isFolderChildsDragged = this.isFolderChildsDragged();
        if (this.fExplorer.isSortByNameEnabled()) {
            event.feedback &= 0xFFFFFFFB;
            event.feedback &= 0xFFFFFFFD;
        }
        if (this.fExplorer.isGroupingEnabled() && !(currentTarget instanceof INewsBin)) {
            event.feedback &= 0xFFFFFFFB;
            event.feedback &= 0xFFFFFFFD;
            event.feedback &= 0xFFFFFFFE;
        }
        if (currentTarget instanceof IMark && (!(currentTarget instanceof INewsBin) || isFolderChildsDragged)) {
            event.feedback &= 0xFFFFFFFE;
        }
        if (currentTarget instanceof INewsBin && !isFolderChildsDragged) {
            event.feedback &= 0xFFFFFFFB;
            event.feedback &= 0xFFFFFFFD;
        }
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType) || URLTransfer.getInstance().isSupportedType(event.currentDataType) || FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.feedback &= 0xFFFFFFFB;
            event.feedback &= 0xFFFFFFFD;
        }
        if (event.detail == 0 && URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 4;
        }
    }

    private boolean isFolderChildsDragged() {
        IStructuredSelection currentSource = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        if (currentSource != null) {
            List draggedItems = currentSource.toList();
            return this.containsFolderChilds(draggedItems);
        }
        return true;
    }

    public boolean validateDrop(final Object target, int operation, TransferData transferType) {
        if (TextTransfer.getInstance().isSupportedType(transferType) || URLTransfer.getInstance().isSupportedType(transferType) || FileTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        if (!(target instanceof IEntity)) {
            return false;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            final boolean[] result = new boolean[1];
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                    if (selection instanceof IStructuredSelection) {
                        List draggedObjects = ((IStructuredSelection)selection).toList();
                        result[0] = BookMarkDNDImpl.this.isValidDrop((IEntity)target, draggedObjects);
                    }
                }
            });
            return result[0];
        }
        return false;
    }

    private boolean isValidDrop(IEntity dropTarget, List<?> draggedObjects) {
        for (Object draggedObject : draggedObjects) {
            if (draggedObject instanceof IFolderChild && this.fExplorer.isGroupingEnabled()) {
                return false;
            }
            if (draggedObject.equals(dropTarget)) {
                return false;
            }
            if (draggedObject instanceof IFolder) {
                IFolder draggedFolder = (IFolder)draggedObject;
                if (this.isValidDrop(draggedFolder, dropTarget)) continue;
                return false;
            }
            if (draggedObject instanceof IMark) {
                IMark draggedMark = (IMark)draggedObject;
                if (this.isValidDrop(draggedMark, dropTarget)) continue;
                return false;
            }
            if (draggedObject instanceof INews) {
                INews draggedNews = (INews)draggedObject;
                return this.isValidDrop(draggedNews, dropTarget);
            }
            if (!(draggedObject instanceof EntityGroup)) continue;
            EntityGroup group = (EntityGroup)draggedObject;
            return this.isValidDrop(group, dropTarget);
        }
        return true;
    }

    private boolean isValidDrop(INews dragSource, IEntity dropTarget) {
        int loc = this.getCurrentLocation();
        if (loc == 1 || loc == 2) {
            return false;
        }
        return dropTarget instanceof INewsBin;
    }

    private boolean isValidDrop(EntityGroup group, IEntity dropTarget) {
        int loc = this.getCurrentLocation();
        if (loc == 1 || loc == 2) {
            return false;
        }
        return dropTarget instanceof INewsBin && "org.rssowl.ui.internal.editors.feed.NewsGrouping".equals(group.getCategory());
    }

    private boolean isValidDrop(IFolder dragSource, IEntity dropTarget) {
        IFolder target;
        int loc = this.getCurrentLocation();
        if (loc == 3 && dragSource.getParent().equals(dropTarget)) {
            return false;
        }
        if (this.fExplorer.isSortByNameEnabled() && (loc == 2 || loc == 1) && dropTarget instanceof IFolder && (target = (IFolder)dropTarget).getParent().containsChild((IFolderChild)dragSource)) {
            return false;
        }
        if ((this.fExplorer.isSortByNameEnabled() || this.fExplorer.isGroupingEnabled()) && dropTarget instanceof IMark && (target = (IMark)dropTarget).getParent().containsChild((IFolderChild)dragSource)) {
            return false;
        }
        return !CoreUtils.hasChildRelation((IFolder)dragSource, (IEntity)dropTarget);
    }

    private boolean isValidDrop(IMark dragSource, IEntity dropTarget) {
        IMark target;
        int loc = this.getCurrentLocation();
        if (loc == 3 && dragSource.getParent().equals(dropTarget)) {
            return false;
        }
        if (this.fExplorer.isSortByNameEnabled() && dropTarget instanceof IMark && (target = (IMark)dropTarget).getParent().containsChild((IFolderChild)dragSource)) {
            return false;
        }
        return !this.fExplorer.isSortByNameEnabled() && !this.fExplorer.isGroupingEnabled() || !(dropTarget instanceof IFolder) || loc != 2 && loc != 1 || !(target = (IFolder)dropTarget).getParent().containsChild((IFolderChild)dragSource);
    }

    private boolean containsFolderChilds(List<?> draggedObjects) {
        for (Object object : draggedObjects) {
            if (!(object instanceof IFolderChild)) continue;
            return true;
        }
        return false;
    }

    public boolean performDrop(final Object data) {
        if (data instanceof IStructuredSelection) {
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    IStructuredSelection selection = (IStructuredSelection)data;
                    List draggedObjects = selection.toList();
                    if (BookMarkDNDImpl.this.getCurrentTarget() instanceof INewsBin && !BookMarkDNDImpl.this.containsFolderChilds(draggedObjects)) {
                        BookMarkDNDImpl.this.perfromNewsDrop(draggedObjects);
                    } else {
                        BookMarkDNDImpl.this.perfromFolderChildDrop(draggedObjects);
                    }
                }
            });
            return true;
        }
        if (data instanceof String) {
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    final List urls = RegExUtils.extractLinksFromText((String)((String)data), (boolean)false);
                    if (urls.size() > 0) {
                        final IFolder parent = BookMarkDNDImpl.this.getParentFolderFromDropTarget();
                        Object dropTarget = BookMarkDNDImpl.this.getCurrentTarget();
                        final IMark position = (IMark)(dropTarget instanceof IMark ? dropTarget : null);
                        JobRunner.runInUIThread(0, true, (Widget)BookMarkDNDImpl.this.getViewer().getControl(), new Runnable(){

                            public void run() {
                                new NewBookMarkAction(BookMarkDNDImpl.this.getViewer().getControl().getShell(), parent, position, (String)urls.get(0)).run(null);
                            }
                        });
                    }
                }
            });
            return true;
        }
        if (data instanceof String[]) {
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    String strVal;
                    File file;
                    String[] strArray = (String[])data;
                    if (strArray.length != 0 && (file = new File(strVal = strArray[0])).exists() && (strVal.endsWith(".opml") || strVal.endsWith(".xml"))) {
                        final IFolder parent = BookMarkDNDImpl.this.getParentFolderFromDropTarget();
                        JobRunner.runInUIThread(0, true, (Widget)BookMarkDNDImpl.this.getViewer().getControl(), new Runnable(){

                            public void run() {
                                ImportAction action = new ImportAction();
                                action.openWizardForFileImport(BookMarkDNDImpl.this.getViewer().getControl().getShell(), parent, strVal);
                            }
                        });
                    }
                }
            });
            return true;
        }
        return false;
    }

    private IFolder getParentFolderFromDropTarget() {
        Object dropTarget = this.getCurrentTarget();
        if (dropTarget instanceof IFolder) {
            return (IFolder)dropTarget;
        }
        if (dropTarget instanceof IMark) {
            return ((IMark)dropTarget).getParent();
        }
        if (dropTarget == null) {
            return OwlUI.getSelectedBookMarkSet();
        }
        return null;
    }

    private void perfromNewsDrop(List<?> draggedObjects) {
        int operation = this.getCurrentOperation();
        INewsBin dropTarget = (INewsBin)this.getCurrentTarget();
        new MoveCopyNewsToBinAction((IStructuredSelection)new StructuredSelection(draggedObjects), dropTarget, operation == 2).run();
    }

    private void perfromFolderChildDrop(List<?> draggedObjects) {
        IFolderChild position;
        Object dropTarget = this.getCurrentTarget();
        int location = this.getCurrentLocation();
        IFolder parentFolder = null;
        boolean requireSave = false;
        boolean on = location == 3;
        IFolderChild iFolderChild = position = dropTarget != null ? (IFolderChild)dropTarget : null;
        if (on && dropTarget instanceof IFolder) {
            position = null;
        }
        Boolean after = location == 2;
        if (position == null) {
            after = null;
        }
        if (dropTarget instanceof IFolder) {
            IFolder dropFolder = (IFolder)dropTarget;
            parentFolder = on ? (IFolder)dropTarget : dropFolder.getParent();
        } else if (dropTarget instanceof IMark) {
            IMark dropMark = (IMark)dropTarget;
            parentFolder = dropMark.getParent();
        }
        if (parentFolder == null) {
            return;
        }
        ArrayList<IFolderChild> childReordering = null;
        ArrayList<ReparentInfo> reparenting = null;
        for (Object object : draggedObjects) {
            if (!(object instanceof IFolder) && !(object instanceof IMark)) continue;
            IFolderChild draggedFolderChild = (IFolderChild)object;
            if (!draggedFolderChild.getParent().equals(parentFolder)) {
                if (reparenting == null) {
                    reparenting = new ArrayList<ReparentInfo>(draggedObjects.size());
                }
                ReparentInfo reparentInfo = ReparentInfo.create((Object)draggedFolderChild, (Object)parentFolder, (Object)position, (Boolean)after);
                reparenting.add(reparentInfo);
                continue;
            }
            if (childReordering == null) {
                childReordering = new ArrayList<IFolderChild>(draggedObjects.size());
            }
            childReordering.add(draggedFolderChild);
        }
        if (reparenting != null) {
            final ArrayList<ReparentInfo> finalReparenting = reparenting;
            BusyIndicator.showWhile((Display)this.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    CoreUtils.reparentWithProperties((List)finalReparenting);
                }
            });
        }
        if (childReordering != null) {
            parentFolder.reorderChildren(childReordering, (IFolderChild)dropTarget, after);
            requireSave = true;
        }
        if (requireSave) {
            this.fFolderDAO.save((IPersistable)parentFolder);
        }
    }
}

