/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.util.ITreeNode;
import org.rssowl.ui.internal.views.explorer.BookMarkViewer;

public class WidgetTreeNode
implements ITreeNode {
    private TreeItem fItem;
    private Tree fTree;
    private TreeViewer fViewer;

    public WidgetTreeNode(Tree tree, TreeViewer viewer) {
        this.fTree = tree;
        this.fViewer = viewer;
    }

    public WidgetTreeNode(TreeItem item, TreeViewer viewer) {
        this.fItem = item;
        this.fViewer = viewer;
    }

    public ITreeNode getFirstChild() {
        if (this.isSet((Widget)this.fTree) && this.fTree.getItemCount() > 0) {
            return new WidgetTreeNode(this.fTree.getItem(0), this.fViewer);
        }
        if (this.isSet((Widget)this.fItem) && this.fItem.getItemCount() > 0) {
            return new WidgetTreeNode(this.fItem.getItem(0), this.fViewer);
        }
        return null;
    }

    public ITreeNode getLastChild() {
        int itemCount;
        if (this.isSet((Widget)this.fTree) && (itemCount = this.fTree.getItemCount()) > 0) {
            return new WidgetTreeNode(this.fTree.getItem(itemCount - 1), this.fViewer);
        }
        if (this.isSet((Widget)this.fItem) && (itemCount = this.fItem.getItemCount()) > 0) {
            return new WidgetTreeNode(this.fItem.getItem(itemCount - 1), this.fViewer);
        }
        return null;
    }

    public ITreeNode getNextSibling() {
        if (!this.isSet((Widget)this.fItem)) {
            return null;
        }
        TreeItem parent = this.fItem.getParentItem();
        if (this.isSet((Widget)parent)) {
            int index = parent.indexOf(this.fItem);
            if (parent.getItemCount() > index + 1) {
                return new WidgetTreeNode(parent.getItem(index + 1), this.fViewer);
            }
            return null;
        }
        Tree tree = this.fItem.getParent();
        int index = tree.indexOf(this.fItem);
        if (tree.getItemCount() > index + 1) {
            return new WidgetTreeNode(tree.getItem(index + 1), this.fViewer);
        }
        return null;
    }

    public ITreeNode getParent() {
        if (this.isSet((Widget)this.fTree) || !this.isSet((Widget)this.fItem)) {
            return null;
        }
        return new WidgetTreeNode(this.fItem.getParentItem(), this.fViewer);
    }

    public ITreeNode getPreviousSibling() {
        if (!this.isSet((Widget)this.fItem)) {
            return null;
        }
        TreeItem parent = this.fItem.getParentItem();
        if (this.isSet((Widget)parent)) {
            int index = parent.indexOf(this.fItem);
            if (index > 0) {
                return new WidgetTreeNode(parent.getItem(index - 1), this.fViewer);
            }
            return null;
        }
        Tree tree = this.fItem.getParent();
        int index = tree.indexOf(this.fItem);
        if (index > 0) {
            return new WidgetTreeNode(tree.getItem(index - 1), this.fViewer);
        }
        return null;
    }

    public boolean hasChildren() {
        if (this.isSet((Widget)this.fTree)) {
            return this.fTree.getItemCount() > 0;
        }
        if (this.isSet((Widget)this.fItem)) {
            if (this.fViewer instanceof BookMarkViewer && !this.fItem.getExpanded() && this.fItem.getItemCount() == 1) {
                ((BookMarkViewer)this.fViewer).createChildren((Widget)this.fItem);
            }
            return this.fItem.getItemCount() > 0;
        }
        return false;
    }

    public Object getData() {
        if (this.isSet((Widget)this.fTree)) {
            return this.fTree.getData();
        }
        if (this.isSet((Widget)this.fItem)) {
            return this.fItem.getData();
        }
        return null;
    }

    private boolean isSet(Widget item) {
        return item != null && !item.isDisposed();
    }
}

