/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeItemAdapter {
    private Tree fTree;
    private TreeItem fTreeItem;

    public TreeItemAdapter(Tree tree) {
        Assert.isNotNull((Object)tree);
        this.fTree = tree;
    }

    public TreeItemAdapter(TreeItem item) {
        Assert.isNotNull((Object)item);
        this.fTreeItem = item;
    }

    public int getItemCount() {
        if (this.fTree != null) {
            return this.fTree.getItemCount();
        }
        return this.fTreeItem.getItemCount();
    }

    public TreeItem getItem(int index) {
        if (this.fTree != null) {
            return this.fTree.getItem(index);
        }
        return this.fTreeItem.getItem(index);
    }

    public TreeItemAdapter getParent() {
        if (this.fTree != null) {
            return this;
        }
        TreeItem parentItem = this.fTreeItem.getParentItem();
        if (parentItem != null) {
            return new TreeItemAdapter(parentItem);
        }
        return new TreeItemAdapter(this.fTreeItem.getParent());
    }

    public int indexOf(TreeItem item) {
        if (this.fTree != null) {
            return this.fTree.indexOf(item);
        }
        return this.fTreeItem.indexOf(item);
    }

    public Widget getItem() {
        if (this.fTree != null) {
            return this.fTree;
        }
        return this.fTreeItem;
    }

    public void setItem(Widget item) {
        if (item instanceof Tree) {
            this.setTree((Tree)item);
        } else if (item instanceof TreeItem) {
            this.setTreeItem((TreeItem)item);
        }
    }

    private void setTree(Tree tree) {
        this.fTree = tree;
        this.fTreeItem = null;
    }

    private void setTreeItem(TreeItem treeItem) {
        this.fTreeItem = treeItem;
        this.fTree = null;
    }
}

