/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.List;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;

public class EditorUtils {
    public static IEditorReference findEditor(IEditorReference[] editorReferences, Object input) {
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            try {
                IEditorInput editorInput = reference.getEditorInput();
                if (editorInput instanceof FeedViewInput) {
                    FeedViewInput feedViewInput = (FeedViewInput)editorInput;
                    INewsMark inputObj = feedViewInput.getMark();
                    if (inputObj instanceof FolderNewsMark) {
                        inputObj = ((FolderNewsMark)inputObj).getFolder();
                    }
                    if (inputObj.equals(input)) {
                        return reference;
                    }
                }
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
        return null;
    }

    public static int getOpenEditorLimit() {
        IPreferenceScope preferences = Owl.getPreferenceService().getEclipseScope();
        boolean isLimited = preferences.getBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS);
        if (!isLimited) {
            return Integer.MAX_VALUE;
        }
        return preferences.getInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD);
    }

    public static void updateFilterAndGrouping() {
        EditorUtils.updateFilterAndGrouping(null);
    }

    public static void updateFilterAndGrouping(FeedView exception) {
        List<FeedView> feedViews = OwlUI.getFeedViews();
        for (FeedView feedView : feedViews) {
            if (((Object)((Object)feedView)).equals((Object)exception)) continue;
            feedView.updateFilterAndGrouping(true);
        }
    }

    public static void updateLayout() {
        List<FeedView> feedViews = OwlUI.getFeedViews();
        for (FeedView feedView : feedViews) {
            feedView.updateLayout();
        }
    }

    public static void updateColumns() {
        List<FeedView> feedViews = OwlUI.getFeedViews();
        for (FeedView feedView : feedViews) {
            feedView.updateColumns();
        }
    }

    public static void updateToolbarVisibility() {
        List<FeedView> feedViews = OwlUI.getFeedViews();
        for (FeedView feedView : feedViews) {
            feedView.updateToolbarVisibility();
        }
    }
}

