/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StreamGobbler;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.preferences.BrowserPreferencePage;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;
import org.rssowl.ui.internal.editors.browser.WebBrowserInput;
import org.rssowl.ui.internal.editors.browser.WebBrowserView;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.Messages;

public class BrowserUtils {
    private static String fgWebBrowser;
    private static boolean fgWebBrowserSuccessfullyOpened;

    private BrowserUtils() {
    }

    public static WebBrowserView openLinkInternal(String href, WebBrowserContext context) {
        return BrowserUtils.openLinkInternal(href, context, false);
    }

    public static WebBrowserView openLinkInternal(String href, WebBrowserContext context, boolean forceOpenInBackground) {
        WebBrowserView view;
        block9: {
            view = null;
            try {
                WebBrowserView browser;
                IPreferenceScope eclipsePreferences = Owl.getPreferenceService().getEclipseScope();
                IPreferenceScope owlPreferences = Owl.getPreferenceService().getGlobalScope();
                WebBrowserInput input = new WebBrowserInput(href, context);
                IWorkbenchPage page = OwlUI.getPage();
                if (page == null) break block9;
                boolean multipleTabs = eclipsePreferences.getBoolean(DefaultPreferences.ECLIPSE_MULTIPLE_TABS);
                boolean openInBackground = forceOpenInBackground || owlPreferences.getBoolean(DefaultPreferences.OPEN_BROWSER_IN_BACKGROUND);
                boolean reuseTab = owlPreferences.getBoolean(DefaultPreferences.ALWAYS_REUSE_BROWSER);
                if (reuseTab && (browser = OwlUI.getFirstActiveBrowser()) != null) {
                    browser.setInput(input);
                    if (!openInBackground) {
                        page.activate((IWorkbenchPart)browser);
                    }
                    return browser;
                }
                if (multipleTabs && openInBackground) {
                    IEditorPart previousActiveEditor = page.getActiveEditor();
                    page.getWorkbenchWindow().getShell().setRedraw(false);
                    try {
                        view = (WebBrowserView)page.openEditor((IEditorInput)input, "org.rssowl.ui.WebBrowser", true);
                        if (previousActiveEditor != null) {
                            page.activate((IWorkbenchPart)previousActiveEditor);
                        }
                        break block9;
                    }
                    finally {
                        page.getWorkbenchWindow().getShell().setRedraw(true);
                    }
                }
                view = (WebBrowserView)page.openEditor((IEditorInput)input, "org.rssowl.ui.WebBrowser", true);
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return view;
    }

    public static void openLinkExternal(String href) {
        String localHref;
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        if ((localHref = href).contains(" ")) {
            localHref = "\"" + localHref + "\"";
        }
        if (Owl.isStarted() && Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.USE_CUSTOM_EXTERNAL_BROWSER)) {
            BrowserUtils.useCustomBrowser(localHref);
        } else {
            BrowserUtils.useDefaultBrowser(localHref);
        }
    }

    public static void sendMail(String subject, String body) {
        BrowserUtils.sendMail(null, subject, body);
    }

    public static void sendMail(String address, String subject, String body) {
        StringBuilder str = new StringBuilder();
        str.append("mailto:");
        str.append(address != null ? URIUtils.mailToUrllEncode((String)address) : "");
        str.append("?body=");
        str.append(body != null ? URIUtils.mailToUrllEncode((String)body) : "");
        str.append("&subject=");
        str.append(subject != null ? URIUtils.mailToUrllEncode((String)subject) : "");
        BrowserUtils.openLinkExternal(str.toString());
    }

    private static Process openWebBrowser(String href) {
        Process p = null;
        if (fgWebBrowser == null) {
            try {
                fgWebBrowser = "netscape";
                p = Runtime.getRuntime().exec(String.valueOf(fgWebBrowser) + "  " + href);
            }
            catch (IOException iOException) {
                fgWebBrowser = "mozilla";
            }
        }
        if (p == null) {
            try {
                p = Runtime.getRuntime().exec(String.valueOf(fgWebBrowser) + " " + href);
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                BrowserUtils.showErrorIfExternalBrowserFails(fgWebBrowser);
            }
        }
        return p;
    }

    private static void useDefaultBrowser(final String link) {
        if (Program.launch((String)link)) {
            return;
        }
        if (Application.IS_WINDOWS) {
            BrowserUtils.showErrorIfExternalBrowserFails(null);
        } else if (Application.IS_MAC) {
            try {
                Process proc = Runtime.getRuntime().exec("/usr/bin/open " + link);
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
                errorGobbler.schedule();
                outputGobbler.schedule();
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                BrowserUtils.showErrorIfExternalBrowserFails(null);
            }
        } else {
            Thread launcher = new Thread(""){

                public void run() {
                    block11: {
                        try {
                            if (Controller.getDefault().isShuttingDown()) {
                                return;
                            }
                            if (fgWebBrowserSuccessfullyOpened) {
                                Process proc = Runtime.getRuntime().exec(String.valueOf(fgWebBrowser) + " -remote openURL(" + link + ")");
                                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
                                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
                                errorGobbler.schedule();
                                outputGobbler.schedule();
                                break block11;
                            }
                            Process proc = BrowserUtils.openWebBrowser(link);
                            fgWebBrowserSuccessfullyOpened = true;
                            if (proc != null) {
                                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
                                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
                                errorGobbler.schedule();
                                outputGobbler.schedule();
                            }
                            try {
                                try {
                                    if (proc != null) {
                                        proc.waitFor();
                                    }
                                }
                                catch (InterruptedException e) {
                                    Activator.safeLogError(e.getMessage(), e);
                                    fgWebBrowserSuccessfullyOpened = false;
                                }
                            }
                            finally {
                                fgWebBrowserSuccessfullyOpened = false;
                            }
                        }
                        catch (IOException e) {
                            Activator.safeLogError(e.getMessage(), e);
                            BrowserUtils.showErrorIfExternalBrowserFails(null);
                        }
                    }
                }
            };
            launcher.setDaemon(true);
            launcher.start();
        }
    }

    private static void showErrorIfExternalBrowserFails(final String browser) {
        final IWorkbenchWindow window = OwlUI.getWindow();
        if (window == null) {
            return;
        }
        JobRunner.runInUIThread((Widget)window.getShell(), new Runnable(){

            public void run() {
                MessageBox box = new MessageBox(window.getShell(), 296);
                box.setText(Messages.BrowserUtils_ERROR_LAUNCH_BROWSER);
                if (StringUtils.isSet((String)browser)) {
                    box.setMessage(NLS.bind((String)Messages.BrowserUtils_ERROR_LAUNCH_BROWSER_MSG_N, (Object)browser));
                } else {
                    box.setMessage(Messages.BrowserUtils_ERROR_LAUNCH_BROWSER_MSG);
                }
                if (box.open() == 32) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)window.getShell(), (String)BrowserPreferencePage.ID, null, null).open();
                }
            }
        });
    }

    private static void useCustomBrowser(final String link) {
        final String browser = Owl.getPreferenceService().getGlobalScope().getString(DefaultPreferences.CUSTOM_BROWSER_PATH);
        final String executable = String.valueOf(browser) + " " + link;
        Thread launcher = new Thread(""){

            public void run() {
                if (Controller.getDefault().isShuttingDown()) {
                    return;
                }
                try {
                    Process proc = Runtime.getRuntime().exec(executable);
                    StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
                    StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
                    errorGobbler.schedule();
                    outputGobbler.schedule();
                    proc.waitFor();
                }
                catch (IOException e) {
                    Activator.safeLogError(e.getMessage(), e);
                    BrowserUtils.showErrorIfExternalBrowserFails(browser);
                    BrowserUtils.useDefaultBrowser(link);
                }
                catch (InterruptedException e) {
                    Activator.safeLogError(e.getMessage(), e);
                }
            }
        };
        launcher.setDaemon(true);
        launcher.start();
    }

    public static void sendErrorLog() {
        String address = "crash-report@rssowl.org";
        String subject = NLS.bind((String)"RSSOwl Crash Report ({0})", (Object)CoreUtils.getUserAgent());
        String body = Messages.BrowserUtils_ATTACH_REPORT_ADVISE;
        BrowserUtils.sendMail(address, subject, body);
    }

    public static void openHelpForum(IStatus errorStatus) {
        if (errorStatus != null && errorStatus.getException() instanceof OutOfMemoryError) {
            Program.launch((String)"http://sourceforge.net/projects/rssowl/forums/forum/296910");
        } else {
            BrowserUtils.openLinkExternal("http://sourceforge.net/projects/rssowl/forums/forum/296910");
        }
    }

    public static void openFAQ(IStatus errorStatus) {
        if (errorStatus != null && errorStatus.getException() instanceof OutOfMemoryError) {
            Program.launch((String)"http://www.rssowl.org/help#item_6g");
        } else {
            BrowserUtils.openLinkExternal("http://www.rssowl.org/help#item_6");
        }
    }
}

