/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.undo.IUndoOperation;
import org.rssowl.ui.internal.undo.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOperation
implements IUndoOperation {
    private static final int LONG_RUNNING_LIMIT = 50;
    private final Map<INews.State, List<NewsReference>> fCopiedNews;
    final int fNewsCount;
    final INewsDAO fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);

    public CopyOperation(List<INews> copiednews) {
        this.fCopiedNews = CoreUtils.toStateMap(copiednews);
        this.fNewsCount = copiednews.size();
    }

    @Override
    public String getName() {
        return NLS.bind((String)Messages.CopyOperation_COPY_N, (Object)this.fNewsCount);
    }

    @Override
    public void undo() {
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        this.fNewsDao.setState((Collection)CoreUtils.resolveAll(this.fCopiedNews), INews.State.HIDDEN, false, false);
    }

    @Override
    public void redo() {
        Set<Map.Entry<INews.State, List<NewsReference>>> entries = this.fCopiedNews.entrySet();
        for (Map.Entry<INews.State, List<NewsReference>> entry : entries) {
            INews.State oldState = entry.getKey();
            List<NewsReference> newsRefs = entry.getValue();
            ArrayList<INews> resolvedNews = new ArrayList<INews>(newsRefs.size());
            for (NewsReference newsRef : newsRefs) {
                INews newsitem = newsRef.resolve();
                if (newsitem == null) continue;
                resolvedNews.add(newsitem);
            }
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            this.fNewsDao.setState(resolvedNews, oldState, false, false);
        }
    }

    @Override
    public boolean isLongRunning() {
        return this.fNewsCount > 50;
    }
}

