/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.Pair;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsBrowserViewModel {
    private final List<Item> fItemList = new ArrayList<Item>();
    private final Map<Long, Item> fNewsMap = new HashMap<Long, Item>();
    private final Map<Long, Group> fGroupMap = new HashMap<Long, Group>();
    private final Map<Long, List<Long>> fEntityGroupToNewsMap = new HashMap<Long, List<Long>>();
    private final Set<Long> fExpandedNews = new HashSet<Long>();
    private final Set<Long> fCollapsedGroups = new HashSet<Long>();
    private final Set<Long> fHiddenNews = new HashSet<Long>();
    private final Set<Long> fHiddenGroups = new HashSet<Long>();
    private final Object fLock = new Object();
    private final NewsBrowserViewer fViewer;

    public NewsBrowserViewModel(NewsBrowserViewer viewer) {
        this.fViewer = viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(Object[] elements, int pageSize) {
        Object object = this.fLock;
        synchronized (object) {
            this.fItemList.clear();
            this.fNewsMap.clear();
            this.fGroupMap.clear();
            this.fEntityGroupToNewsMap.clear();
            this.fExpandedNews.clear();
            this.fCollapsedGroups.clear();
            this.fHiddenNews.clear();
            this.fHiddenGroups.clear();
            if (elements != null && elements.length > 0) {
                int newsCounter = 0;
                ArrayList<Long> currentGroupEntryList = null;
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    Item entry = null;
                    if (element instanceof EntityGroup) {
                        EntityGroup group = (EntityGroup)element;
                        entry = new Group(group.getId());
                        this.fGroupMap.put(entry.getId(), (Group)entry);
                        currentGroupEntryList = new ArrayList<Long>();
                        this.fEntityGroupToNewsMap.put(group.getId(), currentGroupEntryList);
                        if (pageSize != 0 && newsCounter >= pageSize) {
                            this.setGroupVisible(group.getId(), false);
                        }
                    } else if (element instanceof INews) {
                        ++newsCounter;
                        INews news = (INews)element;
                        entry = new Item(news.getId());
                        this.fNewsMap.put(entry.getId(), entry);
                        if (currentGroupEntryList != null) {
                            currentGroupEntryList.add(news.getId());
                        }
                        if (pageSize != 0 && newsCounter > pageSize) {
                            this.setNewsVisible(news, false);
                        }
                    }
                    if (entry != null) {
                        this.fItemList.add(entry);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, List<Long>> getGroups() {
        Object object = this.fLock;
        synchronized (object) {
            return new HashMap<Long, List<Long>>(this.fEntityGroupToNewsMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGroup(long groupId) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fEntityGroupToNewsMap.containsKey(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNews(long newsId) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fNewsMap.containsKey(newsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupSize(long groupId) {
        Object object = this.fLock;
        synchronized (object) {
            List<Long> entries = this.fEntityGroupToNewsMap.get(groupId);
            return entries != null ? entries.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getNewsIds(long groupId) {
        Object object = this.fLock;
        synchronized (object) {
            List<Long> newsIds = this.fEntityGroupToNewsMap.get(groupId);
            return newsIds != null ? new ArrayList<Long>(newsIds) : Collections.EMPTY_LIST;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewsExpanded(INews news) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fExpandedNews.contains(news.getId());
        }
    }

    public boolean isNewsVisible(INews news) {
        return news.getId() != null && this.isNewsVisible(news.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewsVisible(long newsId) {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fHiddenNews.contains(newsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGroupExpanded(long groupId) {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fCollapsedGroups.contains(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGroupVisible(long groupId) {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fHiddenGroups.contains(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpandedNews() {
        Object object = this.fLock;
        synchronized (object) {
            if (!this.fExpandedNews.isEmpty()) {
                return this.fExpandedNews.iterator().next();
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewsExpanded(INews news, boolean expanded) {
        Object object = this.fLock;
        synchronized (object) {
            if (expanded) {
                this.fExpandedNews.add(news.getId());
            } else {
                this.fExpandedNews.remove(news.getId());
            }
        }
    }

    public void setNewsVisible(INews news, boolean visible) {
        if (news.getId() != null) {
            this.setNewsVisible(news.getId(), visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewsVisible(long newsId, boolean visible) {
        Object object = this.fLock;
        synchronized (object) {
            if (visible) {
                this.fHiddenNews.remove(newsId);
            } else {
                this.fHiddenNews.add(newsId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOfNewsItem(long newsId) {
        Object object = this.fLock;
        synchronized (object) {
            int i = 0;
            while (i < this.fItemList.size()) {
                Item item = this.fItemList.get(i);
                if (!(item instanceof Group) && item.getId() == newsId) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupVisible(long groupId, boolean visible) {
        Object object = this.fLock;
        synchronized (object) {
            if (visible) {
                this.fHiddenGroups.remove(groupId);
            } else {
                this.fHiddenGroups.add(groupId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupExpanded(long groupId, boolean expanded) {
        Object object = this.fLock;
        synchronized (object) {
            if (expanded) {
                this.fCollapsedGroups.remove(groupId);
            } else {
                this.fCollapsedGroups.add(groupId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findGroup(long newsId) {
        Object object = this.fLock;
        synchronized (object) {
            Set<Map.Entry<Long, List<Long>>> entries = this.fEntityGroupToNewsMap.entrySet();
            for (Map.Entry<Long, List<Long>> entry : entries) {
                List<Long> newsInGroup = entry.getValue();
                if (!newsInGroup.contains(newsId)) continue;
                return entry.getKey();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirstItemUnread() {
        Object object = this.fLock;
        synchronized (object) {
            if (!this.fItemList.isEmpty()) {
                Item item = this.fItemList.get(0);
                return this.isUnread(item);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasItems() {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fItemList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHiddenNews() {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fHiddenNews.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewsCount() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fItemList.size() - this.fEntityGroupToNewsMap.keySet().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVisibleNewsCount() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fItemList.size() - this.fEntityGroupToNewsMap.keySet().size() - this.fHiddenNews.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getVisibleUnreadNews() {
        ArrayList<Long> visibleUnreadNewsIds = new ArrayList<Long>();
        Object object = this.fLock;
        synchronized (object) {
            for (Item item : this.fItemList) {
                if (item instanceof Group) continue;
                if (!this.isNewsVisible(item.getId())) break;
                if (this.isNewsInCollapsedGroup(item.getId()) || !this.isUnread(item)) continue;
                visibleUnreadNewsIds.add(item.getId());
            }
        }
        return visibleUnreadNewsIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isNewsInCollapsedGroup(long newsId) {
        Object object = this.fLock;
        synchronized (object) {
            Long groupId;
            Iterator<Long> iterator = this.fCollapsedGroups.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.fEntityGroupToNewsMap.get(groupId = iterator.next()).contains(newsId));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstHiddenNews(boolean onlyUnread) {
        Object object = this.fLock;
        synchronized (object) {
            block6: {
                if (!this.fHiddenNews.isEmpty()) break block6;
                return -1L;
            }
            int i = 0;
            while (i < this.fItemList.size()) {
                Item item = this.fItemList.get(i);
                if (!(item instanceof Group || this.isNewsVisible(item.getId()) || onlyUnread && !this.isUnread(item))) {
                    return item.getId();
                }
                ++i;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastVisibleNews() {
        Item lastVisibleNews = null;
        Object object = this.fLock;
        synchronized (object) {
            int i = 0;
            while (i < this.fItemList.size()) {
                Item item = this.fItemList.get(i);
                if (!(item instanceof Group)) {
                    if (!this.isNewsVisible(item.getId())) break;
                    lastVisibleNews = item;
                }
                ++i;
            }
        }
        return lastVisibleNews != null ? lastVisibleNews.getId() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastNews() {
        Object object = this.fLock;
        synchronized (object) {
            int i = this.fItemList.size() - 1;
            while (i >= 0) {
                Item item = this.fItemList.get(i);
                if (!(item instanceof Group)) {
                    return item.getId();
                }
                --i;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeNews(INews news) {
        Object object = this.fLock;
        synchronized (object) {
            this.fHiddenNews.remove(news.getId());
            Item item = this.fNewsMap.get(news.getId());
            if (item != null) {
                this.fItemList.remove(item);
                this.fNewsMap.remove(item.getId());
            }
            this.fExpandedNews.remove(news.getId());
            Set<Map.Entry<Long, List<Long>>> entries = this.fEntityGroupToNewsMap.entrySet();
            for (Map.Entry<Long, List<Long>> entry : entries) {
                Long groupId = entry.getKey();
                List<Long> newsInGroup = entry.getValue();
                if (!newsInGroup.contains(news.getId())) continue;
                newsInGroup.remove(news.getId());
                if (newsInGroup.isEmpty()) {
                    this.fEntityGroupToNewsMap.remove(groupId);
                    this.fCollapsedGroups.remove(groupId);
                    this.fHiddenGroups.remove(groupId);
                    Group group = this.fGroupMap.get(groupId);
                    if (group != null) {
                        this.fItemList.remove(group);
                        this.fGroupMap.remove(group.getId());
                    }
                }
                return groupId;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextNews(boolean unread, long offset) {
        Object object = this.fLock;
        synchronized (object) {
            int nextIndex;
            Item item = new Item(offset);
            int i = nextIndex = offset != -1L && this.fItemList.contains(item) ? this.fItemList.indexOf(item) + 1 : 0;
            while (i < this.fItemList.size()) {
                Item nextItem = this.fItemList.get(i);
                if (!(nextItem instanceof Group || unread && !this.isUnread(nextItem))) {
                    return nextItem.getId();
                }
                ++i;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long previousNews(boolean unread, long offset) {
        Object object = this.fLock;
        synchronized (object) {
            int previousIndex;
            Item item = new Item(offset);
            int i = previousIndex = offset != -1L && this.fItemList.contains(item) ? this.fItemList.indexOf(item) - 1 : this.fItemList.size() - 1;
            while (i >= 0 && i < this.fItemList.size()) {
                Item previousItem = this.fItemList.get(i);
                if (!(previousItem instanceof Group || unread && !this.isUnread(previousItem))) {
                    return previousItem.getId();
                }
                --i;
            }
        }
        return -1L;
    }

    private boolean isUnread(Item item) {
        if (item instanceof Group) {
            return false;
        }
        INews news = this.fViewer != null ? this.fViewer.resolve(item.getId()) : (INews)DynamicDAO.load(INews.class, (long)item.getId());
        if (news == null) {
            return false;
        }
        switch (news.getState()) {
            case NEW: 
            case UNREAD: 
            case UPDATED: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<Long>, List<Long>> getNextPage(int pageSize) {
        ArrayList<Long> groups = new ArrayList<Long>(1);
        ArrayList<Long> news = new ArrayList<Long>(pageSize);
        if (pageSize != 0) {
            Object object = this.fLock;
            synchronized (object) {
                int indexOfFirstHiddenItem = this.indexOfFirstHiddenItem(-1L);
                if (indexOfFirstHiddenItem != -1) {
                    int newsCounter = 0;
                    int i = indexOfFirstHiddenItem;
                    while (i < this.fItemList.size()) {
                        Item item = this.fItemList.get(i);
                        if (item instanceof Group) {
                            groups.add(item.getId());
                        } else {
                            ++newsCounter;
                            news.add(item.getId());
                        }
                        if (newsCounter == pageSize) break;
                        ++i;
                    }
                }
            }
        }
        return Pair.create(groups, news);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<Long>, List<Long>> revealPage(long newsId, int pageSize) {
        ArrayList<Long> groups = new ArrayList<Long>(1);
        ArrayList<Long> news = new ArrayList<Long>();
        if (pageSize != 0) {
            Object object = this.fLock;
            synchronized (object) {
                int indexOfFirstHiddenItem = this.indexOfFirstHiddenItem(newsId);
                if (indexOfFirstHiddenItem != -1) {
                    int newsCounter = 0;
                    int i = indexOfFirstHiddenItem;
                    while (i < this.fItemList.size()) {
                        Item item = this.fItemList.get(i);
                        if (item instanceof Group) {
                            groups.add(item.getId());
                        } else {
                            ++newsCounter;
                            news.add(item.getId());
                        }
                        if (news.contains(newsId) && newsCounter % pageSize == 0) break;
                        ++i;
                    }
                }
            }
        }
        return Pair.create(groups, news);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexOfFirstHiddenItem(long toId) {
        Object object = this.fLock;
        synchronized (object) {
            block6: {
                if (!this.fHiddenNews.isEmpty() || !this.fHiddenGroups.isEmpty()) break block6;
                return -1;
            }
            int i = 0;
            while (i < this.fItemList.size()) {
                Item item = this.fItemList.get(i);
                if (!this.isVisible(item)) {
                    return i;
                }
                if (toId != -1L && toId == item.getId()) break;
                ++i;
            }
        }
        return -1;
    }

    private boolean isVisible(Item item) {
        if (item instanceof Group) {
            return this.isGroupVisible(item.getId());
        }
        return this.isNewsVisible(item.getId());
    }

    private static class Group
    extends Item {
        public Group(long id) {
            super(id);
        }
    }

    private static class Item {
        private final long fId;

        public Item(long id) {
            this.fId = id;
        }

        public long getId() {
            return this.fId;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.fId ^ this.fId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return this.fId == other.fId;
        }
    }
}

