/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.ITask;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.TaskAdapter;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.SearchMarkDialog;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.editors.feed.NewsTableControl;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.JobTracker;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;

public class FilterBar {
    private static final String FILTER_ACTION = "org.rssowl.ui.internal.editors.feed.FilterAction";
    private static final String GROUP_ACTION = "org.rssowl.ui.internal.editors.feed.GroupAction";
    private static final String LAYOUT_ACTION = "org.rssowl.ui.internal.editors.feed.LayoutAction";
    private static final String QUICKSEARCH_ACTION = "org.rssowl.ui.internal.editors.feed.QuickSearchAction";
    private Composite fParent;
    private Composite fContainer;
    private ToolBarManager fFilterGroupingLayoutToolBarManager;
    private ToolBarManager fClearQuicksearchToolBar;
    private ToolBarManager fHighlightToolBarManager;
    private IAction fHighlightSearchAction;
    private FeedView fFeedView;
    private JobTracker fQuickSearchTracker;
    private Text fSearchInput;
    private IPreferenceScope fGlobalPreferences;
    private boolean fBlockRefresh;
    private NewsFilter.Type fLastFilterType;
    private NewsGrouping.Type fLastGroupType;
    private boolean fSearchSelectAllOnce = true;

    public FilterBar(FeedView feedView, Composite parent) {
        this.fFeedView = feedView;
        this.fParent = parent;
        this.fQuickSearchTracker = new JobTracker(500, false, true, ITask.Priority.SHORT);
        this.fGlobalPreferences = Owl.getPreferenceService().getGlobalScope();
        this.createControl();
    }

    boolean isVisible() {
        IPreferenceScope globalScope = Owl.getPreferenceService().getGlobalScope();
        boolean hideFilterBar = globalScope.getBoolean(DefaultPreferences.FV_FEED_TOOLBAR_HIDDEN);
        return !hideFilterBar;
    }

    private boolean isListLayout() {
        return this.getLayout() == OwlUI.Layout.LIST;
    }

    private OwlUI.Layout getLayout() {
        FeedViewInput input = (FeedViewInput)this.fFeedView.getEditorInput();
        if (input != null) {
            return OwlUI.getLayout(Owl.getPreferenceService().getEntityScope((IEntity)input.getMark()));
        }
        return OwlUI.getLayout(this.fGlobalPreferences);
    }

    private boolean isSearchMark() {
        FeedViewInput input = (FeedViewInput)this.fFeedView.getEditorInput();
        return input != null && input.getMark() instanceof ISearchMark;
    }

    public void clearQuickSearch(boolean refresh) {
        this.setSearchControlsVisible(false);
        if (this.fSearchInput.getText().length() != 0) {
            this.fBlockRefresh = !refresh;
            try {
                this.fSearchInput.setText("");
            }
            finally {
                this.fBlockRefresh = false;
            }
        }
    }

    public void focusQuickSearch() {
        this.fSearchInput.setFocus();
    }

    private void createControl() {
        this.fContainer = new Composite(this.fParent, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(5, 3, 0, 0, 0, false));
        this.fContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.updateVisibility();
        this.fFilterGroupingLayoutToolBarManager = new ToolBarManager(0x820000);
        this.createFilterBar();
        this.createGrouperBar();
        this.createLayoutBar();
        this.fFilterGroupingLayoutToolBarManager.createControl(this.fContainer);
        this.fFilterGroupingLayoutToolBarManager.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.createQuickSearch(this.fContainer);
    }

    void updateVisibility() {
        boolean isVisible = this.isVisible();
        ((GridData)this.fContainer.getLayoutData()).exclude = !isVisible;
        this.fContainer.setVisible(isVisible);
    }

    private boolean setHighlight(boolean enabled) {
        if (this.isListLayout()) {
            return false;
        }
        boolean isHighlightEnabled = this.fGlobalPreferences.getBoolean(DefaultPreferences.FV_HIGHLIGHT_SEARCH_RESULTS);
        if (enabled == isHighlightEnabled) {
            return false;
        }
        this.fGlobalPreferences.putBoolean(DefaultPreferences.FV_HIGHLIGHT_SEARCH_RESULTS, !isHighlightEnabled);
        this.fHighlightSearchAction.setChecked(!isHighlightEnabled);
        return true;
    }

    private void createQuickSearch(Composite parent) {
        ToolBar toolBar;
        Composite searchContainer = new Composite(parent, 0);
        searchContainer.setLayout((Layout)LayoutUtils.createGridLayout(OwlUI.needsCancelControl() ? 4 : 3, 0, 0, 0, 0, false));
        ((GridLayout)searchContainer.getLayout()).marginTop = 1;
        searchContainer.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)searchContainer.getLayoutData()).widthHint = 280;
        final ToolBarManager manager = new ToolBarManager(0x800000);
        final NewsFilter filter = this.fFeedView.getFilter();
        Action quickSearch = new Action(Messages.FilterBar_QUICK_SEARCH, 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, manager);
            }

            public String getId() {
                return FilterBar.QUICKSEARCH_ACTION;
            }
        };
        quickSearch.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/find.gif"));
        quickSearch.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Menu menu = new Menu(parent);
                final MenuItem searchHeadline = new MenuItem(menu, 16);
                searchHeadline.setText(NewsFilter.SearchTarget.HEADLINE.getName());
                searchHeadline.setSelection(NewsFilter.SearchTarget.HEADLINE == filter.getSearchTarget());
                searchHeadline.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchHeadline.getSelection() && filter.getSearchTarget() != NewsFilter.SearchTarget.HEADLINE) {
                            FilterBar.this.doSearch(NewsFilter.SearchTarget.HEADLINE);
                        }
                    }
                });
                final MenuItem searchEntireNews = new MenuItem(menu, 16);
                searchEntireNews.setText(NewsFilter.SearchTarget.ALL.getName());
                searchEntireNews.setSelection(NewsFilter.SearchTarget.ALL == filter.getSearchTarget());
                searchEntireNews.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchEntireNews.getSelection() && filter.getSearchTarget() != NewsFilter.SearchTarget.ALL) {
                            FilterBar.this.doSearch(NewsFilter.SearchTarget.ALL);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem searchAuthor = new MenuItem(menu, 16);
                searchAuthor.setText(NewsFilter.SearchTarget.AUTHOR.getName());
                searchAuthor.setSelection(NewsFilter.SearchTarget.AUTHOR == filter.getSearchTarget());
                searchAuthor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchAuthor.getSelection() && filter.getSearchTarget() != NewsFilter.SearchTarget.AUTHOR) {
                            FilterBar.this.doSearch(NewsFilter.SearchTarget.AUTHOR);
                        }
                    }
                });
                final MenuItem searchCategory = new MenuItem(menu, 16);
                searchCategory.setText(NewsFilter.SearchTarget.CATEGORY.getName());
                searchCategory.setSelection(NewsFilter.SearchTarget.CATEGORY == filter.getSearchTarget());
                searchCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchCategory.getSelection() && filter.getSearchTarget() != NewsFilter.SearchTarget.CATEGORY) {
                            FilterBar.this.doSearch(NewsFilter.SearchTarget.CATEGORY);
                        }
                    }
                });
                final MenuItem searchSource = new MenuItem(menu, 16);
                searchSource.setText(NewsFilter.SearchTarget.SOURCE.getName());
                searchSource.setSelection(NewsFilter.SearchTarget.SOURCE == filter.getSearchTarget());
                searchSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchSource.getSelection() && filter.getSearchTarget() != NewsFilter.SearchTarget.SOURCE) {
                            FilterBar.this.doSearch(NewsFilter.SearchTarget.SOURCE);
                        }
                    }
                });
                final MenuItem searchAttachments = new MenuItem(menu, 16);
                searchAttachments.setText(NewsFilter.SearchTarget.ATTACHMENTS.getName());
                searchAttachments.setSelection(NewsFilter.SearchTarget.ATTACHMENTS == filter.getSearchTarget());
                searchAttachments.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchAttachments.getSelection() && filter.getSearchTarget() != NewsFilter.SearchTarget.ATTACHMENTS) {
                            FilterBar.this.doSearch(NewsFilter.SearchTarget.ATTACHMENTS);
                        }
                    }
                });
                final MenuItem searchLabels = new MenuItem(menu, 16);
                searchLabels.setText(NewsFilter.SearchTarget.LABELS.getName());
                searchLabels.setSelection(NewsFilter.SearchTarget.LABELS == filter.getSearchTarget());
                searchLabels.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchLabels.getSelection() && filter.getSearchTarget() != NewsFilter.SearchTarget.LABELS) {
                            FilterBar.this.doSearch(NewsFilter.SearchTarget.LABELS);
                        }
                    }
                });
                INewsMark inputMark = ((FeedViewInput)FilterBar.this.fFeedView.getEditorInput()).getMark();
                if (inputMark instanceof IBookMark || inputMark instanceof INewsBin || inputMark instanceof FolderNewsMark) {
                    new MenuItem(menu, 2);
                    MenuItem createSavedSearch = new MenuItem(menu, 16);
                    createSavedSearch.setText(Messages.FilterBar_SAVE_SEARCH);
                    createSavedSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            FilterBar.this.onCreateSavedSearch(true);
                        }
                    });
                }
                return menu;
            }
        });
        manager.add((IAction)quickSearch);
        manager.createControl(searchContainer);
        this.fSearchInput = new Text(searchContainer, 2436);
        this.fSearchInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fSearchInput.setMessage(this.fFeedView.getFilter().getSearchTarget().getName());
        Controller.getDefault().getContextService().registerInputField((Control)this.fSearchInput);
        this.fSearchInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    FilterBar.this.clearQuickSearch(true);
                    FilterBar.this.fFeedView.handleQuicksearchTraversalEvent(4, true);
                }
            }
        });
        this.fSearchInput.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 || e.detail == 512 || e.detail == 256) {
                    e.doit = false;
                    FilterBar.this.fFeedView.handleQuicksearchTraversalEvent(e.detail, false);
                }
            }
        });
        this.fSearchInput.addModifyListener(new ModifyListener(){
            private boolean highlightChanged = false;

            public void modifyText(ModifyEvent e) {
                if (FilterBar.this.fSearchInput.getText().length() == 0 && FilterBar.this.fFeedView.getFilter().isPatternSet()) {
                    FilterBar.this.fFeedView.getFilter().setPattern(FilterBar.this.fSearchInput.getText());
                    if (!FilterBar.this.fBlockRefresh) {
                        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                            public void run() {
                                if (highlightChanged) {
                                    FilterBar.this.setHighlight(false);
                                    highlightChanged = false;
                                }
                                if (FilterBar.this.needsCacheRevalidationFromSearch()) {
                                    FilterBar.this.fFeedView.revalidateCaches();
                                }
                                FilterBar.this.fFeedView.refresh(true, false);
                            }
                        });
                    }
                    FilterBar.this.setSearchControlsVisible(false);
                } else if (FilterBar.this.fSearchInput.getText().length() > 0) {
                    FilterBar.this.fQuickSearchTracker.run((ITask)new TaskAdapter(){

                        public IStatus run(IProgressMonitor monitor) {
                            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                                public void run() {
                                    if (FilterBar.this.setHighlight(true)) {
                                        highlightChanged = true;
                                    }
                                    FilterBar.this.fFeedView.getFilter().setPattern(FilterBar.this.fSearchInput.getText());
                                    if (FilterBar.this.needsCacheRevalidationFromSearch()) {
                                        FilterBar.this.fFeedView.revalidateCaches();
                                    }
                                    FilterBar.this.fFeedView.refresh(true, false);
                                    FilterBar.this.updateBrowserSelection();
                                }
                            });
                            FilterBar.this.setSearchControlsVisible(true);
                            return Status.OK_STATUS;
                        }
                    });
                }
            }
        });
        this.fSearchInput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                FilterBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(true);
                FilterBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(true);
                FilterBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                FilterBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(false);
                FilterBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(false);
                FilterBar.this.fFeedView.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(false);
                FilterBar.this.fSearchSelectAllOnce = true;
            }
        });
        this.fSearchInput.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (FilterBar.this.fSearchSelectAllOnce && FilterBar.this.fSearchInput.getSelectionCount() == 0) {
                    FilterBar.this.fSearchInput.selectAll();
                }
                FilterBar.this.fSearchSelectAllOnce = false;
            }
        });
        if (OwlUI.needsCancelControl()) {
            toolBar = new ToolBar(searchContainer, 0x800100);
            this.fClearQuicksearchToolBar = new ToolBarManager(toolBar);
            toolBar.setBackground(parent.getBackground());
            toolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
            ((GridData)toolBar.getLayoutData()).exclude = true;
            toolBar.setVisible(false);
            Action clearTextAction = new Action("", 1){

                public void run() {
                    FilterBar.this.clearQuickSearch(true);
                    FilterBar.this.fFeedView.handleQuicksearchTraversalEvent(4, true);
                }
            };
            clearTextAction.setToolTipText(Messages.FilterBar_CLEAR);
            clearTextAction.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/clear.gif"));
            this.fClearQuicksearchToolBar.add((IAction)clearTextAction);
            this.fClearQuicksearchToolBar.update(false);
        }
        toolBar = new ToolBar(searchContainer, 0x800100);
        this.fHighlightToolBarManager = new ToolBarManager(toolBar);
        toolBar.setBackground(parent.getBackground());
        toolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)toolBar.getLayoutData()).horizontalIndent = 2;
        boolean show = this.isSearchMark() && !this.isListLayout();
        ((GridData)toolBar.getLayoutData()).exclude = !show;
        toolBar.setVisible(show);
        this.fHighlightSearchAction = new Action(Messages.FilterBar_HIGHLIGHT, 2){

            public void run() {
                FilterBar.this.fGlobalPreferences.putBoolean(DefaultPreferences.FV_HIGHLIGHT_SEARCH_RESULTS, this.isChecked());
                if (FilterBar.this.fFeedView.isBrowserViewerVisible()) {
                    FilterBar.this.fFeedView.getNewsBrowserControl().getViewer().refresh();
                }
            }
        };
        this.fHighlightSearchAction.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/highlight.gif"));
        this.fHighlightSearchAction.setToolTipText(Messages.FilterBar_HIGHLIGHT);
        this.fHighlightSearchAction.setChecked(this.fGlobalPreferences.getBoolean(DefaultPreferences.FV_HIGHLIGHT_SEARCH_RESULTS));
        this.fHighlightToolBarManager.add(this.fHighlightSearchAction);
        this.fHighlightToolBarManager.update(false);
    }

    private void updateBrowserSelection() {
        NewsTableControl newsTable;
        if (this.fFeedView.isTableViewerVisible() && this.fFeedView.isBrowserViewerVisible() && this.fFeedView.isBrowserShowingNews() && (newsTable = this.fFeedView.getNewsTableControl()).getViewer().getSelection().isEmpty()) {
            this.fFeedView.getNewsBrowserControl().setPartInput(null);
        }
    }

    void setSearchControlsVisible(boolean visible) {
        if (!this.isVisible()) {
            return;
        }
        boolean layout = false;
        if (this.fClearQuicksearchToolBar != null && !this.fClearQuicksearchToolBar.getControl().isDisposed() && ((GridData)this.fClearQuicksearchToolBar.getControl().getLayoutData()).exclude == visible) {
            ((GridData)this.fClearQuicksearchToolBar.getControl().getLayoutData()).exclude = !visible;
            this.fClearQuicksearchToolBar.getControl().setVisible(visible);
            layout = true;
        }
        if (this.isListLayout()) {
            visible = false;
        } else if (this.isSearchMark()) {
            visible = true;
        }
        if (this.fHighlightToolBarManager != null && !this.fHighlightToolBarManager.getControl().isDisposed() && ((GridData)this.fHighlightToolBarManager.getControl().getLayoutData()).exclude == visible) {
            ((GridData)this.fHighlightToolBarManager.getControl().getLayoutData()).exclude = !visible;
            this.fHighlightToolBarManager.getControl().setVisible(visible);
            layout = true;
        }
        if (layout) {
            this.fSearchInput.getParent().layout();
        }
    }

    private void createFilterBar() {
        final NewsFilter filter = this.fFeedView.getFilter();
        Action newsFilterAction = new Action(Messages.FilterBar_FILTER_NEWS, 4){

            public void run() {
                if (filter.getType() != NewsFilter.Type.SHOW_ALL) {
                    FilterBar.this.onFilter(NewsFilter.Type.SHOW_ALL);
                } else if (FilterBar.this.fLastFilterType != null) {
                    FilterBar.this.onFilter(FilterBar.this.fLastFilterType);
                } else {
                    OwlUI.positionDropDownMenu(this, FilterBar.this.fFilterGroupingLayoutToolBarManager);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                if (filter.getType() == NewsFilter.Type.SHOW_ALL) {
                    return OwlUI.FILTER;
                }
                return OwlUI.getImageDescriptor("icons/etool16/filter_active.gif");
            }

            public String getText() {
                return filter.getType().getDisplayName();
            }
        };
        newsFilterAction.setId(FILTER_ACTION);
        ActionContributionItem item = new ActionContributionItem((IAction)newsFilterAction);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.fFilterGroupingLayoutToolBarManager.add((IContributionItem)item);
        newsFilterAction.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Menu menu = new Menu(parent);
                final MenuItem showAll = new MenuItem(menu, 16);
                showAll.setText(NewsFilter.Type.SHOW_ALL.getName());
                showAll.setSelection(NewsFilter.Type.SHOW_ALL == filter.getType());
                showAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showAll.getSelection() && filter.getType() != NewsFilter.Type.SHOW_ALL) {
                            FilterBar.this.onFilter(NewsFilter.Type.SHOW_ALL);
                        }
                    }
                });
                menu.setDefaultItem(showAll);
                new MenuItem(menu, 2);
                final MenuItem showNew = new MenuItem(menu, 16);
                showNew.setText(NewsFilter.Type.SHOW_NEW.getName());
                showNew.setSelection(NewsFilter.Type.SHOW_NEW == filter.getType());
                showNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showNew.getSelection() && filter.getType() != NewsFilter.Type.SHOW_NEW) {
                            FilterBar.this.onFilter(NewsFilter.Type.SHOW_NEW);
                        }
                    }
                });
                final MenuItem showUnread = new MenuItem(menu, 16);
                showUnread.setText(NewsFilter.Type.SHOW_UNREAD.getName());
                showUnread.setSelection(NewsFilter.Type.SHOW_UNREAD == filter.getType());
                showUnread.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showUnread.getSelection() && filter.getType() != NewsFilter.Type.SHOW_UNREAD) {
                            FilterBar.this.onFilter(NewsFilter.Type.SHOW_UNREAD);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem showSticky = new MenuItem(menu, 16);
                showSticky.setText(NewsFilter.Type.SHOW_STICKY.getName());
                showSticky.setSelection(NewsFilter.Type.SHOW_STICKY == filter.getType());
                showSticky.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showSticky.getSelection() && filter.getType() != NewsFilter.Type.SHOW_STICKY) {
                            FilterBar.this.onFilter(NewsFilter.Type.SHOW_STICKY);
                        }
                    }
                });
                final MenuItem showLabeled = new MenuItem(menu, 16);
                showLabeled.setText(NewsFilter.Type.SHOW_LABELED.getName());
                showLabeled.setSelection(NewsFilter.Type.SHOW_LABELED == filter.getType());
                showLabeled.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showLabeled.getSelection() && filter.getType() != NewsFilter.Type.SHOW_LABELED) {
                            FilterBar.this.onFilter(NewsFilter.Type.SHOW_LABELED);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem showRecent = new MenuItem(menu, 16);
                showRecent.setText(NewsFilter.Type.SHOW_RECENT.getName());
                showRecent.setSelection(NewsFilter.Type.SHOW_RECENT == filter.getType());
                showRecent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showRecent.getSelection() && filter.getType() != NewsFilter.Type.SHOW_RECENT) {
                            FilterBar.this.onFilter(NewsFilter.Type.SHOW_RECENT);
                        }
                    }
                });
                final MenuItem showLastFiveDays = new MenuItem(menu, 16);
                showLastFiveDays.setText(NewsFilter.Type.SHOW_LAST_5_DAYS.getName());
                showLastFiveDays.setSelection(NewsFilter.Type.SHOW_LAST_5_DAYS == filter.getType());
                showLastFiveDays.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (showLastFiveDays.getSelection() && filter.getType() != NewsFilter.Type.SHOW_LAST_5_DAYS) {
                            FilterBar.this.onFilter(NewsFilter.Type.SHOW_LAST_5_DAYS);
                        }
                    }
                });
                INewsMark inputMark = ((FeedViewInput)FilterBar.this.fFeedView.getEditorInput()).getMark();
                if (inputMark instanceof IBookMark || inputMark instanceof INewsBin || inputMark instanceof FolderNewsMark) {
                    new MenuItem(menu, 2);
                    MenuItem createSavedSearch = new MenuItem(menu, 16);
                    createSavedSearch.setText(Messages.FilterBar_SAVE_SEARCH);
                    createSavedSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            FilterBar.this.onCreateSavedSearch(false);
                        }
                    });
                }
                return menu;
            }
        });
    }

    private void onCreateSavedSearch(boolean withQuickSearch) {
        IModelFactory factory = Owl.getModelFactory();
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(2);
        ArrayList<IFolderChild> searchScope = new ArrayList<IFolderChild>(1);
        searchScope.add((IFolderChild)((FeedViewInput)this.fFeedView.getEditorInput()).getMark());
        ISearchField field = factory.createSearchField(19, INews.class.getName());
        conditions.add(factory.createSearchCondition(field, SearchSpecifier.SCOPE, (Object)ModelUtils.toPrimitive(searchScope)));
        NewsFilter.Type filterType = this.fFeedView.getFilter().getType();
        switch (filterType) {
            case SHOW_ALL: {
                if (withQuickSearch) break;
                field = factory.createSearchField(-1, INews.class.getName());
                conditions.add(factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)""));
                break;
            }
            case SHOW_NEW: {
                field = factory.createSearchField(14, INews.class.getName());
                conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS, EnumSet.of(INews.State.NEW)));
                break;
            }
            case SHOW_RECENT: {
                field = factory.createSearchField(18, INews.class.getName());
                conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS_LESS_THAN, (Object)2));
                break;
            }
            case SHOW_LAST_5_DAYS: {
                field = factory.createSearchField(18, INews.class.getName());
                conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS_LESS_THAN, (Object)6));
                break;
            }
            case SHOW_STICKY: {
                field = factory.createSearchField(13, INews.class.getName());
                conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS, (Object)true));
                break;
            }
            case SHOW_LABELED: {
                field = factory.createSearchField(15, INews.class.getName());
                conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS, (Object)"*"));
                break;
            }
            case SHOW_UNREAD: {
                field = factory.createSearchField(14, INews.class.getName());
                conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS, EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)));
            }
        }
        if (withQuickSearch) {
            NewsFilter.SearchTarget target = this.fFeedView.getFilter().getSearchTarget();
            String text = this.fSearchInput.getText();
            if (StringUtils.supportsTrailingWildcards((String)text)) {
                text = String.valueOf(text) + "*";
            }
            switch (target) {
                case ALL: {
                    field = factory.createSearchField(-1, INews.class.getName());
                    conditions.add(factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)text));
                    break;
                }
                case HEADLINE: {
                    field = factory.createSearchField(0, INews.class.getName());
                    conditions.add(factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)text));
                    break;
                }
                case ATTACHMENTS: {
                    field = factory.createSearchField(11, INews.class.getName());
                    conditions.add(factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)text));
                    break;
                }
                case AUTHOR: {
                    field = factory.createSearchField(3, INews.class.getName());
                    conditions.add(factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)text));
                    break;
                }
                case CATEGORY: {
                    field = factory.createSearchField(12, INews.class.getName());
                    conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS, (Object)text));
                    break;
                }
                case LABELS: {
                    field = factory.createSearchField(15, INews.class.getName());
                    conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS, (Object)text));
                    break;
                }
                case SOURCE: {
                    field = factory.createSearchField(9, INews.class.getName());
                    conditions.add(factory.createSearchCondition(field, SearchSpecifier.IS, (Object)text));
                }
            }
        }
        SearchMarkDialog dialog = new SearchMarkDialog(this.fParent.getShell(), OwlUI.getBookMarkExplorerSelection(), null, conditions, true);
        dialog.open();
    }

    private void onFilter(NewsFilter.Type type) {
        this.doFilter(type, true, true);
        EditorUtils.updateFilterAndGrouping(this.fFeedView);
    }

    void doFilter(NewsFilter.Type type, boolean refresh, boolean saveSettings) {
        this.doFilter(type, refresh, saveSettings, null);
    }

    void doFilter(NewsFilter.Type type, boolean refresh, boolean saveSettings, final Runnable browserRefreshRunnable) {
        boolean noChange;
        NewsFilter.Type oldType = this.fFeedView.getFilter().getType();
        boolean bl = noChange = oldType == type;
        if (type != NewsFilter.Type.SHOW_ALL) {
            this.fLastFilterType = type;
        } else if (this.fFeedView.getFilter().getType() != NewsFilter.Type.SHOW_ALL) {
            this.fLastFilterType = oldType;
        }
        if (noChange) {
            return;
        }
        this.fFeedView.getFilter().setType(type);
        this.fFilterGroupingLayoutToolBarManager.find(FILTER_ACTION).update();
        if (refresh) {
            final Runnable uiRunnable = new Runnable(){

                public void run() {
                    if (browserRefreshRunnable != null) {
                        FilterBar.this.fFeedView.getNewsBrowserControl().getViewer().setBlockRefresh(true);
                    }
                    try {
                        NewsTableControl newsTable = FilterBar.this.fFeedView.getNewsTableControl();
                        boolean isNewsTableVisible = FilterBar.this.fFeedView.isTableViewerVisible();
                        if (newsTable != null && isNewsTableVisible) {
                            FilterBar.this.fFeedView.refreshTableViewer(true, false);
                        } else {
                            FilterBar.this.fFeedView.refresh(true, false);
                        }
                        FilterBar.this.updateBrowserSelection();
                        if (browserRefreshRunnable != null) {
                            browserRefreshRunnable.run();
                        }
                    }
                    finally {
                        if (browserRefreshRunnable != null) {
                            FilterBar.this.fFeedView.getNewsBrowserControl().getViewer().setBlockRefresh(false);
                        }
                    }
                }
            };
            if (oldType != type) {
                JobRunner.runInBackgroundWithBusyIndicator(new Runnable(){

                    public void run() {
                        FilterBar.this.fFeedView.revalidateCaches();
                        JobRunner.runInUIThread((Widget)FilterBar.this.fParent, uiRunnable);
                    }
                });
            } else {
                uiRunnable.run();
            }
        }
        if (saveSettings) {
            this.saveIntegerValue(DefaultPreferences.BM_NEWS_FILTERING, type.ordinal());
        }
    }

    private boolean needsCacheRevalidationFromSearch() {
        INewsMark mark = ((FeedViewInput)this.fFeedView.getEditorInput()).getMark();
        return mark instanceof FolderNewsMark && mark.getNewsCount(INews.State.getVisible()) > 500;
    }

    private void doSearch(final NewsFilter.SearchTarget target) {
        this.fFeedView.getFilter().setSearchTarget(target);
        this.fSearchInput.setMessage(this.fFeedView.getFilter().getSearchTarget().getName());
        this.fSearchInput.setFocus();
        if (this.fSearchInput.getText().length() > 0) {
            if (this.needsCacheRevalidationFromSearch()) {
                this.fFeedView.revalidateCaches();
            }
            this.fFeedView.refresh(true, false);
            this.updateBrowserSelection();
        }
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                FilterBar.this.fGlobalPreferences.putInteger(DefaultPreferences.FV_SEARCH_TARGET, target.ordinal());
            }
        });
    }

    private void createGrouperBar() {
        final NewsGrouping grouping = this.fFeedView.getGrouper();
        Action newsGroup = new Action(Messages.FilterBar_GROUP_NEWS, 4){

            public void run() {
                if (FilterBar.this.fFeedView.getGrouper().getType() != NewsGrouping.Type.NO_GROUPING) {
                    FilterBar.this.onGrouping(NewsGrouping.Type.NO_GROUPING);
                } else if (FilterBar.this.fLastGroupType != null) {
                    FilterBar.this.onGrouping(FilterBar.this.fLastGroupType);
                } else {
                    OwlUI.positionDropDownMenu(this, FilterBar.this.fFilterGroupingLayoutToolBarManager);
                }
            }

            public ImageDescriptor getImageDescriptor() {
                if (grouping.getType() == NewsGrouping.Type.NO_GROUPING) {
                    return OwlUI.getImageDescriptor("icons/etool16/group.gif");
                }
                return OwlUI.getImageDescriptor("icons/etool16/group_active.gif");
            }

            public String getText() {
                return grouping.getType().getDisplayName();
            }
        };
        newsGroup.setId(GROUP_ACTION);
        newsGroup.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Menu menu = new Menu(parent);
                final MenuItem noGrouping = new MenuItem(menu, 16);
                noGrouping.setText(NewsGrouping.Type.NO_GROUPING.getName());
                noGrouping.setSelection(grouping.getType() == NewsGrouping.Type.NO_GROUPING);
                noGrouping.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (noGrouping.getSelection() && grouping.getType() != NewsGrouping.Type.NO_GROUPING) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.NO_GROUPING);
                        }
                    }
                });
                menu.setDefaultItem(noGrouping);
                new MenuItem(menu, 2);
                final MenuItem groupByDate = new MenuItem(menu, 16);
                groupByDate.setText(NewsGrouping.Type.GROUP_BY_DATE.getName());
                groupByDate.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_DATE);
                groupByDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByDate.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_DATE) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_DATE);
                        }
                    }
                });
                final MenuItem groupByAuthor = new MenuItem(menu, 16);
                groupByAuthor.setText(NewsGrouping.Type.GROUP_BY_AUTHOR.getName());
                groupByAuthor.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_AUTHOR);
                groupByAuthor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByAuthor.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_AUTHOR) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_AUTHOR);
                        }
                    }
                });
                final MenuItem groupByCategory = new MenuItem(menu, 16);
                groupByCategory.setText(NewsGrouping.Type.GROUP_BY_CATEGORY.getName());
                groupByCategory.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_CATEGORY);
                groupByCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByCategory.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_CATEGORY) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_CATEGORY);
                        }
                    }
                });
                final MenuItem groupByTopic = new MenuItem(menu, 16);
                groupByTopic.setText(NewsGrouping.Type.GROUP_BY_TOPIC.getName());
                groupByTopic.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_TOPIC);
                groupByTopic.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByTopic.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_TOPIC) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_TOPIC);
                        }
                    }
                });
                final MenuItem groupByFeed = new MenuItem(menu, 16);
                groupByFeed.setText(NewsGrouping.Type.GROUP_BY_FEED.getName());
                groupByFeed.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_FEED);
                groupByFeed.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByFeed.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_FEED) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_FEED);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem groupByState = new MenuItem(menu, 16);
                groupByState.setText(NewsGrouping.Type.GROUP_BY_STATE.getName());
                groupByState.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_STATE);
                groupByState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByState.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_STATE) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_STATE);
                        }
                    }
                });
                final MenuItem groupByStickyness = new MenuItem(menu, 16);
                groupByStickyness.setText(NewsGrouping.Type.GROUP_BY_STICKY.getName());
                groupByStickyness.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_STICKY);
                groupByStickyness.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByStickyness.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_STICKY) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_STICKY);
                        }
                    }
                });
                new MenuItem(menu, 2);
                final MenuItem groupByLabel = new MenuItem(menu, 16);
                groupByLabel.setText(NewsGrouping.Type.GROUP_BY_LABEL.getName());
                groupByLabel.setSelection(grouping.getType() == NewsGrouping.Type.GROUP_BY_LABEL);
                groupByLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (groupByLabel.getSelection() && grouping.getType() != NewsGrouping.Type.GROUP_BY_LABEL) {
                            FilterBar.this.onGrouping(NewsGrouping.Type.GROUP_BY_LABEL);
                        }
                    }
                });
                return menu;
            }
        });
        ActionContributionItem item = new ActionContributionItem((IAction)newsGroup);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.fFilterGroupingLayoutToolBarManager.add((IContributionItem)item);
    }

    private void createLayoutBar() {
        Action newsLayout = new Action("", 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, FilterBar.this.fFilterGroupingLayoutToolBarManager);
            }

            public ImageDescriptor getImageDescriptor() {
                OwlUI.Layout currentLayout = FilterBar.this.getLayout();
                switch (currentLayout) {
                    case CLASSIC: {
                        return OwlUI.getImageDescriptor("icons/obj16/classic_layout.gif");
                    }
                    case VERTICAL: {
                        return OwlUI.getImageDescriptor("icons/obj16/vertical_layout.gif");
                    }
                    case LIST: {
                        return OwlUI.getImageDescriptor("icons/obj16/list_layout.gif");
                    }
                    case NEWSPAPER: {
                        return OwlUI.getImageDescriptor("icons/obj16/newspaper_layout.gif");
                    }
                    case HEADLINES: {
                        return OwlUI.getImageDescriptor("icons/obj16/headlines_layout.gif");
                    }
                }
                return OwlUI.getImageDescriptor("icons/obj16/classic_layout.gif");
            }

            public String getText() {
                OwlUI.Layout currentLayout = FilterBar.this.getLayout();
                return currentLayout.getName();
            }
        };
        newsLayout.setId(LAYOUT_ACTION);
        newsLayout.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                OwlUI.Layout[] layouts;
                OwlUI.Layout currentLayout = FilterBar.this.getLayout();
                Menu menu = new Menu(parent);
                OwlUI.Layout[] layoutArray = layouts = new OwlUI.Layout[]{OwlUI.Layout.CLASSIC, OwlUI.Layout.VERTICAL, OwlUI.Layout.LIST, OwlUI.Layout.NEWSPAPER, OwlUI.Layout.HEADLINES};
                int n = layouts.length;
                int n2 = 0;
                while (n2 < n) {
                    final OwlUI.Layout layout = layoutArray[n2];
                    final MenuItem layoutMenuItem = new MenuItem(menu, 16);
                    layoutMenuItem.setText(layout.getName());
                    layoutMenuItem.setSelection(layout == currentLayout);
                    layoutMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (layoutMenuItem.getSelection()) {
                                FilterBar.this.onLayout(layout);
                            }
                        }
                    });
                    ++n2;
                }
                return menu;
            }
        });
        ActionContributionItem item = new ActionContributionItem((IAction)newsLayout);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.fFilterGroupingLayoutToolBarManager.add((IContributionItem)item);
    }

    private void onGrouping(NewsGrouping.Type type) {
        this.doGrouping(type, true, true);
        EditorUtils.updateFilterAndGrouping(this.fFeedView);
    }

    private void onLayout(OwlUI.Layout layout) {
        this.doLayout(layout, true);
        EditorUtils.updateLayout();
    }

    void doLayout(OwlUI.Layout layout, boolean saveSettings) {
        if (saveSettings) {
            this.saveIntegerValue(DefaultPreferences.FV_LAYOUT, layout.ordinal());
        }
        this.fFilterGroupingLayoutToolBarManager.find(LAYOUT_ACTION).update();
    }

    void doGrouping(NewsGrouping.Type type, boolean refresh, boolean saveSettings) {
        boolean noChange;
        boolean bl = noChange = this.fFeedView.getGrouper().getType() == type;
        if (type != NewsGrouping.Type.NO_GROUPING) {
            this.fLastGroupType = type;
        } else if (this.fFeedView.getGrouper().getType() != NewsGrouping.Type.NO_GROUPING) {
            this.fLastGroupType = this.fFeedView.getGrouper().getType();
        }
        this.fFeedView.getGrouper().setType(type);
        this.fFilterGroupingLayoutToolBarManager.find(GROUP_ACTION).update();
        if (noChange) {
            return;
        }
        if (refresh) {
            NewsTableControl newsTable = this.fFeedView.getNewsTableControl();
            boolean isNewsTableVisible = this.fFeedView.isTableViewerVisible();
            try {
                if (newsTable != null && isNewsTableVisible) {
                    newsTable.setBlockNewsStateTracker(true);
                    this.fFeedView.refreshTableViewer(true, false);
                } else {
                    this.fFeedView.refresh(true, false);
                }
            }
            finally {
                if (newsTable != null && isNewsTableVisible) {
                    newsTable.setBlockNewsStateTracker(false);
                }
            }
        }
        if (saveSettings) {
            this.saveIntegerValue(DefaultPreferences.BM_NEWS_GROUPING, type.ordinal());
        }
    }

    private void saveIntegerValue(String key, int value) {
        FeedViewInput input = (FeedViewInput)this.fFeedView.getEditorInput();
        IPreferenceScope entityPrefs = Owl.getPreferenceService().getEntityScope((IEntity)input.getMark());
        if (entityPrefs.hasKey(key)) {
            entityPrefs.putInteger(key, value);
            if (input.getMark() instanceof FolderNewsMark) {
                DynamicDAO.save((IPersistable)((FolderNewsMark)input.getMark()).getFolder());
            } else {
                DynamicDAO.save((IPersistable)input.getMark());
            }
        } else {
            this.fGlobalPreferences.putInteger(key, value);
        }
    }
}

