/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.importer;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.dialogs.importer.ImportElementsPage;
import org.rssowl.ui.internal.dialogs.importer.ImportOptionsPage;
import org.rssowl.ui.internal.dialogs.importer.ImportSourcePage;
import org.rssowl.ui.internal.dialogs.importer.ImportTargetPage;
import org.rssowl.ui.internal.dialogs.importer.Messages;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.util.ImportUtils;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.views.explorer.BookMarkExplorer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportWizard
extends Wizard
implements IImportWizard {
    private ImportSourcePage fImportSourcePage;
    private ImportElementsPage fImportElementsPage;
    private ImportTargetPage fImportTargetPage;
    private ImportOptionsPage fImportOptionsPage;
    private final IFolder fTargetFolder;
    private String fFileOrWebsite;
    private boolean fIsKewordSearch;
    private boolean fIsWelcome;

    public ImportWizard() {
        this(null, null, false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public ImportWizard(boolean isWelcome) {
        this(null, null, false);
        this.fIsWelcome = isWelcome;
    }

    public ImportWizard(IFolder targetFolder, String fileOrWebsite, boolean isKeywordSearch) {
        this.fTargetFolder = targetFolder;
        this.fFileOrWebsite = fileOrWebsite;
        this.fIsKewordSearch = isKeywordSearch;
    }

    public void addPages() {
        this.setWindowTitle(Messages.ImportWizard_IMPORT);
        this.fImportSourcePage = new ImportSourcePage(this.fFileOrWebsite, this.fIsKewordSearch);
        this.addPage((IWizardPage)this.fImportSourcePage);
        this.fImportElementsPage = new ImportElementsPage();
        this.addPage((IWizardPage)this.fImportElementsPage);
        this.fImportTargetPage = new ImportTargetPage(this.fTargetFolder);
        this.addPage((IWizardPage)this.fImportTargetPage);
        this.fImportOptionsPage = new ImportOptionsPage();
        this.addPage((IWizardPage)this.fImportOptionsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ImportElementsPage && !this.fImportSourcePage.isRemoteSource() && this.fImportElementsPage.getFolderChildsToImport().isEmpty() && this.fImportElementsPage.showOptionsPage()) {
            return this.fImportOptionsPage;
        }
        if (page instanceof ImportTargetPage && !this.fImportElementsPage.showOptionsPage()) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        if (this.fImportSourcePage.getSource() == ImportSourcePage.Source.NONE) {
            return true;
        }
        return this.doImport();
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.fImportSourcePage && (this.fImportSourcePage.getSource() == ImportSourcePage.Source.RESOURCE || this.fImportSourcePage.isRemoteSource() || this.fImportSourcePage.getSource() == ImportSourcePage.Source.RECOMMENDED)) {
            return false;
        }
        if (this.fImportSourcePage.getSource() == ImportSourcePage.Source.NONE) {
            return true;
        }
        return super.canFinish();
    }

    private boolean doImport() {
        BookMarkExplorer explorer;
        boolean restart;
        MessageDialog dialog;
        boolean importPreferences;
        boolean importFilters;
        List<IFolderChild> folderChilds = this.fImportElementsPage.getFolderChildsToImport();
        boolean isRSSOwlOPML = this.isRSSOwlOPMLImport(folderChilds);
        if (this.fImportElementsPage.excludeExisting()) {
            folderChilds = this.excludeExisting(folderChilds);
        }
        if (StringUtils.isSet((String)this.fImportElementsPage.getErrorMessage())) {
            this.getContainer().showPage((IWizardPage)this.fImportElementsPage);
            return false;
        }
        List<ILabel> labels = this.fImportElementsPage.getLabelsToImport();
        List<ISearchFilter> filters = this.fImportElementsPage.getFiltersToImport();
        List<IPreference> preferences = this.fImportElementsPage.getPreferencesToImport();
        CoreUtils.normalize(folderChilds);
        IFolder target = this.fIsWelcome ? null : this.fImportTargetPage.getTargetLocation();
        boolean importLabels = this.fImportOptionsPage.importLabels();
        if (!importLabels) {
            labels = null;
        }
        if (!(importFilters = this.fImportOptionsPage.importFilters())) {
            filters = null;
        }
        if (!(importPreferences = this.fImportOptionsPage.importPreferences())) {
            preferences = null;
        }
        if (!this.fIsWelcome && importPreferences && preferences != null && !preferences.isEmpty() && (dialog = new MessageDialog(this.getShell(), Messages.ImportWizard_ATTENTION, null, Messages.ImportWizard_PREFERENCE_OVERWRITE, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open() != 0) {
            return false;
        }
        ImportUtils.doImport(target, folderChilds, labels, filters, preferences, !this.fIsWelcome);
        if (!(!this.fIsWelcome || isRSSOwlOPML || importLabels || importFilters || importPreferences)) {
            this.addDefaultSearches();
        }
        this.fImportSourcePage.saveSettings();
        if (importPreferences && preferences != null && !preferences.isEmpty() && (restart = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ImportWizard_RESTART_RSSOWL, (String)Messages.ImportWizard_RESTART_RSSOWL_INFO))) {
            BookMarkExplorer explorer2 = OwlUI.getOpenedBookMarkExplorer();
            if (explorer2 != null) {
                explorer2.saveStateOnDispose(false);
            }
            Controller.getDefault().restart();
            return true;
        }
        if (target != null && target.getParent() != null && (explorer = OwlUI.getOpenedBookMarkExplorer()) != null) {
            explorer.reveal((IFolderChild)target, true);
        }
        new ReloadTypesAction((IStructuredSelection)new StructuredSelection(folderChilds), OwlUI.getPrimaryShell()).run();
        JobRunner.runDelayedInBackgroundThread(new Runnable(){

            public void run() {
                Controller.getDefault().getSavedSearchService().updateSavedSearches(true);
            }
        });
        return true;
    }

    private boolean isRSSOwlOPMLImport(List<IFolderChild> folderChilds) {
        for (IFolderChild child : folderChilds) {
            IFolder set;
            if (!(child instanceof IFolder) || child.getParent() != null || (set = (IFolder)child).getProperty("org.rssowl.core.interpreter.typeimporter.TemporaryFolder") != null) continue;
            return true;
        }
        return false;
    }

    private List<IFolderChild> excludeExisting(List<IFolderChild> folderChilds) {
        IFolderChild child;
        IBookMarkDAO dao = (IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class);
        Iterator<IFolderChild> iterator = folderChilds.iterator();
        while (iterator.hasNext()) {
            child = iterator.next();
            if (child instanceof IBookMark) {
                IBookMark bm = (IBookMark)child;
                if (!dao.exists(bm.getFeedLinkReference())) continue;
                iterator.remove();
                continue;
            }
            if (child instanceof INewsBin) {
                INewsBin bin = (INewsBin)child;
                if (!CoreUtils.existsNewsBin((INewsBin)bin)) continue;
                iterator.remove();
                continue;
            }
            if (child instanceof ISearchMark) {
                ISearchMark search = (ISearchMark)child;
                if (!CoreUtils.existsSearchMark((ISearchMark)search)) continue;
                iterator.remove();
                continue;
            }
            if (!(child instanceof IFolder)) continue;
            this.excludeExisting((IFolder)child);
        }
        iterator = folderChilds.iterator();
        while (iterator.hasNext()) {
            child = iterator.next();
            if (!(child instanceof IFolder) || !((IFolder)child).getChildren().isEmpty()) continue;
            iterator.remove();
        }
        return folderChilds;
    }

    private void excludeExisting(IFolder folder) {
        IBookMarkDAO dao = (IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class);
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IBookMark) {
                IBookMark bm = (IBookMark)child;
                if (!dao.exists(bm.getFeedLinkReference())) continue;
                folder.removeChild((IFolderChild)bm);
                continue;
            }
            if (child instanceof INewsBin) {
                INewsBin bin = (INewsBin)child;
                if (!CoreUtils.existsNewsBin((INewsBin)bin)) continue;
                folder.removeChild((IFolderChild)bin);
                continue;
            }
            if (child instanceof ISearchMark) {
                ISearchMark search = (ISearchMark)child;
                if (!CoreUtils.existsSearchMark((ISearchMark)search)) continue;
                folder.removeChild((IFolderChild)search);
                continue;
            }
            if (!(child instanceof IFolder)) continue;
            this.excludeExisting((IFolder)child);
        }
        if (folder.getChildren().isEmpty() && folder.getParent() != null) {
            folder.getParent().removeChild((IFolderChild)folder);
        }
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    private void addDefaultSearches() {
        Set roots = CoreUtils.loadRootFolders();
        if (roots.isEmpty()) {
            return;
        }
        IFolder root = (IFolder)roots.iterator().next();
        IModelFactory factory = Owl.getModelFactory();
        String newsEntityName = INews.class.getName();
        ISearchMark mark = factory.createSearchMark(null, root, Messages.ImportWizard_NEW_UPDATED_NEWS);
        mark.setMatchAllConditions(true);
        ISearchField field1 = factory.createSearchField(14, newsEntityName);
        factory.createSearchCondition(null, mark, field1, SearchSpecifier.IS, EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED));
        mark = factory.createSearchMark(null, root, Messages.ImportWizard_TODAYS_NEWS);
        mark.setMatchAllConditions(true);
        field1 = factory.createSearchField(18, newsEntityName);
        factory.createSearchCondition(null, mark, field1, SearchSpecifier.IS_LESS_THAN, (Object)1);
        mark = factory.createSearchMark(null, root, Messages.ImportWizard_NEWS_WITH_ATTACHMENTS);
        mark.setMatchAllConditions(true);
        ISearchField field = factory.createSearchField(10, newsEntityName);
        factory.createSearchCondition(null, mark, field, SearchSpecifier.IS, (Object)true);
        mark = factory.createSearchMark(null, root, Messages.ImportWizard_STICKY_NEWS);
        mark.setMatchAllConditions(true);
        field = factory.createSearchField(13, newsEntityName);
        factory.createSearchCondition(null, mark, field, SearchSpecifier.IS, (Object)true);
        mark = factory.createSearchMark(null, root, Messages.ImportWizard_LABELED_NEWS);
        IPreferenceScope preferences = Owl.getPreferenceService().getEntityScope((IEntity)mark);
        preferences.putInteger(DefaultPreferences.BM_NEWS_GROUPING, NewsGrouping.Type.GROUP_BY_LABEL.ordinal());
        ISearchField field2 = factory.createSearchField(15, newsEntityName);
        factory.createSearchCondition(null, mark, field2, SearchSpecifier.IS, (Object)"*");
        DynamicDAO.save((IPersistable)root);
    }
}

