/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.fatal;

import java.io.File;
import java.text.DateFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.util.Pair;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.fatal.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreBackupPage
extends WizardPage {
    private List<File> fBackups;
    private ComboViewer fBackupsViewer;
    private final DateFormat fDateFormat = OwlUI.getShortDateFormat();
    private Button fConfirmRestoreCheck;
    private final IStatus fErrorStatus;

    RestoreBackupPage(String pageName, IStatus errorStatus, List<File> backups) {
        super(pageName, pageName, null);
        this.fErrorStatus = errorStatus;
        this.fBackups = backups;
    }

    public void createControl(Composite parent) {
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/wizban/welcome_wiz.gif"));
        if (!this.fErrorStatus.isOK()) {
            this.setMessage(Messages.RestoreBackupPage_RSSOWL_CRASH, 2);
        } else {
            this.setMessage(Messages.RestoreBackupPage_RESTORE_TEXT_OK, 1);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 5));
        ((GridLayout)container.getLayout()).marginBottom = 10;
        Label backupInfoLabel = new Label(container, 0);
        backupInfoLabel.setText(Messages.RestoreBackupPage_RESTORING_A_BACKUP);
        backupInfoLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        backupInfoLabel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label backupTextLabel = new Label(container, 64);
        backupTextLabel.setText(Application.IS_WINDOWS && !this.fErrorStatus.isOK() ? Messages.RestoreBackupPage_BACKUP_INFO_RESTART : Messages.RestoreBackupPage_BACKUP_INFO_QUIT);
        backupTextLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        ((GridData)backupTextLabel.getLayoutData()).widthHint = 200;
        Pair pair = InternalOwl.getDefault().getProfile();
        File profile = (File)pair.getFirst();
        if (profile != null && profile.exists()) {
            Label currentProfileLabel = new Label(container, 0);
            currentProfileLabel.setText(Messages.RestoreBackupPage_CURRENT_PROFILE);
            currentProfileLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            ((GridData)currentProfileLabel.getLayoutData()).verticalIndent = 5;
            Long timestamp = pair.getSecond() != null ? ((Long)pair.getSecond()).longValue() : profile.lastModified();
            Label currentProfileTextLabel = new Label(container, 0);
            currentProfileTextLabel.setText(NLS.bind((String)Messages.RestoreBackupPage_LAST_MODIFIED, (Object)this.fDateFormat.format(timestamp), (Object)OwlUI.getSize((int)profile.length())));
            currentProfileTextLabel.setLayoutData((Object)new GridData(4, 1, true, false));
            ((GridData)currentProfileTextLabel.getLayoutData()).verticalIndent = 5;
        }
        Label chooseBackupLabel = new Label(container, 0);
        chooseBackupLabel.setText(Messages.RestoreBackupPage_CHOOSE_BACKUP);
        chooseBackupLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fBackupsViewer = new ComboViewer(container, 2056);
        this.fBackupsViewer.getControl().setLayoutData((Object)new GridData(1, 1, false, false));
        this.fBackupsViewer.getCombo().setVisibleItemCount(this.fBackups.size());
        this.fBackupsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fBackupsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                File file = (File)element;
                return NLS.bind((String)Messages.RestoreBackupPage_BACKUP_LABEL, (Object)RestoreBackupPage.this.fDateFormat.format(file.lastModified()), (Object)OwlUI.getSize((int)file.length()));
            }
        });
        this.fBackupsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RestoreBackupPage.this.getContainer().updateButtons();
                RestoreBackupPage.this.fConfirmRestoreCheck.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.fBackupsViewer.setInput(this.fBackups);
        Composite adviseContainer = new Composite(container, 0);
        adviseContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        adviseContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        ((GridData)adviseContainer.getLayoutData()).verticalIndent = 5;
        Label adviseLabel = new Label(adviseContainer, 0);
        adviseLabel.setText(Messages.RestoreBackupPage_CAUTION);
        adviseLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        adviseLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        Label adviseTextLabel = new Label(adviseContainer, 64);
        adviseTextLabel.setText(Messages.RestoreBackupPage_RESTORE_WARNING);
        adviseTextLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)adviseTextLabel.getLayoutData()).widthHint = 200;
        this.fConfirmRestoreCheck = new Button(adviseContainer, 32);
        this.fConfirmRestoreCheck.setText(Messages.RestoreBackupPage_CONFIRM_RESTORE);
        this.fConfirmRestoreCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fConfirmRestoreCheck.getLayoutData()).verticalIndent = 5;
        ((GridData)this.fConfirmRestoreCheck.getLayoutData()).horizontalIndent = 5;
        this.fConfirmRestoreCheck.setEnabled(false);
        this.fConfirmRestoreCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackupPage.this.getContainer().updateButtons();
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public boolean isPageComplete() {
        return this.fBackupsViewer.getSelection().isEmpty() || this.fConfirmRestoreCheck.getSelection();
    }

    File getSelectedBackup() {
        IStructuredSelection selection = (IStructuredSelection)this.fBackupsViewer.getSelection();
        if (!selection.isEmpty()) {
            return (File)selection.getFirstElement();
        }
        return null;
    }
}

