/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.cleanup;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.PreviewFeedDialog;
import org.rssowl.ui.internal.dialogs.cleanup.Messages;
import org.rssowl.ui.internal.util.FolderChildCheckboxTree;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedSelectionPage
extends WizardPage {
    private FolderChildCheckboxTree fFolderChildTree;
    private CheckboxTreeViewer fViewer;
    private Button fSelectAll;
    private Button fDeselectAll;
    private Button fDisplayFeedButton;

    protected FeedSelectionPage(String pageName) {
        super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/cleanup_wiz.gif"));
        this.setMessage(Messages.FeedSelectionPage_CHOOSE_BOOKMARKS);
    }

    Set<IBookMark> getSelection() {
        Object[] checkedElements;
        HashSet<IBookMark> selection = new HashSet<IBookMark>();
        Object[] objectArray = checkedElements = this.fViewer.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof IFolder) {
                this.addAll(selection, (IFolder)checkedElement);
            } else if (checkedElement instanceof IBookMark) {
                selection.add((IBookMark)checkedElement);
            }
            ++n2;
        }
        return selection;
    }

    private void addAll(Set<IBookMark> bookmarks, IFolder folder) {
        List childFolders = folder.getFolders();
        for (IFolder childFolder : childFolders) {
            this.addAll(bookmarks, childFolder);
        }
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark)) continue;
            bookmarks.add((IBookMark)mark);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.fFolderChildTree = new FolderChildCheckboxTree(container, true);
        this.fViewer = this.fFolderChildTree.getViewer();
        this.fViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFolder) {
                    return FeedSelectionPage.this.hasBookMarks((IFolder)element);
                }
                return element instanceof IBookMark;
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FeedSelectionPage.this.fDisplayFeedButton.setEnabled(((IStructuredSelection)event.getSelection()).getFirstElement() instanceof IBookMark);
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FeedSelectionPage.this.showFeeds((IStructuredSelection)event.getSelection());
            }
        });
        this.fFolderChildTree.getViewer().setInput((Object)CoreUtils.loadRootFolders());
        this.fFolderChildTree.setAllChecked(true);
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(4, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSelectAll = new Button(buttonContainer, 8);
        this.fSelectAll.setText(Messages.FeedSelectionPage_SELECT_ALL);
        Dialog.applyDialogFont((Control)this.fSelectAll);
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedSelectionPage.this.fFolderChildTree.setAllChecked(true);
            }
        });
        this.fDeselectAll = new Button(buttonContainer, 8);
        this.fDeselectAll.setText(Messages.FeedSelectionPage_DESELECT_ALL);
        Dialog.applyDialogFont((Control)this.fDeselectAll);
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedSelectionPage.this.fFolderChildTree.setAllChecked(false);
            }
        });
        if (!Application.IS_MAC) {
            Label sep = new Label(buttonContainer, 514);
            sep.setLayoutData((Object)new GridData(1, 4, false, false));
            ((GridData)sep.getLayoutData()).heightHint = 20;
        }
        this.fDisplayFeedButton = new Button(buttonContainer, 8);
        this.fDisplayFeedButton.setText(Messages.FeedSelectionPage_DISPLAY);
        this.fDisplayFeedButton.setEnabled(false);
        this.fDisplayFeedButton.setToolTipText(Messages.FeedSelectionPage_DISPLAY_FEEDS);
        Dialog.applyDialogFont((Control)this.fDisplayFeedButton);
        this.setButtonLayoutData(this.fDisplayFeedButton);
        this.fDisplayFeedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedSelectionPage.this.showFeeds((IStructuredSelection)FeedSelectionPage.this.fViewer.getSelection());
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void showFeeds(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            Object[] elements = selection.toArray();
            int offset = 0;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IBookMark) {
                    IBookMark bookmark = (IBookMark)element;
                    PreviewFeedDialog dialog = new PreviewFeedDialog(this.getShell(), bookmark, bookmark.getFeedLinkReference());
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                    if (offset != 0) {
                        Point location = dialog.getShell().getLocation();
                        dialog.getShell().setLocation(location.x + offset, location.y + offset);
                    }
                    offset += 20;
                }
                ++n2;
            }
        }
    }

    private boolean hasBookMarks(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark)) continue;
            return true;
        }
        List childFolders = folder.getFolders();
        for (IFolder childFolder : childFolders) {
            if (!this.hasBookMarks(childFolder)) continue;
            return true;
        }
        return false;
    }
}

