/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.cleanup;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.PreviewFeedDialog;
import org.rssowl.ui.internal.dialogs.cleanup.BookMarkTask;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpGroup;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpModel;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpOperations;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpOptionsPage;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpTask;
import org.rssowl.ui.internal.dialogs.cleanup.FeedSelectionPage;
import org.rssowl.ui.internal.dialogs.cleanup.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpSummaryPage
extends WizardPage {
    private CheckboxTreeViewer fViewer;
    private ResourceManager fResources;
    private Button fSelectAll;
    private Button fDeselectAll;
    private Button fDisplayFeedButton;

    protected CleanUpSummaryPage(String pageName) {
        super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/cleanup_wiz.gif"));
        this.setMessage(Messages.CleanUpSummaryPage_REVIEW_OPS);
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    List<CleanUpTask> getTasks() {
        Object[] checkedElements = this.fViewer.getCheckedElements();
        ArrayList<CleanUpTask> tasks = new ArrayList<CleanUpTask>(checkedElements.length);
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof CleanUpTask) {
                tasks.add((CleanUpTask)checkedElement);
            }
            ++n2;
        }
        return tasks;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.fViewer = new CheckboxTreeViewer(container, 67584);
        this.fViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.getTree().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        this.fViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof CleanUpGroup) {
                    CleanUpGroup group = (CleanUpGroup)parentElement;
                    return group.getTasks().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof CleanUpTask) {
                    return ((CleanUpTask)element).getGroup();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof CleanUpGroup;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final SummaryLabelProvider summaryLabelProvider = new SummaryLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)summaryLabelProvider);
        if (!OwlUI.isHighContrast()) {
            this.fViewer.getControl().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    Object element = event.item.getData();
                    if (element instanceof CleanUpGroup) {
                        summaryLabelProvider.eraseGroup(event);
                    }
                }
            });
        }
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CleanUpSummaryPage.this.onDoubleClick(event);
            }
        });
        this.fViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSummaryPage.this.onSelect(e);
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CleanUpSummaryPage.this.fDisplayFeedButton.setEnabled(((IStructuredSelection)event.getSelection()).getFirstElement() instanceof BookMarkTask);
            }
        });
        this.fViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                CleanUpSummaryPage.this.onExpand(event);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(4, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSelectAll = new Button(buttonContainer, 8);
        this.fSelectAll.setText(Messages.CleanUpSummaryPage_SELECT_ALL);
        Dialog.applyDialogFont((Control)this.fSelectAll);
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OwlUI.setAllChecked(CleanUpSummaryPage.this.fViewer.getTree(), true);
            }
        });
        this.fDeselectAll = new Button(buttonContainer, 8);
        this.fDeselectAll.setText(Messages.CleanUpSummaryPage_DESELECT_ALL);
        Dialog.applyDialogFont((Control)this.fDeselectAll);
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OwlUI.setAllChecked(CleanUpSummaryPage.this.fViewer.getTree(), false);
            }
        });
        if (!Application.IS_MAC) {
            Label sep = new Label(buttonContainer, 514);
            sep.setLayoutData((Object)new GridData(1, 4, false, false));
            ((GridData)sep.getLayoutData()).heightHint = 20;
        }
        this.fDisplayFeedButton = new Button(buttonContainer, 8);
        this.fDisplayFeedButton.setText(Messages.CleanUpSummaryPage_DISPLAY);
        this.fDisplayFeedButton.setEnabled(false);
        this.fDisplayFeedButton.setToolTipText(Messages.CleanUpSummaryPage_DISPLAY_FEED);
        Dialog.applyDialogFont((Control)this.fDisplayFeedButton);
        this.setButtonLayoutData(this.fDisplayFeedButton);
        this.fDisplayFeedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSummaryPage.this.showFeeds((IStructuredSelection)CleanUpSummaryPage.this.fViewer.getSelection());
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            CleanUpOptionsPage cleanUpOptionsPage = (CleanUpOptionsPage)this.getPreviousPage();
            FeedSelectionPage feedSelectionPage = (FeedSelectionPage)cleanUpOptionsPage.getPreviousPage();
            final Set<IBookMark> selection = feedSelectionPage.getSelection();
            final CleanUpOperations operations = cleanUpOptionsPage.getOperations();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.CleanUpSummaryPage_WAIT_GENERATE_PREVIEW, -1);
                    CleanUpSummaryPage.this.onGenerateSummary(operations, selection, monitor);
                }
            };
            try {
                this.getContainer().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    private void onGenerateSummary(CleanUpOperations operations, Set<IBookMark> selection, IProgressMonitor monitor) {
        final CleanUpModel model = new CleanUpModel(operations, selection);
        model.generate(monitor);
        JobRunner.runInUIThread((Widget)this.fViewer.getTree(), new Runnable(){

            public void run() {
                CleanUpSummaryPage.this.fViewer.setInput(model.getTasks());
                CleanUpSummaryPage.this.fViewer.expandAll();
                OwlUI.setAllChecked(CleanUpSummaryPage.this.fViewer.getTree(), true);
            }
        });
    }

    public boolean isPageComplete() {
        return this.isCurrentPage();
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    private void onDoubleClick(DoubleClickEvent event) {
        CleanUpGroup group;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        CleanUpGroup cleanUpGroup = group = selection.getFirstElement() instanceof CleanUpGroup ? (CleanUpGroup)selection.getFirstElement() : null;
        if (group != null) {
            boolean expandedState = !this.fViewer.getExpandedState((Object)group);
            this.fViewer.setExpandedState((Object)group, expandedState);
            if (expandedState && this.fViewer.getChecked((Object)group)) {
                this.setChildsChecked(group, true);
            }
        } else if (selection.getFirstElement() instanceof BookMarkTask) {
            this.showFeeds(selection);
        }
    }

    private void showFeeds(IStructuredSelection selection) {
        Object firstElement;
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof BookMarkTask) {
            IBookMark bookmark = ((BookMarkTask)firstElement).getMark();
            PreviewFeedDialog dialog = new PreviewFeedDialog(this.getShell(), bookmark, bookmark.getFeedLinkReference());
            dialog.setBlockOnOpen(false);
            dialog.open();
        }
    }

    private void onSelect(SelectionEvent e) {
        if (e.detail == 32) {
            TreeItem item = (TreeItem)e.item;
            if (item.getData() instanceof CleanUpGroup) {
                this.setChildsChecked((CleanUpGroup)item.getData(), item.getChecked());
            }
            if (!item.getChecked() && item.getData() instanceof CleanUpTask) {
                this.setParentsChecked((CleanUpTask)item.getData(), false);
            }
        }
    }

    private void onExpand(TreeExpansionEvent event) {
        boolean isChecked = this.fViewer.getChecked(event.getElement());
        if (isChecked) {
            this.setChildsChecked((CleanUpGroup)event.getElement(), isChecked);
        }
    }

    private void setChildsChecked(CleanUpGroup cleanUpGroup, boolean checked) {
        List<CleanUpTask> children = cleanUpGroup.getTasks();
        for (CleanUpTask child : children) {
            this.fViewer.setChecked((Object)child, checked);
        }
    }

    private void setParentsChecked(CleanUpTask cleanUpTask, boolean checked) {
        CleanUpGroup parent = cleanUpTask.getGroup();
        if (parent != null) {
            this.fViewer.setChecked((Object)parent, checked);
        }
    }

    class SummaryLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider {
        private Color fGradientFgColor;
        private Color fGradientBgColor;
        private Color fGradientEndColor;
        private Color fGroupFgColor;

        SummaryLabelProvider() {
            this.fGradientFgColor = OwlUI.getColor(CleanUpSummaryPage.this.fResources, OwlUI.GROUP_GRADIENT_FG_COLOR);
            this.fGradientBgColor = OwlUI.getColor(CleanUpSummaryPage.this.fResources, OwlUI.GROUP_GRADIENT_BG_COLOR);
            this.fGradientEndColor = OwlUI.getColor(CleanUpSummaryPage.this.fResources, OwlUI.GROUP_GRADIENT_END_COLOR);
            this.fGroupFgColor = OwlUI.getColor(CleanUpSummaryPage.this.fResources, OwlUI.GROUP_FG_COLOR);
        }

        public String getText(Object element) {
            if (element instanceof CleanUpGroup) {
                return ((CleanUpGroup)element).getLabel();
            }
            return ((CleanUpTask)element).getLabel();
        }

        public Image getImage(Object element) {
            if (element instanceof CleanUpGroup) {
                return OwlUI.getImage(CleanUpSummaryPage.this.fResources, OwlUI.GROUP);
            }
            return OwlUI.getImage(CleanUpSummaryPage.this.fResources, ((CleanUpTask)element).getImage());
        }

        public Font getFont(Object element) {
            if (element instanceof CleanUpGroup) {
                return OwlUI.getBold("org.eclipse.jface.defaultfont");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof CleanUpGroup && !OwlUI.isHighContrast()) {
                return this.fGroupFgColor;
            }
            return null;
        }

        void eraseGroup(Event event) {
            Scrollable scrollable = (Scrollable)event.widget;
            GC gc = event.gc;
            Rectangle area = scrollable.getClientArea();
            Rectangle rect = event.getBounds();
            OwlUI.codExpandRegion(event, scrollable, gc, area);
            Color oldForeground = gc.getForeground();
            Color oldBackground = gc.getBackground();
            gc.setForeground(this.fGradientFgColor);
            gc.setBackground(this.fGradientBgColor);
            gc.fillGradientRectangle(0, rect.y, area.width, rect.height, true);
            gc.setForeground(this.fGradientEndColor);
            gc.drawLine(0, rect.y + rect.height - 1, area.width, rect.y + rect.height - 1);
            gc.setForeground(oldForeground);
            gc.setBackground(oldBackground);
            event.detail &= 0xFFFFFFF7;
        }
    }
}

