/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.bookmark;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFeedDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.dialogs.LoginDialog;
import org.rssowl.ui.internal.dialogs.bookmark.BookmarkDefinitionPage;
import org.rssowl.ui.internal.dialogs.bookmark.FeedDefinitionPage;
import org.rssowl.ui.internal.dialogs.bookmark.KeywordSubscriptionPage;
import org.rssowl.ui.internal.dialogs.bookmark.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.ModelUtils;

public class CreateBookmarkWizard
extends Wizard
implements INewWizard {
    private FeedDefinitionPage fFeedDefinitionPage;
    private KeywordSubscriptionPage fKeywordPage;
    private BookmarkDefinitionPage fBookMarkDefinitionPage;
    private IFolder fParent;
    private final String fInitialLink;
    private IFolderChild fPosition;
    private String fLastRealm;

    public CreateBookmarkWizard() {
        this(null, null, null);
    }

    public CreateBookmarkWizard(IFolder parent, IMark position, String initialLink) {
        this.fParent = parent;
        this.fPosition = position;
        this.fInitialLink = initialLink;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Pair<IFolder, IFolderChild> pair = ModelUtils.getLocationAndPosition(selection);
        this.fParent = (IFolder)pair.getFirst();
        this.fPosition = (IFolderChild)pair.getSecond();
    }

    public void addPages() {
        this.setWindowTitle(Messages.CreateBookmarkWizard_NEW_BOOKMARK);
        this.fFeedDefinitionPage = new FeedDefinitionPage(Messages.CreateBookmarkWizard_BOOKMARK, this.fInitialLink);
        this.addPage((IWizardPage)this.fFeedDefinitionPage);
        this.fKeywordPage = new KeywordSubscriptionPage(Messages.CreateBookmarkWizard_BOOKMARK);
        this.addPage((IWizardPage)this.fKeywordPage);
        this.fBookMarkDefinitionPage = new BookmarkDefinitionPage(Messages.CreateBookmarkWizard_BOOKMARK, this.fParent);
        this.addPage((IWizardPage)this.fBookMarkDefinitionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fFeedDefinitionPage) {
            if (this.fFeedDefinitionPage.isKeywordSubscription()) {
                return this.fKeywordPage;
            }
            return this.fBookMarkDefinitionPage;
        }
        return super.getNextPage(page);
    }

    void loadNameFromFeed() {
        if (this.fFeedDefinitionPage.isKeywordSubscription()) {
            this.fBookMarkDefinitionPage.presetBookmarkName(this.fKeywordPage.getSelectedEngine().getLabel(this.fFeedDefinitionPage.getKeyword()));
        } else if (this.fFeedDefinitionPage.loadTitleFromFeed()) {
            final String linkText = URIUtils.ensureProtocol((String)this.fFeedDefinitionPage.getLink());
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.CreateBookmarkWizard_LOADING_TITLE, -1);
                    String feedTitle = null;
                    final URI[] link = new URI[1];
                    try {
                        URI feedLink;
                        link[0] = new URI(URIUtils.fastEncode((String)linkText));
                        if (monitor.isCanceled()) {
                            return;
                        }
                        if (!URIUtils.looksLikeFeedLink((String)linkText) && (feedLink = Owl.getConnectionService().getFeed(link[0], monitor)) != null) {
                            link[0] = feedLink;
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        feedTitle = Owl.getConnectionService().getLabel(link[0], monitor);
                        CreateBookmarkWizard.this.fLastRealm = null;
                    }
                    catch (ConnectionException e) {
                        if (!monitor.isCanceled() && e instanceof AuthenticationRequiredException && CreateBookmarkWizard.this.handleProtectedFeed(link[0], ((AuthenticationRequiredException)e).getRealm())) {
                            try {
                                feedTitle = Owl.getConnectionService().getLabel(link[0], monitor);
                            }
                            catch (ConnectionException connectionException) {
                                Activator.getDefault().logError(e.getMessage(), e);
                            }
                        }
                    }
                    catch (URISyntaxException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                    }
                    CreateBookmarkWizard.this.fBookMarkDefinitionPage.presetBookmarkName(feedTitle);
                    if (link[0] != null) {
                        JobRunner.runInUIThread(100, (Widget)CreateBookmarkWizard.this.getShell(), new Runnable(){

                            public void run() {
                                CreateBookmarkWizard.this.fFeedDefinitionPage.setLink(link[0].toString());
                            }
                        });
                    }
                }
            };
            try {
                this.getContainer().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    private boolean handleProtectedFeed(final URI feedLink, final String realm) {
        this.fLastRealm = realm;
        final boolean[] result = new boolean[1];
        JobRunner.runSyncedInUIThread((Widget)this.getShell(), new Runnable(){

            public void run() {
                LoginDialog login = new LoginDialog(CreateBookmarkWizard.this.getShell(), feedLink, realm);
                if (login.open() == 0) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        String link = this.fFeedDefinitionPage.getLink();
        if (currentPage == this.fFeedDefinitionPage && this.fFeedDefinitionPage.loadTitleFromFeed() && StringUtils.isSet((String)link) && !"http://".equals(link)) {
            return true;
        }
        if (currentPage == this.fKeywordPage) {
            return true;
        }
        if (currentPage != this.fBookMarkDefinitionPage) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        boolean res = false;
        try {
            res = this.internalPerformFinish();
        }
        catch (URISyntaxException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            ((DialogPage)this.getContainer().getCurrentPage()).setMessage(Messages.CreateBookmarkWizard_ENTER_VALID_LINK, 3);
        }
        IPreferenceScope globalPrefs = Owl.getPreferenceService().getGlobalScope();
        globalPrefs.putBoolean(DefaultPreferences.BM_LOAD_TITLE_FROM_FEED, this.fFeedDefinitionPage.loadTitleFromFeed());
        if (this.fFeedDefinitionPage.isKeywordSubscription()) {
            globalPrefs.putString(DefaultPreferences.LAST_KEYWORD_FEED, this.fKeywordPage.getSelectedEngine().getId());
        }
        return res;
    }

    private boolean internalPerformFinish() throws URISyntaxException {
        IFeedDAO feedDAO;
        final String[] title = new String[]{this.fBookMarkDefinitionPage.getBookmarkName()};
        final URI[] uriObj = new URI[1];
        if (this.fFeedDefinitionPage.isKeywordSubscription()) {
            uriObj[0] = new URI(this.fKeywordPage.getSelectedEngine().toUrl(this.fFeedDefinitionPage.getKeyword()));
        } else {
            String linkVal = URIUtils.ensureProtocol((String)this.fFeedDefinitionPage.getLink());
            if (linkVal.endsWith("/")) {
                linkVal = linkVal.substring(0, linkVal.length() - 1);
            }
            uriObj[0] = new URI(URIUtils.fastEncode((String)linkVal));
        }
        if (!StringUtils.isSet((String)title[0])) {
            if (!this.fFeedDefinitionPage.isKeywordSubscription()) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        block7: {
                            monitor.beginTask(Messages.CreateBookmarkWizard_LOADING_TITLE, -1);
                            try {
                                URI feedLink;
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                if (!URIUtils.looksLikeFeedLink((String)uriObj[0].toString()) && (feedLink = Owl.getConnectionService().getFeed(uriObj[0], monitor)) != null) {
                                    uriObj[0] = feedLink;
                                }
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                title[0] = Owl.getConnectionService().getLabel(uriObj[0], monitor);
                            }
                            catch (ConnectionException e) {
                                if (monitor.isCanceled() || !(e instanceof AuthenticationRequiredException) || !CreateBookmarkWizard.this.handleProtectedFeed(uriObj[0], ((AuthenticationRequiredException)e).getRealm())) break block7;
                                try {
                                    title[0] = Owl.getConnectionService().getLabel(uriObj[0], monitor);
                                }
                                catch (ConnectionException connectionException) {
                                    Activator.getDefault().logError(e.getMessage(), e);
                                }
                            }
                        }
                    }
                };
                try {
                    this.getContainer().run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                catch (InterruptedException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
                if (!StringUtils.isSet((String)title[0])) {
                    this.getContainer().showPage((IWizardPage)this.fBookMarkDefinitionPage);
                    return false;
                }
            } else {
                title[0] = this.fKeywordPage.getSelectedEngine().getLabel(this.fFeedDefinitionPage.getKeyword());
            }
        }
        if (!(feedDAO = (IFeedDAO)DynamicDAO.getDAO(IFeedDAO.class)).exists(uriObj[0])) {
            IFeed feed = Owl.getModelFactory().createFeed(null, uriObj[0]);
            feed = (IFeed)feedDAO.save((IPersistable)feed);
        }
        IFolder parent = this.fBookMarkDefinitionPage.getFolder();
        FeedLinkReference feedLinkRef = new FeedLinkReference(uriObj[0]);
        IBookMark bookmark = Owl.getModelFactory().createBookMark(null, parent, feedLinkRef, title[0], this.fPosition, this.fPosition != null ? Boolean.valueOf(true) : null);
        Map properties = parent.getProperties();
        for (Map.Entry property : properties.entrySet()) {
            bookmark.setProperty((String)property.getKey(), (Serializable)property.getValue());
        }
        if (StringUtils.isSet((String)this.fLastRealm)) {
            bookmark.setProperty("org.rssowl.ui.BMRealmProperty", (Serializable)((Object)this.fLastRealm));
        }
        parent = (IFolder)DynamicDAO.save((IPersistable)parent);
        for (IMark mark : parent.getMarks()) {
            if (!mark.equals(bookmark)) continue;
            new ReloadTypesAction((IStructuredSelection)new StructuredSelection((Object)mark), this.getShell()).run();
            break;
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        return true;
    }
}

