/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.MarkTypesReadAction;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.undo.NewsStateOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.ModelUtils;

public class ToggleReadStateAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public static final String ID = "org.rssowl.ui.ToggleReadState";
    private static final EnumSet<INews.State> UNREAD_STATES = EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED);
    private IStructuredSelection fSelection;
    private boolean fMarkRead;

    public ToggleReadStateAction() {
        this((IStructuredSelection)StructuredSelection.EMPTY);
    }

    public ToggleReadStateAction(IStructuredSelection selection) {
        this.fSelection = selection;
        this.fMarkRead = this.shouldMarkRead(this.fSelection);
    }

    public int getStyle() {
        return 2;
    }

    private boolean shouldMarkRead(IStructuredSelection selection) {
        List<INews> entities = ModelUtils.getEntities(selection, INews.class);
        for (INews entity : entities) {
            if (!UNREAD_STATES.contains(entity.getState())) continue;
            return true;
        }
        return false;
    }

    public String getText() {
        IBindingService bs = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence binding = bs.getBestActiveBindingFor(ID);
        return binding != null ? NLS.bind((String)Messages.ToggleReadStateAction_NEWS_READ_BINDING, (Object)binding.format()) : Messages.ToggleReadStateAction_NEWS_READ;
    }

    public boolean isChecked() {
        return !this.fMarkRead && !this.fSelection.isEmpty();
    }

    public ImageDescriptor getImageDescriptor() {
        return OwlUI.getImageDescriptor("icons/elcl16/mark_read.gif");
    }

    public void run() {
        this.internalRun(this.fSelection, this.fMarkRead);
    }

    public void run(IAction action) {
        IStructuredSelection selection;
        FeedView activeFeedView = OwlUI.getActiveFeedView();
        if (activeFeedView != null && (selection = (IStructuredSelection)activeFeedView.getSite().getSelectionProvider().getSelection()) != null && !selection.isEmpty()) {
            this.internalRun(selection, this.shouldMarkRead(selection));
        }
    }

    private void internalRun(IStructuredSelection selection, boolean markRead) {
        if (selection.isEmpty()) {
            return;
        }
        if (markRead) {
            new MarkTypesReadAction(selection).run();
        } else {
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            List<INews> newsList = ModelUtils.getEntities(selection, INews.class);
            UndoStack.getInstance().addOperation(new NewsStateOperation(newsList, INews.State.UNREAD, false));
            ((INewsDAO)DynamicDAO.getDAO(INewsDAO.class)).setState(newsList, INews.State.UNREAD, false, false);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

