/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.NewsFilterDialog;
import org.rssowl.ui.internal.dialogs.NewsFiltersListDialog;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFilterAction
implements IObjectActionDelegate {
    public static final String ID = "org.rssowl.ui.CreateFilterAction";
    private IStructuredSelection fSelection;
    private PresetAction fPresetAction = PresetAction.NONE;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void setPresetAction(PresetAction action) {
        this.fPresetAction = action;
    }

    public void run(IAction action) {
        Shell shell = OwlUI.getActiveShell();
        if (shell != null && !this.fSelection.isEmpty()) {
            ISearch presetSearch = Owl.getModelFactory().createSearch(null);
            this.fillSearchConditions(presetSearch);
            presetSearch.setMatchAllConditions(true);
            List<IFilterAction> presetActions = null;
            boolean matchAll = false;
            switch (this.fPresetAction) {
                case DOWNLOAD: {
                    presetActions = Collections.singletonList(Owl.getModelFactory().createFilterAction("org.rssowl.ui.DownloadAttachmentsNewsAction"));
                    matchAll = true;
                    break;
                }
                case LABEL: {
                    presetActions = Collections.singletonList(Owl.getModelFactory().createFilterAction("org.rssowl.core.LabelNewsAction"));
                    break;
                }
                case MOVE: {
                    presetActions = Collections.singletonList(Owl.getModelFactory().createFilterAction("org.rssowl.core.MoveNewsAction"));
                    break;
                }
                case COPY: {
                    presetActions = Collections.singletonList(Owl.getModelFactory().createFilterAction("org.rssowl.core.CopyNewsAction"));
                }
            }
            NewsFilterDialog dialog = presetActions != null && !presetActions.isEmpty() ? new NewsFilterDialog(shell, presetSearch, presetActions, matchAll) : new NewsFilterDialog(shell, presetSearch);
            Collection existingFilters = DynamicDAO.loadAll(ISearchFilter.class);
            if (existingFilters != null && !existingFilters.isEmpty()) {
                dialog.setFilterPosition(existingFilters.size());
            }
            if (dialog.open() == 0) {
                NewsFiltersListDialog filterListDialog = NewsFiltersListDialog.getVisibleInstance();
                if (filterListDialog == null) {
                    filterListDialog = new NewsFiltersListDialog(shell);
                    filterListDialog.setSelection(dialog.getFilter());
                    filterListDialog.open();
                } else {
                    filterListDialog.refresh();
                    filterListDialog.setSelection(dialog.getFilter());
                    filterListDialog.getShell().forceActive();
                    if (filterListDialog.getShell().getMinimized()) {
                        filterListDialog.getShell().setMinimized(false);
                    }
                }
            }
        }
    }

    private void fillSearchConditions(ISearch presetSearch) {
        List selection = this.fSelection.toList();
        if (selection.get(0) instanceof INews) {
            this.fillSearchConditionsForNews(selection, presetSearch);
        } else if (selection.get(0) instanceof IFolderChild) {
            this.fillSearchConditionsForFolderChild(selection, presetSearch);
        }
    }

    private void fillSearchConditionsForFolderChild(List<?> selection, ISearch presetSearch) {
        ISearchField locationField = Owl.getModelFactory().createSearchField(19, INews.class.getName());
        Long[][] value = ModelUtils.toPrimitive(selection);
        ISearchCondition condition = Owl.getModelFactory().createSearchCondition(locationField, SearchSpecifier.SCOPE, (Object)value);
        presetSearch.addSearchCondition(condition);
    }

    private void fillSearchConditionsForNews(List<?> selection, ISearch presetSearch) {
        IPerson author;
        ICategory category;
        INews news = (INews)selection.get(0);
        IModelFactory factory = Owl.getModelFactory();
        ISearchField locationField = factory.createSearchField(19, INews.class.getName());
        FeedLinkReference feedReference = news.getFeedReference();
        Collection bookmarks = ((IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class)).loadAll(feedReference);
        Long[][] value = ModelUtils.toPrimitive(new ArrayList<IFolderChild>(bookmarks));
        ISearchCondition condition = factory.createSearchCondition(locationField, SearchSpecifier.SCOPE, (Object)value);
        presetSearch.addSearchCondition(condition);
        if (this.fPresetAction == PresetAction.DOWNLOAD) {
            return;
        }
        List categories = news.getCategories();
        if (!categories.isEmpty() && StringUtils.isSet((String)(category = (ICategory)categories.get(0)).getName())) {
            ISearchField categoryField = factory.createSearchField(12, INews.class.getName());
            ISearchCondition condition2 = factory.createSearchCondition(categoryField, SearchSpecifier.IS, (Object)category.getName());
            presetSearch.addSearchCondition(condition2);
        }
        if ((author = news.getAuthor()) != null) {
            String value2 = author.getName();
            if (!StringUtils.isSet((String)value2) && author.getEmail() != null) {
                value2 = author.getEmail().toString();
            }
            if (StringUtils.isSet((String)value2)) {
                ISearchField authorField = factory.createSearchField(3, INews.class.getName());
                condition = factory.createSearchCondition(authorField, SearchSpecifier.CONTAINS_ALL, (Object)value2);
                presetSearch.addSearchCondition(condition);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PresetAction {
        NONE,
        DOWNLOAD,
        LABEL,
        MOVE,
        COPY;

    }
}

