/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.util.JobRunner;

public class DefaultStatusHandler
extends WorkbenchErrorHandler {
    public void handle(StatusAdapter statusAdapter, int style) {
        IStatus status = statusAdapter.getStatus();
        if (status != null) {
            Throwable ex = status.getException();
            if (ex instanceof PersistenceException) {
                this.handlePersistenceException((PersistenceException)ex);
            } else if (ex instanceof OutOfMemoryError) {
                this.handleOutOfMemoryError((OutOfMemoryError)ex);
            } else if (ex != null) {
                Throwable cause = ex.getCause();
                if (cause instanceof PersistenceException) {
                    this.handlePersistenceException((PersistenceException)cause);
                } else if (cause instanceof OutOfMemoryError) {
                    this.handleOutOfMemoryError((OutOfMemoryError)cause);
                }
            }
        }
        super.handle(statusAdapter, style);
    }

    private void handlePersistenceException(final PersistenceException ex) {
        JobRunner.runInUIThread(null, new Runnable(){

            public void run() {
                Throwable cause = ex.getCause();
                if (cause != null && cause instanceof IOException) {
                    ErrorDialog.openError((Shell)OwlUI.getPrimaryShell(), (String)Messages.DefaultStatusHandler_ERROR, (String)Messages.DefaultStatusHandler_ERROR_DISK_WRITE, (IStatus)Activator.getDefault().createErrorStatus(cause.getMessage(), cause));
                }
            }
        });
    }

    private void handleOutOfMemoryError(OutOfMemoryError error) {
        Controller.getDefault().emergencyOutOfMemoryShutdown(error);
    }
}

