/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IPreferenceDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.NewsAdapter;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.PreferenceEvent;
import org.rssowl.core.persist.event.PreferenceListener;
import org.rssowl.core.persist.event.runnable.EventType;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.SearchHit;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationActionBarAdvisor;
import org.rssowl.ui.internal.ApplicationWorkbenchAdvisor;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EditorDNDImpl;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.ActivityDialog;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.notifier.NotificationService;
import org.rssowl.ui.internal.util.JobRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public static final String FOCUSLESS_SCROLL_HOOK = "org.rssowl.ui.internal.FocuslessScrollHook";
    private static final String SWT_BROWSER_WIN = "org.eclipse.swt.browser.WebSite";
    private static final int TEASE_LIMIT = 200;
    private TrayItem fTrayItem;
    private boolean fTrayTeasing;
    private boolean fTrayEnabled;
    private boolean fMinimizedToTray;
    private ApplicationActionBarAdvisor fActionBarAdvisor;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private IPreferenceScope fPreferences;
    private boolean fBlockIconifyEvent;
    private boolean fMinimizeFromClose;
    private Menu fTrayMenu;
    private List<Long> fTeasingNewsCache = new ArrayList<Long>();
    private ISearch fTodaysNewsSearch;
    private NewsAdapter fNewsListener;
    private ShellListener fTrayShellListener;
    private PreferenceListener fPrefListener;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.fActionBarAdvisor = new ApplicationActionBarAdvisor(configurer);
        return this.fActionBarAdvisor;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowMenuBar(true);
        configurer.setShowFastViewBars(false);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle("RSSOwl");
        Point size = OwlUI.getFirstMonitorSize();
        if (size != null) {
            configurer.setInitialSize(size);
        }
        configurer.addEditorAreaTransfer((Transfer)LocalSelectionTransfer.getTransfer());
        configurer.configureEditorAreaDropListener((DropTargetListener)new EditorDNDImpl());
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
    }

    void setToolBarVisible(boolean visible, boolean layout) {
        this.getWindowConfigurer().setShowCoolBar(visible);
        if (layout) {
            this.getWindowConfigurer().getWindow().getShell().layout();
        }
    }

    public void setStatusVisible(boolean visible, boolean layout) {
        this.getWindowConfigurer().setShowStatusLine(visible);
        this.getWindowConfigurer().setShowProgressIndicator(visible);
        boolean showsToolBar = this.getWindowConfigurer().getShowCoolBar();
        this.getWindowConfigurer().setShowCoolBar(!showsToolBar);
        this.getWindowConfigurer().setShowCoolBar(showsToolBar);
        if (layout) {
            this.getWindowConfigurer().getWindow().getShell().layout();
        }
    }

    public void postWindowCreate() {
        IPreferenceScope preferences;
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        if (window != null && this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_START)) {
            this.blockShellOpen(window);
        }
        if (!(preferences = Owl.getPreferenceService().getGlobalScope()).getBoolean(DefaultPreferences.SHOW_TOOLBAR)) {
            this.setToolBarVisible(false, false);
        }
        if (!preferences.getBoolean(DefaultPreferences.SHOW_STATUS)) {
            this.setStatusVisible(false, false);
        }
    }

    private void blockShellOpen(IWorkbenchWindow window) {
        try {
            Method method = window.getClass().getMethod("blockShellOpenOnce", new Class[0]);
            if (method != null) {
                method.invoke((Object)window, new Object[0]);
            }
        }
        catch (Exception exception) {}
    }

    public void postWindowOpen() {
        final Shell shell = this.getWindowConfigurer().getWindow().getShell();
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                boolean trayEnabled = false;
                if (ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_MINIMIZE) || ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_CLOSE) || ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_START)) {
                    trayEnabled = ApplicationWorkbenchWindowAdvisor.this.enableTray();
                }
                if (Application.IS_WINDOWS) {
                    ApplicationWorkbenchWindowAdvisor.this.hookFocuslessScrolling(shell.getDisplay());
                }
                ApplicationWorkbenchWindowAdvisor.this.registerListeners();
                if (trayEnabled && ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_START)) {
                    ApplicationWorkbenchWindowAdvisor.this.moveToTray(shell);
                }
            }
        });
        shell.getDisplay().addFilter(13, new Listener(){

            public void handleEvent(Event event) {
                ToolItem item;
                ToolBar toolbar;
                Composite parent;
                if (event.item == null && event.widget instanceof ToolItem && !((parent = (toolbar = (item = (ToolItem)event.widget).getParent()).getParent()) instanceof Shell) && (parent = parent.getParent()) != null && !(parent instanceof Shell) && !parent.isDisposed() && parent.getLayoutData() instanceof ProgressRegion) {
                    event.doit = false;
                    event.type = 0;
                    ApplicationWorkbenchWindowAdvisor.this.asyncOpenActivityDialog(toolbar.getShell());
                }
            }
        });
        Controller.getDefault().postWindowOpen();
    }

    private void asyncOpenActivityDialog(final Shell shell) {
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ActivityDialog instance = ActivityDialog.getVisibleInstance();
                if (instance == null) {
                    ActivityDialog dialog = new ActivityDialog(shell);
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                } else {
                    instance.getShell().forceActive();
                }
            }
        });
    }

    public boolean preWindowShellClose() {
        final boolean[] res = new boolean[]{true};
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                if (((Object)((Object)ApplicationWorkbenchWindowAdvisor.this)).equals((Object)ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor) && ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_CLOSE)) {
                    ApplicationWorkbenchWindowAdvisor.this.fMinimizeFromClose = true;
                    ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell().notifyListeners(19, new Event());
                    res[0] = false;
                    ApplicationWorkbenchWindowAdvisor.this.fMinimizeFromClose = false;
                } else {
                    ApplicationWorkbenchWindowAdvisor.this.onClose();
                }
            }
        });
        return res[0];
    }

    public boolean isMinimizedToTray() {
        return this.fMinimizedToTray;
    }

    public boolean isMinimized() {
        return this.getWindowConfigurer().getWindow().getShell().getMinimized();
    }

    private void registerListeners() {
        this.getWindowConfigurer().getWindow().getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellIconified(ShellEvent e) {
                if (!ApplicationWorkbenchWindowAdvisor.this.fBlockIconifyEvent) {
                    ApplicationWorkbenchWindowAdvisor.this.onMinimize();
                }
            }
        });
        this.fPrefListener = new PreferenceListener(){

            public void entitiesAdded(Set<PreferenceEvent> events) {
                ApplicationWorkbenchWindowAdvisor.this.onPreferencesChange(events, EventType.PERSIST);
            }

            public void entitiesDeleted(Set<PreferenceEvent> events) {
                ApplicationWorkbenchWindowAdvisor.this.onPreferencesChange(events, EventType.REMOVE);
            }

            public void entitiesUpdated(Set<PreferenceEvent> events) {
                ApplicationWorkbenchWindowAdvisor.this.onPreferencesChange(events, EventType.UPDATE);
            }
        };
        ((IPreferenceDAO)DynamicDAO.getDAO(IPreferenceDAO.class)).addEntityListener((EntityListener)this.fPrefListener);
    }

    private void unregisterListeners() {
        ((IPreferenceDAO)DynamicDAO.getDAO(IPreferenceDAO.class)).removeEntityListener((EntityListener)this.fPrefListener);
    }

    private void onPreferencesChange(Set<PreferenceEvent> events, EventType type) {
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        boolean useTray = false;
        boolean affectsTray = false;
        for (PreferenceEvent event : events) {
            String key = event.getEntity().getKey();
            if (DefaultPreferences.TRAY_ON_MINIMIZE.equals(key)) {
                affectsTray = true;
                useTray = type == EventType.REMOVE ? defaultScope.getBoolean(DefaultPreferences.TRAY_ON_MINIMIZE) || this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_CLOSE) : event.getEntity().getBoolean() != false || this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_CLOSE);
            } else if (DefaultPreferences.TRAY_ON_CLOSE.equals(key)) {
                affectsTray = true;
                if (type == EventType.REMOVE) {
                    useTray = defaultScope.getBoolean(DefaultPreferences.TRAY_ON_CLOSE) || this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_MINIMIZE);
                } else {
                    boolean bl = useTray = event.getEntity().getBoolean() != false || this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_MINIMIZE);
                }
            }
            if (affectsTray && useTray && !this.fTrayEnabled) {
                JobRunner.runInUIThread(null, new Runnable(){

                    public void run() {
                        ApplicationWorkbenchWindowAdvisor.this.enableTray();
                    }
                });
                continue;
            }
            if (!affectsTray || useTray || !this.fTrayEnabled) continue;
            JobRunner.runInUIThread(null, new Runnable(){

                public void run() {
                    ApplicationWorkbenchWindowAdvisor.this.disableTray();
                }
            });
        }
    }

    public void dispose() {
        this.unregisterListeners();
        if (this.fTrayItem != null) {
            this.fTrayItem.dispose();
        }
        if (this.fNewsListener != null) {
            DynamicDAO.removeEntityListener(INews.class, (EntityListener)this.fNewsListener);
        }
        this.fResources.dispose();
    }

    private void onMinimize() {
        IEditorPart activeEditor = OwlUI.getActiveEditor();
        if (activeEditor != null && activeEditor instanceof FeedView) {
            FeedView feedView = (FeedView)activeEditor;
            feedView.notifyUIEvent(FeedView.UIEvent.MINIMIZE);
        }
        Controller.getDefault().getSyncService().synchronize();
    }

    private void onClose() {
        IEditorPart activeEditor = OwlUI.getActiveEditor();
        if (activeEditor != null && activeEditor instanceof FeedView) {
            FeedView feedView = (FeedView)activeEditor;
            feedView.notifyUIEvent(FeedView.UIEvent.CLOSE);
        }
    }

    private boolean enableTray() {
        if (this.fTrayEnabled) {
            return true;
        }
        IWorkbenchWindow primaryWindow = OwlUI.getPrimaryWindow();
        if (primaryWindow == null || !primaryWindow.equals(this.getWindowConfigurer().getWindow())) {
            return false;
        }
        final Shell shell = primaryWindow.getShell();
        final int doubleClickTime = shell.getDisplay().getDoubleClickTime();
        final Tray tray = shell.getDisplay().getSystemTray();
        if (tray == null) {
            return false;
        }
        this.fTrayItem = new TrayItem(tray, 0);
        this.fTrayItem.setToolTipText("RSSOwl");
        this.fTrayEnabled = true;
        if (Application.IS_WINDOWS) {
            this.fTrayItem.setVisible(false);
        }
        this.fTrayItem.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.TRAY_OWL));
        this.fTrayShellListener = new ShellAdapter(){

            public void shellIconified(ShellEvent e) {
                if (!ApplicationWorkbenchWindowAdvisor.this.fBlockIconifyEvent && (ApplicationWorkbenchWindowAdvisor.this.fMinimizeFromClose || ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.TRAY_ON_MINIMIZE))) {
                    ApplicationWorkbenchWindowAdvisor.this.moveToTray(shell);
                }
            }
        };
        shell.addShellListener(this.fTrayShellListener);
        this.fTrayItem.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                ApplicationWorkbenchWindowAdvisor.this.showTrayMenu(shell);
            }
        });
        Listener selectionListener = new Listener(){
            private long lastDoubleClickTime;

            public void handleEvent(Event event) {
                boolean isDoubleClick;
                boolean restoreOnDoubleclick = ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.RESTORE_TRAY_DOUBLECLICK);
                boolean bl = isDoubleClick = event.type == 14;
                if (isDoubleClick) {
                    this.lastDoubleClickTime = System.currentTimeMillis();
                }
                if (!isDoubleClick && restoreOnDoubleclick && Application.IS_WINDOWS) {
                    NotificationService service = Controller.getDefault().getNotificationService();
                    if (service.isPopupVisible()) {
                        service.closePopup();
                    } else if (!service.wasPopupRecentlyClosed()) {
                        JobRunner.runInBackgroundThread(doubleClickTime, new Runnable(){

                            public void run() {
                                if (lastDoubleClickTime < System.currentTimeMillis() - (long)doubleClickTime) {
                                    JobRunner.runInUIThread((Widget)tray, new Runnable(){

                                        public void run() {
                                            if (!shell.isDisposed()) {
                                                ApplicationWorkbenchWindowAdvisor.this.onSingleClick(shell);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
                if (restoreOnDoubleclick != isDoubleClick) {
                    return;
                }
                if (!shell.isVisible()) {
                    ApplicationWorkbenchWindowAdvisor.this.restoreFromTray(shell);
                } else if (!Application.IS_WINDOWS) {
                    ApplicationWorkbenchWindowAdvisor.this.moveToTray(shell);
                }
            }
        };
        this.fTrayItem.addListener(14, selectionListener);
        this.fTrayItem.addListener(13, selectionListener);
        this.fNewsListener = new NewsAdapter(){

            public void entitiesAdded(final Set<NewsEvent> events) {
                if (!CoreUtils.containsState(events, (INews.State)INews.State.NEW)) {
                    return;
                }
                JobRunner.runInUIThread((Widget)ApplicationWorkbenchWindowAdvisor.this.fTrayItem, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (!ApplicationWorkbenchWindowAdvisor.this.fTrayItem.getVisible() || shell.getVisible()) {
                            return;
                        }
                        if (Controller.getDefault().isShuttingDown()) {
                            return;
                        }
                        if (Application.IS_WINDOWS && ApplicationWorkbenchWindowAdvisor.this.fPreferences.getBoolean(DefaultPreferences.RESTORE_TRAY_DOUBLECLICK)) {
                            List list = ApplicationWorkbenchWindowAdvisor.this.fTeasingNewsCache;
                            synchronized (list) {
                                for (NewsEvent event : events) {
                                    if (event.getEntity().getState() != INews.State.NEW) continue;
                                    ApplicationWorkbenchWindowAdvisor.this.fTeasingNewsCache.add(event.getEntity().getId());
                                }
                                if (!ApplicationWorkbenchWindowAdvisor.this.fTeasingNewsCache.isEmpty()) {
                                    ApplicationWorkbenchWindowAdvisor.this.fTrayItem.setToolTipText(NLS.bind((String)Messages.ApplicationWorkbenchWindowAdvisor_N_INCOMING_NEWS, (Object)ApplicationWorkbenchWindowAdvisor.this.fTeasingNewsCache.size()));
                                }
                            }
                        }
                        if (!ApplicationWorkbenchWindowAdvisor.this.fTrayTeasing) {
                            ApplicationWorkbenchWindowAdvisor.this.fTrayTeasing = true;
                            ApplicationWorkbenchWindowAdvisor.this.fTrayItem.setImage(OwlUI.getImage((ResourceManager)ApplicationWorkbenchWindowAdvisor.this.fResources, OwlUI.TRAY_OWL_TEASING));
                        }
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(INews.class, (EntityListener)this.fNewsListener);
        return true;
    }

    private void moveToTray(Shell shell) {
        if (Application.IS_WINDOWS) {
            this.fTrayItem.setVisible(true);
        }
        this.fBlockIconifyEvent = true;
        try {
            shell.setVisible(false);
        }
        finally {
            this.fBlockIconifyEvent = false;
        }
        this.fMinimizedToTray = true;
    }

    public void restoreFromTray(Shell shell) {
        if (Application.IS_MAC && shell.getMinimized()) {
            shell.setMinimized(false);
        }
        shell.setVisible(true);
        if (Application.IS_MAC) {
            shell.forceActive();
        } else {
            shell.setActive();
        }
        if (!Application.IS_MAC && shell.getMinimized()) {
            shell.setMinimized(false);
        }
        if (Application.IS_WINDOWS) {
            this.fTrayItem.setVisible(false);
        }
        this.fMinimizedToTray = false;
        this.clearTease(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTease(boolean clearTray) {
        if (this.fTrayTeasing) {
            this.fTrayItem.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.TRAY_OWL));
        }
        this.fTrayTeasing = false;
        if (Application.IS_WINDOWS) {
            List<Long> list = this.fTeasingNewsCache;
            synchronized (list) {
                this.fTeasingNewsCache.clear();
            }
            this.fTrayItem.setToolTipText(clearTray ? "" : "RSSOwl");
        }
    }

    private void disableTray() {
        if (!this.fTrayEnabled) {
            return;
        }
        this.restoreFromTray(this.getWindowConfigurer().getWindow().getShell());
        this.fTrayEnabled = false;
        this.fMinimizedToTray = false;
        if (this.fTrayItem != null) {
            this.fTrayItem.dispose();
        }
        if (this.fNewsListener != null) {
            DynamicDAO.removeEntityListener(INews.class, (EntityListener)this.fNewsListener);
        }
        if (this.fTrayShellListener != null) {
            this.getWindowConfigurer().getWindow().getShell().removeShellListener(this.fTrayShellListener);
        }
    }

    private void hookFocuslessScrolling(final Display display) {
        display.addFilter(37, new Listener(){

            public void handleEvent(Event event) {
                Control control = display.getCursorControl();
                if (control == null || control.isDisposed() || control.isFocusControl()) {
                    return;
                }
                boolean isBrowser = ApplicationWorkbenchWindowAdvisor.SWT_BROWSER_WIN.equals(control.getClass().getName());
                if (isBrowser || control.getData(ApplicationWorkbenchWindowAdvisor.FOCUSLESS_SCROLL_HOOK) != null) {
                    control.setFocus();
                    event.doit = false;
                    event.widget = control;
                    display.post(event);
                }
            }
        });
    }

    public IWorkbenchWindowConfigurer getWindowConfigurer() {
        return super.getWindowConfigurer();
    }

    private void showTrayMenu(final Shell shell) {
        MenuManager trayMenuManager = new MenuManager();
        trayMenuManager.add((IContributionItem)new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem restoreItem = new MenuItem(menu, 8);
                restoreItem.setText(Messages.ApplicationWorkbenchWindowAdvisor_RESTORE);
                restoreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ApplicationWorkbenchWindowAdvisor.this.restoreFromTray(shell);
                    }
                });
                menu.setDefaultItem(restoreItem);
            }
        });
        trayMenuManager.add((IContributionItem)new Separator());
        this.fActionBarAdvisor.fillTrayItem((IMenuManager)trayMenuManager, shell, this);
        if (this.fTrayMenu != null) {
            OwlUI.safeDispose(this.fTrayMenu);
        }
        this.fTrayMenu = trayMenuManager.createContextMenu((Control)shell);
        this.fTrayMenu.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSingleClick(Shell shell) {
        NotificationService service = Controller.getDefault().getNotificationService();
        ArrayList<INews> newsToShow = new ArrayList<INews>();
        NotificationService.Mode mode = NotificationService.Mode.RECENT;
        if (service.isPopupVisible()) {
            return;
        }
        if (!this.fTeasingNewsCache.isEmpty()) {
            List<Long> list = this.fTeasingNewsCache;
            synchronized (list) {
                int counter = 0;
                int i = this.fTeasingNewsCache.size() - 1;
                while (i >= 0) {
                    NewsReference reference = new NewsReference(this.fTeasingNewsCache.get(i).longValue());
                    INews newsitem = reference.resolve();
                    if (newsitem != null && newsitem.getState() == INews.State.NEW && service.shouldShow(newsitem)) {
                        newsToShow.add(newsitem);
                        if (++counter >= 200) {
                            break;
                        }
                    } else {
                        CoreUtils.reportIndexIssue();
                    }
                    if (service.isPopupVisible()) {
                        return;
                    }
                    --i;
                }
            }
            mode = NotificationService.Mode.INCOMING_MANUAL;
        }
        if (newsToShow.isEmpty()) {
            if (this.fTodaysNewsSearch == null) {
                IModelFactory factory = Owl.getModelFactory();
                String newsClassName = INews.class.getName();
                ISearchField ageInDaysField = factory.createSearchField(18, newsClassName);
                ISearchField ageInMinutesField = factory.createSearchField(21, newsClassName);
                ISearchCondition dayCondition = factory.createSearchCondition(ageInDaysField, SearchSpecifier.IS_LESS_THAN, (Object)1);
                ISearchCondition recentCondition = factory.createSearchCondition(ageInMinutesField, SearchSpecifier.IS_LESS_THAN, (Object)-360);
                this.fTodaysNewsSearch = factory.createSearch(null);
                this.fTodaysNewsSearch.setMatchAllConditions(false);
                this.fTodaysNewsSearch.addSearchCondition(dayCondition);
                this.fTodaysNewsSearch.addSearchCondition(recentCondition);
            }
            List result = Owl.getPersistenceService().getModelSearch().searchNews(this.fTodaysNewsSearch);
            TreeSet<NewsReference> recentNews = new TreeSet<NewsReference>(new Comparator<NewsReference>(){

                @Override
                public int compare(NewsReference ref1, NewsReference ref2) {
                    if (ref1.equals((Object)ref2)) {
                        return 0;
                    }
                    return ref1.getId() > ref2.getId() ? -1 : 1;
                }
            });
            for (SearchHit hit : result) {
                recentNews.add((NewsReference)hit.getResult());
            }
            int counter = 0;
            for (NewsReference reference : recentNews) {
                INews newsitem = reference.resolve();
                if (newsitem != null && newsitem.isVisible() && service.shouldShow(newsitem)) {
                    newsToShow.add(newsitem);
                    if (++counter >= 200) {
                        break;
                    }
                } else if (newsitem == null) {
                    CoreUtils.reportIndexIssue();
                }
                if (!service.isPopupVisible()) continue;
                return;
            }
            mode = NotificationService.Mode.RECENT;
        }
        if (service.isPopupVisible()) {
            return;
        }
        if (!newsToShow.isEmpty()) {
            service.show(newsToShow, null, mode);
            this.clearTease(true);
        } else {
            this.showTrayMenu(shell);
        }
    }
}

