/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationWorkbenchAdvisor;
import org.rssowl.ui.internal.ApplicationWorkbenchWindowAdvisor;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.CoolBarAdvisor;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.ShareProvider;
import org.rssowl.ui.internal.actions.ArchiveNewsAction;
import org.rssowl.ui.internal.actions.AssignLabelsAction;
import org.rssowl.ui.internal.actions.AutomateFilterAction;
import org.rssowl.ui.internal.actions.CopyLinkAction;
import org.rssowl.ui.internal.actions.CreateFilterAction;
import org.rssowl.ui.internal.actions.FindAction;
import org.rssowl.ui.internal.actions.LabelAction;
import org.rssowl.ui.internal.actions.MakeNewsStickyAction;
import org.rssowl.ui.internal.actions.MarkAllNewsReadAction;
import org.rssowl.ui.internal.actions.MoveCopyNewsToBinAction;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.OpenInExternalBrowserAction;
import org.rssowl.ui.internal.actions.OpenInNewTabAction;
import org.rssowl.ui.internal.actions.RedoAction;
import org.rssowl.ui.internal.actions.ReloadAllAction;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.actions.SearchNewsAction;
import org.rssowl.ui.internal.actions.ToggleReadStateAction;
import org.rssowl.ui.internal.actions.UndoAction;
import org.rssowl.ui.internal.dialogs.CustomizeToolbarDialog;
import org.rssowl.ui.internal.dialogs.LabelDialog;
import org.rssowl.ui.internal.dialogs.preferences.NotifierPreferencesPage;
import org.rssowl.ui.internal.dialogs.welcome.TutorialWizard;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.editors.feed.FeedViewInput;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsColumnViewModel;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.editors.feed.NewsGrouping;
import org.rssowl.ui.internal.handler.TutorialHandler;
import org.rssowl.ui.internal.services.DownloadService;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    public static final String M_MANAGE_EXTENSIONS = "manageExtensions";
    public static final String M_VIEW = "view";
    public static final String M_VIEW_START = "viewStart";
    public static final String M_VIEW_END = "viewEnd";
    private static ResourceManager fgResources = new LocalResourceManager(JFaceResources.getResources());
    private CoolBarAdvisor fCoolBarAdvisor;
    private IContributionItem fOpenWindowsItem;
    private IContributionItem fReopenEditors;
    private FindAction fFindAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.register((IAction)ActionFactory.SAVE_AS.create(window));
        this.register((IAction)ActionFactory.CLOSE.create(window));
        this.register((IAction)ActionFactory.CLOSE_ALL.create(window));
        this.register((IAction)ActionFactory.PRINT.create(window));
        this.register((IAction)ActionFactory.QUIT.create(window));
        this.fReopenEditors = ContributionItemFactory.REOPEN_EDITORS.create(window);
        this.register((IAction)ActionFactory.CUT.create(window));
        this.register((IAction)ActionFactory.COPY.create(window));
        this.register((IAction)ActionFactory.PASTE.create(window));
        this.register((IAction)ActionFactory.DELETE.create(window));
        this.register((IAction)ActionFactory.SELECT_ALL.create(window));
        this.register((IAction)ActionFactory.PROPERTIES.create(window));
        this.fFindAction = new FindAction();
        this.register((IAction)this.fFindAction);
        this.register((IAction)ActionFactory.PREFERENCES.create(window));
        this.register((IAction)ActionFactory.OPEN_NEW_WINDOW.create(window));
        this.getAction(ActionFactory.OPEN_NEW_WINDOW.getId()).setText(Messages.ApplicationActionBarAdvisor_NEW_WINDOW);
        this.fOpenWindowsItem = ContributionItemFactory.OPEN_WINDOWS.create(window);
        this.register((IAction)ActionFactory.ABOUT.create(window));
        this.getAction(ActionFactory.ABOUT.getId()).setText(Messages.ApplicationActionBarAdvisor_ABOUT_RSSOWL);
        this.register((IAction)ActionFactory.LOCK_TOOL_BAR.create(window));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        this.createFileMenu(menuBar);
        this.createEditMenu(menuBar);
        this.createViewMenu(menuBar);
        this.createGoMenu(menuBar);
        this.createBookMarksMenu(menuBar);
        this.createNewsMenu(menuBar);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        this.createToolsMenu(menuBar);
        this.createWindowMenu(menuBar);
        this.createHelpMenu(menuBar);
    }

    private void createFileMenu(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_FILE, "file");
        menuBar.add((IContributionItem)fileMenu);
        fileMenu.add((IContributionItem)new GroupMarker("fileStart"));
        fileMenu.add((IContributionItem)new GroupMarker("new.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add(this.getAction(ActionFactory.CLOSE.getId()));
        fileMenu.add(this.getAction(ActionFactory.CLOSE_ALL.getId()));
        fileMenu.add((IContributionItem)new GroupMarker("close.ext"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add(this.getAction(ActionFactory.SAVE_AS.getId()));
        if (!Application.IS_MAC) {
            fileMenu.add((IContributionItem)new Separator());
            fileMenu.add(this.getAction(ActionFactory.PRINT.getId()));
        }
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("additions"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker("fileEnd"));
        fileMenu.add((IContributionItem)new Separator());
        if (Application.IS_LINUX) {
            fileMenu.add(this.getAction(ActionFactory.PROPERTIES.getId()));
            fileMenu.add((IContributionItem)new Separator());
        }
        fileMenu.add(this.getAction(ActionFactory.QUIT.getId()));
    }

    private void createEditMenu(IMenuManager menuBar) {
        MenuManager editMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_EDIT, "edit");
        editMenu.add(this.getAction(ActionFactory.COPY.getId()));
        menuBar.add((IContributionItem)editMenu);
        editMenu.setRemoveAllWhenShown(true);
        editMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager editMenu) {
                editMenu.add((IContributionItem)new GroupMarker("editStart"));
                editMenu.add((IContributionItem)new Separator());
                editMenu.add((IAction)new UndoAction());
                editMenu.add((IAction)new RedoAction());
                editMenu.add((IContributionItem)new GroupMarker("undo.ext"));
                editMenu.add((IContributionItem)new Separator());
                editMenu.add(ApplicationActionBarAdvisor.this.getAction(ActionFactory.CUT.getId()));
                editMenu.add(ApplicationActionBarAdvisor.this.getAction(ActionFactory.COPY.getId()));
                editMenu.add((IAction)new CopyLinkAction());
                editMenu.add(ApplicationActionBarAdvisor.this.getAction(ActionFactory.PASTE.getId()));
                editMenu.add((IContributionItem)new Separator());
                editMenu.add(ApplicationActionBarAdvisor.this.getAction(ActionFactory.DELETE.getId()));
                editMenu.add(ApplicationActionBarAdvisor.this.getAction(ActionFactory.SELECT_ALL.getId()));
                editMenu.add((IContributionItem)new Separator());
                editMenu.add((IAction)new SearchNewsAction(OwlUI.getWindow()));
                editMenu.add((IAction)ApplicationActionBarAdvisor.this.fFindAction);
                editMenu.add((IContributionItem)new GroupMarker("editEnd"));
                editMenu.add((IContributionItem)new Separator());
                if (Application.IS_LINUX) {
                    IAction preferences = ApplicationActionBarAdvisor.this.getAction(ActionFactory.PREFERENCES.getId());
                    preferences.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/preferences.gif"));
                    editMenu.add(preferences);
                } else {
                    editMenu.add(ApplicationActionBarAdvisor.this.getAction(ActionFactory.PROPERTIES.getId()));
                }
            }
        });
    }

    private void createViewMenu(IMenuManager menuBar) {
        final IPreferenceScope globalPreferences = Owl.getPreferenceService().getGlobalScope();
        final IPreferenceScope eclipsePrefs = Owl.getPreferenceService().getEclipseScope();
        MenuManager viewMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_VIEW, M_VIEW);
        viewMenu.setRemoveAllWhenShown(true);
        menuBar.add((IContributionItem)viewMenu);
        viewMenu.add((IAction)new Action(""){

            public void run() {
            }
        });
        viewMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NewsGrouping.Type[] groups;
                NewsFilter.Type[] filters;
                NewsColumn[] columns;
                FeedView activeFeedView = OwlUI.getActiveFeedView();
                final IPreferenceScope entityPreferences = OwlUI.getActiveFeedViewPreferences();
                final OwlUI.Layout layout = OwlUI.getLayout(entityPreferences != null ? entityPreferences : globalPreferences);
                final OwlUI.PageSize pageSize = OwlUI.getPageSize(entityPreferences != null ? entityPreferences : globalPreferences);
                manager.add((IContributionItem)new GroupMarker(ApplicationActionBarAdvisor.M_VIEW_START));
                MenuManager layoutMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_LAYOUT);
                layoutMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_CLASSIC_LAYOUT, 8){

                    public void run() {
                        if (super.isChecked()) {
                            ApplicationActionBarAdvisor.this.updateLayoutPreferences(globalPreferences, entityPreferences, OwlUI.Layout.CLASSIC);
                        }
                    }

                    public boolean isChecked() {
                        return layout == OwlUI.Layout.CLASSIC;
                    }
                });
                layoutMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_VERTICAL_LAYOUT, 8){

                    public void run() {
                        if (super.isChecked()) {
                            ApplicationActionBarAdvisor.this.updateLayoutPreferences(globalPreferences, entityPreferences, OwlUI.Layout.VERTICAL);
                        }
                    }

                    public boolean isChecked() {
                        return layout == OwlUI.Layout.VERTICAL;
                    }
                });
                layoutMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_LIST_LAYOUT, 8){

                    public void run() {
                        if (super.isChecked()) {
                            ApplicationActionBarAdvisor.this.updateLayoutPreferences(globalPreferences, entityPreferences, OwlUI.Layout.LIST);
                        }
                    }

                    public boolean isChecked() {
                        return layout == OwlUI.Layout.LIST;
                    }
                });
                layoutMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_NEWSPAPER_LAYOUT, 8){

                    public void run() {
                        if (super.isChecked()) {
                            ApplicationActionBarAdvisor.this.updateLayoutPreferences(globalPreferences, entityPreferences, OwlUI.Layout.NEWSPAPER);
                        }
                    }

                    public boolean isChecked() {
                        return layout == OwlUI.Layout.NEWSPAPER;
                    }
                });
                layoutMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_HEADLINES_LAYOUT, 8){

                    public void run() {
                        if (super.isChecked()) {
                            ApplicationActionBarAdvisor.this.updateLayoutPreferences(globalPreferences, entityPreferences, OwlUI.Layout.HEADLINES);
                        }
                    }

                    public boolean isChecked() {
                        return layout == OwlUI.Layout.HEADLINES;
                    }
                });
                if (layout == OwlUI.Layout.NEWSPAPER || layout == OwlUI.Layout.HEADLINES) {
                    layoutMenu.add((IContributionItem)new Separator());
                    MenuManager pageMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_PAGE_SIZE);
                    pageMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_T_ARTICLES, 8){

                        public void run() {
                            if (super.isChecked()) {
                                ApplicationActionBarAdvisor.this.updatePageSizePreferences(globalPreferences, entityPreferences, OwlUI.PageSize.TEN);
                            }
                        }

                        public boolean isChecked() {
                            return pageSize == OwlUI.PageSize.TEN;
                        }
                    });
                    pageMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_TF_ARTICLES, 8){

                        public void run() {
                            if (super.isChecked()) {
                                ApplicationActionBarAdvisor.this.updatePageSizePreferences(globalPreferences, entityPreferences, OwlUI.PageSize.TWENTY_FIVE);
                            }
                        }

                        public boolean isChecked() {
                            return pageSize == OwlUI.PageSize.TWENTY_FIVE;
                        }
                    });
                    pageMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_F_ARTICLES, 8){

                        public void run() {
                            if (super.isChecked()) {
                                ApplicationActionBarAdvisor.this.updatePageSizePreferences(globalPreferences, entityPreferences, OwlUI.PageSize.FIFTY);
                            }
                        }

                        public boolean isChecked() {
                            return pageSize == OwlUI.PageSize.FIFTY;
                        }
                    });
                    pageMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_H_ARTICLES, 8){

                        public void run() {
                            if (super.isChecked()) {
                                ApplicationActionBarAdvisor.this.updatePageSizePreferences(globalPreferences, entityPreferences, OwlUI.PageSize.HUNDRED);
                            }
                        }

                        public boolean isChecked() {
                            return pageSize == OwlUI.PageSize.HUNDRED;
                        }
                    });
                    pageMenu.add((IContributionItem)new Separator());
                    pageMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_ALL_ARTICLES, 8){

                        public void run() {
                            if (super.isChecked()) {
                                ApplicationActionBarAdvisor.this.updatePageSizePreferences(globalPreferences, entityPreferences, OwlUI.PageSize.NO_PAGING);
                            }
                        }

                        public boolean isChecked() {
                            return pageSize == OwlUI.PageSize.NO_PAGING;
                        }
                    });
                    layoutMenu.add((IContributionItem)pageMenu);
                }
                manager.add((IContributionItem)layoutMenu);
                final boolean isColumnsEnabled = layout != OwlUI.Layout.NEWSPAPER && layout != OwlUI.Layout.HEADLINES;
                MenuManager columnsMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_COLUMNS);
                final NewsColumnViewModel model = NewsColumnViewModel.loadFrom(entityPreferences != null ? entityPreferences : globalPreferences);
                NewsColumn[] newsColumnArray = columns = NewsColumn.values();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    final NewsColumn column = newsColumnArray[n2];
                    if (column.isSelectable()) {
                        columnsMenu.add((IAction)new Action(column.getName(), 2){

                            public void run() {
                                if (model.contains(column)) {
                                    model.removeColumn(column);
                                } else {
                                    model.addColumn(column);
                                }
                                ApplicationActionBarAdvisor.this.updateColumnsPreferences(globalPreferences, entityPreferences, model, new String[]{DefaultPreferences.BM_NEWS_COLUMNS});
                            }

                            public boolean isChecked() {
                                return model.contains(column);
                            }

                            public boolean isEnabled() {
                                return isColumnsEnabled;
                            }
                        });
                    }
                    ++n2;
                }
                columnsMenu.add((IContributionItem)new Separator());
                columnsMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_RESTORE_DEFAULT_COLUMNS){

                    public void run() {
                        NewsColumnViewModel defaultModel = NewsColumnViewModel.createDefault(false);
                        ApplicationActionBarAdvisor.this.updateColumnsPreferences(globalPreferences, entityPreferences, defaultModel, new String[]{DefaultPreferences.BM_NEWS_COLUMNS, DefaultPreferences.BM_NEWS_SORT_COLUMN, DefaultPreferences.BM_NEWS_SORT_ASCENDING});
                    }

                    public boolean isEnabled() {
                        return isColumnsEnabled;
                    }
                });
                manager.add((IContributionItem)columnsMenu);
                MenuManager sortingMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_SORT_BY);
                NewsColumn[] newsColumnArray2 = columns;
                int n3 = columns.length;
                n = 0;
                while (n < n3) {
                    final NewsColumn column = newsColumnArray2[n];
                    if (column.isSelectable()) {
                        sortingMenu.add((IAction)new Action(column.getName(), 8){

                            public void run() {
                                if (super.isChecked()) {
                                    model.setSortColumn(column);
                                    ApplicationActionBarAdvisor.this.updateColumnsPreferences(globalPreferences, entityPreferences, model, new String[]{DefaultPreferences.BM_NEWS_SORT_COLUMN});
                                }
                            }

                            public boolean isChecked() {
                                return model.getSortColumn().equals((Object)column);
                            }
                        });
                    }
                    ++n;
                }
                sortingMenu.add((IContributionItem)new Separator());
                sortingMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_ASCENDING, 8){

                    public void run() {
                        if (super.isChecked()) {
                            model.setAscending(true);
                            ApplicationActionBarAdvisor.this.updateColumnsPreferences(globalPreferences, entityPreferences, model, new String[]{DefaultPreferences.BM_NEWS_SORT_ASCENDING});
                        }
                    }

                    public boolean isChecked() {
                        return model.isAscending();
                    }
                });
                sortingMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_DESCENDING, 8){

                    public void run() {
                        if (super.isChecked()) {
                            model.setAscending(false);
                            ApplicationActionBarAdvisor.this.updateColumnsPreferences(globalPreferences, entityPreferences, model, new String[]{DefaultPreferences.BM_NEWS_SORT_ASCENDING});
                        }
                    }

                    public boolean isChecked() {
                        return !model.isAscending();
                    }
                });
                manager.add((IContributionItem)sortingMenu);
                manager.add((IContributionItem)new Separator());
                MenuManager filterMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_FILTER_NEWS);
                int selectedFilterIndex = entityPreferences != null ? ModelUtils.loadIntegerValueWithFallback(entityPreferences, DefaultPreferences.BM_NEWS_FILTERING, globalPreferences, DefaultPreferences.FV_FILTER_TYPE) : ModelUtils.loadIntegerValueWithFallback(globalPreferences, DefaultPreferences.BM_NEWS_FILTERING, globalPreferences, DefaultPreferences.FV_FILTER_TYPE);
                final NewsFilter.Type selectedFilter = NewsFilter.Type.values()[selectedFilterIndex];
                NewsFilter.Type[] typeArray = filters = new NewsFilter.Type[]{NewsFilter.Type.SHOW_ALL, NewsFilter.Type.SHOW_NEW, NewsFilter.Type.SHOW_UNREAD, NewsFilter.Type.SHOW_STICKY, NewsFilter.Type.SHOW_LABELED, NewsFilter.Type.SHOW_RECENT, NewsFilter.Type.SHOW_LAST_5_DAYS};
                int n4 = filters.length;
                int n5 = 0;
                while (n5 < n4) {
                    final NewsFilter.Type filter = typeArray[n5];
                    filterMenu.add((IAction)new Action(filter.getName(), 8){

                        public void run() {
                            if (super.isChecked()) {
                                ApplicationActionBarAdvisor.this.updateFilterAndGroupingPreferences(globalPreferences, entityPreferences, filter, null);
                            }
                        }

                        public boolean isChecked() {
                            return filter == selectedFilter;
                        }
                    });
                    if (filter == NewsFilter.Type.SHOW_ALL || filter == NewsFilter.Type.SHOW_UNREAD || filter == NewsFilter.Type.SHOW_LABELED) {
                        filterMenu.add((IContributionItem)new Separator());
                    }
                    ++n5;
                }
                manager.add((IContributionItem)filterMenu);
                MenuManager groupMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_GROUP_NEWS);
                int selectedGroupIndex = entityPreferences != null ? ModelUtils.loadIntegerValueWithFallback(entityPreferences, DefaultPreferences.BM_NEWS_GROUPING, globalPreferences, DefaultPreferences.FV_GROUP_TYPE) : ModelUtils.loadIntegerValueWithFallback(globalPreferences, DefaultPreferences.BM_NEWS_GROUPING, globalPreferences, DefaultPreferences.FV_GROUP_TYPE);
                final NewsGrouping.Type selectedGroup = NewsGrouping.Type.values()[selectedGroupIndex];
                NewsGrouping.Type[] typeArray2 = groups = new NewsGrouping.Type[]{NewsGrouping.Type.NO_GROUPING, NewsGrouping.Type.GROUP_BY_DATE, NewsGrouping.Type.GROUP_BY_AUTHOR, NewsGrouping.Type.GROUP_BY_CATEGORY, NewsGrouping.Type.GROUP_BY_TOPIC, NewsGrouping.Type.GROUP_BY_FEED, NewsGrouping.Type.GROUP_BY_STATE, NewsGrouping.Type.GROUP_BY_STICKY, NewsGrouping.Type.GROUP_BY_LABEL};
                int n6 = groups.length;
                int n7 = 0;
                while (n7 < n6) {
                    final NewsGrouping.Type group = typeArray2[n7];
                    groupMenu.add((IAction)new Action(group.getName(), 8){

                        public void run() {
                            if (super.isChecked()) {
                                ApplicationActionBarAdvisor.this.updateFilterAndGroupingPreferences(globalPreferences, entityPreferences, null, group);
                            }
                        }

                        public boolean isChecked() {
                            return group == selectedGroup;
                        }
                    });
                    if (group == NewsGrouping.Type.NO_GROUPING || group == NewsGrouping.Type.GROUP_BY_FEED || group == NewsGrouping.Type.GROUP_BY_STICKY) {
                        groupMenu.add((IContributionItem)new Separator());
                    }
                    ++n7;
                }
                manager.add((IContributionItem)groupMenu);
                final boolean isZoomingEnabled = activeFeedView != null && activeFeedView.isBrowserShowingNews();
                manager.add((IContributionItem)new Separator());
                MenuManager zoomMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_ZOOM);
                zoomMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_ZOOM_IN){

                    public void run() {
                        OwlUI.zoomNewsText(true, false);
                    }

                    public String getId() {
                        return "org.rssowl.ui.ZoomInCommand";
                    }

                    public String getActionDefinitionId() {
                        return "org.rssowl.ui.ZoomInCommand";
                    }

                    public boolean isEnabled() {
                        return isZoomingEnabled;
                    }
                });
                zoomMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_ZOOM_OUT){

                    public void run() {
                        OwlUI.zoomNewsText(false, false);
                    }

                    public String getId() {
                        return "org.rssowl.ui.ZoomOutCommand";
                    }

                    public String getActionDefinitionId() {
                        return "org.rssowl.ui.ZoomOutCommand";
                    }

                    public boolean isEnabled() {
                        return isZoomingEnabled;
                    }
                });
                zoomMenu.add((IContributionItem)new Separator());
                zoomMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_RESET){

                    public void run() {
                        OwlUI.zoomNewsText(false, true);
                    }

                    public String getId() {
                        return "org.rssowl.ui.ZoomResetCommand";
                    }

                    public String getActionDefinitionId() {
                        return "org.rssowl.ui.ZoomResetCommand";
                    }

                    public boolean isEnabled() {
                        return isZoomingEnabled;
                    }
                });
                manager.add((IContributionItem)zoomMenu);
                manager.add((IContributionItem)new Separator());
                final MenuManager toolbarsMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_TOOLBARS);
                toolbarsMenu.setRemoveAllWhenShown(true);
                toolbarsMenu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        boolean useExternalBrowser = OwlUI.useExternalBrowser();
                        toolbarsMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_TOOLBAR, 2){

                            public void run() {
                                ApplicationWorkbenchWindowAdvisor configurer = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                                boolean isMainToolBarVisible = globalPreferences.getBoolean(DefaultPreferences.SHOW_TOOLBAR);
                                configurer.setToolBarVisible(!isMainToolBarVisible, true);
                                globalPreferences.putBoolean(DefaultPreferences.SHOW_TOOLBAR, !isMainToolBarVisible);
                            }

                            public boolean isChecked() {
                                return globalPreferences.getBoolean(DefaultPreferences.SHOW_TOOLBAR);
                            }
                        });
                        toolbarsMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_FEED_TOOLBAR, 2){

                            public void run() {
                                boolean isFeedToolBarHidden = globalPreferences.getBoolean(DefaultPreferences.FV_FEED_TOOLBAR_HIDDEN);
                                globalPreferences.putBoolean(DefaultPreferences.FV_FEED_TOOLBAR_HIDDEN, !isFeedToolBarHidden);
                                EditorUtils.updateToolbarVisibility();
                            }

                            public boolean isChecked() {
                                return !globalPreferences.getBoolean(DefaultPreferences.FV_FEED_TOOLBAR_HIDDEN);
                            }
                        });
                        if (!useExternalBrowser) {
                            toolbarsMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_BROWSER_TOOLBAR, 2){

                                public void run() {
                                    boolean isBrowserToolBarHidden = globalPreferences.getBoolean(DefaultPreferences.FV_BROWSER_TOOLBAR_HIDDEN);
                                    globalPreferences.putBoolean(DefaultPreferences.FV_BROWSER_TOOLBAR_HIDDEN, !isBrowserToolBarHidden);
                                    EditorUtils.updateToolbarVisibility();
                                }

                                public boolean isChecked() {
                                    return !globalPreferences.getBoolean(DefaultPreferences.FV_BROWSER_TOOLBAR_HIDDEN);
                                }
                            });
                        }
                    }
                });
                manager.add((IContributionItem)toolbarsMenu);
                manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_STATUS, 2){

                    public void run() {
                        ApplicationWorkbenchWindowAdvisor configurer = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                        boolean isStatusVisible = globalPreferences.getBoolean(DefaultPreferences.SHOW_STATUS);
                        configurer.setStatusVisible(!isStatusVisible, true);
                        globalPreferences.putBoolean(DefaultPreferences.SHOW_STATUS, !isStatusVisible);
                    }

                    public boolean isChecked() {
                        return globalPreferences.getBoolean(DefaultPreferences.SHOW_STATUS);
                    }
                });
                manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_BOOKMARKS, 2){

                    public void run() {
                        OwlUI.toggleBookmarks();
                    }

                    public String getActionDefinitionId() {
                        return "org.rssowl.ui.ToggleBookmarksCommand";
                    }

                    public String getId() {
                        return "org.rssowl.ui.ToggleBookmarksCommand";
                    }

                    public boolean isChecked() {
                        IWorkbenchPage page = OwlUI.getPage();
                        if (page != null) {
                            return page.findView("org.rssowl.ui.BookMarkExplorer") != null;
                        }
                        return false;
                    }
                });
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_CUSTOMIZE_TOOLBAR){

                    public void run() {
                        CustomizeToolbarDialog dialog;
                        ApplicationWorkbenchWindowAdvisor configurer = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                        boolean isToolBarVisible = globalPreferences.getBoolean(DefaultPreferences.SHOW_TOOLBAR);
                        if (!isToolBarVisible) {
                            configurer.setToolBarVisible(true, true);
                            globalPreferences.putBoolean(DefaultPreferences.SHOW_TOOLBAR, true);
                        }
                        if ((dialog = new CustomizeToolbarDialog(ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow().getShell())).open() == 0) {
                            ApplicationActionBarAdvisor.this.fCoolBarAdvisor.advise(true);
                        }
                    }
                });
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_TABBED_BROWSING, 2){

                    public void run() {
                        boolean tabbedBrowsingEnabled = this.isChecked();
                        if (tabbedBrowsingEnabled) {
                            IEditorReference[] editorReferences;
                            boolean doit = true;
                            IWorkbenchPage page = OwlUI.getPage();
                            if (page != null && (editorReferences = page.getEditorReferences()).length > 1) {
                                MessageBox confirmDialog = new MessageBox(page.getWorkbenchWindow().getShell(), 196);
                                confirmDialog.setText(Messages.ApplicationActionBarAdvisor_DISABLE_TABBED_BROWSING);
                                confirmDialog.setMessage(NLS.bind((String)Messages.ApplicationActionBarAdvisor_TABS_MESSAGE, (Object)editorReferences.length));
                                if (confirmDialog.open() == 64) {
                                    OwlUI.closeOtherEditors();
                                } else {
                                    doit = false;
                                }
                            }
                            if (doit) {
                                eclipsePrefs.putBoolean(DefaultPreferences.ECLIPSE_MULTIPLE_TABS, false);
                                eclipsePrefs.putBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS, true);
                                eclipsePrefs.putInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD, 1);
                            }
                        } else {
                            eclipsePrefs.putBoolean(DefaultPreferences.ECLIPSE_MULTIPLE_TABS, true);
                            eclipsePrefs.putBoolean(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS, false);
                            eclipsePrefs.putInteger(DefaultPreferences.ECLIPSE_AUTOCLOSE_TABS_THRESHOLD, 5);
                        }
                    }

                    public boolean isChecked() {
                        return OwlUI.isTabbedBrowsingEnabled();
                    }
                });
                manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_FULL_SCREEN, 2){

                    public void run() {
                        OwlUI.toggleFullScreen();
                    }

                    public String getActionDefinitionId() {
                        return "org.rssowl.ui.FullScreenCommand";
                    }

                    public String getId() {
                        return "org.rssowl.ui.FullScreenCommand";
                    }

                    public boolean isChecked() {
                        Shell shell = OwlUI.getActiveShell();
                        if (shell != null) {
                            return shell.getFullScreen();
                        }
                        return super.isChecked();
                    }
                });
                manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_MINIMIZE){

                    public void run() {
                        Shell shell = OwlUI.getActiveShell();
                        if (shell != null) {
                            shell.setMinimized(true);
                        }
                    }

                    public String getActionDefinitionId() {
                        return "org.rssowl.ui.MinimizeCommand";
                    }

                    public String getId() {
                        return "org.rssowl.ui.MinimizeCommand";
                    }
                });
                manager.add((IContributionItem)new GroupMarker("additions"));
                manager.add((IContributionItem)new GroupMarker(ApplicationActionBarAdvisor.M_VIEW_START));
            }
        });
    }

    private void updatePageSizePreferences(IPreferenceScope globalPreferences, IPreferenceScope entityPreferences, OwlUI.PageSize pageSize) {
        globalPreferences.putInteger(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE, pageSize.getPageSize());
        if (entityPreferences != null && entityPreferences.hasKey(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE)) {
            entityPreferences.delete(DefaultPreferences.NEWS_BROWSER_PAGE_SIZE);
            entityPreferences.flush();
        }
    }

    private void updateLayoutPreferences(IPreferenceScope globalPreferences, IPreferenceScope entityPreferences, OwlUI.Layout layout) {
        globalPreferences.putInteger(DefaultPreferences.FV_LAYOUT, layout.ordinal());
        if (entityPreferences != null && entityPreferences.hasKey(DefaultPreferences.FV_LAYOUT)) {
            entityPreferences.delete(DefaultPreferences.FV_LAYOUT);
            entityPreferences.flush();
        }
        EditorUtils.updateLayout();
    }

    private void updateFilterAndGroupingPreferences(IPreferenceScope globalPreferences, IPreferenceScope entityPreferences, NewsFilter.Type filter, NewsGrouping.Type grouping) {
        if (filter != null) {
            globalPreferences.putInteger(DefaultPreferences.BM_NEWS_FILTERING, filter.ordinal());
        }
        if (grouping != null) {
            globalPreferences.putInteger(DefaultPreferences.BM_NEWS_GROUPING, grouping.ordinal());
        }
        if (entityPreferences != null) {
            boolean flush = false;
            if (filter != null && entityPreferences.hasKey(DefaultPreferences.BM_NEWS_FILTERING)) {
                entityPreferences.delete(DefaultPreferences.BM_NEWS_FILTERING);
                flush = true;
            }
            if (grouping != null && entityPreferences.hasKey(DefaultPreferences.BM_NEWS_GROUPING)) {
                entityPreferences.delete(DefaultPreferences.BM_NEWS_GROUPING);
                flush = true;
            }
            if (flush) {
                entityPreferences.flush();
            }
        }
        EditorUtils.updateFilterAndGrouping();
    }

    private void updateColumnsPreferences(IPreferenceScope globalPreferences, IPreferenceScope entityPreferences, NewsColumnViewModel model, String ... prefKeys) {
        boolean saveColumns = this.contains(DefaultPreferences.BM_NEWS_COLUMNS, prefKeys);
        boolean saveSortColumn = this.contains(DefaultPreferences.BM_NEWS_SORT_COLUMN, prefKeys);
        boolean saveSortDirection = this.contains(DefaultPreferences.BM_NEWS_SORT_ASCENDING, prefKeys);
        model.saveTo(globalPreferences, false, saveColumns, saveSortColumn, saveSortDirection);
        if (entityPreferences != null && prefKeys != null) {
            boolean flush = false;
            String[] stringArray = prefKeys;
            int n = prefKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String prefKey = stringArray[n2];
                if (entityPreferences.hasKey(prefKey)) {
                    entityPreferences.delete(prefKey);
                    flush = true;
                }
                ++n2;
            }
            if (flush) {
                entityPreferences.flush();
            }
        }
        EditorUtils.updateColumns();
    }

    private boolean contains(String key, String ... elements) {
        if (elements == null) {
            return false;
        }
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (key.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void createGoMenu(IMenuManager menuBar) {
        MenuManager goMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_GO, "navigate");
        menuBar.add((IContributionItem)goMenu);
        goMenu.add((IContributionItem)new GroupMarker("additions"));
        goMenu.add(this.fReopenEditors);
    }

    private void createBookMarksMenu(IMenuManager menuBar) {
        MenuManager bmMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_BOOKMARKS, "bookmarks");
        bmMenu.setRemoveAllWhenShown(true);
        bmMenu.add((IAction)new Action(""){});
        bmMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationActionBarAdvisor.fillBookMarksMenu(manager, ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow());
                manager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        menuBar.add((IContributionItem)bmMenu);
    }

    private void createNewsMenu(IMenuManager menuBar) {
        MenuManager newsMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_NEWS, "news");
        menuBar.add((IContributionItem)newsMenu);
        newsMenu.setRemoveAllWhenShown(true);
        newsMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructuredSelection selection;
                FeedView activeFeedView = OwlUI.getActiveFeedView();
                FeedViewInput activeInput = null;
                if (activeFeedView != null) {
                    selection = (IStructuredSelection)activeFeedView.getSite().getSelectionProvider().getSelection();
                    activeInput = (FeedViewInput)activeFeedView.getEditorInput();
                } else {
                    selection = StructuredSelection.EMPTY;
                }
                boolean isEntityGroupSelected = ModelUtils.isEntityGroupSelected((ISelection)selection);
                if (!isEntityGroupSelected) {
                    manager.add((IContributionItem)new Separator("open"));
                    manager.add((IAction)new OpenInBrowserAction((IStructuredSelection)selection, WebBrowserContext.createFrom((ISelection)selection, activeFeedView), (IStructuredSelection)selection){
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.val$selection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public boolean isEnabled() {
                            return !this.val$selection.isEmpty();
                        }
                    });
                    if (!selection.isEmpty() && !OwlUI.useExternalBrowser()) {
                        manager.add((IAction)new OpenInExternalBrowserAction((IStructuredSelection)selection));
                    }
                }
                ApplicationActionBarAdvisor.fillAttachmentsMenu(manager, (IStructuredSelection)selection, (IShellProvider)ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow(), false);
                manager.add((IContributionItem)new Separator("mark"));
                MenuManager markMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_MARK, "mark");
                manager.add((IContributionItem)markMenu);
                Action action = new ToggleReadStateAction((IStructuredSelection)selection);
                action.setEnabled(!selection.isEmpty());
                markMenu.add((IAction)action);
                action = new MarkAllNewsReadAction();
                action.setEnabled(activeFeedView != null);
                markMenu.add((IAction)action);
                markMenu.add((IContributionItem)new Separator());
                action = new MakeNewsStickyAction((IStructuredSelection)selection);
                action.setEnabled(!selection.isEmpty());
                markMenu.add((IAction)action);
                ApplicationActionBarAdvisor.fillLabelMenu(manager, (IStructuredSelection)selection, (IShellProvider)ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow(), false);
                if (!selection.isEmpty()) {
                    manager.add((IContributionItem)new Separator("movecopy"));
                    ArrayList newsbins = new ArrayList(DynamicDAO.loadAll(INewsBin.class));
                    Comparator<INewsBin> comparator = new Comparator<INewsBin>(){

                        @Override
                        public int compare(INewsBin o1, INewsBin o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    };
                    Collections.sort(newsbins, comparator);
                    MenuManager moveMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_MOVE_TO, "moveto");
                    manager.add((IContributionItem)moveMenu);
                    for (INewsBin bin : newsbins) {
                        if (activeInput != null && activeInput.getMark().equals(bin)) continue;
                        moveMenu.add((IAction)new MoveCopyNewsToBinAction((IStructuredSelection)selection, bin, true));
                    }
                    moveMenu.add((IAction)new MoveCopyNewsToBinAction((IStructuredSelection)selection, null, true));
                    moveMenu.add((IContributionItem)new Separator());
                    moveMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.MOVE, (ISelection)selection));
                    MenuManager copyMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_COPY_TO, "copyto");
                    manager.add((IContributionItem)copyMenu);
                    for (INewsBin bin : newsbins) {
                        if (activeInput != null && activeInput.getMark().equals(bin)) continue;
                        copyMenu.add((IAction)new MoveCopyNewsToBinAction((IStructuredSelection)selection, bin, false));
                    }
                    copyMenu.add((IAction)new MoveCopyNewsToBinAction((IStructuredSelection)selection, null, false));
                    copyMenu.add((IContributionItem)new Separator());
                    copyMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.COPY, (ISelection)selection));
                    manager.add((IAction)new ArchiveNewsAction((IStructuredSelection)selection));
                }
                ApplicationActionBarAdvisor.fillShareMenu(manager, (IStructuredSelection)selection, (IShellProvider)ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow(), false);
                if (!selection.isEmpty()) {
                    manager.add((IContributionItem)new Separator("filter"));
                    manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_CREATE_FILTER, (IStructuredSelection)selection){
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.val$selection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            CreateFilterAction action = new CreateFilterAction();
                            action.selectionChanged(null, (ISelection)this.val$selection);
                            action.run(null);
                        }

                        public ImageDescriptor getImageDescriptor() {
                            return OwlUI.FILTER;
                        }

                        public String getActionDefinitionId() {
                            return "org.rssowl.ui.CreateFilterAction";
                        }

                        public String getId() {
                            return "org.rssowl.ui.CreateFilterAction";
                        }
                    });
                }
                manager.add((IContributionItem)new Separator("reload"));
                manager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_UPDATE, (IStructuredSelection)selection){
                    private final /* synthetic */ IStructuredSelection val$selection;
                    {
                        this.val$selection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        ReloadTypesAction action = new ReloadTypesAction();
                        action.selectionChanged(null, (ISelection)this.val$selection);
                        action.run(null);
                    }

                    public ImageDescriptor getImageDescriptor() {
                        return OwlUI.getImageDescriptor("icons/elcl16/reload.gif");
                    }

                    public ImageDescriptor getDisabledImageDescriptor() {
                        return OwlUI.getImageDescriptor("icons/dlcl16/reload.gif");
                    }

                    public boolean isEnabled() {
                        return !this.val$selection.isEmpty() || OwlUI.getActiveFeedView() != null;
                    }

                    public String getActionDefinitionId() {
                        return "org.rssowl.ui.actions.Reload";
                    }

                    public String getId() {
                        return "org.rssowl.ui.actions.Reload";
                    }
                });
                manager.add((IAction)new ReloadAllAction());
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
    }

    private void createToolsMenu(IMenuManager menuBar) {
        MenuManager toolsMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_TOOLS, "tools");
        menuBar.add((IContributionItem)toolsMenu);
        toolsMenu.add((IContributionItem)new GroupMarker("begin"));
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("middle"));
        toolsMenu.add((IContributionItem)new Separator("addons"));
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("additions"));
        toolsMenu.add((IContributionItem)new Separator());
        toolsMenu.add((IContributionItem)new GroupMarker("end"));
        if (!Application.IS_LINUX) {
            IContributionItem item;
            toolsMenu.add((IContributionItem)new Separator());
            IAction preferences = this.getAction(ActionFactory.PREFERENCES.getId());
            preferences.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/preferences.gif"));
            toolsMenu.add(preferences);
            if (Application.IS_MAC && (item = toolsMenu.find(ActionFactory.PREFERENCES.getId())) != null) {
                item.setVisible(false);
            }
        }
    }

    private void createWindowMenu(IMenuManager menuBar) {
        MenuManager windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_WINDOW, "window");
        menuBar.add((IContributionItem)windowMenu);
        IAction openNewWindowAction = this.getAction(ActionFactory.OPEN_NEW_WINDOW.getId());
        openNewWindowAction.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/newwindow.gif"));
        windowMenu.add(openNewWindowAction);
        windowMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add(this.fOpenWindowsItem);
    }

    private void createHelpMenu(IMenuManager menuBar) {
        IContributionItem item;
        MenuManager helpMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_HELP, "help");
        menuBar.add((IContributionItem)helpMenu);
        helpMenu.add((IContributionItem)new GroupMarker("helpStart"));
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_TUTORIAL){

            public void run() {
                TutorialWizard wizard = new TutorialWizard();
                OwlUI.openWizard(ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow().getShell(), wizard, false, false, null);
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.getImageDescriptor("icons/elcl16/help.gif");
            }

            public String getId() {
                return TutorialHandler.ID;
            }

            public String getActionDefinitionId() {
                return TutorialHandler.ID;
            }
        });
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_FAQ){

            public void run() {
                BrowserUtils.openLinkExternal("http://www.rssowl.org/help");
            }
        });
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_VISIT_FORUM){

            public void run() {
                BrowserUtils.openLinkExternal("http://sourceforge.net/projects/rssowl/forums/forum/296910");
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.getImageDescriptor("icons/obj16/forum.gif");
            }
        });
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_SHOW_KEY_BINDINGS){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IBindingService bindingService = (IBindingService)workbench.getService(IBindingService.class);
                bindingService.openKeyAssistDialog();
            }
        });
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_REPORT_PROBLEMS){

            public void run() {
                BrowserUtils.openLinkExternal("http://dev.rssowl.org");
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.getImageDescriptor("icons/elcl16/bug.gif");
            }
        });
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_EXPORT_LOGFILE){

            public void run() {
                block10: {
                    FileDialog dialog = new FileDialog(ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow().getShell(), 8192);
                    dialog.setText(Messages.ApplicationActionBarAdvisor_EXPORT_LOGFILE_DIALOG);
                    dialog.setFilterExtensions(new String[]{"*.log"});
                    dialog.setFileName("rssowl.log");
                    dialog.setOverwrite(true);
                    String file = dialog.open();
                    if (StringUtils.isSet((String)file)) {
                        try {
                            String logMessages = CoreUtils.getAndFlushLogMessages();
                            if (logMessages != null && logMessages.length() > 0) {
                                Activator.safeLogError(logMessages, null);
                            }
                            Activator.safeLogInfo("Error Log Exported");
                            File logFile = Platform.getLogFileLocation().toFile();
                            InputStream inS = logFile.exists() ? new FileInputStream(logFile) : new ByteArrayInputStream(new byte[0]);
                            FileOutputStream outS = new FileOutputStream(new File(file));
                            CoreUtils.copy((InputStream)inS, (OutputStream)outS);
                            String nl = System.getProperty("line.separator");
                            if (!StringUtils.isSet((String)nl)) {
                                nl = "\n";
                            }
                            StringBuilder errorReport = new StringBuilder();
                            Collection bookmarks = ((IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class)).loadAll();
                            for (IBookMark bookmark : bookmarks) {
                                Object errorObj;
                                if (!bookmark.isErrorLoading() || (errorObj = bookmark.getProperty("org.rssowl.ui.internal.LoadErrorKey")) == null || !(errorObj instanceof String)) continue;
                                errorReport.append((CharSequence)Controller.getDefault().createLogEntry(bookmark, null, (String)errorObj));
                                errorReport.append(nl).append(nl);
                            }
                            if (errorReport.length() <= 0) break block10;
                            FileWriter writer = new FileWriter(new File(file), true);
                            try {
                                writer.append(nl).append(nl).append(nl);
                                writer.write("--- Summary of Feeds that are not Loading -----------------------------------------------");
                                writer.append(nl).append(nl);
                                writer.write(errorReport.toString());
                                writer.close();
                            }
                            finally {
                                writer.close();
                            }
                        }
                        catch (FileNotFoundException e) {
                            Activator.getDefault().logError(e.getMessage(), e);
                        }
                        catch (IOException e) {
                            Activator.getDefault().logError(e.getMessage(), e);
                        }
                    }
                }
            }
        });
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_HOMEPAGE){

            public void run() {
                BrowserUtils.openLinkExternal("http://www.rssowl.org");
            }
        });
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_LICENSE){

            public void run() {
                BrowserUtils.openLinkExternal("http://www.rssowl.org/legal/epl-v10.html");
            }
        });
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_DONATE){

            public void run() {
                BrowserUtils.openLinkExternal("http://sourceforge.net/donate/index.php?group_id=86683");
            }
        });
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new GroupMarker("helpEnd"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add(this.getAction(ActionFactory.ABOUT.getId()));
        if (Application.IS_MAC && (item = helpMenu.find(ActionFactory.ABOUT.getId())) != null) {
            item.setVisible(false);
        }
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        super.fillStatusLine(statusLine);
    }

    public void fillActionBars(int flags) {
        super.fillActionBars(flags);
    }

    protected void fillTrayItem(IMenuManager trayItem, final Shell shell, final ApplicationWorkbenchWindowAdvisor advisor) {
        trayItem.add((IAction)new ReloadAllAction(false));
        trayItem.add((IContributionItem)new Separator());
        trayItem.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_CONFIGURE_NOTIFICATIONS){

            public void run() {
                advisor.restoreFromTray(shell);
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)NotifierPreferencesPage.ID, null, null).open();
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.getImageDescriptor("icons/elcl16/notification.gif");
            }
        });
        trayItem.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_PREFERENCES){

            public void run() {
                advisor.restoreFromTray(shell);
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.ui.preferencePages.Workbench", null, null).open();
            }

            public ImageDescriptor getImageDescriptor() {
                return OwlUI.getImageDescriptor("icons/elcl16/preferences.gif");
            }
        });
        trayItem.add((IContributionItem)new Separator("additions"));
        trayItem.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_EXIT){

            public void run() {
                PlatformUI.getWorkbench().close();
            }
        });
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        MenuManager coolBarContextMenuManager = new MenuManager(null, "org.rssowl.ui.CoolBarContextMenu");
        coolBar.setContextMenuManager((IMenuManager)coolBarContextMenuManager);
        coolBarContextMenuManager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_CUSTOMIZE_TOOLBAR){

            public void run() {
                CustomizeToolbarDialog dialog = new CustomizeToolbarDialog(ApplicationActionBarAdvisor.this.getActionBarConfigurer().getWindowConfigurer().getWindow().getShell());
                if (dialog.open() == 0) {
                    ApplicationActionBarAdvisor.this.fCoolBarAdvisor.advise(true);
                }
            }
        });
        coolBarContextMenuManager.add((IContributionItem)new Separator());
        IAction lockToolbarAction = this.getAction(ActionFactory.LOCK_TOOL_BAR.getId());
        lockToolbarAction.setText(Messages.ApplicationActionBarAdvisor_LOCK_TOOLBAR);
        coolBarContextMenuManager.add(lockToolbarAction);
        coolBarContextMenuManager.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_HIDE_TOOLBAR){

            public void run() {
                ApplicationWorkbenchWindowAdvisor configurer = ApplicationWorkbenchAdvisor.fgPrimaryApplicationWorkbenchWindowAdvisor;
                configurer.setToolBarVisible(false, true);
                Owl.getPreferenceService().getGlobalScope().putBoolean(DefaultPreferences.SHOW_TOOLBAR, false);
            }
        });
        coolBarContextMenuManager.add((IContributionItem)new GroupMarker("additions"));
        this.fCoolBarAdvisor = new CoolBarAdvisor(coolBar, this.getActionBarConfigurer().getWindowConfigurer().getWindow());
        this.fCoolBarAdvisor.advise();
    }

    public static void fillAttachmentsMenu(IMenuManager manager, IStructuredSelection selection, final IShellProvider shellProvider, boolean directMenu) {
        final List<Pair<IAttachment, URI>> attachments = ModelUtils.getAttachmentLinks(selection);
        if (!attachments.isEmpty()) {
            IMenuManager attachmentMenu;
            manager.add((IContributionItem)new Separator("attachments"));
            if (directMenu) {
                attachmentMenu = manager;
            } else {
                attachmentMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_ATTACHMENTS, "attachments");
                manager.add((IContributionItem)attachmentMenu);
            }
            final IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
            if (attachments.size() > 1) {
                int sumBytes = 0;
                for (Pair<IAttachment, URI> attachment : attachments) {
                    if (((IAttachment)attachment.getFirst()).getLength() > 0) {
                        sumBytes += ((IAttachment)attachment.getFirst()).getLength();
                        continue;
                    }
                    sumBytes = 0;
                    break;
                }
                String sumSize = OwlUI.getSize(sumBytes);
                Action downloadAllAction = new Action(sumSize != null ? NLS.bind((String)Messages.ApplicationActionBarAdvisor_DOWNLOAD_ALL_WITH_SIZE, (Object)sumSize) : Messages.ApplicationActionBarAdvisor_DOWNLOAD_ALL){

                    public void run() {
                        String folder;
                        DirectoryDialog dialog = new DirectoryDialog(shellProvider.getShell(), 0);
                        dialog.setText(Messages.ApplicationActionBarAdvisor_SELECT_FOLDER_FOR_DOWNLOADS);
                        String downloadFolder = preferences.getString(DefaultPreferences.DOWNLOAD_FOLDER);
                        if (StringUtils.isSet((String)downloadFolder) && new File(downloadFolder).exists()) {
                            dialog.setFilterPath(downloadFolder);
                        }
                        if (StringUtils.isSet((String)(folder = dialog.open()))) {
                            for (Pair attachment : attachments) {
                                Controller.getDefault().getDownloadService().download(DownloadService.DownloadRequest.createAttachmentDownloadRequest((IAttachment)attachment.getFirst(), (URI)attachment.getSecond(), new File(folder), true, null));
                            }
                            preferences.putString(DefaultPreferences.DOWNLOAD_FOLDER, folder);
                        }
                    }
                };
                downloadAllAction.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/save_all.gif"));
                attachmentMenu.add((IAction)downloadAllAction);
                attachmentMenu.add((IContributionItem)new Separator());
            }
            ArrayList<23> openActions = new ArrayList<23>(1);
            Set<String> downloadLocations = ApplicationActionBarAdvisor.getDownloadLocations();
            block1: for (final Pair<IAttachment, URI> attachmentPair : attachments) {
                String usedFileName;
                IAttachment attachment = (IAttachment)attachmentPair.getFirst();
                final String fileName = URIUtils.getFile((URI)((URI)attachmentPair.getSecond()), (String)OwlUI.getExtensionForMime(attachment.getType()));
                String size = OwlUI.getSize(attachment.getLength());
                Action action = new Action(size != null ? NLS.bind((String)Messages.ApplicationActionBarAdvisor_FILE_SIZE, (Object)fileName, (Object)size) : fileName){

                    public void run() {
                        String selectedFileName;
                        FileDialog dialog = new FileDialog(shellProvider.getShell(), 8192);
                        dialog.setText(Messages.ApplicationActionBarAdvisor_SELECT_FILE_FOR_DOWNLOAD);
                        dialog.setFileName(Application.IS_WINDOWS ? CoreUtils.getSafeFileNameForWindows((String)fileName) : fileName);
                        dialog.setOverwrite(true);
                        String downloadFolder = preferences.getString(DefaultPreferences.DOWNLOAD_FOLDER);
                        if (StringUtils.isSet((String)downloadFolder) && new File(downloadFolder).exists()) {
                            dialog.setFilterPath(downloadFolder);
                        }
                        if (StringUtils.isSet((String)(selectedFileName = dialog.open()))) {
                            File file = new File(selectedFileName);
                            Controller.getDefault().getDownloadService().download(DownloadService.DownloadRequest.createAttachmentDownloadRequest((IAttachment)attachmentPair.getFirst(), (URI)attachmentPair.getSecond(), file.getParentFile(), true, file.getName()));
                            preferences.putString(DefaultPreferences.DOWNLOAD_FOLDER, file.getParentFile().toString());
                        }
                    }
                };
                action.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/save_as.gif"));
                attachmentMenu.add((IAction)action);
                String string = usedFileName = Application.IS_WINDOWS ? CoreUtils.getSafeFileNameForWindows((String)fileName) : fileName;
                if (!ApplicationActionBarAdvisor.shouldOfferOpenAction(usedFileName)) continue;
                for (String downloadLocation : downloadLocations) {
                    final File downloadedFile = new File(downloadLocation, usedFileName);
                    if (!downloadedFile.exists()) continue;
                    Action openAction = new Action(NLS.bind((String)Messages.ApplicationActionBarAdvisor_OPEN_FILE, (Object)fileName)){

                        public void run() {
                            Program.launch((String)downloadedFile.toString());
                        }
                    };
                    openAction.setImageDescriptor(OwlUI.getAttachmentImage(fileName, ((IAttachment)attachmentPair.getFirst()).getType()));
                    openActions.add(openAction);
                    continue block1;
                }
            }
            boolean separate = true;
            if (!openActions.isEmpty()) {
                attachmentMenu.add((IContributionItem)new Separator());
                for (Action action : openActions) {
                    attachmentMenu.add((IAction)action);
                }
            } else if (attachments.size() == 1) {
                separate = false;
                attachmentMenu.add((IContributionItem)new Separator());
                CopyLinkAction copyLinkAction = new CopyLinkAction();
                copyLinkAction.setIgnoreActiveSelection(true);
                copyLinkAction.selectionChanged((IAction)copyLinkAction, (ISelection)new StructuredSelection(attachments.iterator().next().getFirst()));
                attachmentMenu.add((IAction)copyLinkAction);
            }
            if (separate) {
                attachmentMenu.add((IContributionItem)new Separator());
            }
            attachmentMenu.add((IAction)new AutomateFilterAction(CreateFilterAction.PresetAction.DOWNLOAD, (ISelection)selection));
        }
    }

    private static boolean shouldOfferOpenAction(String filename) {
        if (Application.IS_WINDOWS) {
            return !filename.endsWith(".exe") && !filename.endsWith(".bat") && !filename.endsWith(".com");
        }
        return true;
    }

    private static Set<String> getDownloadLocations() {
        File folder;
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        HashSet<String> locations = new HashSet<String>(1);
        String folderPath = preferences.getString(DefaultPreferences.DOWNLOAD_FOLDER);
        if (folderPath != null && (folder = new File(folderPath)).exists()) {
            locations.add(folderPath);
        }
        Collection filters = DynamicDAO.loadAll(ISearchFilter.class);
        for (ISearchFilter filter : filters) {
            List actions = filter.getActions();
            for (IFilterAction action : actions) {
                File folder2;
                if (!"org.rssowl.ui.DownloadAttachmentsNewsAction".equals(action.getActionId()) || !(action.getData() instanceof String) || (folderPath = (String)action.getData()) == null || !(folder2 = new File(folderPath)).exists()) continue;
                locations.add(folderPath);
            }
        }
        return locations;
    }

    public static void fillShareMenu(IMenuManager manager, final IStructuredSelection selection, final IShellProvider shellProvider, boolean directMenu) {
        IMenuManager shareMenu;
        manager.add((IContributionItem)new Separator("share"));
        if (directMenu) {
            shareMenu = manager;
        } else {
            shareMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_SHARE_NEWS, OwlUI.SHARE, "sharenews");
            manager.add((IContributionItem)shareMenu);
        }
        final boolean isEnabled = !selection.isEmpty() && !ModelUtils.isEntityGroupSelected((ISelection)selection);
        List<ShareProvider> providers = Controller.getDefault().getShareProviders();
        for (final ShareProvider provider : providers) {
            if (!provider.isEnabled()) continue;
            shareMenu.add((IAction)new Action(provider.getName()){

                public void run() {
                    Controller.getDefault().share(selection, provider);
                }

                public ImageDescriptor getImageDescriptor() {
                    if (StringUtils.isSet((String)provider.getIconPath())) {
                        return OwlUI.getImageDescriptor(provider.getPluginId(), provider.getIconPath());
                    }
                    return super.getImageDescriptor();
                }

                public String getText() {
                    IBindingService bs = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
                    TriggerSequence binding = bs.getBestActiveBindingFor(provider.getId());
                    return binding != null ? NLS.bind((String)Messages.ApplicationActionBarAdvisor_SHARE_BINDING, (Object)provider.getName(), (Object)binding.format()) : provider.getName();
                }

                public boolean isEnabled() {
                    return isEnabled;
                }

                public String getActionDefinitionId() {
                    return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getActionDefinitionId();
                }

                public String getId() {
                    return "org.rssowl.ui.SendLinkAction".equals(provider.getId()) ? "org.rssowl.ui.SendLinkAction" : super.getId();
                }
            });
        }
        shareMenu.add((IContributionItem)new Separator());
        shareMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_CONFIGURE){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)shellProvider.getShell(), (String)"org.rssowl.ui.SharingPreferencesPage", null, null).open();
            }
        });
    }

    public static void fillLabelMenu(IMenuManager manager, final IStructuredSelection selection, final IShellProvider shellProvider, boolean directMenu) {
        IMenuManager labelMenu;
        if (directMenu) {
            labelMenu = manager;
        } else {
            labelMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_LABEL);
            manager.add((IContributionItem)labelMenu);
        }
        labelMenu.add((IAction)new AssignLabelsAction(shellProvider.getShell(), selection));
        labelMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_ORGANIZE_LABELS){

            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)shellProvider.getShell(), (String)"org.rssowl.ui.ManageLabels", null, null).open();
            }
        });
        final Set labels = CoreUtils.loadSortedLabels();
        labelMenu.add((IContributionItem)new Separator());
        Set<ILabel> selectedLabels = ModelUtils.getLabelsForAll(selection);
        for (ILabel label : labels) {
            LabelAction labelAction = new LabelAction(label, selection);
            labelAction.setChecked(selectedLabels.contains(label));
            labelMenu.add((IAction)labelAction);
        }
        labelMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_NEW_LABEL){

            public void run() {
                LabelDialog dialog = new LabelDialog(shellProvider.getShell(), LabelDialog.DialogMode.ADD, null);
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    RGB color = dialog.getColor();
                    ILabel newLabel = Owl.getModelFactory().createLabel(null, name);
                    newLabel.setColor(OwlUI.toString(color));
                    newLabel.setOrder(labels.size());
                    DynamicDAO.save((IPersistable)newLabel);
                    LabelAction labelAction = new LabelAction(newLabel, selection);
                    labelAction.run();
                }
            }

            public boolean isEnabled() {
                return !selection.isEmpty();
            }
        });
        labelMenu.add((IContributionItem)new Separator());
        LabelAction removeAllLabels = new LabelAction(null, selection);
        removeAllLabels.setId("org.rssowl.ui.RemoveLabelsCommand");
        removeAllLabels.setActionDefinitionId("org.rssowl.ui.RemoveLabelsCommand");
        removeAllLabels.setEnabled(!selection.isEmpty() && !labels.isEmpty());
        labelMenu.add((IAction)removeAllLabels);
    }

    public static void fillBookMarksMenu(IMenuManager menu, IWorkbenchWindow window) {
        Set roots = CoreUtils.loadRootFolders();
        final IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        BookMarkFilter.Type[] allFilters = BookMarkFilter.Type.values();
        BookMarkFilter.Type selectedFilter = allFilters[preferences.getInteger(DefaultPreferences.BM_MENU_FILTER)];
        List<BookMarkFilter.Type> displayedFilters = Arrays.asList(BookMarkFilter.Type.SHOW_ALL, BookMarkFilter.Type.SHOW_NEW, BookMarkFilter.Type.SHOW_UNREAD, BookMarkFilter.Type.SHOW_STICKY);
        MenuManager optionsMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_FILTER_ELEMENTS, selectedFilter == BookMarkFilter.Type.SHOW_ALL ? OwlUI.FILTER : OwlUI.getImageDescriptor("icons/etool16/filter_active.gif"), null);
        for (final BookMarkFilter.Type filter : displayedFilters) {
            String name = Messages.ApplicationActionBarAdvisor_SHOW_ALL;
            switch (filter) {
                case SHOW_NEW: {
                    name = Messages.ApplicationActionBarAdvisor_SHOW_NEW;
                    break;
                }
                case SHOW_UNREAD: {
                    name = Messages.ApplicationActionBarAdvisor_SHOW_UNREAD;
                    break;
                }
                case SHOW_STICKY: {
                    name = Messages.ApplicationActionBarAdvisor_SHOW_STICKY;
                }
            }
            Action action = new Action(name, 8){

                public void run() {
                    if (this.isChecked()) {
                        preferences.putInteger(DefaultPreferences.BM_MENU_FILTER, filter.ordinal());
                    }
                }
            };
            action.setChecked(filter == selectedFilter);
            optionsMenu.add((IAction)action);
            if (filter != BookMarkFilter.Type.SHOW_ALL) continue;
            optionsMenu.add((IContributionItem)new Separator());
        }
        menu.add((IContributionItem)optionsMenu);
        menu.add((IContributionItem)new Separator());
        if (roots.size() == 1) {
            ApplicationActionBarAdvisor.fillBookMarksMenu(window, preferences, menu, ((IFolder)roots.iterator().next()).getChildren(), selectedFilter);
        } else {
            for (IFolder root : roots) {
                if (!ApplicationActionBarAdvisor.shouldShow((IFolderChild)root, selectedFilter)) continue;
                MenuManager rootItem = new MenuManager(root.getName(), OwlUI.BOOKMARK_SET, null);
                menu.add((IContributionItem)rootItem);
                ApplicationActionBarAdvisor.fillBookMarksMenu(window, preferences, (IMenuManager)rootItem, root.getChildren(), selectedFilter);
            }
        }
        if (menu.getItems().length == 2 && selectedFilter != BookMarkFilter.Type.SHOW_ALL) {
            boolean hasBookMarks = false;
            for (IFolder root : roots) {
                if (root.getChildren().isEmpty()) continue;
                hasBookMarks = true;
                break;
            }
            if (hasBookMarks) {
                menu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_SOME_ELEMENTS_FILTERED){

                    public boolean isEnabled() {
                        return false;
                    }
                });
            }
        }
    }

    private static boolean shouldShow(IFolderChild child, BookMarkFilter.Type filter) {
        switch (filter) {
            case SHOW_ALL: {
                return true;
            }
            case SHOW_NEW: {
                return ApplicationActionBarAdvisor.hasNewsWithState(child, EnumSet.of(INews.State.NEW));
            }
            case SHOW_UNREAD: {
                return ApplicationActionBarAdvisor.hasNewsWithState(child, EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED));
            }
            case SHOW_STICKY: {
                return ApplicationActionBarAdvisor.hasStickyNews(child);
            }
        }
        return true;
    }

    private static void fillBookMarksMenu(final IWorkbenchWindow window, final IPreferenceScope preferences, IMenuManager parent, List<IFolderChild> childs, final BookMarkFilter.Type filter) {
        for (final IFolderChild child : childs) {
            if (!ApplicationActionBarAdvisor.shouldShow(child, filter)) continue;
            if (child instanceof INewsMark || child instanceof IFolder && ((IFolder)child).getChildren().isEmpty()) {
                int unreadNewsCount;
                String name = child.getName();
                if (child instanceof INewsMark && (unreadNewsCount = ((INewsMark)child).getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED))) > 0) {
                    name = NLS.bind((String)Messages.ApplicationActionBarAdvisor_MARK_UNREAD_COUNT, (Object)name, (Object)unreadNewsCount);
                }
                Action action = new Action(name){

                    public void run() {
                        if (child instanceof INewsMark) {
                            OwlUI.openInFeedView(window.getActivePage(), (IStructuredSelection)new StructuredSelection((Object)child));
                        }
                    }
                };
                action.setImageDescriptor(ApplicationActionBarAdvisor.getImageDescriptor(child));
                parent.add((IAction)action);
                continue;
            }
            if (!(child instanceof IFolder)) continue;
            final IFolder folder = (IFolder)child;
            final MenuManager folderMenu = new MenuManager(folder.getName(), ApplicationActionBarAdvisor.getImageDescriptor((IFolderChild)folder), null);
            parent.add((IContributionItem)folderMenu);
            folderMenu.add((IAction)new Action(""){});
            folderMenu.setRemoveAllWhenShown(true);
            folderMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    folderMenu.add((IAction)new Action(Messages.ApplicationActionBarAdvisor_OPEN_FOLDER){

                        public void run() {
                            OwlUI.openInFeedView(window.getActivePage(), (IStructuredSelection)new StructuredSelection((Object)child));
                        }
                    });
                    if (preferences.getBoolean(DefaultPreferences.ALWAYS_REUSE_FEEDVIEW) && OwlUI.isTabbedBrowsingEnabled()) {
                        folderMenu.add((IAction)new OpenInNewTabAction(OwlUI.getPage(window), (IStructuredSelection)new StructuredSelection((Object)child)));
                        folderMenu.add((IAction)new OpenInNewTabAction(OwlUI.getPage(window), folder));
                    }
                    folderMenu.add((IContributionItem)new Separator());
                    ApplicationActionBarAdvisor.fillBookMarksMenu(window, preferences, (IMenuManager)folderMenu, folder.getChildren(), filter);
                }
            });
        }
    }

    private static ImageDescriptor getImageDescriptor(IFolderChild child) {
        boolean hasNewNews = ApplicationActionBarAdvisor.hasNewsWithState(child, EnumSet.of(INews.State.NEW));
        if (child instanceof IBookMark) {
            ImageDescriptor favicon = OwlUI.getFavicon((IBookMark)child);
            if (!hasNewNews) {
                return favicon != null ? favicon : OwlUI.BOOKMARK;
            }
            Image base = favicon != null ? OwlUI.getImage(fgResources, favicon) : OwlUI.getImage(fgResources, OwlUI.BOOKMARK);
            DecorationOverlayIcon overlay = new DecorationOverlayIcon(base, OwlUI.getImageDescriptor("icons/ovr16/new.gif"), 3);
            return overlay;
        }
        if (child instanceof ISearchMark) {
            if (hasNewNews) {
                return OwlUI.SEARCHMARK_NEW;
            }
            if (((INewsMark)child).getNewsCount(INews.State.getVisible()) != 0) {
                return OwlUI.SEARCHMARK;
            }
            return OwlUI.SEARCHMARK_EMPTY;
        }
        if (child instanceof INewsBin) {
            boolean isArchive;
            boolean bl = isArchive = child.getProperty(DefaultPreferences.ARCHIVE_BIN_MARKER) != null;
            if (hasNewNews) {
                return isArchive ? OwlUI.ARCHIVE_NEW : OwlUI.NEWSBIN_NEW;
            }
            if (isArchive) {
                return OwlUI.ARCHIVE;
            }
            if (((INewsMark)child).getNewsCount(INews.State.getVisible()) != 0) {
                return OwlUI.NEWSBIN;
            }
            return OwlUI.NEWSBIN_EMPTY;
        }
        if (child instanceof IFolder) {
            return hasNewNews ? OwlUI.FOLDER_NEW : OwlUI.FOLDER;
        }
        return null;
    }

    private static boolean hasNewsWithState(IFolderChild child, EnumSet<INews.State> states) {
        if (child instanceof IFolder) {
            return ApplicationActionBarAdvisor.hasNewsWithStates((IFolder)child, states);
        }
        return ((INewsMark)child).getNewsCount(states) != 0;
    }

    private static boolean hasNewsWithStates(IFolder folder, EnumSet<INews.State> states) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof INewsMark) || ((INewsMark)mark).getNewsCount(states) == 0) continue;
            return true;
        }
        List folders = folder.getFolders();
        for (IFolder child : folders) {
            if (!ApplicationActionBarAdvisor.hasNewsWithStates(child, states)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasStickyNews(IFolderChild child) {
        if (child instanceof IFolder) {
            return ApplicationActionBarAdvisor.hasStickyNews((IFolder)child);
        }
        if (child instanceof IBookMark) {
            return ((IBookMark)child).getStickyNewsCount() != 0;
        }
        return false;
    }

    private static boolean hasStickyNews(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (!(mark instanceof IBookMark) || ((IBookMark)mark).getStickyNewsCount() == 0) continue;
            return true;
        }
        List folders = folder.getFolders();
        for (IFolder child : folders) {
            if (!ApplicationActionBarAdvisor.hasStickyNews(child)) continue;
            return true;
        }
        return false;
    }
}

