/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rssowl.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExUtils {
    private static final String URL_REGEX = "(www([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?)|(http|ftp|https|feed):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?";
    private static final Pattern URL_REGEX_PATTERN = Pattern.compile("(www([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?)|(http|ftp|https|feed):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?");
    private static final String STRICT_URL_REGEX = "(http|ftp|https|feed):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?";
    private static final Pattern STRICT_URL_REGEX_PATTERN = Pattern.compile("(http|ftp|https|feed):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?");

    private RegExUtils() {
    }

    public static boolean isValidURL(String url) {
        return URL_REGEX_PATTERN.matcher(url).matches();
    }

    public static List<String> extractLinksFromText(String text, boolean strict) {
        ArrayList<String> urls = new ArrayList<String>();
        Matcher match = strict ? STRICT_URL_REGEX_PATTERN.matcher(text) : URL_REGEX_PATTERN.matcher(text);
        while (match.find()) {
            String str = match.group(0);
            if (!StringUtils.isSet(str) || urls.contains(str)) continue;
            urls.add(str);
        }
        return urls;
    }
}

