/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DAOService;
import org.rssowl.core.persist.dao.IEntityDAO;
import org.rssowl.core.persist.dao.IPersistableDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.service.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicDAO {
    private static DAOService DAO_SERVICE;

    private static final synchronized DAOService getDAOService() {
        if (DAO_SERVICE == null) {
            DAO_SERVICE = Owl.getPersistenceService().getDAOService();
        }
        return DAO_SERVICE;
    }

    public static boolean exists(Class<? extends IEntity> entityClass, long id) throws PersistenceException {
        IEntityDAO<IEntity, ?, ?> dao = DynamicDAO.getDAOFromEntity(entityClass);
        DynamicDAO.checkEntityDAO(entityClass, dao);
        return dao.exists(id);
    }

    public static <T extends IEntity> T load(Class<T> entityClass, long id) throws PersistenceException {
        IEntityDAO<T, ?, ?> dao = DynamicDAO.getDAOFromEntity(entityClass);
        DynamicDAO.checkEntityDAO(entityClass, dao);
        return dao.load(id);
    }

    public static <T extends IPersistable> Collection<T> loadAll(Class<T> persistableClass) throws PersistenceException {
        IPersistableDAO<T> dao = DynamicDAO.getDAOFromPersistable(persistableClass);
        DynamicDAO.checkPersistableDAO(persistableClass, dao);
        return dao.loadAll();
    }

    public static <T extends IPersistable> T save(T persistable) throws PersistenceException {
        Class<?> persistableClass = persistable.getClass();
        IPersistableDAO<?> dao = DynamicDAO.getDAOFromPersistable(persistableClass);
        DynamicDAO.checkPersistableDAO(persistableClass, dao);
        return (T)dao.save(persistable);
    }

    public static <T extends IPersistable> void saveAll(Collection<T> persistables) throws PersistenceException {
        if (persistables.size() == 0) {
            return;
        }
        Map<Class<IPersistable>, List<T>> persistablesMap = DynamicDAO.getPersistablesMap(persistables);
        for (Map.Entry<Class<IPersistable>, List<T>> entry : persistablesMap.entrySet()) {
            Class<IPersistable> key = entry.getKey();
            IPersistableDAO<IPersistable> dao = DynamicDAO.getDAOFromPersistable(key);
            DynamicDAO.checkPersistableDAO(key, dao);
            dao.saveAll((Collection<IPersistable>)entry.getValue());
        }
    }

    private static <T extends IPersistable> Map<Class<? extends IPersistable>, List<T>> getPersistablesMap(Collection<T> persistables) {
        LinkedHashMap<Class<IPersistable>, List<T>> persistablesMap = new LinkedHashMap<Class<IPersistable>, List<T>>(3);
        for (IPersistable persistable : persistables) {
            Class<?> persistableClass = persistable.getClass();
            ArrayList<IPersistable> persistableList = (ArrayList<IPersistable>)persistablesMap.get(persistableClass);
            if (persistableList == null) {
                persistableList = new ArrayList<IPersistable>(persistables.size());
                persistablesMap.put(persistableClass, persistableList);
            }
            persistableList.add(persistable);
        }
        return persistablesMap;
    }

    public static <T extends IPersistable> void delete(T persistable) throws PersistenceException {
        Class<?> persistableClass = persistable.getClass();
        IPersistableDAO<?> dao = DynamicDAO.getDAOFromPersistable(persistableClass);
        DynamicDAO.checkPersistableDAO(persistableClass, dao);
        dao.delete(persistable);
    }

    public static <T extends IPersistable> void deleteAll(Collection<T> persistables) throws PersistenceException {
        if (persistables.size() == 0) {
            return;
        }
        Map<Class<IPersistable>, List<T>> persistablesMap = DynamicDAO.getPersistablesMap(persistables);
        for (Map.Entry<Class<IPersistable>, List<T>> entry : persistablesMap.entrySet()) {
            Class<IPersistable> key = entry.getKey();
            IPersistableDAO<IPersistable> dao = DynamicDAO.getDAOFromPersistable(key);
            DynamicDAO.checkPersistableDAO(key, dao);
            dao.deleteAll((Collection<IPersistable>)entry.getValue());
        }
    }

    public static <T extends IPersistable> long countAll(Class<T> persistableClass) throws PersistenceException {
        IPersistableDAO<T> dao = DynamicDAO.getDAOFromPersistable(persistableClass);
        DynamicDAO.checkPersistableDAO(persistableClass, dao);
        return dao.countAll();
    }

    private static void checkPersistableDAO(Class<? extends IPersistable> persistableClass, IPersistableDAO<?> dao) {
        if (dao == null) {
            throw new IllegalArgumentException("There is no DAO for persistable of type: " + persistableClass);
        }
    }

    private static void checkEntityDAO(Class<? extends IPersistable> entityClass, IEntityDAO<?, ?, ?> dao) {
        if (dao == null) {
            throw new IllegalArgumentException("There is no DAO for entity of type: " + entityClass);
        }
    }

    public static <T extends IEntity, L extends EntityListener<E, T>, E extends ModelEvent> void addEntityListener(Class<T> entityClass, L listener) {
        IEntityDAO dao = (IEntityDAO)DynamicDAO.getDAOFromPersistable(entityClass);
        DynamicDAO.checkEntityDAO(entityClass, dao);
        dao.addEntityListener(listener);
    }

    public static <T extends IEntity, L extends EntityListener<E, T>, E extends ModelEvent> void removeEntityListener(Class<T> entityClass, L listener) {
        IEntityDAO dao = (IEntityDAO)DynamicDAO.getDAOFromPersistable(entityClass);
        DynamicDAO.checkEntityDAO(entityClass, dao);
        dao.removeEntityListener(listener);
    }

    public static <D extends IPersistableDAO<T>, T extends IPersistable> D getDAO(Class<D> daoInterface) {
        return DynamicDAO.getDAOService().getDAO(daoInterface);
    }

    public static <T extends IPersistable> IPersistableDAO<T> getDAOFromPersistable(Class<? extends T> persistableClass) {
        return DynamicDAO.getDAOService().getDAOFromPersistable(persistableClass);
    }

    public static <T extends IEntity> IEntityDAO<T, ?, ?> getDAOFromEntity(Class<? extends T> entityClass) {
        return (IEntityDAO)DynamicDAO.getDAOService().getDAOFromPersistable(entityClass);
    }
}

