/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.pref;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.persist.pref.IPreferenceScope;

public class EclipseScope
implements IPreferenceScope {
    private static final String NODE_SEPARATOR = "/";
    private static final String ROOT_NAME = "/";
    private final IPreferenceScope fParent;
    private final IPreferencesService fPrefService;
    private final IEclipsePreferences fRootNode;

    public EclipseScope(IPreferenceScope parent) {
        this.fParent = parent;
        this.fPrefService = Platform.getPreferencesService();
        this.fRootNode = this.fPrefService.getRootNode();
    }

    public IPreferenceScope getParent() {
        return this.fParent;
    }

    public void flush() {
        try {
            this.fRootNode.flush();
        }
        catch (BackingStoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public boolean hasKey(String key) {
        throw new UnsupportedOperationException();
    }

    public void delete(String key) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String key) {
        return this.fPrefService.getBoolean("/", key, this.fParent.getBoolean(key), null);
    }

    public int getInteger(String key) {
        return this.fPrefService.getInt("/", key, this.fParent.getInteger(key), null);
    }

    public int[] getIntegers(String key) {
        throw new UnsupportedOperationException();
    }

    public long getLong(String key) {
        return this.fPrefService.getLong("/", key, this.fParent.getLong(key), null);
    }

    public long[] getLongs(String key) {
        throw new UnsupportedOperationException();
    }

    public String getString(String key) {
        return this.fPrefService.getString("/", key, this.fParent.getString(key), null);
    }

    public String[] getStrings(String key) {
        throw new UnsupportedOperationException();
    }

    public void putBoolean(String key, boolean value) {
        Assert.isTrue((boolean)key.contains("/"), (String)"Invalid Eclipse Preferences Key!");
        String nodePath = this.getNodePath(key);
        key = key.substring(key.lastIndexOf("/") + 1);
        Preferences prefNode = this.fRootNode.node(nodePath);
        prefNode.putBoolean(key, value);
    }

    public void putInteger(String key, int value) {
        Assert.isTrue((boolean)key.contains("/"), (String)"Invalid Eclipse Preferences Key!");
        String nodePath = this.getNodePath(key);
        key = key.substring(key.lastIndexOf("/") + 1);
        Preferences prefNode = this.fRootNode.node(nodePath);
        prefNode.putInt(key, value);
    }

    public void putIntegers(String key, int[] values) {
        throw new UnsupportedOperationException();
    }

    public void putLong(String key, long value) {
        Assert.isTrue((boolean)key.contains("/"), (String)"Invalid Eclipse Preferences Key!");
        String nodePath = this.getNodePath(key);
        key = key.substring(key.lastIndexOf("/") + 1);
        Preferences prefNode = this.fRootNode.node(nodePath);
        prefNode.putLong(key, value);
    }

    public void putLongs(String key, long[] values) {
        throw new UnsupportedOperationException();
    }

    public void putString(String key, String value) {
        Assert.isTrue((boolean)key.contains("/"), (String)"Invalid Eclipse Preferences Key!");
        String nodePath = this.getNodePath(key);
        key = key.substring(key.lastIndexOf("/") + 1);
        Preferences prefNode = this.fRootNode.node(nodePath);
        prefNode.put(key, value);
    }

    public void putStrings(String key, String[] values) {
        throw new UnsupportedOperationException();
    }

    private String getNodePath(String key) {
        if (key.startsWith("/")) {
            return key.substring(0, key.lastIndexOf("/"));
        }
        return "/" + key.substring(0, key.lastIndexOf("/"));
    }
}

