/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.dao.AbstractPersistableDAO;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.NewsCounter;
import org.rssowl.core.persist.NewsCounterItem;
import org.rssowl.core.persist.dao.INewsCounterDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewsCounterDAOImpl
extends AbstractPersistableDAO<NewsCounter>
implements INewsCounterDAO {
    private volatile NewsCounter fNewsCounter;

    public NewsCounterDAOImpl() {
        super(NewsCounter.class, true);
    }

    @Override
    protected void onDatabaseOpened(DatabaseEvent event) {
        super.onDatabaseOpened(event);
        NewsCounter newsCounter = this.doLoad();
        if (newsCounter == null) {
            newsCounter = this.doCountAll();
            this.save(newsCounter);
        }
        this.fNewsCounter = newsCounter;
    }

    private NewsCounter doLoad() {
        Collection counters = super.loadAll();
        Assert.isLegal((counters.size() <= 1 ? 1 : 0) != 0, (String)("There shouldn't be more than 1 NewsCounter, size: " + counters.size()));
        Iterator iterator = counters.iterator();
        if (iterator.hasNext()) {
            NewsCounter newsCounter = (NewsCounter)iterator.next();
            return newsCounter;
        }
        return null;
    }

    @Override
    protected void onDatabaseClosed(DatabaseEvent event) {
        super.onDatabaseClosed(event);
        this.fNewsCounter = null;
    }

    @Override
    public final void delete() {
        super.delete(this.load());
    }

    @Override
    protected void preCommit() {
    }

    private NewsCounter doCountAll() {
        NewsCounter newsCounter = new NewsCounter();
        Collection<IFeed> feeds = DBHelper.loadAllFeeds(this.fDb);
        for (IFeed feed : feeds) {
            newsCounter.put(feed.getLink().toString(), this.doCount(feed));
        }
        return newsCounter;
    }

    private NewsCounterItem doCount(IFeed feed) {
        NewsCounterItem counterItem = new NewsCounterItem();
        List<INews> newsList = feed.getVisibleNews();
        for (INews news : newsList) {
            if (EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED).contains((Object)news.getState())) {
                counterItem.incrementUnreadCounter();
            }
            if (INews.State.NEW.equals((Object)news.getState())) {
                counterItem.incrementNewCounter();
            }
            if (!news.isFlagged()) continue;
            counterItem.incrementStickyCounter();
        }
        return counterItem;
    }

    @Override
    public final void delete(NewsCounter newsCounter) {
        if (!newsCounter.equals(this.load())) {
            throw new IllegalArgumentException("Only a single newsCounter should be used. Trying to delete a non-existent one.");
        }
        super.delete(newsCounter);
    }

    @Override
    public Collection<NewsCounter> loadAll() {
        ArrayList<NewsCounter> newsCounters = new ArrayList<NewsCounter>(1);
        newsCounters.add(this.load());
        return newsCounters;
    }

    @Override
    public final NewsCounter load() {
        return this.fNewsCounter;
    }

    @Override
    public final void saveAll(Collection<NewsCounter> entities) {
        if (entities.size() > 1) {
            throw new IllegalArgumentException("Only a single newsCounter can be stored");
        }
        super.saveAll(entities);
    }

    @Override
    protected final void doSave(NewsCounter entity) {
        if (!this.fDb.ext().isStored((Object)entity) && this.load() != null) {
            throw new IllegalArgumentException("Only a single newsCounter can be stored");
        }
        super.doSave(entity);
    }

    @Override
    public void save() {
        Assert.isNotNull((Object)this.fNewsCounter, (String)"fNewsCounter");
        this.fDb.ext().set((Object)this.fNewsCounter, Integer.MAX_VALUE);
    }
}

