/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.Arrays;
import org.rssowl.core.internal.persist.LongArrayList;
import org.rssowl.core.util.ArrayUtils;

public final class SortedLongArrayList
extends LongArrayList {
    protected SortedLongArrayList() {
    }

    public SortedLongArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public int indexOf(long element) {
        return ArrayUtils.binarySearch(this.fElements, element, this.fSize);
    }

    public void add(long element) {
        this.fElements = ArrayUtils.ensureCapacity(this.fElements, this.fSize + 1);
        int insertionPoint = this.indexOf(element);
        if (insertionPoint < 0) {
            insertionPoint = -insertionPoint - 1;
        }
        System.arraycopy(this.fElements, insertionPoint, this.fElements, insertionPoint + 1, this.fSize - insertionPoint);
        this.fElements[insertionPoint] = element;
        ++this.fSize;
    }

    public void setAll(long[] elements) {
        super.setAll(elements);
        Arrays.sort(this.fElements, 0, this.fSize);
    }
}

