/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.persist.reference.SearchFilterReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilter
extends AbstractEntity
implements ISearchFilter {
    private int fOrder;
    private String fName;
    private boolean fEnabled;
    private List<IFilterAction> fActions;
    private ISearch fSearch;
    private boolean fMatchAllNews;

    public SearchFilter(Long id, ISearch search, String name) {
        super(id);
        Assert.isNotNull((Object)name);
        this.fSearch = search;
        this.fMatchAllNews = this.fSearch == null;
        this.fActions = new ArrayList<IFilterAction>(1);
        this.fName = name;
    }

    protected SearchFilter() {
    }

    @Override
    public synchronized List<IFilterAction> getActions() {
        return new ArrayList<IFilterAction>(this.fActions);
    }

    @Override
    public synchronized String getName() {
        return this.fName;
    }

    @Override
    public synchronized int getOrder() {
        return this.fOrder;
    }

    @Override
    public synchronized ISearch getSearch() {
        return this.fSearch;
    }

    @Override
    public synchronized void setSearch(ISearch search) {
        this.fSearch = search;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public synchronized void addAction(IFilterAction action) {
        this.fActions.add(action);
    }

    @Override
    public synchronized void removeAction(IFilterAction action) {
        this.fActions.remove(action);
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    @Override
    public synchronized void setName(String name) {
        this.fName = name;
    }

    @Override
    public synchronized void setOrder(int order) {
        this.fOrder = order;
    }

    @Override
    public synchronized void setMatchAllNews(boolean matchAllNews) {
        this.fMatchAllNews = matchAllNews;
    }

    @Override
    public synchronized boolean matchAllNews() {
        return this.fMatchAllNews;
    }

    @Override
    public synchronized ModelReference toReference() {
        return new SearchFilterReference(this.getIdAsPrimitive());
    }

    @Override
    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ", ";
    }
}

