/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.internal.persist.ComplexMergeResult;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.reference.CategoryReference;
import org.rssowl.core.util.MergeUtils;

public class Category
extends AbstractEntity
implements ICategory {
    private String fName;
    private String fDomain;

    public Category() {
        super(null);
    }

    public Category(Long id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category(ICategory category) {
        ICategory iCategory = category;
        synchronized (iCategory) {
            this.setName(category.getName());
            this.setDomain(category.getDomain());
        }
    }

    public synchronized void setName(String name) {
        this.fName = name;
    }

    public synchronized void setDomain(String domain) {
        this.fDomain = domain;
    }

    public synchronized String getDomain() {
        return this.fDomain;
    }

    public synchronized String getName() {
        return this.fName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(ICategory category) {
        if (category == this) {
            return true;
        }
        if (!(category instanceof Category)) {
            return false;
        }
        ICategory iCategory = category;
        synchronized (iCategory) {
            Category c = (Category)category;
            return (this.getId() == null ? c.getId() == null : this.getId().equals(c.getId())) && (this.fDomain == null ? c.fDomain == null : this.fDomain.equals(c.fDomain)) && this.fName.equals(c.fName) && (this.getProperties() == null ? c.getProperties() == null : this.getProperties().equals(c.getProperties()));
        }
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ")";
    }

    public synchronized String toLongString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ", Domain = " + this.fDomain + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MergeResult merge(ICategory objectToMerge) {
        Assert.isNotNull((Object)objectToMerge, (String)"objectToMerge");
        ICategory iCategory = objectToMerge;
        synchronized (iCategory) {
            boolean updated = false;
            updated |= !MergeUtils.equals(this.fDomain, objectToMerge.getDomain());
            this.fDomain = objectToMerge.getDomain();
            boolean bl = !MergeUtils.equals(this.fName, objectToMerge.getName());
            this.fName = objectToMerge.getName();
            MergeUtils.mergeProperties(this, objectToMerge);
            ComplexMergeResult<?> result = MergeUtils.mergeProperties(this, objectToMerge);
            if ((updated |= bl) || result.isStructuralChange()) {
                result.addUpdatedObject(this);
            }
            return result;
        }
    }

    public CategoryReference toReference() {
        return new CategoryReference(this.getIdAsPrimitive());
    }
}

