/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.interpreter.BasicInterpreter;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IImage;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ITextInput;
import org.rssowl.core.util.URIUtils;

public class RDFInterpreter
extends BasicInterpreter {
    private int fNewsCounter;

    public void interpret(Document document, IFeed feed) {
        Element root = document.getRootElement();
        this.setDefaultNamespaceUri(root.getNamespace().getURI());
        this.setRootElementName(root.getName());
        feed.setFormat("RDF");
        this.processFeed(root, feed);
    }

    private void processFeed(Element element, IFeed feed) {
        this.processNamespaceAttributes(element, feed);
        List feedChildren = element.getChildren();
        for (Element child : feedChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("channel".equals(name)) {
                this.processChannel(child, feed);
                continue;
            }
            if ("item".equals(name)) {
                this.processItem(child, feed);
                continue;
            }
            if ("image".equals(name)) {
                this.processImage(child, feed);
                continue;
            }
            if (!"textinput".equals(name)) continue;
            this.processTextInput(child, feed);
        }
    }

    private void processChannel(Element element, IFeed feed) {
        this.processNamespaceAttributes(element, feed);
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("title".equals(name)) {
                feed.setTitle(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("link".equals(name)) {
                URI uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    feed.setHomepage(uri);
                }
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("description".equals(name)) {
                feed.setDescription(child.getText());
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("image".equals(name)) {
                this.processImage(child, feed);
                continue;
            }
            if (!"textinput".equals(name)) continue;
            this.processTextInput(child, feed);
        }
    }

    private void processTextInput(Element element, IFeed feed) {
        ITextInput input = Owl.getModelFactory().createTextInput(feed);
        this.processNamespaceAttributes(element, input);
        List inputChilds = element.getChildren();
        for (Element child : inputChilds) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, input)) continue;
            if ("title".equals(name)) {
                input.setTitle(child.getText());
                this.processNamespaceAttributes(child, input);
                continue;
            }
            if ("description".equals(name)) {
                input.setDescription(child.getText());
                this.processNamespaceAttributes(child, input);
                continue;
            }
            if ("name".equals(name)) {
                input.setName(child.getText());
                this.processNamespaceAttributes(child, input);
                continue;
            }
            if (!"link".equals(name)) continue;
            URI uri = URIUtils.createURI(child.getText());
            if (uri != null) {
                input.setLink(uri);
            }
            this.processNamespaceAttributes(child, input);
        }
    }

    private void processImage(Element element, IFeed feed) {
        IImage image = Owl.getModelFactory().createImage(feed);
        this.processNamespaceAttributes(element, image);
        List imageChilds = element.getChildren();
        for (Element child : imageChilds) {
            URI uri;
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, image)) continue;
            if ("url".equals(name)) {
                uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    image.setLink(uri);
                }
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if ("title".equals(name)) {
                image.setTitle(child.getText());
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if (!"link".equals(name)) continue;
            uri = URIUtils.createURI(child.getText());
            if (uri != null) {
                image.setHomepage(uri);
            }
            this.processNamespaceAttributes(child, image);
        }
    }

    private void processItem(Element element, IFeed feed) {
        INews news = Owl.getModelFactory().createNews(null, feed, new Date(System.currentTimeMillis() - (long)(this.fNewsCounter++ * 1)));
        news.setBase(feed.getBase());
        List itemAttributes = element.getAttributes();
        for (Attribute attribute : itemAttributes) {
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, news) || !"about".equals(name)) continue;
            Owl.getModelFactory().createGuid(news, attribute.getValue(), true);
        }
        List newsChilds = element.getChildren();
        for (Element child : newsChilds) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, news)) continue;
            if ("title".equals(name)) {
                news.setTitle(child.getText());
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("link".equals(name)) {
                URI uri;
                if (child.getText().length() > 0 && (uri = URIUtils.createURI(child.getText())) != null) {
                    news.setLink(uri);
                }
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if (!"description".equals(name)) continue;
            news.setDescription(child.getText());
            this.processNamespaceAttributes(child, news);
        }
    }
}

