/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.io.IoAdapter;
import com.db4o.io.RandomAccessFileAdapter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SymbianIoAdapter
extends RandomAccessFileAdapter {
    private byte[] _seekBytes = new byte[500];
    private String _path;
    private long _pos;
    private long _length;

    protected SymbianIoAdapter(String string, boolean bl, long l) throws IOException {
        super(string, bl, l);
        this._path = string;
        this._pos = 0L;
        this.setLength();
    }

    private void setLength() throws IOException {
        this._length = this.retrieveLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long retrieveLength() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this._path, "r");
        try {
            long l = randomAccessFile.length();
            return l;
        }
        finally {
            randomAccessFile.close();
        }
    }

    public SymbianIoAdapter() {
    }

    public IoAdapter open(String string, boolean bl, long l) throws IOException {
        return new SymbianIoAdapter(string, bl, l);
    }

    public long getLength() throws IOException {
        this.setLength();
        return this._length;
    }

    public int read(byte[] byArray, int n) throws IOException {
        int n2 = super.read(byArray, n);
        this._pos += (long)n2;
        return n2;
    }

    public void write(byte[] byArray, int n) throws IOException {
        super.write(byArray, n);
        this._pos += (long)n;
        if (this._pos > this._length) {
            this.setLength();
        }
    }

    public void seek(long l) throws IOException {
        if (l > this._length) {
            this.setLength();
        }
        if (l > this._length) {
            int n = (int)(l - this._length);
            super.seek(this._length);
            this._pos = this._length;
            if (n < 500) {
                this.write(this._seekBytes, n);
            } else {
                this.write(new byte[n]);
            }
        }
        super.seek(l);
        this._pos = l;
    }
}

