/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.marshall.ArrayMarshaller;
import com.db4o.internal.marshall.ArrayMarshaller0;
import com.db4o.internal.marshall.ArrayMarshaller1;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.ClassMarshaller0;
import com.db4o.internal.marshall.ClassMarshaller1;
import com.db4o.internal.marshall.ClassMarshaller2;
import com.db4o.internal.marshall.FieldMarshaller;
import com.db4o.internal.marshall.FieldMarshaller0;
import com.db4o.internal.marshall.FieldMarshaller1;
import com.db4o.internal.marshall.ObjectMarshaller;
import com.db4o.internal.marshall.ObjectMarshaller0;
import com.db4o.internal.marshall.ObjectMarshaller1;
import com.db4o.internal.marshall.PrimitiveMarshaller;
import com.db4o.internal.marshall.PrimitiveMarshaller0;
import com.db4o.internal.marshall.PrimitiveMarshaller1;
import com.db4o.internal.marshall.StringMarshaller;
import com.db4o.internal.marshall.StringMarshaller0;
import com.db4o.internal.marshall.StringMarshaller1;
import com.db4o.internal.marshall.UntypedMarshaller;
import com.db4o.internal.marshall.UntypedMarshaller0;
import com.db4o.internal.marshall.UntypedMarshaller1;

public class MarshallerFamily {
    private static int FAMILY_VERSION = 2;
    public final ArrayMarshaller _array;
    public final ClassMarshaller _class;
    public final FieldMarshaller _field;
    public final ObjectMarshaller _object;
    public final PrimitiveMarshaller _primitive;
    public final StringMarshaller _string;
    public final UntypedMarshaller _untyped;
    private final int _converterVersion;
    private static final MarshallerFamily[] allVersions = new MarshallerFamily[]{new MarshallerFamily(0, new ArrayMarshaller0(), new ClassMarshaller0(), new FieldMarshaller0(), new ObjectMarshaller0(), new PrimitiveMarshaller0(), new StringMarshaller0(), new UntypedMarshaller0()), new MarshallerFamily(5, new ArrayMarshaller1(), new ClassMarshaller1(), new FieldMarshaller0(), new ObjectMarshaller1(), new PrimitiveMarshaller1(), new StringMarshaller1(), new UntypedMarshaller1()), new MarshallerFamily(6, new ArrayMarshaller1(), new ClassMarshaller2(), new FieldMarshaller1(), new ObjectMarshaller1(), new PrimitiveMarshaller1(), new StringMarshaller1(), new UntypedMarshaller1())};

    private MarshallerFamily(int n, ArrayMarshaller arrayMarshaller, ClassMarshaller classMarshaller, FieldMarshaller fieldMarshaller, ObjectMarshaller objectMarshaller, PrimitiveMarshaller primitiveMarshaller, StringMarshaller stringMarshaller, UntypedMarshaller untypedMarshaller) {
        this._converterVersion = n;
        this._array = arrayMarshaller;
        this._array._family = this;
        this._class = classMarshaller;
        this._class._family = this;
        this._field = fieldMarshaller;
        this._object = objectMarshaller;
        this._object._family = this;
        this._primitive = primitiveMarshaller;
        this._primitive._family = this;
        this._string = stringMarshaller;
        this._untyped = untypedMarshaller;
        this._untyped._family = this;
    }

    public static MarshallerFamily version(int n) {
        return allVersions[n];
    }

    public static MarshallerFamily current() {
        if (FAMILY_VERSION < 2) {
            throw new IllegalStateException("Using old marshaller versions to write database files is not supported, source code has been removed.");
        }
        return MarshallerFamily.version(FAMILY_VERSION);
    }

    public static MarshallerFamily forConverterVersion(int n) {
        MarshallerFamily marshallerFamily = allVersions[0];
        for (int i = 1; i < allVersions.length; ++i) {
            if (MarshallerFamily.allVersions[i]._converterVersion > n) {
                return marshallerFamily;
            }
            marshallerFamily = allVersions[i];
        }
        return marshallerFamily;
    }

    public static class FamilyVersion {
        public static final int PRE_MARSHALLER = 0;
        public static final int MARSHALLER = 1;
        public static final int BTREE_FIELD_INDEXES = 2;
    }
}

