/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.internal.Buffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.MarshallerFamily;

public final class BooleanHandler
extends PrimitiveHandler {
    static final int LENGTH = 1;
    private static final byte TRUE = 84;
    private static final byte FALSE = 70;
    private static final byte NULL = 78;
    private static final Boolean i_primitive = new Boolean(false);
    private boolean i_compareTo;

    public BooleanHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    public int getID() {
        return 4;
    }

    public Object defaultValue() {
        return i_primitive;
    }

    public int linkLength() {
        return 1;
    }

    protected Class primitiveJavaClass() {
        return Boolean.TYPE;
    }

    public Object primitiveNull() {
        return i_primitive;
    }

    Object read1(Buffer buffer) {
        byte by = buffer.readByte();
        if (by == 84) {
            return new Boolean(true);
        }
        if (by == 70) {
            return new Boolean(false);
        }
        return null;
    }

    public Object writeNew(MarshallerFamily marshallerFamily, Object object, boolean bl, StatefulBuffer statefulBuffer, boolean bl2, boolean bl3) {
        this.write(object, statefulBuffer);
        return object;
    }

    public void write(Object object, Buffer buffer) {
        buffer.append(this.getEncodedByteValue(object));
    }

    private byte getEncodedByteValue(Object object) {
        if (object == null) {
            return 78;
        }
        if (((Boolean)object).booleanValue()) {
            return 84;
        }
        return 70;
    }

    private boolean val(Object object) {
        return (Boolean)object;
    }

    void prepareComparison1(Object object) {
        this.i_compareTo = this.val(object);
    }

    public Object current1() {
        return new Boolean(this.i_compareTo);
    }

    boolean isEqual1(Object object) {
        return object instanceof Boolean && this.val(object) == this.i_compareTo;
    }

    boolean isGreater1(Object object) {
        if (this.i_compareTo) {
            return false;
        }
        return object instanceof Boolean && this.val(object);
    }

    boolean isSmaller1(Object object) {
        if (!this.i_compareTo) {
            return false;
        }
        return object instanceof Boolean && !this.val(object);
    }
}

