/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.foundation.MutableInt;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TreeReader;
import com.db4o.internal.freespace.FreeSlotNode;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public class FreespaceManagerRam
extends FreespaceManager {
    private final TreeIntObject _finder = new TreeIntObject(0);
    private Tree _freeByAddress;
    private Tree _freeBySize;

    public FreespaceManagerRam(LocalObjectContainer localObjectContainer) {
        super(localObjectContainer);
    }

    public void traverseFreeSlots(final Visitor4 visitor4) {
        Tree.traverse(this._freeByAddress, new Visitor4(){

            public void visit(Object object) {
                FreeSlotNode freeSlotNode = (FreeSlotNode)object;
                int n = freeSlotNode._key;
                int n2 = freeSlotNode._peer._key;
                visitor4.visit(new Slot(n, n2));
            }
        });
    }

    private void addFreeSlotNodes(int n, int n2) {
        FreeSlotNode freeSlotNode = new FreeSlotNode(n);
        freeSlotNode.createPeer(n2);
        this._freeByAddress = Tree.add(this._freeByAddress, freeSlotNode);
        this._freeBySize = Tree.add(this._freeBySize, freeSlotNode._peer);
    }

    public void beginCommit() {
    }

    public void debug() {
    }

    public void endCommit() {
    }

    public void free(int n, int n2) {
        if (n <= 0) {
            return;
        }
        if (n2 <= this.discardLimit()) {
            return;
        }
        n2 = this._file.blocksFor(n2);
        this._finder._key = n;
        FreeSlotNode freeSlotNode = (FreeSlotNode)Tree.findSmaller(this._freeByAddress, this._finder);
        if (freeSlotNode != null && freeSlotNode._key + freeSlotNode._peer._key == n) {
            FreeSlotNode freeSlotNode2 = freeSlotNode._peer;
            this._freeBySize = this._freeBySize.removeNode(freeSlotNode2);
            freeSlotNode2._key += n2;
            FreeSlotNode freeSlotNode3 = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (freeSlotNode3 != null && n + n2 == freeSlotNode3._key) {
                freeSlotNode2._key += freeSlotNode3._peer._key;
                this._freeBySize = this._freeBySize.removeNode(freeSlotNode3._peer);
                this._freeByAddress = this._freeByAddress.removeNode(freeSlotNode3);
            }
            freeSlotNode2.removeChildren();
            this._freeBySize = Tree.add(this._freeBySize, freeSlotNode2);
        } else {
            freeSlotNode = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (freeSlotNode != null && n + n2 == freeSlotNode._key) {
                FreeSlotNode freeSlotNode4 = freeSlotNode._peer;
                this._freeByAddress = this._freeByAddress.removeNode(freeSlotNode);
                this._freeBySize = this._freeBySize.removeNode(freeSlotNode4);
                freeSlotNode4._key += n2;
                freeSlotNode._key = n;
                freeSlotNode.removeChildren();
                freeSlotNode4.removeChildren();
                this._freeByAddress = Tree.add(this._freeByAddress, freeSlotNode);
                this._freeBySize = Tree.add(this._freeBySize, freeSlotNode4);
            } else {
                this.addFreeSlotNodes(n, n2);
            }
        }
        this._file.overwriteDeletedBytes(n, n2 * this.blockSize());
    }

    public void freeSelf() {
    }

    public int freeSize() {
        final MutableInt mutableInt = new MutableInt();
        Tree.traverse(this._freeBySize, new Visitor4(){

            public void visit(Object object) {
                FreeSlotNode freeSlotNode = (FreeSlotNode)object;
                mutableInt.add(freeSlotNode._key);
            }
        });
        return mutableInt.value();
    }

    public int getSlot(int n) {
        int n2 = this.getSlot1(n);
        if (n2 != 0) {
            // empty if block
        }
        return n2;
    }

    public int getSlot1(int n) {
        this._finder._key = n = this._file.blocksFor(n);
        this._finder._object = null;
        this._freeBySize = FreeSlotNode.removeGreaterOrEqual((FreeSlotNode)this._freeBySize, this._finder);
        if (this._finder._object == null) {
            return 0;
        }
        FreeSlotNode freeSlotNode = (FreeSlotNode)this._finder._object;
        int n2 = freeSlotNode._key;
        int n3 = freeSlotNode._peer._key;
        this._freeByAddress = this._freeByAddress.removeNode(freeSlotNode._peer);
        if (n2 > n) {
            this.addFreeSlotNodes(n3 + n, n2 - n);
        }
        return n3;
    }

    public void migrate(final FreespaceManager freespaceManager) {
        if (this._freeByAddress != null) {
            this._freeByAddress.traverse(new Visitor4(){

                public void visit(Object object) {
                    FreeSlotNode freeSlotNode = (FreeSlotNode)object;
                    int n = freeSlotNode._key;
                    int n2 = freeSlotNode._peer._key;
                    freespaceManager.free(n, n2);
                }
            });
        }
    }

    public void onNew(LocalObjectContainer localObjectContainer) {
    }

    public void read(int n) {
        if (n <= 0) {
            return;
        }
        if (this.discardLimit() == Integer.MAX_VALUE) {
            return;
        }
        StatefulBuffer statefulBuffer = this._file.readWriterByID(this.trans(), n);
        if (statefulBuffer == null) {
            return;
        }
        FreeSlotNode.sizeLimit = this.discardLimit();
        this._freeBySize = new TreeReader(statefulBuffer, new FreeSlotNode(0), true).read();
        final Tree.ByRef byRef = new Tree.ByRef();
        if (this._freeBySize != null) {
            this._freeBySize.traverse(new Visitor4(){

                public void visit(Object object) {
                    FreeSlotNode freeSlotNode = ((FreeSlotNode)object)._peer;
                    byRef.value = Tree.add(byRef.value, freeSlotNode);
                }
            });
        }
        this._freeByAddress = byRef.value;
        this._file.free(n, 8);
        this._file.free(statefulBuffer.getAddress(), statefulBuffer.getLength());
    }

    public void start(int n) {
    }

    public byte systemType() {
        return 2;
    }

    private final Transaction trans() {
        return this._file.getSystemTransaction();
    }

    public int write(boolean bl) {
        if (!bl) {
            return 0;
        }
        int n = 0;
        int n2 = TreeInt.byteCount((TreeInt)this._freeBySize);
        Pointer4 pointer4 = this._file.newSlot(this.trans(), n2);
        n = pointer4._id;
        StatefulBuffer statefulBuffer = new StatefulBuffer(this.trans(), n2);
        statefulBuffer.useSlot(n, pointer4._address, n2);
        TreeInt.write(statefulBuffer, (TreeInt)this._freeBySize);
        statefulBuffer.writeEncrypt();
        this.trans().writePointer(pointer4._id, pointer4._address, n2);
        return n;
    }

    public int entryCount() {
        return Tree.size(this._freeByAddress);
    }
}

