/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.messages;

import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Buffer;
import com.db4o.internal.Const4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.messages.Msg;
import java.io.IOException;

public class MsgD
extends Msg {
    StatefulBuffer _payLoad;

    MsgD() {
    }

    MsgD(String string) {
        super(string);
    }

    void fakePayLoad(Transaction transaction) {
    }

    public Buffer getByteLoad() {
        return this._payLoad;
    }

    public final StatefulBuffer payLoad() {
        return this._payLoad;
    }

    public void payLoad(StatefulBuffer statefulBuffer) {
        this._payLoad = statefulBuffer;
    }

    public final MsgD getWriterForLength(Transaction transaction, int n) {
        MsgD msgD = (MsgD)this.clone(transaction);
        msgD._payLoad = new StatefulBuffer(transaction, n + 9);
        msgD.writeInt(this._msgID);
        msgD.writeInt(n);
        if (transaction.parentTransaction() == null) {
            msgD._payLoad.append((byte)115);
        } else {
            msgD._payLoad.append((byte)117);
        }
        return msgD;
    }

    public final MsgD getWriter(Transaction transaction) {
        return this.getWriterForLength(transaction, 0);
    }

    public final MsgD getWriterForInts(Transaction transaction, int[] nArray) {
        MsgD msgD = this.getWriterForLength(transaction, 4 * nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            msgD.writeInt(nArray[i]);
        }
        return msgD;
    }

    public final MsgD getWriterForIntArray(Transaction transaction, int[] nArray, int n) {
        MsgD msgD = this.getWriterForLength(transaction, 4 * (n + 1));
        msgD.writeInt(n);
        for (int i = 0; i < n; ++i) {
            msgD.writeInt(nArray[i]);
        }
        return msgD;
    }

    public final MsgD getWriterForInt(Transaction transaction, int n) {
        MsgD msgD = this.getWriterForLength(transaction, 4);
        msgD.writeInt(n);
        return msgD;
    }

    public final MsgD getWriterForIntString(Transaction transaction, int n, String string) {
        MsgD msgD = this.getWriterForLength(transaction, Const4.stringIO.length(string) + 8);
        msgD.writeInt(n);
        msgD.writeString(string);
        return msgD;
    }

    public final MsgD getWriterForLong(Transaction transaction, long l) {
        MsgD msgD = this.getWriterForLength(transaction, 8);
        msgD.writeLong(l);
        return msgD;
    }

    public final MsgD getWriterForString(Transaction transaction, String string) {
        MsgD msgD = this.getWriterForLength(transaction, Const4.stringIO.length(string) + 4);
        msgD.writeString(string);
        return msgD;
    }

    public MsgD getWriter(StatefulBuffer statefulBuffer) {
        MsgD msgD = this.getWriterForLength(statefulBuffer.getTransaction(), statefulBuffer.getLength());
        msgD._payLoad.append(statefulBuffer._buffer);
        return msgD;
    }

    public byte[] readBytes() {
        return this._payLoad.readBytes(this.readInt());
    }

    public final int readInt() {
        return this._payLoad.readInt();
    }

    public final long readLong() {
        return this._payLoad.readLong();
    }

    public final boolean readBoolean() {
        return this._payLoad.readByte() != 0;
    }

    final Msg readPayLoad(Transaction transaction, Socket4 socket4, Buffer buffer) throws IOException {
        int n = buffer.readInt();
        transaction = this.checkParentTransaction(transaction, buffer);
        MsgD msgD = (MsgD)this.clone(transaction);
        msgD._payLoad = new StatefulBuffer(transaction, n);
        msgD._payLoad.read(socket4);
        return msgD;
    }

    public final String readString() {
        int n = this.readInt();
        return Const4.stringIO.read(this._payLoad, n);
    }

    public final void writeBytes(byte[] byArray) {
        this.writeInt(byArray.length);
        this._payLoad.append(byArray);
    }

    public final void writeInt(int n) {
        this._payLoad.writeInt(n);
    }

    public final void writeLong(long l) {
        this._payLoad.writeLong(l);
    }

    public final void writeString(String string) {
        this._payLoad.writeInt(string.length());
        Const4.stringIO.write(this._payLoad, string);
    }
}

