/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.ObjectSet;
import com.db4o.User;
import com.db4o.config.Configuration;
import com.db4o.ext.ExtObjectServer;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.network.LoopbackSocket;
import com.db4o.foundation.network.LoopbackSocketServer;
import com.db4o.foundation.network.ServerSocket4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.ServerMessageDispatcher;
import java.io.IOException;

public class ObjectServerImpl
implements ObjectServer,
ExtObjectServer,
Runnable,
LoopbackSocketServer {
    private final String _name;
    private ServerSocket4 _serverSocket;
    private final int _port;
    private int i_threadIDGen = 1;
    private final Collection4 _threads = new Collection4();
    private LocalObjectContainer _container;
    private final Object _startupLock = new Object();
    private Config4Impl _config;

    public ObjectServerImpl(LocalObjectContainer localObjectContainer, int n) {
        this._container = localObjectContainer;
        this._port = n;
        this._config = this._container.configImpl();
        this._name = "db4o ServerSocket FILE: " + localObjectContainer.toString() + "  PORT:" + this._port;
        this._container.setServer(true);
        this.configureObjectServer();
        this.ensureLoadStaticClass();
        this.ensureLoadConfiguredClasses();
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer() {
        if (this.isEmbeddedServer()) {
            return;
        }
        Object object = this._startupLock;
        synchronized (object) {
            this.startServerSocket();
            this.startServerThread();
            boolean bl = false;
            while (!bl) {
                try {
                    this._startupLock.wait();
                    bl = true;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void startServerThread() {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    private void startServerSocket() {
        try {
            this._serverSocket = new ServerSocket4(this._port);
            this._serverSocket.setSoTimeout(this._config.timeoutServerSocket());
        }
        catch (IOException iOException) {
            Exceptions4.throwRuntimeException(30, "" + this._port);
        }
    }

    private boolean isEmbeddedServer() {
        return this._port <= 0;
    }

    private void ensureLoadStaticClass() {
        this._container.produceYapClass(this._container.i_handlers.ICLASS_STATICCLASS);
    }

    private void ensureLoadConfiguredClasses() {
        this._config.exceptionalClasses().forEachValue(new Visitor4(){

            public void visit(Object object) {
                ObjectServerImpl.this._container.produceYapClass(ObjectServerImpl.this._container.reflector().forName(((Config4Class)object).getName()));
            }
        });
    }

    private void configureObjectServer() {
        this._config.callbacks(false);
        this._config.isServer(true);
        this._config.objectClass(User.class).minimumActivationDepth(1);
    }

    public void backup(String string) throws IOException {
        this._container.backup(string);
    }

    final void checkClosed() {
        if (this._container == null) {
            Exceptions4.throwRuntimeException(20, this._name);
        }
        this._container.checkClosed();
    }

    public synchronized boolean close() {
        this.closeServerSocket();
        boolean bl = this.closeFile();
        this.closeMessageDispatchers();
        return bl;
    }

    private boolean closeFile() {
        if (this._container == null) {
            return true;
        }
        boolean bl = this._container.close();
        this._container = null;
        return bl;
    }

    private void closeMessageDispatchers() {
        Iterator4 iterator4 = this.iterateThreads();
        while (iterator4.moveNext()) {
            try {
                ((ServerMessageDispatcher)iterator4.current()).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator4 iterateThreads() {
        Collection4 collection4 = this._threads;
        synchronized (collection4) {
            return new Collection4(this._threads).iterator();
        }
    }

    private void closeServerSocket() {
        try {
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._serverSocket = null;
    }

    public Configuration configure() {
        return this._config;
    }

    public ExtObjectServer ext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerMessageDispatcher findThread(int n) {
        Collection4 collection4 = this._threads;
        synchronized (collection4) {
            Iterator4 iterator4 = this._threads.iterator();
            while (iterator4.moveNext()) {
                ServerMessageDispatcher serverMessageDispatcher = (ServerMessageDispatcher)iterator4.current();
                if (serverMessageDispatcher.i_threadID != n) continue;
                return serverMessageDispatcher;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void grantAccess(String string, String string2) {
        this.checkClosed();
        Object object = this._container.i_lock;
        synchronized (object) {
            User user = this.getUser(string);
            if (user != null) {
                this.setPassword(user, string2);
            } else {
                this.addUser(string, string2);
            }
            this._container.commit();
        }
    }

    private void addUser(String string, String string2) {
        this._container.set(new User(string, string2));
    }

    private void setPassword(User user, String string) {
        user.password = string;
        this._container.set(user);
    }

    User getUser(String string) {
        ObjectSet objectSet = this.queryUsers(string);
        if (!objectSet.hasNext()) {
            return null;
        }
        return (User)objectSet.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSet queryUsers(String string) {
        this._container.showInternalClasses(true);
        try {
            ObjectSet objectSet = this._container.get(new User(string, null));
            return objectSet;
        }
        finally {
            this._container.showInternalClasses(false);
        }
    }

    public ObjectContainer objectContainer() {
        return this._container;
    }

    public ObjectContainer openClient() {
        return this.openClient(Db4o.cloneConfiguration());
    }

    public synchronized ObjectContainer openClient(Configuration configuration) {
        this.checkClosed();
        try {
            ClientObjectContainer clientObjectContainer = new ClientObjectContainer(configuration, this.openClientSocket(), "embedded client" + (this.i_threadIDGen - 1), "", false);
            clientObjectContainer.blockSize(this._container.blockSize());
            return clientObjectContainer;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public LoopbackSocket openClientSocket() {
        int n = this._config.timeoutClientSocket();
        LoopbackSocket loopbackSocket = new LoopbackSocket(this, n);
        LoopbackSocket loopbackSocket2 = new LoopbackSocket(this, n, loopbackSocket);
        try {
            ServerMessageDispatcher serverMessageDispatcher = new ServerMessageDispatcher(this, this._container, loopbackSocket2, this.newThreadId(), true);
            this.addThread(serverMessageDispatcher);
            serverMessageDispatcher.start();
            return loopbackSocket;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(ServerMessageDispatcher serverMessageDispatcher) {
        Collection4 collection4 = this._threads;
        synchronized (collection4) {
            this._threads.remove(serverMessageDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void revokeAccess(String string) {
        this.checkClosed();
        Object object = this._container.i_lock;
        synchronized (object) {
            this.deleteUsers(string);
            this._container.commit();
        }
    }

    private void deleteUsers(String string) {
        ObjectSet objectSet = this.queryUsers(string);
        while (objectSet.hasNext()) {
            this._container.delete(objectSet.next());
        }
    }

    public void run() {
        this.setThreadName();
        this.logListeningOnPort();
        this.notifyThreadStarted();
        this.socketServerLoop();
    }

    private void setThreadName() {
        Thread.currentThread().setName(this._name);
    }

    private void socketServerLoop() {
        while (this._serverSocket != null) {
            try {
                ServerMessageDispatcher serverMessageDispatcher = new ServerMessageDispatcher(this, this._container, this._serverSocket.accept(), this.newThreadId(), false);
                this.addThread(serverMessageDispatcher);
                serverMessageDispatcher.start();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThreadStarted() {
        Object object = this._startupLock;
        synchronized (object) {
            this._startupLock.notifyAll();
        }
    }

    private void logListeningOnPort() {
        this._container.logMsg(31, "" + this._serverSocket.getLocalPort());
    }

    private int newThreadId() {
        return this.i_threadIDGen++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThread(ServerMessageDispatcher serverMessageDispatcher) {
        Collection4 collection4 = this._threads;
        synchronized (collection4) {
            this._threads.add(serverMessageDispatcher);
        }
    }
}

