/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.BitMap4;
import com.db4o.foundation.PrimitiveCodec;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.SlotReader;
import com.db4o.internal.Transaction;
import com.db4o.internal.handlers.LongHandler;

public class Buffer
implements SlotReader {
    public byte[] _buffer;
    public int _offset;

    Buffer() {
    }

    public Buffer(int n) {
        this._buffer = new byte[n];
    }

    public void seek(int n) {
        this._offset = n;
    }

    public final void append(byte by) {
        this._buffer[this._offset++] = by;
    }

    public void append(byte[] byArray) {
        System.arraycopy(byArray, 0, this._buffer, this._offset, byArray.length);
        this._offset += byArray.length;
    }

    public final boolean containsTheSame(Buffer buffer) {
        if (buffer != null) {
            byte[] byArray = buffer._buffer;
            if (this._buffer == null) {
                return byArray == null;
            }
            if (byArray != null && this._buffer.length == byArray.length) {
                int n = this._buffer.length;
                for (int i = 0; i < n; ++i) {
                    if (this._buffer[i] == byArray[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void copyTo(Buffer buffer, int n, int n2, int n3) {
        System.arraycopy(this._buffer, n, buffer._buffer, n2, n3);
    }

    public int getLength() {
        return this._buffer.length;
    }

    public void incrementOffset(int n) {
        this._offset += n;
    }

    public void read(ObjectContainerBase objectContainerBase, int n, int n2) {
        objectContainerBase.readBytes(this._buffer, n, n2, this.getLength());
    }

    public final void readBegin(byte by) {
    }

    public BitMap4 readBitMap(int n) {
        BitMap4 bitMap4 = new BitMap4(this._buffer, this._offset, n);
        this._offset += bitMap4.marshalledLength();
        return bitMap4;
    }

    public byte readByte() {
        return this._buffer[this._offset++];
    }

    public byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        this.readBytes(byArray);
        return byArray;
    }

    public void readBytes(byte[] byArray) {
        int n = byArray.length;
        System.arraycopy(this._buffer, this._offset, byArray, 0, n);
        this._offset += n;
    }

    public final Buffer readEmbeddedObject(Transaction transaction) {
        return transaction.stream().readReaderByAddress(this.readInt(), this.readInt());
    }

    public void readEncrypt(ObjectContainerBase objectContainerBase, int n) {
        objectContainerBase.readBytes(this._buffer, n, this.getLength());
        objectContainerBase.i_handlers.decrypt(this);
    }

    public void readEnd() {
    }

    public final int readInt() {
        int n = (this._offset += 4) - 1;
        return this._buffer[n] & 0xFF | (this._buffer[--n] & 0xFF) << 8 | (this._buffer[--n] & 0xFF) << 16 | this._buffer[--n] << 24;
    }

    public long readLong() {
        long l = 0L;
        l = PrimitiveCodec.readLong(this._buffer, this._offset);
        this.incrementOffset(8);
        return l;
    }

    public Buffer readPayloadReader(int n, int n2) {
        Buffer buffer = new Buffer(n2);
        System.arraycopy(this._buffer, n, buffer._buffer, 0, n2);
        return buffer;
    }

    void replaceWith(byte[] byArray) {
        System.arraycopy(byArray, 0, this._buffer, 0, this.getLength());
    }

    public String toString() {
        try {
            String string = "";
            for (int i = 0; i < this._buffer.length; ++i) {
                if (i > 0) {
                    string = string + " , ";
                }
                string = string + this._buffer[i];
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void writeBegin(byte by) {
    }

    public final void writeBitMap(BitMap4 bitMap4) {
        bitMap4.writeTo(this._buffer, this._offset);
        this._offset += bitMap4.marshalledLength();
    }

    public final void writeEncrypt(LocalObjectContainer localObjectContainer, int n, int n2) {
        localObjectContainer.i_handlers.encrypt(this);
        localObjectContainer.writeBytes(this, n, n2);
        localObjectContainer.i_handlers.decrypt(this);
    }

    public void writeEnd() {
    }

    public final void writeInt(int n) {
        int n2 = this._offset + 4;
        this._offset = n2--;
        byte[] byArray = this._buffer;
        byArray[n2] = (byte)n;
        byArray[--n2] = (byte)(n >>= 8);
        byArray[--n2] = (byte)(n >>= 8);
        byArray[--n2] = (byte)(n >> 8);
    }

    public void writeIDOf(Transaction transaction, Object object) {
        if (object == null) {
            this.writeInt(0);
            return;
        }
        if (object instanceof PersistentBase) {
            this.writeIDOf(transaction, (PersistentBase)object);
            return;
        }
        this.writeInt((Integer)object);
    }

    public void writeIDOf(Transaction transaction, PersistentBase persistentBase) {
        if (persistentBase == null) {
            this.writeInt(0);
            return;
        }
        persistentBase.writeOwnID(transaction, this);
    }

    public void writeShortString(Transaction transaction, String string) {
        transaction.stream().i_handlers.i_stringHandler.writeShort(string, this);
    }

    public void writeLong(long l) {
        LongHandler.writeLong(l, this);
    }

    public void incrementIntSize() {
        this.incrementOffset(4);
    }

    public int offset() {
        return this._offset;
    }

    public void offset(int n) {
        this._offset = n;
    }

    public void copyBytes(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this._buffer, n, byArray, n2, n3);
    }
}

