/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ReplicationRecord;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;
import com.db4o.internal.replication.MigrationConnection;
import com.db4o.query.Query;
import com.db4o.replication.ReplicationConflictHandler;
import com.db4o.replication.ReplicationProcess;

public class ReplicationImpl
implements ReplicationProcess {
    final ObjectContainerBase _peerA;
    final Transaction _transA;
    final ObjectContainerBase _peerB;
    final Transaction _transB;
    final ReplicationConflictHandler _conflictHandler;
    final ReplicationRecord _record;
    private int _direction;
    private static final int IGNORE = 0;
    private static final int TO_B = -1;
    private static final int TO_A = 1;
    private static final int CHECK_CONFLICT = -99;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationImpl(ObjectContainerBase objectContainerBase, ObjectContainer objectContainer, ReplicationConflictHandler replicationConflictHandler) {
        if (replicationConflictHandler == null) {
            throw new NullPointerException();
        }
        Object object = objectContainerBase.ext().lock();
        synchronized (object) {
            Object object2 = objectContainer.ext().lock();
            synchronized (object2) {
                this._peerA = objectContainerBase;
                this._transA = objectContainerBase.checkTransaction(null);
                this._peerB = (ObjectContainerBase)objectContainer;
                this._transB = this._peerB.checkTransaction(null);
                MigrationConnection migrationConnection = new MigrationConnection(this._peerA, this._peerB);
                this._peerA.i_handlers.migrationConnection(migrationConnection);
                this._peerA.i_handlers.replication(this);
                this._peerA.replicationCallState(-1);
                this._peerB.i_handlers.migrationConnection(migrationConnection);
                this._peerB.i_handlers.replication(this);
                this._peerB.replicationCallState(-1);
                this._conflictHandler = replicationConflictHandler;
                this._record = ReplicationRecord.beginReplication(this._transA, this._transB);
            }
        }
    }

    private int bindAndSet(Transaction transaction, ObjectContainerBase objectContainerBase, ObjectReference objectReference, Object object) {
        Db4oTypeImpl db4oTypeImpl;
        if (object instanceof Db4oTypeImpl && !(db4oTypeImpl = (Db4oTypeImpl)object).canBind()) {
            Db4oTypeImpl db4oTypeImpl2 = (Db4oTypeImpl)objectReference.getObject();
            db4oTypeImpl2.replicateFrom(object);
            return objectReference.getID();
        }
        objectContainerBase.bind2(objectReference, object);
        return objectContainerBase.setAfterReplication(transaction, object, 1, true);
    }

    public void checkConflict(Object object) {
        int n = this._direction;
        this._direction = -99;
        this.replicate(object);
        this._direction = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this._peerA.lock();
        synchronized (object) {
            Object object2 = this._peerB.lock();
            synchronized (object2) {
                this._peerA.commit();
                this._peerB.commit();
                this.endReplication();
                long l = this._peerA.currentVersion();
                long l2 = this._peerB.currentVersion();
                this._record._version = l > l2 ? l : l2;
                this._peerA.raiseVersion(this._record._version + 1L);
                this._peerB.raiseVersion(this._record._version + 1L);
                this._record.store(this._peerA);
                this._record.store(this._peerB);
            }
        }
    }

    private void endReplication() {
        this._peerA.replicationCallState(0);
        this._peerA.i_handlers.migrationConnection(null);
        this._peerA.i_handlers.replication(null);
        this._peerA.replicationCallState(0);
        this._peerB.i_handlers.migrationConnection(null);
        this._peerB.i_handlers.replication(null);
    }

    private int idInCaller(ObjectContainerBase objectContainerBase, ObjectReference objectReference, ObjectReference objectReference2) {
        return objectContainerBase == this._peerA ? objectReference.getID() : objectReference2.getID();
    }

    private int ignoreOrCheckConflict() {
        if (this._direction == -99) {
            return -99;
        }
        return 0;
    }

    private boolean isInConflict(long l, long l2) {
        if (l > this._record._version && l2 > this._record._version) {
            return true;
        }
        if (l2 > this._record._version && this._direction == -1) {
            return true;
        }
        return l > this._record._version && this._direction == 1;
    }

    private long lastSynchronization() {
        return this._record._version;
    }

    public ObjectContainer peerA() {
        return this._peerA;
    }

    public ObjectContainer peerB() {
        return this._peerB;
    }

    public void replicate(Object object) {
        ObjectContainerBase objectContainerBase = this._peerB;
        if (this._peerB.isStored(object) && !this._peerA.isStored(object)) {
            objectContainerBase = this._peerA;
        }
        objectContainerBase.set(object);
    }

    public void rollback() {
        this._peerA.rollback();
        this._peerB.rollback();
        this.endReplication();
    }

    public void setDirection(ObjectContainer objectContainer, ObjectContainer objectContainer2) {
        if (objectContainer == this._peerA && objectContainer2 == this._peerB) {
            this._direction = -1;
        }
        if (objectContainer == this._peerB && objectContainer2 == this._peerA) {
            this._direction = 1;
        }
    }

    private void shareBinding(ObjectReference objectReference, ObjectReference objectReference2, Object object, ObjectReference objectReference3, Object object2) {
        if (objectReference == null) {
            return;
        }
        if (object instanceof Db4oTypeImpl && !((Db4oTypeImpl)object).canBind()) {
            return;
        }
        if (objectReference == objectReference2) {
            this._peerB.bind2(objectReference3, object);
        } else {
            this._peerA.bind2(objectReference2, object2);
        }
    }

    private int toA() {
        if (this._direction == -99) {
            return -99;
        }
        if (this._direction != -1) {
            return 1;
        }
        return 0;
    }

    private int toB() {
        if (this._direction == -99) {
            return -99;
        }
        if (this._direction != 1) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryToHandle(ObjectContainerBase objectContainerBase, Object object) {
        int n = 0;
        ObjectContainerBase objectContainerBase2 = null;
        ObjectReference objectReference = null;
        if (objectContainerBase == this._peerA) {
            objectContainerBase2 = this._peerB;
            if (this._direction == -1) {
                n = -1;
            }
        } else {
            objectContainerBase2 = this._peerA;
            if (this._direction == 1) {
                n = -1;
            }
        }
        Object object2 = objectContainerBase2.i_lock;
        synchronized (object2) {
            Object[] objectArray;
            Object object3 = object;
            Object object4 = object;
            ObjectReference objectReference2 = this._peerA.getYapObject(object);
            ObjectReference objectReference3 = this._peerB.getYapObject(object);
            VirtualAttributes virtualAttributes = null;
            VirtualAttributes virtualAttributes2 = null;
            if (objectReference2 == null) {
                if (objectReference3 == null) {
                    return n;
                }
                objectReference = objectReference3;
                virtualAttributes2 = objectReference3.virtualAttributes(this._transB);
                if (virtualAttributes2 == null) {
                    return n;
                }
                objectArray = this._transA.objectAndYapObjectBySignature(virtualAttributes2.i_uuid, virtualAttributes2.i_database.i_signature);
                if (objectArray[0] == null) {
                    return n;
                }
                objectReference2 = (ObjectReference)objectArray[1];
                object3 = objectArray[0];
                virtualAttributes = objectReference2.virtualAttributes(this._transA);
            } else {
                virtualAttributes = objectReference2.virtualAttributes(this._transA);
                if (virtualAttributes == null) {
                    return n;
                }
                if (objectReference3 == null) {
                    objectReference = objectReference2;
                    objectArray = this._transB.objectAndYapObjectBySignature(virtualAttributes.i_uuid, virtualAttributes.i_database.i_signature);
                    if (objectArray[0] == null) {
                        return n;
                    }
                    objectReference3 = (ObjectReference)objectArray[1];
                    object4 = objectArray[0];
                }
                virtualAttributes2 = objectReference3.virtualAttributes(this._transB);
            }
            if (virtualAttributes == null || virtualAttributes2 == null) {
                return n;
            }
            if (object3 == object4) {
                if (objectContainerBase == this._peerA && this._direction == -1) {
                    return -1;
                }
                if (objectContainerBase == this._peerB && this._direction == 1) {
                    return -1;
                }
                return this.idInCaller(objectContainerBase, objectReference2, objectReference3);
            }
            this._peerA.refresh(object3, 1);
            this._peerB.refresh(object4, 1);
            if (virtualAttributes.i_version <= this._record._version && virtualAttributes2.i_version <= this._record._version) {
                if (this._direction != -99) {
                    this.shareBinding(objectReference, objectReference2, object3, objectReference3, object4);
                }
                return this.idInCaller(objectContainerBase, objectReference2, objectReference3);
            }
            int n2 = this.ignoreOrCheckConflict();
            if (this.isInConflict(virtualAttributes.i_version, virtualAttributes2.i_version)) {
                Object object5 = this._conflictHandler.resolveConflict(this, object3, object4);
                if (object5 == object3) {
                    int n3 = n2 = this._direction == 1 ? 0 : this.toB();
                }
                if (object5 == object4) {
                    int n4 = n2 = this._direction == -1 ? 0 : this.toA();
                }
                if (n2 == 0) {
                    return -1;
                }
            } else {
                int n5 = n2 = virtualAttributes2.i_version > this._record._version ? this.toA() : this.toB();
            }
            if (n2 == 1) {
                if (!objectReference3.isActive()) {
                    objectReference3.activate(this._transB, object4, 1, false);
                }
                int n6 = this.bindAndSet(this._transA, this._peerA, objectReference2, object4);
                if (objectContainerBase == this._peerA) {
                    return n6;
                }
            }
            if (n2 == -1) {
                if (!objectReference2.isActive()) {
                    objectReference2.activate(this._transA, object3, 1, false);
                }
                int n7 = this.bindAndSet(this._transB, this._peerB, objectReference3, object3);
                if (objectContainerBase == this._peerB) {
                    return n7;
                }
            }
            return this.idInCaller(objectContainerBase, objectReference2, objectReference3);
        }
    }

    public void whereModified(Query query) {
        query.descend("v4oversion").constrain(new Long(this.lastSynchronization())).greater();
    }
}

