/*
 * Decompiled with CFR 0.152.
 */
final class Cpu
implements CpuOutput,
Cloneable {
    private Action lastAction;
    private static final int binopPriorityMin = 0;
    private Settings.Mode mode;
    private CpuStack stack;
    private DoubleByDigit input;
    private double x;
    private final int base;
    private final double[] mem;
    private int currentMem;
    private Settings.AngleUnits angleUnits;
    private Settings.EnterMode enterMode;
    private final int inputLength;
    private final int expInputLength;
    private InputField inputField;

    private Cpu() {
        throw new AssertionError((Object)"Instantiating CPU without specifying the mode - RPN or Algebraic");
    }

    @Override
    public boolean isInputInProgress() {
        return this.lastAction == Action.INPUT || this.lastAction == Action.CLEAR;
    }

    @Override
    public CpuStackGetters getStack() {
        return this.stack;
    }

    @Override
    public DoubleByDigitGetters getInput() {
        return this.input;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getMem(int n) {
        if (n > this.mem.length) {
            throw new RuntimeException("Requesting the content of memory register " + n + " while the max allowed is " + this.mem.length);
        }
        return this.mem[n];
    }

    @Override
    public int getActiveMemNum() {
        return this.currentMem;
    }

    @Override
    public Settings.AngleUnits getAngleUnits() {
        return this.angleUnits;
    }

    public Cpu(Settings.Mode mode, Settings.AngleUnits angleUnits, int n, int n2, int n3, int n4, Settings.EnterMode enterMode, Settings.StackMode stackMode) {
        this.base = n3;
        this.input = new DoubleByDigit();
        this.inputLength = n;
        this.expInputLength = n2;
        this.inputField = InputField.INT;
        this.stack = new CpuStack(mode, stackMode);
        this.mem = new double[n4];
        this.mode = mode;
        this.angleUnits = angleUnits;
        this.enterMode = enterMode;
        this.currentMem = 0;
        this.resetRegisters();
        this.x = 0.0;
    }

    public Cpu clone() {
        Cpu cpu = new Cpu(this.mode, this.angleUnits, this.inputLength, this.expInputLength, this.base, this.mem.length, this.enterMode, this.stack.getStackMode());
        cpu.lastAction = this.lastAction;
        cpu.currentMem = this.currentMem;
        cpu.x = this.x;
        for (int i = 0; i < this.mem.length; ++i) {
            cpu.mem[i] = this.mem[i];
        }
        cpu.stack = this.stack.clone();
        cpu.input = this.input.clone();
        cpu.inputField = this.inputField;
        return cpu;
    }

    private void resetRegisters() {
        this.stack.clear();
        this.lastAction = Action.CLEAR;
        this.x = 0.0;
        this.input.clear();
    }

    void execute(Command command) {
        switch (command) {
            case DIGIT_0: 
            case DIGIT_1: 
            case DIGIT_2: 
            case DIGIT_3: 
            case DIGIT_4: 
            case DIGIT_5: 
            case DIGIT_6: 
            case DIGIT_7: 
            case DIGIT_8: 
            case DIGIT_9: {
                this.executeDigit(this.commandToDigit(command));
                break;
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case POW: {
                this.executeBinaryOp(Cpu.commandToBinaryOp(command));
                break;
            }
            case MEM_TO_X: 
            case MEM_PLUS: 
            case EXCH_X_MEM: 
            case X_TO_MEM: {
                this.executeMemoryOp(Cpu.commandToMemoryOp(command));
                break;
            }
            case MEM0: 
            case MEM1: {
                this.executeSwitchToMem(this.commandToMemIndex(command));
                break;
            }
            case LOG10: 
            case TENTOX: 
            case LN: 
            case ETOX: 
            case SQRT: 
            case SQR: 
            case INVX: 
            case FACT: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case SINH: 
            case ASINH: 
            case ACOS: 
            case COSH: 
            case ACOSH: 
            case ATAN: 
            case TANH: 
            case ATANH: {
                this.executeUnaryOp(Cpu.commandToUnaryOp(command));
                break;
            }
            case EQ: {
                this.executeEq();
                break;
            }
            case ENTER: {
                this.executeEnter();
                break;
            }
            case DOT: {
                this.executeDot();
                break;
            }
            case MANTISSA_SIGN: {
                this.executeMantissaSign();
                break;
            }
            case EXP: {
                this.executeExp();
                break;
            }
            case EXP_SIGN: {
                this.executeExpSign();
                break;
            }
            case SIGN: {
                this.executeCurrentSign();
                break;
            }
            case PI: {
                this.executePi();
                break;
            }
            case EXCH_XY: {
                this.executeExchXY();
                break;
            }
            case STACK_UP: {
                this.executeStackUp();
                break;
            }
            case STACK_DOWN: {
                this.executeStackDown();
                break;
            }
            case LEFT_PAREN: {
                this.executeLeftParen();
                break;
            }
            case RIGHT_PAREN: {
                this.executeRightParen();
                break;
            }
            case CLEAR_ALL: {
                this.executeClearAll();
                break;
            }
            case CLEAR_X: {
                this.executeClearX();
                break;
            }
            case DEG_RAD: {
                this.executeDegRad();
                break;
            }
            default: {
                throw new RuntimeException("unknown command " + (Object)((Object)command));
            }
        }
    }

    private static BinaryOp commandToBinaryOp(Command command) {
        if (command == null) {
            throw new RuntimeException("null BinaryOp command");
        }
        switch (command) {
            case ADD: {
                return BinaryOp.ADD;
            }
            case SUB: {
                return BinaryOp.SUB;
            }
            case MUL: {
                return BinaryOp.MUL;
            }
            case DIV: {
                return BinaryOp.DIV;
            }
            case POW: {
                return BinaryOp.POW;
            }
        }
        throw new RuntimeException("illegal BinaryOp command " + command.toString());
    }

    private static UnaryOp commandToUnaryOp(Command command) {
        if (command == null) {
            throw new RuntimeException("null UnaryOp command");
        }
        switch (command) {
            case LOG10: {
                return UnaryOp.LOG10;
            }
            case TENTOX: {
                return UnaryOp.TENTOX;
            }
            case LN: {
                return UnaryOp.LN;
            }
            case ETOX: {
                return UnaryOp.ETOX;
            }
            case SQRT: {
                return UnaryOp.SQRT;
            }
            case SQR: {
                return UnaryOp.SQR;
            }
            case INVX: {
                return UnaryOp.INVX;
            }
            case FACT: {
                return UnaryOp.FACT;
            }
            case SIN: {
                return UnaryOp.SIN;
            }
            case COS: {
                return UnaryOp.COS;
            }
            case TAN: {
                return UnaryOp.TAN;
            }
            case ASIN: {
                return UnaryOp.ASIN;
            }
            case SINH: {
                return UnaryOp.SINH;
            }
            case ASINH: {
                return UnaryOp.ASINH;
            }
            case ACOS: {
                return UnaryOp.ACOS;
            }
            case COSH: {
                return UnaryOp.COSH;
            }
            case ACOSH: {
                return UnaryOp.ACOSH;
            }
            case ATAN: {
                return UnaryOp.ATAN;
            }
            case TANH: {
                return UnaryOp.TANH;
            }
            case ATANH: {
                return UnaryOp.ATANH;
            }
        }
        throw new RuntimeException("illegal UnaryOp command " + command.toString());
    }

    private static MemoryOp commandToMemoryOp(Command command) {
        if (command == null) {
            throw new RuntimeException("null MemoryOp command");
        }
        switch (command) {
            case MEM_TO_X: {
                return MemoryOp.MEM_TO_X;
            }
            case MEM_PLUS: {
                return MemoryOp.MEM_PLUS;
            }
            case EXCH_X_MEM: {
                return MemoryOp.EXCH_X_MEM;
            }
            case X_TO_MEM: {
                return MemoryOp.X_TO_MEM;
            }
        }
        throw new RuntimeException("illegal MemoryOp command " + command.toString());
    }

    private int commandToDigit(Command command) {
        if (command == null) {
            throw new RuntimeException("null digit command");
        }
        switch (command) {
            case DIGIT_0: {
                return 0;
            }
            case DIGIT_1: {
                return 1;
            }
            case DIGIT_2: {
                return 2;
            }
            case DIGIT_3: {
                return 3;
            }
            case DIGIT_4: {
                return 4;
            }
            case DIGIT_5: {
                return 5;
            }
            case DIGIT_6: {
                return 6;
            }
            case DIGIT_7: {
                return 7;
            }
            case DIGIT_8: {
                return 8;
            }
            case DIGIT_9: {
                return 9;
            }
        }
        throw new RuntimeException("illegal digit command " + command.toString());
    }

    private int commandToMemIndex(Command command) {
        if (command == null) {
            throw new RuntimeException("null mem index command");
        }
        switch (command) {
            case MEM0: {
                return 0;
            }
            case MEM1: {
                return 1;
            }
        }
        throw new RuntimeException("illegal mem index command " + command.toString());
    }

    private void executeDigit(int n) {
        block0 : switch (this.mode) {
            case ALG: {
                switch (this.lastAction) {
                    case CLEAR: 
                    case ENTER: 
                    case BINOP: {
                        this.input.clear();
                        this.inputField = InputField.INT;
                        break block0;
                    }
                    case ENTER_PUSH: {
                        throw new RuntimeException("the cpu's last action may not be ENTER_PUSH in ALG mode");
                    }
                }
                break;
            }
            case RPN: {
                switch (this.lastAction) {
                    case CLEAR: {
                        this.input.clear();
                        this.inputField = InputField.INT;
                        break block0;
                    }
                    case ENTER: {
                        this.stack.push(this.x);
                        this.input.clear();
                        this.inputField = InputField.INT;
                        break block0;
                    }
                    case ENTER_PUSH: {
                        this.input.clear();
                        this.inputField = InputField.INT;
                        break block0;
                    }
                    case INPUT: {
                        break block0;
                    }
                    case BINOP: {
                        throw new RuntimeException("the cpu's last action may not be BINOP in RPN mode");
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown cpu mode " + this.mode.toString());
            }
        }
        switch (this.inputField) {
            case INT: {
                if (this.input.getNIntDigits() >= this.inputLength || n == 0 && this.input.getNIntDigits() == 0) break;
                this.input.addIntDigit(n);
                break;
            }
            case FRAC: {
                if (this.input.getNIntDigits() + this.input.getNFracDigits() >= this.inputLength) break;
                this.input.addFracDigit(n);
                break;
            }
            case EXP: {
                this.input.addExpDigit(n, this.expInputLength);
                break;
            }
            default: {
                throw new RuntimeException("invalid current input field " + this.inputField.toString());
            }
        }
        this.lastAction = Action.INPUT;
    }

    private static double angleToRad(double d, Settings.AngleUnits angleUnits) {
        switch (angleUnits) {
            case RAD: {
                return d;
            }
            case DEG: {
                return d * Math.PI / 180.0;
            }
        }
        throw new RuntimeException("unknown angle units " + angleUnits.toString());
    }

    private static double angleFromRad(double d, Settings.AngleUnits angleUnits) {
        switch (angleUnits) {
            case RAD: {
                return d;
            }
            case DEG: {
                return d * 180.0 / Math.PI;
            }
        }
        throw new RuntimeException("unknown angle units " + angleUnits.toString());
    }

    private void executeDot() {
        if (this.lastAction != Action.INPUT) {
            if (this.mode == Settings.Mode.RPN && this.lastAction == Action.ENTER) {
                this.stack.push(this.x);
            }
            this.input.clear();
            this.lastAction = Action.INPUT;
            this.inputField = InputField.INT;
        }
        if (this.inputField == InputField.INT) {
            if (this.input.getNIntDigits() == 0) {
                this.input.addIntDigit(0);
            }
            this.inputField = InputField.FRAC;
        }
    }

    private void executeMantissaSign() {
        if (this.isInputInProgress()) {
            this.input.inverseSign();
        } else {
            this.x = -this.x;
        }
    }

    private void executeExp() {
        if (this.lastAction != Action.INPUT) {
            if (this.mode == Settings.Mode.RPN && this.lastAction == Action.ENTER) {
                this.stack.push(this.x);
            }
            this.input.clear();
            this.input.addIntDigit(1);
            this.lastAction = Action.INPUT;
            this.inputField = InputField.INT;
        }
        if (this.inputField != InputField.EXP) {
            this.inputField = InputField.EXP;
            this.input.addExpDigit(0, this.expInputLength);
        }
    }

    private void executeExpSign() {
        if (this.inputField != InputField.EXP || this.lastAction != Action.INPUT) {
            return;
        }
        this.input.inverseExpSign();
    }

    private void executeCurrentSign() {
        if (this.isInputInProgress()) {
            if (this.inputField != InputField.EXP) {
                this.input.inverseSign();
            } else {
                this.input.inverseExpSign();
            }
        } else {
            this.x = -this.x;
        }
    }

    private void executeClearAll() {
        this.resetRegisters();
    }

    private void executeClearX() {
        this.lastAction = Action.CLEAR;
        this.x = 0.0;
        this.input.clear();
    }

    private void executePi() {
        if (this.mode == Settings.Mode.RPN) {
            if (this.lastAction == Action.INPUT) {
                this.x = this.input.toDouble(this.base);
            }
            this.stack.push(this.x);
        }
        this.x = Math.PI;
        this.lastAction = Action.ENTER;
    }

    void executePaste(double d) {
        if (this.mode == Settings.Mode.RPN) {
            if (this.lastAction == Action.INPUT) {
                this.x = this.input.toDouble(this.base);
            }
            this.stack.push(this.x);
        }
        this.x = d;
        this.lastAction = Action.ENTER;
    }

    private void executeBinaryOp(BinaryOp binaryOp) {
        if (this.lastAction == Action.INPUT) {
            this.x = this.input.toDouble(10);
        }
        switch (this.mode) {
            case RPN: {
                double d = this.stack.pop();
                this.x = Cpu.computeBinaryOp(d, this.x, binaryOp, this.base);
                this.lastAction = Action.ENTER;
                break;
            }
            case ALG: {
                if (!this.stack.isEmpty() && Cpu.binaryOpPriority(this.stack.getOp()) >= Cpu.binaryOpPriority(binaryOp)) {
                    this.doBinaryOpChain(Cpu.binaryOpPriority(binaryOp), false);
                }
                this.stack.push(this.x, binaryOp);
                this.lastAction = Action.BINOP;
                break;
            }
            default: {
                throw new RuntimeException("unknown cpu mode " + this.mode.toString());
            }
        }
    }

    private static int binaryOpPriority(BinaryOp binaryOp) {
        switch (binaryOp) {
            case ADD: 
            case SUB: {
                return 1;
            }
            case MUL: 
            case DIV: {
                return 2;
            }
            case POW: {
                return 3;
            }
        }
        throw new RuntimeException("unknown binaryOp " + binaryOp.toString());
    }

    private void doBinaryOpChain(int n, boolean bl) {
        if (this.mode == Settings.Mode.RPN) {
            throw new RuntimeException("doBinaryOpChain called in RPN mode");
        }
        if (bl) {
            if (this.stack.headParenExists()) {
                this.stack.headParenRemove();
                return;
            }
            while (!this.stack.headParenExists()) {
                this.x = Cpu.computeBinaryOp(this.stack.getValue(), this.x, this.stack.getOp(), this.base);
                this.stack.pop();
            }
            this.stack.headParenRemove();
        } else {
            while (!this.stack.isEmpty() && (Cpu.binaryOpPriority(this.stack.getOp()) >= n && !this.stack.headParenExists() || n == 0)) {
                this.x = Cpu.computeBinaryOp(this.stack.getValue(), this.x, this.stack.getOp(), this.base);
                this.stack.pop();
            }
        }
    }

    private static double computeBinaryOp(double d, double d2, BinaryOp binaryOp, int n) {
        switch (binaryOp) {
            case ADD: {
                return MathUtil.smartSum(d, d2, n);
            }
            case SUB: {
                return MathUtil.smartSum(d, -d2, n);
            }
            case MUL: {
                return d * d2;
            }
            case DIV: {
                if (d2 != 0.0) {
                    return d / d2;
                }
                return Double.NaN;
            }
            case POW: {
                if (d == 0.0 && d2 <= 0.0 || d < 0.0 && d2 != Math.floor(d2)) {
                    return Double.NaN;
                }
                return Math.pow(d, d2);
            }
        }
        throw new RuntimeException("unknown binaryOp " + binaryOp.toString());
    }

    private void executeEq() {
        switch (this.mode) {
            case RPN: {
                throw new RuntimeException("executeEq called in RPN mode");
            }
            case ALG: {
                if (this.lastAction == Action.INPUT) {
                    this.x = this.input.toDouble(10);
                }
                this.doBinaryOpChain(0, false);
                this.stack.clear();
                this.lastAction = Action.ENTER;
                break;
            }
            default: {
                throw new RuntimeException("unknown cpu mode " + this.mode.toString());
            }
        }
    }

    private void executeEnter() {
        block0 : switch (this.mode) {
            case ALG: {
                throw new RuntimeException("executeEnter called in ALG mode");
            }
            case RPN: {
                switch (this.enterMode) {
                    case TRADITIONAL: {
                        if (this.lastAction == Action.INPUT) {
                            this.x = this.input.toDouble(10);
                        }
                        this.stack.push(this.x);
                        this.lastAction = Action.ENTER_PUSH;
                        break block0;
                    }
                    case HP28: {
                        if (this.lastAction == Action.INPUT) {
                            this.x = this.input.toDouble(10);
                        } else {
                            this.stack.push(this.x);
                        }
                        this.lastAction = Action.ENTER;
                        break block0;
                    }
                }
                throw new RuntimeException("unknown enter mode " + this.enterMode.toString());
            }
            default: {
                throw new RuntimeException("unknown cpu mode " + this.mode.toString());
            }
        }
    }

    private void executeExchXY() {
        if (this.lastAction == Action.INPUT) {
            this.x = this.input.toDouble(10);
        }
        this.x = this.stack.swapHeadValue(this.x);
        this.lastAction = Action.ENTER;
    }

    private void executeStackUp() {
        if (this.lastAction == Action.INPUT) {
            this.x = this.input.toDouble(10);
        }
        this.x = this.stack.rollUp(this.x);
        this.lastAction = Action.ENTER;
    }

    private void executeStackDown() {
        if (this.lastAction == Action.INPUT) {
            this.x = this.input.toDouble(10);
        }
        this.x = this.stack.rollDown(this.x);
        this.lastAction = Action.ENTER;
    }

    private void executeLeftParen() {
        if (this.mode == Settings.Mode.RPN) {
            throw new RuntimeException("cannot be called in RPN mode");
        }
        if (this.lastAction == Action.BINOP) {
            this.stack.headParenAdd();
        }
    }

    private void executeRightParen() {
        if (this.mode == Settings.Mode.RPN) {
            throw new RuntimeException("cannot be called in RPN mode");
        }
        if (this.lastAction == Action.INPUT) {
            this.x = this.input.toDouble(10);
        }
        if (this.stack.existOpenParen()) {
            if (!this.stack.isEmpty()) {
                this.doBinaryOpChain(0, true);
            }
        } else {
            this.doBinaryOpChain(0, false);
        }
        this.lastAction = Action.ENTER;
    }

    private void executeUnaryOp(UnaryOp unaryOp) {
        if (this.lastAction == Action.INPUT) {
            this.x = this.input.toDouble(10);
        }
        switch (unaryOp) {
            case LOG10: {
                if (this.x > 0.0) {
                    this.x = Math.log10(this.x);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case TENTOX: {
                if (this.x < Math.pow(10.0, this.expInputLength)) {
                    this.x = Math.pow(10.0, this.x);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case LN: {
                if (this.x > 0.0) {
                    this.x = Math.log(this.x);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case ETOX: {
                if (this.x * Math.log10(Math.E) < Math.pow(10.0, this.expInputLength)) {
                    this.x = Math.exp(this.x);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case SQRT: {
                if (this.x >= 0.0) {
                    this.x = Math.sqrt(this.x);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case SQR: {
                this.x *= this.x;
                break;
            }
            case INVX: {
                if (this.x != 0.0) {
                    this.x = 1.0 / this.x;
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case FACT: {
                if (MathUtil.factCanDo(this.x, this.expInputLength)) {
                    this.x = MathUtil.fact(this.x, this.inputLength);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case SIN: {
                this.x = Cpu.angleToRad(this.x, this.angleUnits);
                if (Math.abs(this.x % Math.PI) < Math.ulp(this.x)) {
                    this.x = 0.0;
                    break;
                }
                this.x = Math.sin(this.x);
                break;
            }
            case ASIN: {
                if (Math.abs(this.x) <= 1.0) {
                    this.x = Math.asin(this.x);
                    this.x = Cpu.angleFromRad(this.x, this.angleUnits);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case SINH: {
                this.x = Math.sinh(this.x);
                break;
            }
            case ASINH: {
                this.x = MathUtil.asinh(this.x);
                break;
            }
            case COS: {
                this.x = Cpu.angleToRad(this.x, this.angleUnits);
                if (Math.abs((this.x - 1.5707963267948966) % Math.PI) < Math.ulp(this.x)) {
                    this.x = 0.0;
                    break;
                }
                this.x = Math.cos(this.x);
                break;
            }
            case ACOS: {
                if (Math.abs(this.x) <= 1.0) {
                    this.x = Math.acos(this.x);
                    this.x = Cpu.angleFromRad(this.x, this.angleUnits);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case COSH: {
                this.x = Math.cosh(this.x);
                break;
            }
            case ACOSH: {
                if (this.x >= 1.0) {
                    this.x = MathUtil.acosh(this.x);
                    break;
                }
                this.x = Double.NaN;
                break;
            }
            case TAN: {
                this.x = Cpu.angleToRad(this.x, this.angleUnits);
                if (Math.abs((this.x - 1.5707963267948966) % Math.PI) < Math.ulp(this.x)) {
                    this.x = Double.NaN;
                    break;
                }
                if (Math.abs(this.x % Math.PI) < Math.ulp(this.x)) {
                    this.x = 0.0;
                    break;
                }
                this.x = Math.tan(this.x);
                break;
            }
            case ATAN: {
                this.x = Math.atan(this.x);
                this.x = Cpu.angleFromRad(this.x, this.angleUnits);
                break;
            }
            case TANH: {
                this.x = Math.tanh(this.x);
                break;
            }
            case ATANH: {
                this.x = MathUtil.atanh(this.x);
                break;
            }
            default: {
                throw new RuntimeException("unknown unary op " + unaryOp.toString());
            }
        }
        this.lastAction = Action.ENTER;
    }

    private void executeMemoryOp(MemoryOp memoryOp) {
        if (this.lastAction == Action.INPUT) {
            this.x = this.input.toDouble(this.base);
        }
        switch (memoryOp) {
            case MEM_PLUS: {
                this.mem[this.currentMem] = MathUtil.smartSum(this.x, this.mem[this.currentMem], this.base);
                break;
            }
            case MEM_TO_X: {
                switch (this.mode) {
                    case RPN: {
                        this.stack.push(this.x);
                    }
                    case ALG: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown cpu mode " + this.mode.toString());
                    }
                }
                this.x = this.mem[this.currentMem];
                break;
            }
            case X_TO_MEM: {
                this.mem[this.currentMem] = this.x;
                break;
            }
            case EXCH_X_MEM: {
                double d = this.x;
                this.x = this.mem[this.currentMem];
                this.mem[this.currentMem] = d;
                break;
            }
            default: {
                throw new RuntimeException("unknown memory op " + memoryOp.toString());
            }
        }
        this.lastAction = Action.ENTER;
    }

    private void executeSwitchToMem(int n) {
        this.currentMem = n;
    }

    private void executeDegRad() {
        switch (this.angleUnits) {
            case DEG: {
                this.angleUnits = Settings.AngleUnits.RAD;
                break;
            }
            case RAD: {
                this.angleUnits = Settings.AngleUnits.DEG;
                break;
            }
            default: {
                throw new RuntimeException("unknown current angle units " + this.angleUnits.toString());
            }
        }
    }

    void setEnterMode(Settings.EnterMode enterMode) {
        this.enterMode = enterMode;
    }

    void setStackMode(Settings.StackMode stackMode) {
        this.stack.setStackMode(stackMode);
    }

    void setMode(Settings.Mode mode) {
        if (this.mode != mode) {
            this.resetRegisters();
            this.mode = mode;
            this.stack = new CpuStack(mode, this.stack.getStackMode());
        }
    }

    Settings.EnterMode getEnterMode() {
        return this.enterMode;
    }

    Settings.StackMode getStackMode() {
        return this.stack.getStackMode();
    }

    Settings.Mode getMode() {
        return this.mode;
    }

    private static enum InputField {
        INT,
        FRAC,
        EXP;

    }

    private static enum MemoryOp {
        MEM_TO_X,
        MEM_PLUS,
        EXCH_X_MEM,
        X_TO_MEM;

    }

    private static enum UnaryOp {
        LOG10,
        TENTOX,
        LN,
        ETOX,
        SQRT,
        SQR,
        INVX,
        FACT,
        SIN,
        COS,
        TAN,
        ASIN,
        SINH,
        ASINH,
        ACOS,
        COSH,
        ACOSH,
        ATAN,
        TANH,
        ATANH;

    }

    static enum BinaryOp {
        ADD,
        SUB,
        MUL,
        DIV,
        POW;

    }

    private static enum Action {
        CLEAR,
        ENTER,
        ENTER_PUSH,
        INPUT,
        BINOP;

    }
}

