/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextureImage;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wall
implements Serializable,
Selectable,
Elevatable {
    private static final long serialVersionUID = 1L;
    private float xStart;
    private float yStart;
    private float xEnd;
    private float yEnd;
    private Float arcExtent;
    private Wall wallAtStart;
    private Wall wallAtEnd;
    private float thickness;
    private Float height;
    private Float heightAtEnd;
    private Integer leftSideColor;
    private HomeTexture leftSideTexture;
    private float leftSideShininess;
    private Integer rightSideColor;
    private HomeTexture rightSideTexture;
    private float rightSideShininess;
    private boolean symmetric = true;
    private TextureImage pattern;
    private Integer topColor;
    private Level level;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient float[][] pointsCache;

    public Wall(float f, float f2, float f3, float f4, float f5) {
        this(f, f2, f3, f4, f5, 0.0f);
    }

    public Wall(float f, float f2, float f3, float f4, float f5, float f6) {
        this(f, f2, f3, f4, f5, f6, null);
    }

    public Wall(float f, float f2, float f3, float f4, float f5, float f6, TextureImage textureImage) {
        this.xStart = f;
        this.yStart = f2;
        this.xEnd = f3;
        this.yEnd = f4;
        this.thickness = f5;
        this.height = Float.valueOf(f6);
        this.pattern = textureImage;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public float getXStart() {
        return this.xStart;
    }

    public void setXStart(float f) {
        if (f != this.xStart) {
            float f2 = this.xStart;
            this.xStart = f;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.X_START.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getYStart() {
        return this.yStart;
    }

    public void setYStart(float f) {
        if (f != this.yStart) {
            float f2 = this.yStart;
            this.yStart = f;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.Y_START.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getXEnd() {
        return this.xEnd;
    }

    public void setXEnd(float f) {
        if (f != this.xEnd) {
            float f2 = this.xEnd;
            this.xEnd = f;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.X_END.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getYEnd() {
        return this.yEnd;
    }

    public void setYEnd(float f) {
        if (f != this.yEnd) {
            float f2 = this.yEnd;
            this.yEnd = f;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.Y_END.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getLength() {
        if (this.arcExtent == null || this.arcExtent.floatValue() == 0.0f) {
            return (float)Point2D.distance(this.xStart, this.yStart, this.xEnd, this.yEnd);
        }
        float[] fArray = this.getArcCircleCenter();
        float f = (float)Point2D.distance(this.xStart, this.yStart, fArray[0], fArray[1]);
        return Math.abs(this.arcExtent.floatValue()) * f;
    }

    public float getStartPointToEndPointDistance() {
        return (float)Point2D.distance(this.xStart, this.yStart, this.xEnd, this.yEnd);
    }

    public void setArcExtent(Float f) {
        if (f != this.arcExtent || f != null && !f.equals(this.arcExtent)) {
            Float f2 = this.arcExtent;
            this.arcExtent = f;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.ARC_EXTENT.name(), f2, f);
        }
    }

    public Float getArcExtent() {
        return this.arcExtent;
    }

    public float getXArcCircleCenter() {
        if (this.arcExtent == null) {
            return (this.xStart + this.xEnd) / 2.0f;
        }
        return this.getArcCircleCenter()[0];
    }

    public float getYArcCircleCenter() {
        if (this.arcExtent == null) {
            return (this.yStart + this.yEnd) / 2.0f;
        }
        return this.getArcCircleCenter()[1];
    }

    private float[] getArcCircleCenter() {
        double d = Point2D.distance(this.xStart, this.yStart, this.xEnd, this.yEnd);
        double d2 = (double)Math.abs(this.arcExtent.floatValue()) > Math.PI ? -(Math.PI + (double)this.arcExtent.floatValue()) / 2.0 : (Math.PI - (double)this.arcExtent.floatValue()) / 2.0;
        float f = -((float)(Math.tan(d2) * d / 2.0));
        float f2 = (this.xStart + this.xEnd) / 2.0f;
        float f3 = (this.yStart + this.yEnd) / 2.0f;
        double d3 = Math.atan2(this.xStart - this.xEnd, this.yEnd - this.yStart);
        return new float[]{(float)((double)f2 + (double)f * Math.cos(d3)), (float)((double)f3 + (double)f * Math.sin(d3))};
    }

    public Wall getWallAtStart() {
        return this.wallAtStart;
    }

    public void setWallAtStart(Wall wall) {
        this.setWallAtStart(wall, true);
    }

    private void setWallAtStart(Wall wall, boolean bl) {
        if (wall != this.wallAtStart) {
            Wall wall2 = this.wallAtStart;
            this.wallAtStart = wall;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.WALL_AT_START.name(), wall2, wall);
            if (bl) {
                this.detachJoinedWall(wall2);
            }
        }
    }

    public Wall getWallAtEnd() {
        return this.wallAtEnd;
    }

    public void setWallAtEnd(Wall wall) {
        this.setWallAtEnd(wall, true);
    }

    private void setWallAtEnd(Wall wall, boolean bl) {
        if (wall != this.wallAtEnd) {
            Wall wall2 = this.wallAtEnd;
            this.wallAtEnd = wall;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.WALL_AT_END.name(), wall2, wall);
            if (bl) {
                this.detachJoinedWall(wall2);
            }
        }
    }

    private void detachJoinedWall(Wall wall) {
        if (wall != null) {
            if (wall.getWallAtStart() == this) {
                wall.setWallAtStart(null, false);
            } else if (wall.getWallAtEnd() == this) {
                wall.setWallAtEnd(null, false);
            }
        }
    }

    public float getThickness() {
        return this.thickness;
    }

    public void setThickness(float f) {
        if (f != this.thickness) {
            float f2 = this.thickness;
            this.thickness = f;
            this.clearPointsCache();
            this.propertyChangeSupport.firePropertyChange(Property.THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public Float getHeight() {
        return this.height;
    }

    public void setHeight(Float f) {
        if (f != this.height || f != null && !f.equals(this.height)) {
            Float f2 = this.height;
            this.height = f;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f2, f);
        }
    }

    public Float getHeightAtEnd() {
        return this.heightAtEnd;
    }

    public void setHeightAtEnd(Float f) {
        if (!(f == this.heightAtEnd || f != null && f.equals(this.heightAtEnd))) {
            Float f2 = this.heightAtEnd;
            this.heightAtEnd = f;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT_AT_END.name(), f2, f);
        }
    }

    public boolean isTrapezoidal() {
        return this.height != null && this.heightAtEnd != null && !this.height.equals(this.heightAtEnd);
    }

    public Integer getLeftSideColor() {
        return this.leftSideColor;
    }

    public void setLeftSideColor(Integer n) {
        if (!(n == this.leftSideColor || n != null && n.equals(this.leftSideColor))) {
            Integer n2 = this.leftSideColor;
            this.leftSideColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_COLOR.name(), n2, n);
        }
    }

    public Integer getRightSideColor() {
        return this.rightSideColor;
    }

    public void setRightSideColor(Integer n) {
        if (!(n == this.rightSideColor || n != null && n.equals(this.rightSideColor))) {
            Integer n2 = this.rightSideColor;
            this.rightSideColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_COLOR.name(), n2, n);
        }
    }

    public HomeTexture getLeftSideTexture() {
        return this.leftSideTexture;
    }

    public void setLeftSideTexture(HomeTexture homeTexture) {
        if (!(homeTexture == this.leftSideTexture || homeTexture != null && homeTexture.equals(this.leftSideTexture))) {
            HomeTexture homeTexture2 = this.leftSideTexture;
            this.leftSideTexture = homeTexture;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_TEXTURE.name(), homeTexture2, homeTexture);
        }
    }

    public HomeTexture getRightSideTexture() {
        return this.rightSideTexture;
    }

    public void setRightSideTexture(HomeTexture homeTexture) {
        if (!(homeTexture == this.rightSideTexture || homeTexture != null && homeTexture.equals(this.rightSideTexture))) {
            HomeTexture homeTexture2 = this.rightSideTexture;
            this.rightSideTexture = homeTexture;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_TEXTURE.name(), homeTexture2, homeTexture);
        }
    }

    public float getLeftSideShininess() {
        return this.leftSideShininess;
    }

    public void setLeftSideShininess(float f) {
        if (f != this.leftSideShininess) {
            float f2 = this.leftSideShininess;
            this.leftSideShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.LEFT_SIDE_SHININESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getRightSideShininess() {
        return this.rightSideShininess;
    }

    public void setRightSideShininess(float f) {
        if (f != this.rightSideShininess) {
            float f2 = this.rightSideShininess;
            this.rightSideShininess = f;
            this.propertyChangeSupport.firePropertyChange(Property.RIGHT_SIDE_SHININESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public TextureImage getPattern() {
        return this.pattern;
    }

    public void setPattern(TextureImage textureImage) {
        if (this.pattern != textureImage) {
            TextureImage textureImage2 = this.pattern;
            this.pattern = textureImage;
            this.propertyChangeSupport.firePropertyChange(Property.PATTERN.name(), textureImage2, textureImage);
        }
    }

    public Integer getTopColor() {
        return this.topColor;
    }

    public void setTopColor(Integer n) {
        if (!(this.topColor == n || n != null && n.equals(this.topColor))) {
            Integer n2 = this.topColor;
            this.topColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.TOP_COLOR.name(), n2, n);
        }
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            Level level2 = this.level;
            this.level = level;
            this.propertyChangeSupport.firePropertyChange(Property.LEVEL.name(), level2, level);
        }
    }

    @Override
    public boolean isAtLevel(Level level) {
        return this.level == level || this.level != null && level != null && this.level.getElevation() <= level.getElevation() && this.level.getElevation() + this.getWallMaximumHeight() > level.getElevation();
    }

    private float getWallMaximumHeight() {
        if (this.height == null) {
            return 0.0f;
        }
        if (this.isTrapezoidal()) {
            return Math.max(this.height.floatValue(), this.heightAtEnd.floatValue());
        }
        return this.height.floatValue();
    }

    private void clearPointsCache() {
        this.pointsCache = null;
        if (this.wallAtStart != null) {
            this.wallAtStart.pointsCache = null;
        }
        if (this.wallAtEnd != null) {
            this.wallAtEnd.pointsCache = null;
        }
    }

    @Override
    public float[][] getPoints() {
        if (this.pointsCache == null) {
            boolean bl;
            boolean bl2;
            int n;
            int n2;
            int n3;
            int n4;
            float[][] fArray;
            float[][] fArray2 = this.getUnjoinedShapePoints();
            int n5 = 0;
            int n6 = fArray2.length - 1;
            int n7 = fArray2.length / 2 - 1;
            int n8 = fArray2.length / 2;
            float f = 2.0f * this.thickness;
            if (this.wallAtStart != null) {
                fArray = this.wallAtStart.getUnjoinedShapePoints();
                n4 = 0;
                n3 = fArray.length - 1;
                n2 = fArray.length / 2 - 1;
                n = fArray.length / 2;
                bl2 = this.wallAtStart.getWallAtEnd() == this && (this.wallAtStart.getWallAtStart() != this || this.wallAtStart.xEnd == this.xStart && this.wallAtStart.yEnd == this.yStart);
                boolean bl3 = bl = this.wallAtStart.getWallAtStart() == this && (this.wallAtStart.getWallAtEnd() != this || this.wallAtStart.xStart == this.xStart && this.wallAtStart.yStart == this.yStart);
                if (bl2) {
                    this.computeIntersection(fArray2[n5], fArray2[n5 + 1], fArray[n2], fArray[n2 - 1], f);
                    this.computeIntersection(fArray2[n6], fArray2[n6 - 1], fArray[n], fArray[n + 1], f);
                    if (this.wallAtStart.pointsCache != null) {
                        if (Math.abs(fArray2[n5][0] - this.wallAtStart.pointsCache[n2][0]) < 0.01f && Math.abs(fArray2[n5][1] - this.wallAtStart.pointsCache[n2][1]) < 0.01f) {
                            fArray2[n5] = this.wallAtStart.pointsCache[n2];
                        }
                        if (Math.abs(fArray2[n6][0] - this.wallAtStart.pointsCache[n][0]) < 0.01f && Math.abs(fArray2[n6][1] - this.wallAtStart.pointsCache[n][1]) < 0.01f) {
                            fArray2[n6] = this.wallAtStart.pointsCache[n];
                        }
                    }
                } else if (bl) {
                    this.computeIntersection(fArray2[n5], fArray2[n5 + 1], fArray[n3], fArray[n3 - 1], f);
                    this.computeIntersection(fArray2[n6], fArray2[n6 - 1], fArray[n4], fArray[n4 + 1], f);
                    if (this.wallAtStart.pointsCache != null) {
                        if (Math.abs(fArray2[n5][0] - this.wallAtStart.pointsCache[n3][0]) < 0.01f && Math.abs(fArray2[n5][1] - this.wallAtStart.pointsCache[n3][1]) < 0.01f) {
                            fArray2[n5] = this.wallAtStart.pointsCache[n3];
                        }
                        if (this.wallAtStart.pointsCache != null && Math.abs(fArray2[n6][0] - this.wallAtStart.pointsCache[n4][0]) < 0.01f && Math.abs(fArray2[n6][1] - this.wallAtStart.pointsCache[n4][1]) < 0.01f) {
                            fArray2[n6] = this.wallAtStart.pointsCache[n4];
                        }
                    }
                }
            }
            if (this.wallAtEnd != null) {
                fArray = this.wallAtEnd.getUnjoinedShapePoints();
                n4 = 0;
                n3 = fArray.length - 1;
                n2 = fArray.length / 2 - 1;
                n = fArray.length / 2;
                bl2 = this.wallAtEnd.getWallAtStart() == this && (this.wallAtEnd.getWallAtEnd() != this || this.wallAtEnd.xStart == this.xEnd && this.wallAtEnd.yStart == this.yEnd);
                boolean bl4 = bl = this.wallAtEnd.getWallAtEnd() == this && (this.wallAtEnd.getWallAtStart() != this || this.wallAtEnd.xEnd == this.xEnd && this.wallAtEnd.yEnd == this.yEnd);
                if (bl2) {
                    this.computeIntersection(fArray2[n7], fArray2[n7 - 1], fArray[n4], fArray[n4 + 1], f);
                    this.computeIntersection(fArray2[n8], fArray2[n8 + 1], fArray[n3], fArray[n3 - 1], f);
                    if (this.wallAtEnd.pointsCache != null) {
                        if (Math.abs(fArray2[n7][0] - this.wallAtEnd.pointsCache[n4][0]) < 0.01f && Math.abs(fArray2[n7][1] - this.wallAtEnd.pointsCache[n4][1]) < 0.01f) {
                            fArray2[n7] = this.wallAtEnd.pointsCache[n4];
                        }
                        if (Math.abs(fArray2[n8][0] - this.wallAtEnd.pointsCache[n3][0]) < 0.01f && Math.abs(fArray2[n8][1] - this.wallAtEnd.pointsCache[n3][1]) < 0.01f) {
                            fArray2[n8] = this.wallAtEnd.pointsCache[n3];
                        }
                    }
                } else if (bl) {
                    this.computeIntersection(fArray2[n7], fArray2[n7 - 1], fArray[n], fArray[n + 1], f);
                    this.computeIntersection(fArray2[n8], fArray2[n8 + 1], fArray[n2], fArray[n2 - 1], f);
                    if (this.wallAtEnd.pointsCache != null) {
                        if (Math.abs(fArray2[n7][0] - this.wallAtEnd.pointsCache[n][0]) < 0.01f && Math.abs(fArray2[n7][1] - this.wallAtEnd.pointsCache[n][1]) < 0.01f) {
                            fArray2[n7] = this.wallAtEnd.pointsCache[n];
                        }
                        if (Math.abs(fArray2[n8][0] - this.wallAtEnd.pointsCache[n2][0]) < 0.01f && Math.abs(fArray2[n8][1] - this.wallAtEnd.pointsCache[n2][1]) < 0.01f) {
                            fArray2[n8] = this.wallAtEnd.pointsCache[n2];
                        }
                    }
                }
            }
            this.pointsCache = fArray2;
        }
        float[][] fArrayArray = new float[this.pointsCache.length][];
        for (int i = 0; i < this.pointsCache.length; ++i) {
            fArrayArray[i] = (float[])this.pointsCache[i].clone();
        }
        return fArrayArray;
    }

    private float[][] getUnjoinedShapePoints() {
        if (this.arcExtent != null && this.arcExtent.floatValue() != 0.0f && Point2D.distanceSq(this.xStart, this.yStart, this.xEnd, this.yEnd) > 1.0E-10) {
            float[] fArray = this.getArcCircleCenter();
            float f = (float)Math.atan2(fArray[1] - this.yStart, fArray[0] - this.xStart);
            f += 2.0f * (float)Math.atan2(this.yStart - this.yEnd, this.xEnd - this.xStart);
            float f2 = (float)Point2D.distance(fArray[0], fArray[1], this.xStart, this.yStart);
            float f3 = f2 + this.thickness / 2.0f;
            float f4 = Math.max(0.0f, f2 - this.thickness / 2.0f);
            float f5 = f3 * Math.abs(this.arcExtent.floatValue());
            float f6 = this.arcExtent.floatValue() / (float)Math.sqrt(f5);
            int n = (int)(this.arcExtent.floatValue() / f6);
            ArrayList<float[]> arrayList = new ArrayList<float[]>((n + 2) * 2);
            if (this.symmetric) {
                if ((double)Math.abs(this.arcExtent.floatValue() - (float)n * f6) > 1.0E-6) {
                    f6 = this.arcExtent.floatValue() / (float)(++n);
                }
                for (int i = 0; i <= n; ++i) {
                    this.computeRoundWallShapePoint(arrayList, f + this.arcExtent.floatValue() - (float)i * f6, i, f6, fArray, f3, f4);
                }
            } else {
                int n2 = 0;
                float f7 = this.arcExtent.floatValue();
                while (f6 > 0.0f ? f7 >= f6 * 0.1f : f7 <= -f6 * 0.1f) {
                    this.computeRoundWallShapePoint(arrayList, f + f7, n2, f6, fArray, f3, f4);
                    f7 -= f6;
                    ++n2;
                }
                this.computeRoundWallShapePoint(arrayList, f, n2, f6, fArray, f3, f4);
            }
            return (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
        }
        double d = Math.atan2(this.yEnd - this.yStart, this.xEnd - this.xStart);
        float f = (float)Math.sin(d) * this.thickness / 2.0f;
        float f8 = (float)Math.cos(d) * this.thickness / 2.0f;
        return new float[][]{{this.xStart + f, this.yStart - f8}, {this.xEnd + f, this.yEnd - f8}, {this.xEnd - f, this.yEnd + f8}, {this.xStart - f, this.yStart + f8}};
    }

    private void computeRoundWallShapePoint(List<float[]> list, float f, int n, float f2, float[] fArray, float f3, float f4) {
        double d = Math.cos(f);
        double d2 = Math.sin(f);
        float[] fArray2 = new float[]{(float)((double)fArray[0] + (double)f4 * d), (float)((double)fArray[1] - (double)f4 * d2)};
        float[] fArray3 = new float[]{(float)((double)fArray[0] + (double)f3 * d), (float)((double)fArray[1] - (double)f3 * d2)};
        if (f2 > 0.0f) {
            list.add(n, fArray2);
            list.add(list.size() - 1 - n, fArray3);
        } else {
            list.add(n, fArray3);
            list.add(list.size() - 1 - n, fArray2);
        }
    }

    private void computeIntersection(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float f) {
        float f2 = (fArray2[1] - fArray[1]) / (fArray2[0] - fArray[0]);
        float f3 = (fArray4[1] - fArray3[1]) / (fArray4[0] - fArray3[0]);
        if (f2 != f3) {
            float f4 = fArray[0];
            float f5 = fArray[1];
            if (Math.abs(f2) > 4000.0f) {
                if (Math.abs(f3) < 4000.0f) {
                    f4 = fArray[0];
                    float f6 = fArray4[1] - f3 * fArray4[0];
                    f5 = f3 * f4 + f6;
                }
            } else if (Math.abs(f3) > 4000.0f) {
                if (Math.abs(f2) < 4000.0f) {
                    f4 = fArray3[0];
                    float f7 = fArray2[1] - f2 * fArray2[0];
                    f5 = f2 * f4 + f7;
                }
            } else {
                boolean bl;
                boolean bl2 = bl = Math.signum(f2) == Math.signum(f3);
                if (bl && (double)(Math.abs(f2) > Math.abs(f3) ? f2 / f3 : f3 / f2) > 1.004 || !bl && (double)Math.abs(f2 - f3) > 1.0E-5) {
                    float f8 = fArray2[1] - f2 * fArray2[0];
                    float f9 = fArray4[1] - f3 * fArray4[0];
                    f4 = (f9 - f8) / (f2 - f3);
                    f5 = f2 * f4 + f8;
                }
            }
            if (Point2D.distanceSq(f4, f5, fArray[0], fArray[1]) < (double)(f * f)) {
                fArray[0] = f4;
                fArray[1] = f5;
            }
        }
    }

    @Override
    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return this.getShape().intersects(float_);
    }

    @Override
    public boolean containsPoint(float f, float f2, float f3) {
        return this.containsShapeAtWithMargin(this.getShape(), f, f2, f3);
    }

    public boolean containsWallStartAt(float f, float f2, float f3) {
        float[][] fArray = this.getPoints();
        Line2D.Float float_ = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[fArray.length - 1][0], fArray[fArray.length - 1][1]);
        return this.containsShapeAtWithMargin(float_, f, f2, f3);
    }

    public boolean containsWallEndAt(float f, float f2, float f3) {
        float[][] fArray = this.getPoints();
        Line2D.Float float_ = new Line2D.Float(fArray[fArray.length / 2 - 1][0], fArray[fArray.length / 2 - 1][1], fArray[fArray.length / 2][0], fArray[fArray.length / 2][1]);
        return this.containsShapeAtWithMargin(float_, f, f2, f3);
    }

    private boolean containsShapeAtWithMargin(Shape shape, float f, float f2, float f3) {
        if (f3 == 0.0f) {
            return shape.contains(f, f2);
        }
        return shape.intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3);
    }

    private Shape getShape() {
        float[][] fArray = this.getPoints();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    public static List<Wall> clone(List<Wall> list) {
        ArrayList<Wall> arrayList = new ArrayList<Wall>(list.size());
        for (Wall wall : list) {
            arrayList.add(wall.clone());
        }
        for (int i = 0; i < list.size(); ++i) {
            int n;
            Wall wall;
            wall = list.get(i);
            int n2 = list.indexOf(wall.getWallAtStart());
            if (n2 != -1) {
                arrayList.get(i).setWallAtStart(arrayList.get(n2));
            }
            if ((n = list.indexOf(wall.getWallAtEnd())) == -1) continue;
            arrayList.get(i).setWallAtEnd(arrayList.get(n));
        }
        return arrayList;
    }

    @Override
    public void move(float f, float f2) {
        this.setXStart(this.getXStart() + f);
        this.setYStart(this.getYStart() + f2);
        this.setXEnd(this.getXEnd() + f);
        this.setYEnd(this.getYEnd() + f2);
    }

    @Override
    public Wall clone() {
        try {
            Wall wall = (Wall)super.clone();
            wall.propertyChangeSupport = new PropertyChangeSupport(wall);
            wall.wallAtStart = null;
            wall.wallAtEnd = null;
            wall.level = null;
            wall.pointsCache = null;
            return wall;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        X_START,
        Y_START,
        X_END,
        Y_END,
        ARC_EXTENT,
        WALL_AT_START,
        WALL_AT_END,
        THICKNESS,
        HEIGHT,
        HEIGHT_AT_END,
        LEFT_SIDE_COLOR,
        LEFT_SIDE_TEXTURE,
        LEFT_SIDE_SHININESS,
        RIGHT_SIDE_COLOR,
        RIGHT_SIDE_TEXTURE,
        RIGHT_SIDE_SHININESS,
        PATTERN,
        TOP_COLOR,
        LEVEL;

    }
}

