/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.IllegalHomonymException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureCatalog {
    private List<FurnitureCategory> categories = new ArrayList<FurnitureCategory>();
    private boolean sorted;
    private final CollectionChangeSupport<CatalogPieceOfFurniture> furnitureChangeSupport = new CollectionChangeSupport(this);

    public List<FurnitureCategory> getCategories() {
        this.checkCategoriesSorted();
        return Collections.unmodifiableList(this.categories);
    }

    private void checkCategoriesSorted() {
        if (!this.sorted) {
            Collections.sort(this.categories);
            this.sorted = true;
        }
    }

    public int getCategoriesCount() {
        return this.categories.size();
    }

    public FurnitureCategory getCategory(int n) {
        this.checkCategoriesSorted();
        return this.categories.get(n);
    }

    public void addFurnitureListener(CollectionListener<CatalogPieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeFurnitureListener(CollectionListener<CatalogPieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.removeCollectionListener(collectionListener);
    }

    private void add(FurnitureCategory furnitureCategory) {
        if (this.categories.contains(furnitureCategory)) {
            throw new IllegalHomonymException(furnitureCategory.getName() + " already exists in catalog");
        }
        this.categories.add(furnitureCategory);
        this.sorted = false;
    }

    public void add(FurnitureCategory furnitureCategory, CatalogPieceOfFurniture catalogPieceOfFurniture) {
        int n = this.categories.indexOf(furnitureCategory);
        if (n == -1) {
            furnitureCategory = new FurnitureCategory(furnitureCategory.getName());
            this.add(furnitureCategory);
        } else {
            furnitureCategory = this.categories.get(n);
        }
        furnitureCategory.add(catalogPieceOfFurniture);
        this.furnitureChangeSupport.fireCollectionChanged(catalogPieceOfFurniture, furnitureCategory.getIndexOfPieceOfFurniture(catalogPieceOfFurniture), CollectionEvent.Type.ADD);
    }

    public void delete(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        int n;
        FurnitureCategory furnitureCategory = catalogPieceOfFurniture.getCategory();
        if (furnitureCategory != null && (n = furnitureCategory.getIndexOfPieceOfFurniture(catalogPieceOfFurniture)) >= 0) {
            furnitureCategory.delete(catalogPieceOfFurniture);
            if (furnitureCategory.getFurnitureCount() == 0) {
                this.categories = new ArrayList<FurnitureCategory>(this.categories);
                this.categories.remove(furnitureCategory);
            }
            this.furnitureChangeSupport.fireCollectionChanged(catalogPieceOfFurniture, n, CollectionEvent.Type.DELETE);
            return;
        }
        throw new IllegalArgumentException("catalog doesn't contain piece " + catalogPieceOfFurniture.getName());
    }
}

