#include "emu.h"
#include "cpu/m6809/m6809.h"

extern const char layout_pinball[];

class wpc_s_state : public driver_device
{
public:
	wpc_s_state(running_machine &machine, const driver_device_config_base &config)
		: driver_device(machine, config) { }
};


static ADDRESS_MAP_START( wpc_s_map, AS_PROGRAM, 8 )
	AM_RANGE(0x0000, 0xffff) AM_NOP
ADDRESS_MAP_END

static INPUT_PORTS_START( wpc_s )
INPUT_PORTS_END

static MACHINE_RESET( wpc_s )
{
}

static DRIVER_INIT( wpc_s )
{
}

static MACHINE_CONFIG_START( wpc_s, wpc_s_state )
	/* basic machine hardware */
	MCFG_CPU_ADD("maincpu", M6809, 2000000)
	MCFG_CPU_PROGRAM_MAP(wpc_s_map)

	MCFG_MACHINE_RESET( wpc_s )

	/* video hardware */
	MCFG_DEFAULT_LAYOUT(layout_pinball)
MACHINE_CONFIG_END

/*-----------------
/  Corvette
/------------------*/
ROM_START(corv_21)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("corv_2_1.rom", 0x00000, 0x80000, CRC(4fe64c6d) SHA1(f68bca3c216b7b99575fce44bd257325dbcc4f47))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("corvsnd2", 0x000000, 0x080000, CRC(630d20a3) SHA1(c7b6cbc7f23c1f9c149a3ef32e84ca8797ff8026))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("corvsnd3", 0x100000, 0x080000, CRC(6ace0353) SHA1(dec5b6f129ee6b7c0d03c1677d6b71672dd25a5a))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("corvsnd4", 0x200000, 0x080000, CRC(87807278) SHA1(ba01b44c0ad6d10163a8aed2211539d541e69449))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("corvsnd5", 0x300000, 0x080000, CRC(35f82c21) SHA1(ee14489e5629e9cd5622a56849fab65b94ff9b59))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("corvsnd6", 0x400000, 0x080000, CRC(61e56d90) SHA1(41388523fca4839132d3f7e117bdac9ea9f4020c))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("corvsnd7", 0x500000, 0x080000, CRC(1417b547) SHA1(851acf77159a1ef99fc2934353eb887065568004))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(corv_lx1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6-lx1.rom", 0x00000, 0x80000, CRC(0e762e27) SHA1(830d9ccb00a7884e2c6d3bdf7aedac6f58af2397))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("su2-sl1.rom", 0x000000, 0x080000, CRC(141d280e) SHA1(ab1e8e38b9fa0e693837c93616f0821e25b31588))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("corvsnd3", 0x100000, 0x080000, CRC(6ace0353) SHA1(dec5b6f129ee6b7c0d03c1677d6b71672dd25a5a))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("corvsnd4", 0x200000, 0x080000, CRC(87807278) SHA1(ba01b44c0ad6d10163a8aed2211539d541e69449))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("corvsnd5", 0x300000, 0x080000, CRC(35f82c21) SHA1(ee14489e5629e9cd5622a56849fab65b94ff9b59))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("corvsnd6", 0x400000, 0x080000, CRC(61e56d90) SHA1(41388523fca4839132d3f7e117bdac9ea9f4020c))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("corvsnd7", 0x500000, 0x080000, CRC(1417b547) SHA1(851acf77159a1ef99fc2934353eb887065568004))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(corv_px4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6-px4.rom", 0x00000, 0x80000, CRC(a5f22149) SHA1(e0b0bce31b1e66e6b74930c3184f87ebec400f80))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("corvsnd2", 0x000000, 0x080000, CRC(630d20a3) SHA1(c7b6cbc7f23c1f9c149a3ef32e84ca8797ff8026))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("corvsnd3", 0x100000, 0x080000, CRC(6ace0353) SHA1(dec5b6f129ee6b7c0d03c1677d6b71672dd25a5a))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("corvsnd4", 0x200000, 0x080000, CRC(87807278) SHA1(ba01b44c0ad6d10163a8aed2211539d541e69449))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("corvsnd5", 0x300000, 0x080000, CRC(35f82c21) SHA1(ee14489e5629e9cd5622a56849fab65b94ff9b59))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("corvsnd6", 0x400000, 0x080000, CRC(61e56d90) SHA1(41388523fca4839132d3f7e117bdac9ea9f4020c))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("corvsnd7", 0x500000, 0x080000, CRC(1417b547) SHA1(851acf77159a1ef99fc2934353eb887065568004))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END

/*-----------------
/  Dirty Harry
/------------------*/
ROM_START(dh_lx2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("harr_lx2.rom", 0x00000, 0x80000, CRC(d92c2d35) SHA1(68f08120fbc510db46b1fd0e68ec07fe536f77ca))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("dh_snd.u2", 0x000000, 0x080000, CRC(dce5339a) SHA1(c89ec1c2f4f5201cbc40c7038cd1219b200066c7))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dh_snd.u3", 0x100000, 0x080000, CRC(27c30ada) SHA1(388c0e533d1d5c88ae020ef8d8b98db4c603c157))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dh_snd.u4", 0x200000, 0x080000, CRC(8bde0089) SHA1(8efdcc60daef06c65acf5cb805790d2b82d3c091))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dh_snd.u5", 0x300000, 0x080000, CRC(bfacfbdb) SHA1(aa443906a0945586ba5d2910972b333b5d316894))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dh_snd.u6", 0x400000, 0x080000, CRC(793dcfb8) SHA1(c9b35e0511962f9fc372f98e937ee5989109056d))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
ROM_END

/*-----------------
/  Indianapolis 500
/------------------*/
ROM_START(i500_11r)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("indy1_1r.rom", 0x00000, 0x80000, CRC(ec385bf5) SHA1(50d8f3e682e3a59f3df35f099e97858b2fd211ff))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("su2", 0x000000, 0x080000, CRC(d2f9ab24) SHA1(ac96fdce6545d1017fa3ed7567061ae2e0653750))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("su3", 0x100000, 0x080000, CRC(067f4df6) SHA1(0adc116bfebefb17f27718bdd2401c336b07078f))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("su4", 0x200000, 0x080000, CRC(229b96c2) SHA1(77eda81fd011fc818c3fde5e1094cfb3f12372c6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("su5", 0x300000, 0x080000, CRC(f0c006a5) SHA1(ead07bb131bd581c41ab0833f6269de7e574017c))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("su6", 0x400000, 0x080000, CRC(a2b60d31) SHA1(0e0ddb310ec78e0963794994edd0c6bbc4863f4f))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("su7", 0x500000, 0x080000, CRC(94eea5a4) SHA1(afb00e799dbc01c67ed2c4aa399e8a7365ca3dd3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(i500_11b)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("indy1_1b.rom", 0x00000, 0x80000, CRC(76a5de55) SHA1(858d9817b534fed470919fa5957709dd1e4216d8))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("su2", 0x000000, 0x080000, CRC(d2f9ab24) SHA1(ac96fdce6545d1017fa3ed7567061ae2e0653750))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("su3", 0x100000, 0x080000, CRC(067f4df6) SHA1(0adc116bfebefb17f27718bdd2401c336b07078f))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("su4", 0x200000, 0x080000, CRC(229b96c2) SHA1(77eda81fd011fc818c3fde5e1094cfb3f12372c6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("su5", 0x300000, 0x080000, CRC(f0c006a5) SHA1(ead07bb131bd581c41ab0833f6269de7e574017c))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("su6", 0x400000, 0x080000, CRC(a2b60d31) SHA1(0e0ddb310ec78e0963794994edd0c6bbc4863f4f))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("su7", 0x500000, 0x080000, CRC(94eea5a4) SHA1(afb00e799dbc01c67ed2c4aa399e8a7365ca3dd3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END

/*-----------------
/  Jack*Bot
/------------------*/
ROM_START(jb_10r)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jack1_0r.rom", 0x00000, 0x80000, CRC(0e1a900a) SHA1(894f642611d29ce11e13ef9dd68dba7dfc602a3a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("jbsnd_u2.rom", 0x000000, 0x080000, CRC(b116d59f) SHA1(c87c82d7fa4ca40d337fb59476b0b1c90dff86f0))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u3.rom", 0x100000, 0x080000, CRC(76ad3aad) SHA1(012b44c48d1cbb282eb763e40db40b141397f426))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u4.rom", 0x200000, 0x080000, CRC(038b1309) SHA1(a6e337476902ed9ec5123fe4e088a0608c0d5f48))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u5.rom", 0x300000, 0x080000, CRC(0957e2ad) SHA1(0fb4e3fdb949b0979721064162a41cfba84d0013))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u6.rom", 0x400000, 0x080000, CRC(7a1e2c3d) SHA1(0c6ccb937328509cb0a87e4c557a64c13bbed2db))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
ROM_END
ROM_START(jb_10b)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jack1_0b.rom", 0x00000, 0x80000, CRC(da3b2735) SHA1(f895b1548107052f469d8e3fa205bce6113962d9))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("jbsnd_u2.rom", 0x000000, 0x080000, CRC(b116d59f) SHA1(c87c82d7fa4ca40d337fb59476b0b1c90dff86f0))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u3.rom", 0x100000, 0x080000, CRC(76ad3aad) SHA1(012b44c48d1cbb282eb763e40db40b141397f426))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u4.rom", 0x200000, 0x080000, CRC(038b1309) SHA1(a6e337476902ed9ec5123fe4e088a0608c0d5f48))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u5.rom", 0x300000, 0x080000, CRC(0957e2ad) SHA1(0fb4e3fdb949b0979721064162a41cfba84d0013))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("jbsnd_u6.rom", 0x400000, 0x080000, CRC(7a1e2c3d) SHA1(0c6ccb937328509cb0a87e4c557a64c13bbed2db))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
ROM_END

/*-----------------
/  Johnny Mnemonic
/------------------*/
ROM_START(jm_12r)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("john1_2r.rom", 0x00000, 0x80000, CRC(fff07398) SHA1(3b9a51414498ef4c4a9d59ebd35348bca1cc7dfb))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("jm_u2_s.1_0", 0x000000, 0x080000, CRC(4aeeff3d) SHA1(861b65b97715182385e2fe076af1fb2eb2ccc298))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jm_u3_s.1_0", 0x100000, 0x080000, CRC(9bf7bc43) SHA1(94fa83be84940a4db0143acc330aacded1d0d9ca))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("jm_u4_s.1_0", 0x200000, 0x080000, CRC(2e044582) SHA1(0de30f6c223338a67f9332de038baf1398d9043e))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("jm_u5_s.1_0", 0x300000, 0x080000, CRC(50cc06a7) SHA1(fa3072a8bc9be72fe974413094f0944d98cf3857))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("jm_u6_s.1_0", 0x400000, 0x080000, CRC(bfc94707) SHA1(a1f4d35a4b1d80c8160e937458a8e5181f295f28))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("jm_u7_s.1_0", 0x500000, 0x080000, CRC(9d4d9e9d) SHA1(d6e074806eed6fedc169c4849a9dd9ac2beed07e))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("jm_u8_s.1_0", 0x600000, 0x080000, CRC(fc7af6c0) SHA1(a70dadf86d1af2122b58fdd85e938d50d113305f))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END

ROM_START(jm_12b)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("john1_2b.rom", 0x00000, 0x80000, CRC(b039c37e) SHA1(b193a2e08eb47b32cb697bda2d8766fa6b702a8b))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("jm_u2_s.1_0", 0x000000, 0x080000, CRC(4aeeff3d) SHA1(861b65b97715182385e2fe076af1fb2eb2ccc298))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("jm_u3_s.1_0", 0x100000, 0x080000, CRC(9bf7bc43) SHA1(94fa83be84940a4db0143acc330aacded1d0d9ca))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("jm_u4_s.1_0", 0x200000, 0x080000, CRC(2e044582) SHA1(0de30f6c223338a67f9332de038baf1398d9043e))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("jm_u5_s.1_0", 0x300000, 0x080000, CRC(50cc06a7) SHA1(fa3072a8bc9be72fe974413094f0944d98cf3857))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("jm_u6_s.1_0", 0x400000, 0x080000, CRC(bfc94707) SHA1(a1f4d35a4b1d80c8160e937458a8e5181f295f28))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("jm_u7_s.1_0", 0x500000, 0x080000, CRC(9d4d9e9d) SHA1(d6e074806eed6fedc169c4849a9dd9ac2beed07e))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
	ROM_LOAD("jm_u8_s.1_0", 0x600000, 0x080000, CRC(fc7af6c0) SHA1(a70dadf86d1af2122b58fdd85e938d50d113305f))
	ROM_RELOAD(0x600000 +0x080000, 0x080000)
ROM_END
/*-----------------
/  No Fear: Dangerous Sports
/------------------*/
ROM_START(nf_23x)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("nofe2_3x.rom", 0x00000, 0x80000, CRC(d853650b) SHA1(06d58f86c68ccdc242d6b96a22c6226758dc3e44))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("nfu2s", 0x000000, 0x080000, CRC(136caeb9) SHA1(61a56b29a7655e8aab4987d300173e1acf27c77c))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("nfu3s", 0x100000, 0x080000, CRC(983e5578) SHA1(374b1397abbdde5fd9257fd45fd8613c94fbd02d))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("nfu4s", 0x200000, 0x080000, CRC(9469cd40) SHA1(8a1dd1088f24018f48b114c0b27f0331263d4eea))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("nfu5s", 0x300000, 0x080000, CRC(e14d4315) SHA1(63d5ae800cc8a750ea2e3a87c646ab175b60abc7))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("nfu6s", 0x400000, 0x080000, CRC(40a58903) SHA1(78f7e99f39efc83f3cf17801a30e6dc6e4864125))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("nfu7s", 0x500000, 0x080000, CRC(61002bdd) SHA1(e623399ff95f59a4ab7efdd7c69b1a1370479398))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END

ROM_START(nf_23)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("nofe2_3.rom", 0x00000, 0x80000, CRC(47746cbc) SHA1(61606da50894c2f01c64dd5c3aef72cb17a0bc31))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("nfu2s", 0x000000, 0x080000, CRC(136caeb9) SHA1(61a56b29a7655e8aab4987d300173e1acf27c77c))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("nfu3s", 0x100000, 0x080000, CRC(983e5578) SHA1(374b1397abbdde5fd9257fd45fd8613c94fbd02d))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("nfu4s", 0x200000, 0x080000, CRC(9469cd40) SHA1(8a1dd1088f24018f48b114c0b27f0331263d4eea))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("nfu5s", 0x300000, 0x080000, CRC(e14d4315) SHA1(63d5ae800cc8a750ea2e3a87c646ab175b60abc7))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("nfu6s", 0x400000, 0x080000, CRC(40a58903) SHA1(78f7e99f39efc83f3cf17801a30e6dc6e4864125))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("nfu7s", 0x500000, 0x080000, CRC(61002bdd) SHA1(e623399ff95f59a4ab7efdd7c69b1a1370479398))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
ROM_END

ROM_START(nf_23f)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("nofe2_3f.rom", 0x00000, 0x80000, CRC(996e5e75) SHA1(ca3d2c13388e674b26cebf7f9ae65c8a722b68b1))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("nfu2s", 0x000000, 0x080000, CRC(136caeb9) SHA1(61a56b29a7655e8aab4987d300173e1acf27c77c))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("nfu3s", 0x100000, 0x080000, CRC(983e5578) SHA1(374b1397abbdde5fd9257fd45fd8613c94fbd02d))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("nfu4s", 0x200000, 0x080000, CRC(9469cd40) SHA1(8a1dd1088f24018f48b114c0b27f0331263d4eea))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("nfu5s", 0x300000, 0x080000, CRC(e14d4315) SHA1(63d5ae800cc8a750ea2e3a87c646ab175b60abc7))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("nfu6s", 0x400000, 0x080000, CRC(40a58903) SHA1(78f7e99f39efc83f3cf17801a30e6dc6e4864125))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("nfu7s", 0x500000, 0x080000, CRC(61002bdd) SHA1(e623399ff95f59a4ab7efdd7c69b1a1370479398))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
ROM_END

ROM_START(nf_22)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("nofe2_2a.rom", 0x00000, 0x80000, CRC(8694b32e) SHA1(fbdc45910ef5e34c90557491831854de3b4889a8))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("nfu2s", 0x000000, 0x080000, CRC(136caeb9) SHA1(61a56b29a7655e8aab4987d300173e1acf27c77c))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("nfu3s", 0x100000, 0x080000, CRC(983e5578) SHA1(374b1397abbdde5fd9257fd45fd8613c94fbd02d))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("nfu4s", 0x200000, 0x080000, CRC(9469cd40) SHA1(8a1dd1088f24018f48b114c0b27f0331263d4eea))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("nfu5s", 0x300000, 0x080000, CRC(e14d4315) SHA1(63d5ae800cc8a750ea2e3a87c646ab175b60abc7))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("nfu6s", 0x400000, 0x080000, CRC(40a58903) SHA1(78f7e99f39efc83f3cf17801a30e6dc6e4864125))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("nfu7s", 0x500000, 0x080000, CRC(61002bdd) SHA1(e623399ff95f59a4ab7efdd7c69b1a1370479398))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
ROM_END

ROM_START(nf_20)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("nofe2_0a.rom", 0x00000, 0x80000, CRC(dceee809) SHA1(44aaeeb268d67eb48087bd8958f864d4c4ee5138))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("nfu2s", 0x000000, 0x080000, CRC(136caeb9) SHA1(61a56b29a7655e8aab4987d300173e1acf27c77c))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("nfu3s", 0x100000, 0x080000, CRC(983e5578) SHA1(374b1397abbdde5fd9257fd45fd8613c94fbd02d))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("nfu4s", 0x200000, 0x080000, CRC(9469cd40) SHA1(8a1dd1088f24018f48b114c0b27f0331263d4eea))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("nfu5s", 0x300000, 0x080000, CRC(e14d4315) SHA1(63d5ae800cc8a750ea2e3a87c646ab175b60abc7))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("nfu6s", 0x400000, 0x080000, CRC(40a58903) SHA1(78f7e99f39efc83f3cf17801a30e6dc6e4864125))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("nfu7s", 0x500000, 0x080000, CRC(61002bdd) SHA1(e623399ff95f59a4ab7efdd7c69b1a1370479398))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
ROM_END

/*-----------------
/  Red and Ted's Road Show
/------------------*/
ROM_START(rs_l6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("rshw_l6.rom", 0x00000, 0x80000, CRC(3986d402) SHA1(1a67e5bafb7a6aa1d42b2e631e2294a3c1403038))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("rs_u2_s.l1", 0x000000, 0x080000, CRC(5a2db20c) SHA1(34ce236cc874b820db2d2268cc77815ed7ca061b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("rs_u3_s.l1", 0x100000, 0x080000, CRC(719be036) SHA1(fa975a6a93fcaefddcbd1c0b97c49bd9f9608ad4))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("rs_u4_s.l1", 0x200000, 0x080000, CRC(d452d007) SHA1(b850bc8e17d8940f93c1e7b6a0ab786b092694b3))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("rs_u5_s.l1", 0x300000, 0x080000, CRC(1faa04c9) SHA1(817bbd7fc0781d84af6c40cb477adf83cef07ab2))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("rs_u6_s.l1", 0x400000, 0x080000, CRC(eee00add) SHA1(96d664ca73ac896e918d7011c1cda3e55e3731b7))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("rs_u7_s.l1", 0x500000, 0x080000, CRC(3a222a54) SHA1(2a788e4ac573bf1d128e5bef9357e62c805014b9))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("rs_u8_s.l1", 0x600000, 0x080000, CRC(c70f2210) SHA1(9be9f271d81d15a4eb123f1377b0c077eef97774))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(rs_la5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6_la5.rom", 0x00000, 0x80000, CRC(61e63268) SHA1(79e32f489c51e7e79e892d36f586af14ab9aa2a5))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("rs_u2_s.l1", 0x000000, 0x080000, CRC(5a2db20c) SHA1(34ce236cc874b820db2d2268cc77815ed7ca061b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("rs_u3_s.l1", 0x100000, 0x080000, CRC(719be036) SHA1(fa975a6a93fcaefddcbd1c0b97c49bd9f9608ad4))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("rs_u4_s.l1", 0x200000, 0x080000, CRC(d452d007) SHA1(b850bc8e17d8940f93c1e7b6a0ab786b092694b3))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("rs_u5_s.l1", 0x300000, 0x080000, CRC(1faa04c9) SHA1(817bbd7fc0781d84af6c40cb477adf83cef07ab2))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("rs_u6_s.l1", 0x400000, 0x080000, CRC(eee00add) SHA1(96d664ca73ac896e918d7011c1cda3e55e3731b7))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("rs_u7_s.l1", 0x500000, 0x080000, CRC(3a222a54) SHA1(2a788e4ac573bf1d128e5bef9357e62c805014b9))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("rs_u8_s.l1", 0x600000, 0x080000, CRC(c70f2210) SHA1(9be9f271d81d15a4eb123f1377b0c077eef97774))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(rs_lx5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6_lx5.rom", 0x00000, 0x80000, CRC(a2de6ee3) SHA1(90fea1100d5f79c885e693d713b9a113d43131bb))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("rs_u2_s.l1", 0x000000, 0x080000, CRC(5a2db20c) SHA1(34ce236cc874b820db2d2268cc77815ed7ca061b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("rs_u3_s.l1", 0x100000, 0x080000, CRC(719be036) SHA1(fa975a6a93fcaefddcbd1c0b97c49bd9f9608ad4))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("rs_u4_s.l1", 0x200000, 0x080000, CRC(d452d007) SHA1(b850bc8e17d8940f93c1e7b6a0ab786b092694b3))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("rs_u5_s.l1", 0x300000, 0x080000, CRC(1faa04c9) SHA1(817bbd7fc0781d84af6c40cb477adf83cef07ab2))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("rs_u6_s.l1", 0x400000, 0x080000, CRC(eee00add) SHA1(96d664ca73ac896e918d7011c1cda3e55e3731b7))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("rs_u7_s.l1", 0x500000, 0x080000, CRC(3a222a54) SHA1(2a788e4ac573bf1d128e5bef9357e62c805014b9))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("rs_u8_s.l1", 0x600000, 0x080000, CRC(c70f2210) SHA1(9be9f271d81d15a4eb123f1377b0c077eef97774))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(rs_la4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6_la4.rom", 0x00000, 0x80000, CRC(d957a038) SHA1(bd78b62eda2046a72eaaee2fff973fe3589f7d88))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("rs_u2_s.l1", 0x000000, 0x080000, CRC(5a2db20c) SHA1(34ce236cc874b820db2d2268cc77815ed7ca061b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("rs_u3_s.l1", 0x100000, 0x080000, CRC(719be036) SHA1(fa975a6a93fcaefddcbd1c0b97c49bd9f9608ad4))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("rs_u4_s.l1", 0x200000, 0x080000, CRC(d452d007) SHA1(b850bc8e17d8940f93c1e7b6a0ab786b092694b3))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("rs_u5_s.l1", 0x300000, 0x080000, CRC(1faa04c9) SHA1(817bbd7fc0781d84af6c40cb477adf83cef07ab2))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("rs_u6_s.l1", 0x400000, 0x080000, CRC(eee00add) SHA1(96d664ca73ac896e918d7011c1cda3e55e3731b7))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("rs_u7_s.l1", 0x500000, 0x080000, CRC(3a222a54) SHA1(2a788e4ac573bf1d128e5bef9357e62c805014b9))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("rs_u8_s.l1", 0x600000, 0x080000, CRC(c70f2210) SHA1(9be9f271d81d15a4eb123f1377b0c077eef97774))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(rs_lx4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("rshw_lx4.rom", 0x00000, 0x80000, CRC(866f16a5) SHA1(09180ca87b1b4a9f8f81d81fc2d08092f357205a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("rs_u2_s.l1", 0x000000, 0x080000, CRC(5a2db20c) SHA1(34ce236cc874b820db2d2268cc77815ed7ca061b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("rs_u3_s.l1", 0x100000, 0x080000, CRC(719be036) SHA1(fa975a6a93fcaefddcbd1c0b97c49bd9f9608ad4))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("rs_u4_s.l1", 0x200000, 0x080000, CRC(d452d007) SHA1(b850bc8e17d8940f93c1e7b6a0ab786b092694b3))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("rs_u5_s.l1", 0x300000, 0x080000, CRC(1faa04c9) SHA1(817bbd7fc0781d84af6c40cb477adf83cef07ab2))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("rs_u6_s.l1", 0x400000, 0x080000, CRC(eee00add) SHA1(96d664ca73ac896e918d7011c1cda3e55e3731b7))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("rs_u7_s.l1", 0x500000, 0x080000, CRC(3a222a54) SHA1(2a788e4ac573bf1d128e5bef9357e62c805014b9))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("rs_u8_s.l1", 0x600000, 0x080000, CRC(c70f2210) SHA1(9be9f271d81d15a4eb123f1377b0c077eef97774))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(rs_lx3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6-lx3.rom", 0x00000, 0x80000, CRC(5df17d02) SHA1(94b262c91f906d68d2a6ee9432042a202bf04d35))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("rs_u2_s.l1", 0x000000, 0x080000, CRC(5a2db20c) SHA1(34ce236cc874b820db2d2268cc77815ed7ca061b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("rs_u3_s.l1", 0x100000, 0x080000, CRC(719be036) SHA1(fa975a6a93fcaefddcbd1c0b97c49bd9f9608ad4))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("rs_u4_s.l1", 0x200000, 0x080000, CRC(d452d007) SHA1(b850bc8e17d8940f93c1e7b6a0ab786b092694b3))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("rs_u5_s.l1", 0x300000, 0x080000, CRC(1faa04c9) SHA1(817bbd7fc0781d84af6c40cb477adf83cef07ab2))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("rs_u6_s.l1", 0x400000, 0x080000, CRC(eee00add) SHA1(96d664ca73ac896e918d7011c1cda3e55e3731b7))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("rs_u7_s.l1", 0x500000, 0x080000, CRC(3a222a54) SHA1(2a788e4ac573bf1d128e5bef9357e62c805014b9))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("rs_u8_s.l1", 0x600000, 0x080000, CRC(c70f2210) SHA1(9be9f271d81d15a4eb123f1377b0c077eef97774))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(rs_lx2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("rshw_lx2.rom", 0x00000, 0x80000, CRC(317210d0) SHA1(38adcf9c72552bd371b096080b172c63d0f843d3))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("rs_u2_s.l1", 0x000000, 0x080000, CRC(5a2db20c) SHA1(34ce236cc874b820db2d2268cc77815ed7ca061b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("rs_u3_s.l1", 0x100000, 0x080000, CRC(719be036) SHA1(fa975a6a93fcaefddcbd1c0b97c49bd9f9608ad4))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("rs_u4_s.l1", 0x200000, 0x080000, CRC(d452d007) SHA1(b850bc8e17d8940f93c1e7b6a0ab786b092694b3))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("rs_u5_s.l1", 0x300000, 0x080000, CRC(1faa04c9) SHA1(817bbd7fc0781d84af6c40cb477adf83cef07ab2))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("rs_u6_s.l1", 0x400000, 0x080000, CRC(eee00add) SHA1(96d664ca73ac896e918d7011c1cda3e55e3731b7))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("rs_u7_s.l1", 0x500000, 0x080000, CRC(3a222a54) SHA1(2a788e4ac573bf1d128e5bef9357e62c805014b9))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("rs_u8_s.l1", 0x600000, 0x080000, CRC(c70f2210) SHA1(9be9f271d81d15a4eb123f1377b0c077eef97774))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END

/*-----------------
/  The Flintstones
/------------------*/
ROM_START(fs_lx5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("flin_lx5.rom", 0x00000, 0x80000, CRC(06707244) SHA1(d86d4564fb27a81e8ab896e2efaf05f4f4a4a152))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("fs_u2_s.l1", 0x000000, 0x080000, CRC(aa3da768) SHA1(b9ab9d716f03c3fa4dc7352993477c021a07138a))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fs_u3_s.l1", 0x100000, 0x080000, CRC(e8a0b2d1) SHA1(5fd7ff4a194f845db53573a1a44efbfffed292f9))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("fs_u4_s.l1", 0x200000, 0x080000, CRC(a5de69f4) SHA1(a7e7f35964ec8b40a971920c2c6cf2ecb730bc60))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("fs_u5_s.l1", 0x300000, 0x080000, CRC(74b4d495) SHA1(98a145c07694db7b56f5c6ba84bc631fb5c18bae))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("fs_u6_s.l1", 0x400000, 0x080000, CRC(3c7f7a04) SHA1(45e017dc36922ad2ff420724f912e109a75a15a3))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("fs_u7_s.l1", 0x500000, 0x080000, CRC(f32b9271) SHA1(19308cb54ae6fc6343ab7411546b251ba66b0905))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("fs_u8_s.l1", 0x600000, 0x080000, CRC(a7aafa3e) SHA1(54dca32dc2bec5432cd3664bb5aa45d367560b96))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("fs_u9_s.l1", 0x700000, 0x080000, CRC(0a6664fb) SHA1(751a726e3ea6a808bb137f3563d54acd1580836d))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END
ROM_START(fs_lx2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("flin_lx2.rom", 0x00000, 0x80000, CRC(cbab53cd) SHA1(e58ac50326f7acae4d732c2db92e86dd8162e760))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("fs_u2_s.l1", 0x000000, 0x080000, CRC(aa3da768) SHA1(b9ab9d716f03c3fa4dc7352993477c021a07138a))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fs_u3_s.l1", 0x100000, 0x080000, CRC(e8a0b2d1) SHA1(5fd7ff4a194f845db53573a1a44efbfffed292f9))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("fs_u4_s.l1", 0x200000, 0x080000, CRC(a5de69f4) SHA1(a7e7f35964ec8b40a971920c2c6cf2ecb730bc60))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("fs_u5_s.l1", 0x300000, 0x080000, CRC(74b4d495) SHA1(98a145c07694db7b56f5c6ba84bc631fb5c18bae))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("fs_u6_s.l1", 0x400000, 0x080000, CRC(3c7f7a04) SHA1(45e017dc36922ad2ff420724f912e109a75a15a3))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("fs_u7_s.l1", 0x500000, 0x080000, CRC(f32b9271) SHA1(19308cb54ae6fc6343ab7411546b251ba66b0905))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("fs_u8_s.l1", 0x600000, 0x080000, CRC(a7aafa3e) SHA1(54dca32dc2bec5432cd3664bb5aa45d367560b96))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("fs_u9_s.l1", 0x700000, 0x080000, CRC(0a6664fb) SHA1(751a726e3ea6a808bb137f3563d54acd1580836d))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END
ROM_START(fs_sp2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("flin_lx5.rom", 0x00000, 0x80000, CRC(06707244) SHA1(d86d4564fb27a81e8ab896e2efaf05f4f4a4a152))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("su2-sp2.rom", 0x000000, 0x080000, CRC(8c627583) SHA1(ddbd5bd06ee83b126025b487d94998da9106ff3f))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fs_u3_s.l1", 0x100000, 0x080000, CRC(e8a0b2d1) SHA1(5fd7ff4a194f845db53573a1a44efbfffed292f9))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("fs_u4_s.l1", 0x200000, 0x080000, CRC(a5de69f4) SHA1(a7e7f35964ec8b40a971920c2c6cf2ecb730bc60))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("fs_u5_s.l1", 0x300000, 0x080000, CRC(74b4d495) SHA1(98a145c07694db7b56f5c6ba84bc631fb5c18bae))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("fs_u6_s.l1", 0x400000, 0x080000, CRC(3c7f7a04) SHA1(45e017dc36922ad2ff420724f912e109a75a15a3))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("fs_u7_s.l1", 0x500000, 0x080000, CRC(f32b9271) SHA1(19308cb54ae6fc6343ab7411546b251ba66b0905))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("fs_u8_s.l1", 0x600000, 0x080000, CRC(a7aafa3e) SHA1(54dca32dc2bec5432cd3664bb5aa45d367560b96))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("fs_u9_s.l1", 0x700000, 0x080000, CRC(0a6664fb) SHA1(751a726e3ea6a808bb137f3563d54acd1580836d))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END
ROM_START(fs_lx4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("flin_lx4.rom", 0x00000, 0x80000, CRC(fca5634c) SHA1(8d713c0ba94cfc446fef823d45e268bccb5c6fcc))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("fs_u2_s.l1", 0x000000, 0x080000, CRC(aa3da768) SHA1(b9ab9d716f03c3fa4dc7352993477c021a07138a))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fs_u3_s.l1", 0x100000, 0x080000, CRC(e8a0b2d1) SHA1(5fd7ff4a194f845db53573a1a44efbfffed292f9))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("fs_u4_s.l1", 0x200000, 0x080000, CRC(a5de69f4) SHA1(a7e7f35964ec8b40a971920c2c6cf2ecb730bc60))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("fs_u5_s.l1", 0x300000, 0x080000, CRC(74b4d495) SHA1(98a145c07694db7b56f5c6ba84bc631fb5c18bae))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("fs_u6_s.l1", 0x400000, 0x080000, CRC(3c7f7a04) SHA1(45e017dc36922ad2ff420724f912e109a75a15a3))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("fs_u7_s.l1", 0x500000, 0x080000, CRC(f32b9271) SHA1(19308cb54ae6fc6343ab7411546b251ba66b0905))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("fs_u8_s.l1", 0x600000, 0x080000, CRC(a7aafa3e) SHA1(54dca32dc2bec5432cd3664bb5aa45d367560b96))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("fs_u9_s.l1", 0x700000, 0x080000, CRC(0a6664fb) SHA1(751a726e3ea6a808bb137f3563d54acd1580836d))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END

/*-------------
/ The Pinball Circus
/--------------*/

/*-----------------
/  The Shadow
/------------------*/
ROM_START(ts_lh6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("shad_h6.rom", 0x00000, 0x080000, CRC(0a72268d) SHA1(97836afc23c4160bca462f14c115b17e58fe5a48))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ts_u2_s.l1", 0x000000, 0x080000, CRC(f1486cfb) SHA1(a916917cb4e46b5d1e04eb4dd52b4193e48d4da8))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(ts_la2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("cpu-u6l2.rom", 0x00000, 0x080000, CRC(e4cff76a) SHA1(37c01f8c6e88186f3b88808bbfee75005ca4008d))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ts_u2_s.l1", 0x000000, 0x080000, CRC(f1486cfb) SHA1(a916917cb4e46b5d1e04eb4dd52b4193e48d4da8))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(ts_la4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("u6-la4.rom", 0x00000, 0x080000, CRC(5915cf6d) SHA1(1957988c51b791f76130b8960e9ee61ce17b2088))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ts_u2_s.l1", 0x000000, 0x080000, CRC(f1486cfb) SHA1(a916917cb4e46b5d1e04eb4dd52b4193e48d4da8))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(ts_lx4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("u6-lx4.rom", 0x00000, 0x080000, CRC(1d908d38) SHA1(9dbc770ea7b22e27439399f92d81f736a12ddf9f))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ts_u2_s.l1", 0x000000, 0x080000, CRC(f1486cfb) SHA1(a916917cb4e46b5d1e04eb4dd52b4193e48d4da8))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(ts_lx5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("shad_x5.rom", 0x00000, 0x080000, CRC(bb545f83) SHA1(c2851f7169ca3d28399468967c04e69835f61536))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ts_u2_s.l1", 0x000000, 0x080000, CRC(f1486cfb) SHA1(a916917cb4e46b5d1e04eb4dd52b4193e48d4da8))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(ts_pa1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("cpu-u6p1.rom", 0x00000, 0x080000, CRC(835b8167) SHA1(70c00dbe7a7c1a188ef9fe303558e248fdf7230a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("su2-sp2.rom", 0x000000, 0x080000, CRC(ba17f74b) SHA1(9c1f00ea27986d025bcaa6b2ffe8c7c4d2216893))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(ts_lf6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("u6-lf6.rom", 0x00000, 0x080000, CRC(a1692f1a) SHA1(9df2ecd991a08c661cc22f91dfc6c3dfffcfc3e5))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ts_u2_s.l1", 0x000000, 0x080000, CRC(f1486cfb) SHA1(a916917cb4e46b5d1e04eb4dd52b4193e48d4da8))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
ROM_END
ROM_START(ts_lm6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("u6-lm6.rom", 0x00000, 0x080000, CRC(56f15859) SHA1(1fd4d64cff8413903474843dbcfcca3d59b33cd8))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ts_u2_s.l1", 0x000000, 0x080000, CRC(f1486cfb) SHA1(a916917cb4e46b5d1e04eb4dd52b4193e48d4da8))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("ts_u3_s.l1", 0x100000, 0x080000, CRC(b9e39c3f) SHA1(183730dcaa84f8b83b6d26521e90fdb0fc558b4c))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("ts_u4_s.l1", 0x200000, 0x080000, CRC(a1d1ab66) SHA1(5380f347cb3970bac4aab5917a51d2d64fbca541))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("ts_u5_s.l1", 0x300000, 0x080000, CRC(ab8cf435) SHA1(86d7f9eca3e49e184700a0ac0f672349fc1241bb))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("ts_u6_s.l1", 0x400000, 0x080000, CRC(63b8d2db) SHA1(a662a3280a377ac91fdf55d98d2204e024668706))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("ts_u7_s.l1", 0x500000, 0x080000, CRC(62b5db14) SHA1(13832c8573623f9d541de8b814aa10cfb527be99))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
ROM_END

/*-----------------
/  Theatre Of Magic
/------------------*/
ROM_START(tom_14h)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("1_40h.u6", 0x00000, 0x80000, CRC(4181db9b) SHA1(027ada8518207d5a841ec3cc8c7842c7b3841f70))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("tm_u2_s.l2", 0x000000, 0x080000, CRC(b128fbba) SHA1(59101f9f4f43c240630dfbdc7fb432a9939f122d))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("tm_u3_s.l2", 0x100000, 0x080000, CRC(128c7d3c) SHA1(1bd5b56d3f9c8485498746ae6c4d65a1e053161a))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("tm_u4_s.l2", 0x200000, 0x080000, CRC(3d9b2354) SHA1(a39917c0cceda33288594652c47fd0385a85b8b1))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("tm_u5_s.l2", 0x300000, 0x080000, CRC(44247b60) SHA1(519b9d6eab4fe05676382c5f99ea87d4f7a12c5e))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("tm_u6_s.l2", 0x400000, 0x080000, CRC(f366bbe5) SHA1(aca23649a54521748e90aa9a182b9bbdde126409))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("tm_u7_s.l2", 0x500000, 0x080000, CRC(f98e9e38) SHA1(bf8c204cfbbf5f9d59b7ad03d1784d37c638712c))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(tom_13)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("tom1_3x.rom", 0x00000, 0x80000, CRC(aff4d14c) SHA1(9896f3034bb7a59c9e241d16bf231fefc0ae1fd0))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("tm_u2_s.l2", 0x000000, 0x080000, CRC(b128fbba) SHA1(59101f9f4f43c240630dfbdc7fb432a9939f122d))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("tm_u3_s.l2", 0x100000, 0x080000, CRC(128c7d3c) SHA1(1bd5b56d3f9c8485498746ae6c4d65a1e053161a))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("tm_u4_s.l2", 0x200000, 0x080000, CRC(3d9b2354) SHA1(a39917c0cceda33288594652c47fd0385a85b8b1))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("tm_u5_s.l2", 0x300000, 0x080000, CRC(44247b60) SHA1(519b9d6eab4fe05676382c5f99ea87d4f7a12c5e))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("tm_u6_s.l2", 0x400000, 0x080000, CRC(f366bbe5) SHA1(aca23649a54521748e90aa9a182b9bbdde126409))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("tm_u7_s.l2", 0x500000, 0x080000, CRC(f98e9e38) SHA1(bf8c204cfbbf5f9d59b7ad03d1784d37c638712c))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(tom_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("tom1_2x.rom", 0x00000, 0x80000, CRC(bd8dd884) SHA1(2cb74ae5082d8ceaf89b8ef4df86f78cb5ba6463))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("tm_u2_s.l2", 0x000000, 0x080000, CRC(b128fbba) SHA1(59101f9f4f43c240630dfbdc7fb432a9939f122d))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("tm_u3_s.l2", 0x100000, 0x080000, CRC(128c7d3c) SHA1(1bd5b56d3f9c8485498746ae6c4d65a1e053161a))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("tm_u4_s.l2", 0x200000, 0x080000, CRC(3d9b2354) SHA1(a39917c0cceda33288594652c47fd0385a85b8b1))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("tm_u5_s.l2", 0x300000, 0x080000, CRC(44247b60) SHA1(519b9d6eab4fe05676382c5f99ea87d4f7a12c5e))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("tm_u6_s.l2", 0x400000, 0x080000, CRC(f366bbe5) SHA1(aca23649a54521748e90aa9a182b9bbdde126409))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("tm_u7_s.l2", 0x500000, 0x080000, CRC(f98e9e38) SHA1(bf8c204cfbbf5f9d59b7ad03d1784d37c638712c))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(tom_06)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6-06a.rom", 0x00000, 0x80000, CRC(dc1d6681) SHA1(7e60e9fd6e953e3c2899ae2fb2900982f078a4ba))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("tm_u2_s.l2", 0x000000, 0x080000, CRC(b128fbba) SHA1(59101f9f4f43c240630dfbdc7fb432a9939f122d))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("tm_u3_s.l2", 0x100000, 0x080000, CRC(128c7d3c) SHA1(1bd5b56d3f9c8485498746ae6c4d65a1e053161a))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("tm_u4_s.l2", 0x200000, 0x080000, CRC(3d9b2354) SHA1(a39917c0cceda33288594652c47fd0385a85b8b1))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("tm_u5_s.l2", 0x300000, 0x080000, CRC(44247b60) SHA1(519b9d6eab4fe05676382c5f99ea87d4f7a12c5e))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("tm_u6_s.l2", 0x400000, 0x080000, CRC(f366bbe5) SHA1(aca23649a54521748e90aa9a182b9bbdde126409))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("tm_u7_s.l2", 0x500000, 0x080000, CRC(f98e9e38) SHA1(bf8c204cfbbf5f9d59b7ad03d1784d37c638712c))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END

/*-----------------
/  Who Dunnit
/------------------*/
ROM_START(wd_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("whod1_2.rom", 0x00000, 0x80000, CRC(d49be363) SHA1(a265110170e1debf4a566d91c12e0e4c93838d08))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("wdu2_10.rom", 0x000000, 0x080000, CRC(2fd534be) SHA1(9fcbcfb9bc6fc410398413dea71a6fcbe69f761f))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wdu3_10.rom", 0x100000, 0x080000, CRC(be9b312f) SHA1(53038a8a264da4e62455240f2016309462c28275))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wdu4_10.rom", 0x200000, 0x080000, CRC(46965682) SHA1(b12c21a17090480c0960aec808908f2d37c4b498))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wdu5_10.rom", 0x300000, 0x080000, CRC(0a787015) SHA1(e01a19ac0a1b674e2b348d77e584275ef1359cd7))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wdu6_10.rom", 0x400000, 0x080000, CRC(d2e05659) SHA1(3f926dac710adadc38afd70618a84c9f049ebfd0))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wdu7_10.rom", 0x500000, 0x080000, CRC(36285ca2) SHA1(d42f04aa62b9859ce2452fa05da2049fe39e9411))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(wd_12g)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("whod1_2.rom", 0x00000, 0x80000, CRC(d49be363) SHA1(a265110170e1debf4a566d91c12e0e4c93838d08))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("wdu2_20g.rom", 0x000000, 0x080000, CRC(2fe0ce7e) SHA1(ae148809b8f8925376bc6b6b0478176cae490a2b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wdu3_20g.rom", 0x100000, 0x080000, CRC(f01142ab) SHA1(ee2620b6238df0069c9b10d1fee3ea0607b022da))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wdu4_10.rom", 0x200000, 0x080000, CRC(46965682) SHA1(b12c21a17090480c0960aec808908f2d37c4b498))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wdu5_10.rom", 0x300000, 0x080000, CRC(0a787015) SHA1(e01a19ac0a1b674e2b348d77e584275ef1359cd7))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wdu6_10.rom", 0x400000, 0x080000, CRC(d2e05659) SHA1(3f926dac710adadc38afd70618a84c9f049ebfd0))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wdu7_10.rom", 0x500000, 0x080000, CRC(36285ca2) SHA1(d42f04aa62b9859ce2452fa05da2049fe39e9411))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(wd_10r)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("whod1_0.rom", 0x00000, 0x80000, CRC(85c29cfe) SHA1(5156d3699f16ac366c063149113ec78232ba787b))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("wdu2_10.rom", 0x000000, 0x080000, CRC(2fd534be) SHA1(9fcbcfb9bc6fc410398413dea71a6fcbe69f761f))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wdu3_10.rom", 0x100000, 0x080000, CRC(be9b312f) SHA1(53038a8a264da4e62455240f2016309462c28275))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wdu4_10.rom", 0x200000, 0x080000, CRC(46965682) SHA1(b12c21a17090480c0960aec808908f2d37c4b498))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wdu5_10.rom", 0x300000, 0x080000, CRC(0a787015) SHA1(e01a19ac0a1b674e2b348d77e584275ef1359cd7))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wdu6_10.rom", 0x400000, 0x080000, CRC(d2e05659) SHA1(3f926dac710adadc38afd70618a84c9f049ebfd0))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wdu7_10.rom", 0x500000, 0x080000, CRC(36285ca2) SHA1(d42f04aa62b9859ce2452fa05da2049fe39e9411))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(wd_11)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("whod1_1.rom", 0x00000, 0x80000, CRC(85cab586) SHA1(3940bff8dfa240f8c0ed96c96f58ab66effbdea5))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("wdu2_10.rom", 0x000000, 0x080000, CRC(2fd534be) SHA1(9fcbcfb9bc6fc410398413dea71a6fcbe69f761f))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wdu3_10.rom", 0x100000, 0x080000, CRC(be9b312f) SHA1(53038a8a264da4e62455240f2016309462c28275))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wdu4_10.rom", 0x200000, 0x080000, CRC(46965682) SHA1(b12c21a17090480c0960aec808908f2d37c4b498))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wdu5_10.rom", 0x300000, 0x080000, CRC(0a787015) SHA1(e01a19ac0a1b674e2b348d77e584275ef1359cd7))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wdu6_10.rom", 0x400000, 0x080000, CRC(d2e05659) SHA1(3f926dac710adadc38afd70618a84c9f049ebfd0))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wdu7_10.rom", 0x500000, 0x080000, CRC(36285ca2) SHA1(d42f04aa62b9859ce2452fa05da2049fe39e9411))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(wd_10f)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6_10f.rom", 0x00000, 0x80000, CRC(86ca3749) SHA1(fa011a39c260f9c3fd8c6f5d18f803f6f0bfe7a0))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("wdu2_10.rom", 0x000000, 0x080000, CRC(2fd534be) SHA1(9fcbcfb9bc6fc410398413dea71a6fcbe69f761f))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wdu3_10.rom", 0x100000, 0x080000, CRC(be9b312f) SHA1(53038a8a264da4e62455240f2016309462c28275))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wdu4_10.rom", 0x200000, 0x080000, CRC(46965682) SHA1(b12c21a17090480c0960aec808908f2d37c4b498))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wdu5_10.rom", 0x300000, 0x080000, CRC(0a787015) SHA1(e01a19ac0a1b674e2b348d77e584275ef1359cd7))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wdu6_10.rom", 0x400000, 0x080000, CRC(d2e05659) SHA1(3f926dac710adadc38afd70618a84c9f049ebfd0))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wdu7_10.rom", 0x500000, 0x080000, CRC(36285ca2) SHA1(d42f04aa62b9859ce2452fa05da2049fe39e9411))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(wd_10g)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6_10g.rom", 0x00000, 0x80000, CRC(fbc17e3f) SHA1(7d9a8c7dda06bb4353517417fdc65d87b6c94167))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("wdu2_20g.rom", 0x000000, 0x080000, CRC(2fe0ce7e) SHA1(ae148809b8f8925376bc6b6b0478176cae490a2b))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wdu3_20g.rom", 0x100000, 0x080000, CRC(f01142ab) SHA1(ee2620b6238df0069c9b10d1fee3ea0607b022da))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wdu4_10.rom", 0x200000, 0x080000, CRC(46965682) SHA1(b12c21a17090480c0960aec808908f2d37c4b498))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wdu5_10.rom", 0x300000, 0x080000, CRC(0a787015) SHA1(e01a19ac0a1b674e2b348d77e584275ef1359cd7))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wdu6_10.rom", 0x400000, 0x080000, CRC(d2e05659) SHA1(3f926dac710adadc38afd70618a84c9f049ebfd0))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wdu7_10.rom", 0x500000, 0x080000, CRC(36285ca2) SHA1(d42f04aa62b9859ce2452fa05da2049fe39e9411))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(wd_03r)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6_03r.rom", 0x00000, 0x80000, CRC(8901868a) SHA1(35d8173865208a08a819275b4d76db3f050f61f1))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("u2-s031.rom", 0x000000, 0x080000, CRC(a265cd93) SHA1(2cebb00119f8fc2022959be2107669c9b4b65bfb))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("u3-s031.rom", 0x100000, 0x080000, CRC(16105ac9) SHA1(7b40cc9a30dd4f675fda979f41a22364aa9ea452))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("u4-s031.rom", 0x200000, 0x080000, CRC(07d52ef3) SHA1(4bd7dd97316c7244b556b4bd0a8475e282abaa25))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("u5-s031.rom", 0x300000, 0x080000, CRC(14fea24c) SHA1(a63e2a7796b89d5a6bca419ceaa14888ae22b7a6))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("u6-s031.rom", 0x400000, 0x080000, CRC(d15d073e) SHA1(063412a51de3b6c2bdbde0c3f84132d70c935fb4))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("u7-s031.rom", 0x500000, 0x080000, CRC(d252f599) SHA1(bdce67187c027b713b6ef88f6cd4f025de469929))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(wd_048r)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("wd_048r.rom", 0x00000, 0x80000, CRC(45653baa) SHA1(788d5195e61605e151796f5fff9ca8d00820c7a3))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("u2-s031.rom", 0x000000, 0x080000, CRC(a265cd93) SHA1(2cebb00119f8fc2022959be2107669c9b4b65bfb))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("u3-s031.rom", 0x100000, 0x080000, CRC(16105ac9) SHA1(7b40cc9a30dd4f675fda979f41a22364aa9ea452))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("u4-s031.rom", 0x200000, 0x080000, CRC(07d52ef3) SHA1(4bd7dd97316c7244b556b4bd0a8475e282abaa25))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("u5-s031.rom", 0x300000, 0x080000, CRC(14fea24c) SHA1(a63e2a7796b89d5a6bca419ceaa14888ae22b7a6))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("u6-s031.rom", 0x400000, 0x080000, CRC(d15d073e) SHA1(063412a51de3b6c2bdbde0c3f84132d70c935fb4))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("u7-s031.rom", 0x500000, 0x080000, CRC(d252f599) SHA1(bdce67187c027b713b6ef88f6cd4f025de469929))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END

/*--------------
/  World Cup Soccer
/---------------*/
ROM_START(wcs_l2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("wcup_lx2.rom", 0x00000, 0x80000, CRC(0e4514e8) SHA1(4ef8b78777b8caf1a1ab8f63383c8a7a74d5189a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("wcup_u2.rom", 0x000000, 0x080000, CRC(92252f28) SHA1(962a58ea910bcb90c82c81456a888d45f23fcd9a))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wcup_u3.rom", 0x100000, 0x080000, CRC(83f541ad) SHA1(2d81d89e43f350caba60d5bec8a66560f8556ad8))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wcup_u4.rom", 0x200000, 0x080000, CRC(1540c505) SHA1(aca5a421a0fd067f5411fae2fc3c7c3bcfa1b12f))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wcup_u5.rom", 0x300000, 0x080000, CRC(bddad8d4) SHA1(ae6bb1ca3d97a56d1ba984060a1c1ef6c7a00159))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wcup_u6.rom", 0x400000, 0x080000, CRC(00f46c12) SHA1(64e99eb32908dbb7b90ee8fa92a20aacf800aeac))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wcup_u7.rom", 0x500000, 0x080000, CRC(fff01703) SHA1(fb8d7212fe562e9933941b7bfc707aed1eb74e79))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("wcup_u8.rom", 0x600000, 0x080000, CRC(670cd382) SHA1(89548420c3b6b8a3d7621b10c538ee1dc6a7be62))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(wcs_p3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("wcup_px3.rom", 0x00000, 0x80000, CRC(617ea2bc) SHA1(f8e025b62d509126fb4ba425ac4a025dcf13ad99))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("wcup_u2.rom", 0x000000, 0x080000, CRC(92252f28) SHA1(962a58ea910bcb90c82c81456a888d45f23fcd9a))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wcup_u3.rom", 0x100000, 0x080000, CRC(83f541ad) SHA1(2d81d89e43f350caba60d5bec8a66560f8556ad8))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wcup_u4.rom", 0x200000, 0x080000, CRC(1540c505) SHA1(aca5a421a0fd067f5411fae2fc3c7c3bcfa1b12f))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wcup_u5.rom", 0x300000, 0x080000, CRC(bddad8d4) SHA1(ae6bb1ca3d97a56d1ba984060a1c1ef6c7a00159))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wcup_u6.rom", 0x400000, 0x080000, CRC(00f46c12) SHA1(64e99eb32908dbb7b90ee8fa92a20aacf800aeac))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wcup_u7.rom", 0x500000, 0x080000, CRC(fff01703) SHA1(fb8d7212fe562e9933941b7bfc707aed1eb74e79))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("wcup_u8.rom", 0x600000, 0x080000, CRC(670cd382) SHA1(89548420c3b6b8a3d7621b10c538ee1dc6a7be62))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(wcs_p2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6-pa2.rom", 0x00000, 0x80000, CRC(8fcb11b3) SHA1(b8549db3dc096b8b3f684bee35bf5dea3d966957))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("wcup_u2.rom", 0x000000, 0x080000, CRC(92252f28) SHA1(962a58ea910bcb90c82c81456a888d45f23fcd9a))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("wcup_u3.rom", 0x100000, 0x080000, CRC(83f541ad) SHA1(2d81d89e43f350caba60d5bec8a66560f8556ad8))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("wcup_u4.rom", 0x200000, 0x080000, CRC(1540c505) SHA1(aca5a421a0fd067f5411fae2fc3c7c3bcfa1b12f))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("wcup_u5.rom", 0x300000, 0x080000, CRC(bddad8d4) SHA1(ae6bb1ca3d97a56d1ba984060a1c1ef6c7a00159))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("wcup_u6.rom", 0x400000, 0x080000, CRC(00f46c12) SHA1(64e99eb32908dbb7b90ee8fa92a20aacf800aeac))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("wcup_u7.rom", 0x500000, 0x080000, CRC(fff01703) SHA1(fb8d7212fe562e9933941b7bfc707aed1eb74e79))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("wcup_u8.rom", 0x600000, 0x080000, CRC(670cd382) SHA1(89548420c3b6b8a3d7621b10c538ee1dc6a7be62))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END

/*--------------
/ Test Fixture Security generation
/---------------*/
ROM_START(tfs_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6_12.rom", 0x00000, 0x80000, CRC(12687d19) SHA1(bcc3116328a8c6f0ed430a6d2343d01fcdf2459f))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("u2_10.rom", 0x000000, 0x080000, CRC(d705b41e) SHA1(a7811b4bb1b2b5f7e3d1a809da3363b97dfca680))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
ROM_END

GAME(1994,	corv_21,	0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Corvette (2.1)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	corv_px4,	corv_21,	wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Corvette (PX4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	corv_lx1,	corv_21,	wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Corvette (LX1)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	dh_lx2,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Dirty Harry (LX-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	i500_11r,	0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Indianapolis 500 (1.1R)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	i500_11b,	i500_11r,	wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Indianapolis 500 (1.1 Belgium)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	jb_10r,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Jack*Bot (1.0R)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	jb_10b,		jb_10r,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Jack*Bot (1.0B) (Belgium/Canada)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	jm_12r,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Johnny Mnemonic (1.2R)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	jm_12b,		jm_12r,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Johnny Mnemonic (1.2B) Belgium",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	nf_23x,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"No Fear: Dangerous Sports (2.3X)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	nf_23,		nf_23x,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"No Fear: Dangerous Sports (2.3)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	nf_23f,		nf_23x,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"No Fear: Dangerous Sports (2.3F)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	nf_22,		nf_23x,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"No Fear: Dangerous Sports (2.2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	nf_20,		nf_23x,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"No Fear: Dangerous Sports (2.0)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	rs_l6,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Red and Ted's Road Show (L-6)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	rs_la5,		rs_l6,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Red and Ted's Road Show (La-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	rs_lx5,		rs_l6,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Red and Ted's Road Show (Lx-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	rs_la4,		rs_l6,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Red and Ted's Road Show (La-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	rs_lx4,		rs_l6,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Red and Ted's Road Show (Lx-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	rs_lx3,		rs_l6,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Red and Ted's Road Show (Lx-3)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	rs_lx2,		rs_l6,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"Red and Ted's Road Show (Lx-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	fs_lx5,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"The Flintstones (LX-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	fs_lx2,		fs_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"The Flintstones (LX-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	fs_sp2,		fs_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"The Flintstones (SP-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	fs_lx4,		fs_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Williams",				"The Flintstones (LX-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	ts_lx5,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (LX-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	ts_lh6,		ts_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (LH-6)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	ts_lx4,		ts_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (LX-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	ts_la4,		ts_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (LA-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	ts_la2,		ts_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (LA-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	ts_pa1,		ts_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (PA-1)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	ts_lf6,		ts_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (LF-6) French",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	ts_lm6,		ts_lx5,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"The Shadow (LM-6) Mild",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	tom_13,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Theatre Of Magic (1.3X)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(2005,	tom_14h,	tom_13,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Theatre Of Magic (1.4H)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	tom_12,		tom_13,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Theatre Of Magic (1.2X)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	tom_06,		tom_13,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Theatre Of Magic (0.6a)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_12,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (1.2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_12g,		wd_12,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (1.2 Germany)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_11,		wd_12,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (1.1)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_10r,		wd_12,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (1.0 R)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_10g,		wd_12,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (1.0 Germany)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_10f,		wd_12,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (1.0 French)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_03r,		wd_12,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (0.3 R)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	wd_048r,	wd_12,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"Who Dunnit (0.48 R)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	wcs_l2,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"World Cup Soccer (Lx-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	wcs_p2,		wcs_l2,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"World Cup Soccer (Pa-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	wcs_p3,		wcs_l2,		wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"World Cup Soccer (Px-3)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	tfs_12,		0,			wpc_s,	wpc_s,	wpc_s,	ROT0,	"Bally",				"WPC Test Fixture: Security (1.2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
