/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.impl.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import org.jboss.ejb3.embedded.impl.base.JBossEmbeddedContainerStartupParams;
import org.jboss.logging.Logger;

public abstract class JBossEJBContainerProviderBase
implements EJBContainerProvider {
    private static final Logger log = Logger.getLogger(JBossEJBContainerProviderBase.class);

    public EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        String providerProp = "javax.ejb.embeddable.provider";
        Object requestedImplClassValue = properties.get("javax.ejb.embeddable.provider");
        if (requestedImplClassValue != null) {
            if (!(requestedImplClassValue instanceof String)) {
                log.warn((Object)("Obtained propety \"javax.ejb.embeddable.provider\" should be the String FQN of a provider, instead got: " + requestedImplClassValue + ".  Ignoring."));
            }
            String requestedImplClassFqn = (String)requestedImplClassValue;
            if (!this.getClass().getName().equals(requestedImplClassFqn)) {
                log.warn((Object)("Got explicit requested provider \"" + requestedImplClassFqn + "\", so returning null from this provider: " + this));
                return null;
            }
        }
        try {
            Object o;
            String[] modules = null;
            if (properties != null && (o = properties.get("javax.ejb.embeddable.modules")) != null) {
                if (o instanceof String) {
                    modules = new String[]{(String)o};
                } else if (o instanceof Collection) {
                    modules = JBossEJBContainerProviderBase.toStringArray(o);
                } else {
                    throw new EJBException("Illegal type of javax.ejb.embeddable.modules (" + o.getClass().getName() + ") (EJB 3.1 22.2.2.2)");
                }
            }
            JBossEmbeddedContainerStartupParams params = new JBossEmbeddedContainerStartupParams(properties, modules);
            return this.createEJBContainer(params);
        }
        catch (Throwable t) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Exception) {
                throw new EJBException((Exception)t);
            }
            throw new RuntimeException(t);
        }
    }

    private static final String[] toStringArray(Object o) {
        return ((Collection)o).toArray(new String[0]);
    }

    public abstract EJBContainer createEJBContainer(JBossEmbeddedContainerStartupParams var1);
}

