/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Arrays;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class RpcDispatcherUnitTest
extends ChannelTestBase {
    private RpcDispatcher d1;
    private RpcDispatcher d2;
    private RpcDispatcher d3;
    private JChannel c1;
    private JChannel c2;
    private JChannel c3;
    private ServerObject o1;
    private ServerObject o2;
    private ServerObject o3;
    private Address a1;
    private Address a2;
    private Address a3;
    private List<Address> members;

    @BeforeClass
    protected void setUp() throws Exception {
        this.o1 = new ServerObject();
        this.o2 = new ServerObject();
        this.o3 = new ServerObject();
        this.c1 = this.createChannel(true, 3);
        this.c1.setName("A");
        String GROUP = "RpcDispatcherUnitTest";
        this.d1 = new RpcDispatcher((Channel)this.c1, null, null, this.o1);
        this.c1.connect("RpcDispatcherUnitTest");
        this.c2 = this.createChannel(this.c1);
        this.c2.setName("B");
        this.d2 = new RpcDispatcher((Channel)this.c2, null, null, this.o2);
        this.c2.connect("RpcDispatcherUnitTest");
        this.c3 = this.createChannel(this.c1);
        this.c3.setName("C");
        this.d3 = new RpcDispatcher((Channel)this.c3, null, null, this.o3);
        this.c3.connect("RpcDispatcherUnitTest");
        System.out.println("c1.view=" + this.c1.getView() + "\nc2.view=" + this.c2.getView() + "\nc3.view=" + this.c3.getView());
        View view = this.c3.getView();
        assert (view.size() == 3) : "view=" + view;
        this.a1 = this.c1.getAddress();
        this.a2 = this.c2.getAddress();
        this.a3 = this.c3.getAddress();
        this.members = Arrays.asList(this.a1, this.a2, this.a3);
    }

    @BeforeMethod
    protected void reset() {
        this.o1.reset();
        this.o2.reset();
        this.o3.reset();
    }

    @AfterClass
    protected void tearDown() throws Exception {
        this.d3.stop();
        this.d2.stop();
        this.d1.stop();
        Util.close(this.c3, this.c2, this.c1);
    }

    public void testInvocationOnEntireGroup() {
        RspList rsps = this.d1.callRemoteMethods(null, "foo", null, null, RequestOptions.SYNC);
        System.out.println("rsps:\n" + rsps);
        assert (rsps.size() == 3);
        assert (this.o1.wasCalled() && this.o2.wasCalled() && this.o3.wasCalled());
    }

    public void testInvocationOnEntireGroupWithTargetList() {
        RspList rsps = this.d1.callRemoteMethods(this.members, "foo", null, null, RequestOptions.SYNC);
        System.out.println("rsps:\n" + rsps);
        assert (rsps.size() == 3);
        assert (this.o1.wasCalled() && this.o2.wasCalled() && this.o3.wasCalled());
    }

    public void testInvocationWithExclusionOfSelf() {
        RequestOptions options = new RequestOptions(2, 5000L).setExclusionList(this.a1);
        RspList rsps = this.d1.callRemoteMethods(null, "foo", null, null, options);
        Util.sleep(500L);
        System.out.println("rsps:\n" + rsps);
        assert (rsps.size() == 2);
        assert (rsps.containsKey(this.a2) && rsps.containsKey(this.a3));
        assert (!this.o1.wasCalled() && this.o2.wasCalled() && this.o3.wasCalled());
    }

    public void testInvocationWithExclusionOfTwo() {
        RequestOptions options = new RequestOptions(2, 5000L).setExclusionList(this.a2, this.a3);
        RspList rsps = this.d1.callRemoteMethods(null, "foo", null, null, options);
        Util.sleep(500L);
        System.out.println("rsps:\n" + rsps);
        assert (rsps.size() == 1);
        assert (rsps.containsKey(this.a1));
        assert (this.o1.wasCalled() && !this.o2.wasCalled() && !this.o3.wasCalled());
    }

    public void testInvocationOnEmptyTargetSet() {
        RequestOptions options = new RequestOptions(2, 5000L).setExclusionList(this.a1, this.a2, this.a3);
        RspList rsps = this.d1.callRemoteMethods(null, "foo", null, null, options);
        Util.sleep(500L);
        System.out.println("rsps:\n" + rsps);
        assert (rsps.isEmpty());
        assert (!(this.o1.wasCalled() || this.o2.wasCalled() || this.o3.wasCalled()));
    }

    private static class ServerObject {
        boolean called = false;

        private ServerObject() {
        }

        public boolean wasCalled() {
            return this.called;
        }

        public void reset() {
            this.called = false;
        }

        public boolean foo() {
            this.called = true;
            return this.called;
        }
    }
}

