/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.Exclude;
import org.jboss.aspects.security.Permissions;
import org.jboss.aspects.security.SecurityActions;
import org.jboss.aspects.security.Unchecked;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleBasedAuthorizationInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    protected AuthenticationManager authenticationManager;
    protected AuthorizationManager authorizationManager;
    protected RealmMapping realmMapping;

    @Deprecated
    public RoleBasedAuthorizationInterceptor(AuthenticationManager manager, RealmMapping realmMapping) {
        this.authenticationManager = manager;
        this.realmMapping = realmMapping;
    }

    public RoleBasedAuthorizationInterceptor(AuthenticationManager authManager, AuthorizationManager authzManager) {
        this.authenticationManager = authManager;
        this.authorizationManager = authzManager;
    }

    public String getName() {
        return "RoleBasedAuthorizationInterceptor";
    }

    protected Set<Principal> getRoleSet(Invocation invocation) {
        Set<Principal> roles = (Set<Principal>)invocation.getMetaData((Object)"security", (Object)"roles");
        if (roles == null) {
            roles = this.getAnnotationRoleSet(invocation);
        }
        return roles;
    }

    protected Set<Principal> getAnnotationRoleSet(Invocation invocation) {
        HashSet<Principal> set = new HashSet<Principal>();
        Exclude exclude = (Exclude)invocation.resolveAnnotation(Exclude.class);
        if (exclude != null) {
            set.add((Principal)NobodyPrincipal.NOBODY_PRINCIPAL);
            return set;
        }
        Unchecked unchecked = (Unchecked)invocation.resolveAnnotation(Unchecked.class);
        if (unchecked != null) {
            set.add((Principal)AnybodyPrincipal.ANYBODY_PRINCIPAL);
            return set;
        }
        Permissions permissions = (Permissions)invocation.resolveAnnotation(Permissions.class);
        if (permissions == null) {
            set.add((Principal)AnybodyPrincipal.ANYBODY_PRINCIPAL);
            return set;
        }
        for (int i = 0; i < permissions.value().length; ++i) {
            set.add((Principal)new SimplePrincipal(permissions.value()[i]));
        }
        return set;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.authenticationManager == null) {
            return invocation.invokeNext();
        }
        if (this.authorizationManager == null && this.realmMapping == null) {
            throw new SecurityException("Authorization manager has not been set");
        }
        Set<Principal> roles = this.getRoleSet(invocation);
        if (roles == null) {
            String message = "No method permissions assigned.";
            this.log.error((Object)message);
            throw new SecurityException(message);
        }
        RunAs callerRunAsIdentity = SecurityActions.peekRunAsIdentity();
        if (!roles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
            if (callerRunAsIdentity == null) {
                boolean hasRole;
                Principal principal = SecurityActions.getPrincipal();
                boolean bl = hasRole = this.authorizationManager != null ? this.authorizationManager.doesUserHaveRole(principal, roles) : this.realmMapping.doesUserHaveRole(principal, roles);
                if (!hasRole) {
                    Set userRoles = this.authorizationManager != null ? this.authorizationManager.getUserRoles(principal) : this.realmMapping.getUserRoles(principal);
                    String msg = "Insufficient permissions, principal=" + principal + ", requiredRoles=" + roles + ", principalRoles=" + userRoles;
                    this.log.error((Object)msg);
                    throw new SecurityException(msg);
                }
            } else if (callerRunAsIdentity instanceof RunAsIdentity) {
                RunAsIdentity rai = (RunAsIdentity)callerRunAsIdentity;
                if (!rai.doesUserHaveRole(roles)) {
                    String msg = "Insufficient permissions, runAsPrincipal=" + rai.getName() + ", requiredRoles=" + roles + ", runAsRoles=" + rai.getRunAsRoles();
                    this.log.error((Object)msg);
                    throw new SecurityException(msg);
                }
            } else {
                throw new RuntimeException("Unknown RunAs type");
            }
        }
        return invocation.invokeNext();
    }
}

