/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx2.impl;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.tx2.impl.BMTInterceptor;
import org.jboss.ejb3.tx2.impl.util.StatusHelper;
import org.jboss.ejb3.tx2.spi.StatefulContext;
import org.jboss.ejb3.tx2.spi.TransactionalInvocationContext;
import org.jboss.logging.Logger;

public class StatefulBMTInterceptor
extends BMTInterceptor {
    private static final Logger log = Logger.getLogger(StatefulBMTInterceptor.class);

    protected StatefulBMTInterceptor(TransactionManager tm) {
        super(tm);
    }

    private void checkBadStateful(String ejbName) {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception ex) {
                    log.error((Object)"Failed to rollback", (Throwable)ex);
                }
                String msg = "BMT stateful bean '" + ejbName + "' did not complete user transaction properly status=" + StatusHelper.statusAsString(status);
                log.error((Object)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleInvocation(TransactionalInvocationContext invocation) throws Exception {
        assert (this.tm.getTransaction() == null) : "can't handle BMT transaction, there is a transaction active";
        StatefulContext ctx = (StatefulContext)invocation.getEJBContext();
        String ejbName = ctx.getManager().toString();
        Transaction tx = ctx.getTransaction();
        if (tx != null) {
            ctx.setTransaction(null);
            this.tm.resume(tx);
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.checkBadStateful(ejbName);
            Transaction newTx = this.tm.getTransaction();
            if (newTx != null) {
                ctx.setTransaction(newTx);
                this.tm.suspend();
            } else {
                ctx.setTransaction(null);
            }
        }
    }
}

