/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.clustered.local.ContentMetadataPersister;
import org.jboss.system.server.profileservice.repository.clustered.local.LocalContentManager;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.NoOpSynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.RemovalMetadataInsertionAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationId;
import org.jboss.system.server.profileservice.repository.clustered.sync.TwoPhaseCommitAction;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocalContentManager<T extends SynchronizationActionContext>
implements LocalContentManager<T> {
    private final Logger log = Logger.getLogger(this.getClass());
    private RepositoryContentMetadata officialContentMetadata;
    private RepositoryContentMetadata currentContentMetadata;
    private final Map<String, URI> namedURIMap;
    private final Map<String, VirtualFile> vfCache = new ConcurrentHashMap<String, VirtualFile>();
    private Map<String, Closeable> mounts = new ConcurrentHashMap<String, Closeable>();
    private final ProfileKey profileKey;
    private final String storeName;
    private final String localNodeName;
    private final ContentMetadataPersister contentMetadataPersister;
    private List<TwoPhaseCommitAction<T>> currentSynchronizationActions;
    private T currentSynchronizationActionContext;
    private Map<RepositoryItemMetadata, InputStream> pendingStreams = new ConcurrentHashMap<RepositoryItemMetadata, InputStream>();

    protected static String createStoreName(ProfileKey key) {
        if ("default".equals(key.getDomain()) && "default".equals(key.getServer())) {
            return key.getName();
        }
        StringBuilder sb = new StringBuilder();
        if (!"default".equals(key.getDomain())) {
            sb.append(key.getDomain());
            sb.append('-');
        }
        if (!"default".equals(key.getServer())) {
            sb.append(key.getServer());
            sb.append('-');
        }
        sb.append(key.getName());
        return sb.toString();
    }

    protected AbstractLocalContentManager(Map<String, URI> rootMap, ProfileKey profileKey, String localNodeName, ContentMetadataPersister contentMetadataPersister) {
        if (rootMap == null) {
            throw new IllegalArgumentException("Null rootMap");
        }
        if (profileKey == null) {
            throw new IllegalArgumentException("Null profileKey");
        }
        if (localNodeName == null) {
            throw new IllegalArgumentException("Null localNodeName");
        }
        if (contentMetadataPersister == null) {
            throw new IllegalArgumentException("Null contentMetadataPersister");
        }
        this.namedURIMap = rootMap;
        this.profileKey = profileKey;
        this.storeName = AbstractLocalContentManager.createStoreName(profileKey);
        this.localNodeName = localNodeName;
        this.contentMetadataPersister = contentMetadataPersister;
        this.officialContentMetadata = this.contentMetadataPersister.load(this.storeName);
    }

    public String getLocalNodeName() {
        return this.localNodeName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    @Override
    public void initialize() {
        String profileName = this.profileKey.getName();
        VirtualFile backupRoot = VFS.getChild((String)"/profileservice/originals/");
        for (Map.Entry<String, URI> entry : this.namedURIMap.entrySet()) {
            VirtualFile backup = backupRoot.getChild(profileName).getChild("roots").getChild(entry.getKey());
            Closeable closeable = this.mountRepositoryRoot(entry.getValue(), backup);
            this.vfCache.put(entry.getKey(), backup);
            this.mounts.put(entry.getKey(), closeable);
        }
    }

    @Override
    public void shutdown() {
        Iterator<Map.Entry<String, Closeable>> it = this.mounts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Closeable> entry = it.next();
            this.vfCache.remove(entry.getKey());
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                this.log.error((Object)("Problem clearing repository root VFS mount for root " + entry.getKey()), (Throwable)e);
            }
            it.remove();
        }
    }

    @Override
    public RepositoryContentMetadata getOfficialContentMetadata() {
        return this.officialContentMetadata;
    }

    @Override
    public RepositoryContentMetadata createEmptyContentMetadata() {
        RepositoryContentMetadata md = new RepositoryContentMetadata(this.profileKey);
        ArrayList<RepositoryRootMetadata> roots = new ArrayList<RepositoryRootMetadata>();
        for (String rootName : this.vfCache.keySet()) {
            RepositoryRootMetadata rmd = new RepositoryRootMetadata();
            rmd.setName(rootName);
            roots.add(rmd);
        }
        md.setRepositories(roots);
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryContentMetadata getCurrentContentMetadata() throws IOException {
        AbstractLocalContentManager abstractLocalContentManager = this;
        synchronized (abstractLocalContentManager) {
            RepositoryContentMetadata md = new RepositoryContentMetadata(this.profileKey);
            ArrayList<RepositoryRootMetadata> roots = new ArrayList<RepositoryRootMetadata>();
            RepositoryContentMetadata official = this.getOfficialContentMetadata();
            for (Map.Entry<String, VirtualFile> entry : this.vfCache.entrySet()) {
                RepositoryRootMetadata rmd = new RepositoryRootMetadata();
                rmd.setName(entry.getKey());
                RepositoryRootMetadata existingRmd = official == null ? null : official.getRepositoryRootMetadata(entry.getKey());
                VirtualFile root = entry.getValue();
                if (AbstractLocalContentManager.isDirectory(root)) {
                    for (VirtualFile child : root.getChildren()) {
                        this.createItemMetadataFromScan(rmd, existingRmd, child, root);
                    }
                } else {
                    this.createItemMetadataFromScan(rmd, existingRmd, root, root);
                }
                roots.add(rmd);
            }
            md.setRepositories(roots);
            RepositoryContentMetadata existing = this.getOfficialContentMetadata();
            if (existing != null) {
                for (RepositoryRootMetadata existingRoot : existing.getRepositories()) {
                    RepositoryRootMetadata rmd = md.getRepositoryRootMetadata(existingRoot.getName());
                    if (rmd == null) continue;
                    Collection<RepositoryItemMetadata> rimds = rmd.getContent();
                    for (RepositoryItemMetadata existingItem : existingRoot.getContent()) {
                        if (!existingItem.isRemoved() || rmd.getItemMetadata(existingItem.getRelativePathElements()) != null) continue;
                        rimds.add(new RepositoryItemMetadata(existingItem));
                    }
                }
            }
            this.currentContentMetadata = md;
            return this.currentContentMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends SynchronizationAction<T>> initiateSynchronization(SynchronizationId<?> id, List<ContentModification> modifications, RepositoryContentMetadata toInstall, boolean localLed) {
        if (id == null) {
            throw new IllegalArgumentException("Null id");
        }
        if (modifications == null) {
            throw new IllegalArgumentException("Null modifications");
        }
        if (toInstall == null) {
            throw new IllegalArgumentException("Null toInstall");
        }
        AbstractLocalContentManager abstractLocalContentManager = this;
        synchronized (abstractLocalContentManager) {
            if (this.currentSynchronizationActionContext != null) {
                throw new IllegalStateException("Synchronization " + ((SynchronizationActionContext)this.currentSynchronizationActionContext).getId() + " is already in progress");
            }
            this.currentSynchronizationActionContext = this.createSynchronizationActionContext(id, toInstall);
        }
        ArrayList<TwoPhaseCommitAction<T>> actions = new ArrayList<TwoPhaseCommitAction<T>>();
        for (ContentModification mod : modifications) {
            TwoPhaseCommitAction<T> action = null;
            switch (mod.getType()) {
                case PULL_FROM_CLUSTER: {
                    action = this.createPullFromClusterAction(mod, localLed);
                    break;
                }
                case PUSH_TO_CLUSTER: {
                    InputStream stream = this.pendingStreams.remove(mod.getItem());
                    if (stream == null) {
                        action = this.createPushToClusterAction(mod, localLed);
                        break;
                    }
                    action = this.createPushStreamToClusterAction(mod, stream);
                    break;
                }
                case REMOVE_FROM_CLUSTER: {
                    action = this.createRemoveFromClusterAction(mod, localLed);
                    break;
                }
                case REMOVE_TO_CLUSTER: {
                    action = this.createRemoveToClusterAction(mod, localLed);
                    break;
                }
                case PREPARE_RMDIR_FROM_CLUSTER: {
                    action = this.createPrepareRmdirFromClusterAction(mod, localLed);
                    break;
                }
                case PREPARE_RMDIR_TO_CLUSTER: {
                    action = this.createPrepareRmdirToClusterAction(mod, localLed);
                    break;
                }
                case DIR_TIMESTAMP_MISMATCH: {
                    action = this.createDirectoryTimestampMismatchAction(mod, localLed);
                    break;
                }
                case MKDIR_FROM_CLUSTER: {
                    action = this.createMkdirFromClusterAction(mod, localLed);
                    break;
                }
                case MKDIR_TO_CLUSTER: {
                    action = this.createMkdirToClusterAction(mod, localLed);
                    break;
                }
                case REMOVAL_METADATA_FROM_CLUSTER: {
                    action = this.createRemovalMetadataAction(mod, localLed);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown " + ContentModification.Type.class.getSimpleName() + " " + (Object)((Object)mod.getType()));
                }
            }
            actions.add(action);
        }
        this.currentSynchronizationActions = actions;
        return Collections.unmodifiableList(actions);
    }

    @Override
    public boolean prepareSynchronization(SynchronizationId<?> id) {
        this.validateSynchronization(id);
        for (TwoPhaseCommitAction<T> action : this.currentSynchronizationActions) {
            if (action.prepare()) continue;
            if (this.log.isTraceEnabled()) {
                ContentModification mod = action.getRepositoryContentModification();
                this.log.trace((Object)("prepare failed for " + (Object)((Object)mod.getType()) + " " + mod.getItem().getRelativePath()));
            }
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("prepared synchronization " + id));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSynchronization(SynchronizationId<?> id) {
        this.validateSynchronization(id);
        for (TwoPhaseCommitAction<T> action : this.currentSynchronizationActions) {
            action.commit();
        }
        this.updateContentMetadata(((SynchronizationActionContext)this.currentSynchronizationActionContext).getInProgressMetadata());
        AbstractLocalContentManager abstractLocalContentManager = this;
        synchronized (abstractLocalContentManager) {
            this.currentSynchronizationActions = null;
            this.currentSynchronizationActionContext = null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("committed synchronization " + id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackSynchronization(SynchronizationId<?> id) {
        this.validateSynchronization(id);
        for (TwoPhaseCommitAction<T> action : this.currentSynchronizationActions) {
            action.rollback();
        }
        AbstractLocalContentManager abstractLocalContentManager = this;
        synchronized (abstractLocalContentManager) {
            this.currentSynchronizationActionContext = null;
            this.currentSynchronizationActions = null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("rolled back synchronization " + id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installCurrentContentMetadata() {
        AbstractLocalContentManager abstractLocalContentManager = this;
        synchronized (abstractLocalContentManager) {
            if (this.currentContentMetadata == null) {
                throw new IllegalStateException("No currentContentMetadata");
            }
            if (this.currentSynchronizationActionContext != null) {
                throw new IllegalStateException("Cannot install currentContentMetadata; cluster synchronization " + ((SynchronizationActionContext)this.currentSynchronizationActionContext).getId() + " is in progress");
            }
            this.updateContentMetadata(this.currentContentMetadata);
        }
    }

    @Override
    public RepositoryItemMetadata getItemForAddition(String vfsPath) throws IOException {
        RepositoryItemMetadata item = new RepositoryItemMetadata();
        item.setRelativePath(vfsPath);
        List<String> pathElements = item.getRelativePathElements();
        String rootName = null;
        Collection<RepositoryRootMetadata> roots = this.getOfficialContentMetadata().getRepositories();
        for (RepositoryRootMetadata rmd : roots) {
            if (rmd.getItemMetadata(pathElements) == null) continue;
            rootName = rmd.getName();
            break;
        }
        if (rootName == null) {
            for (RepositoryRootMetadata rmd : roots) {
                VirtualFile vf = this.vfCache.get(rmd.getName());
                if (!AbstractLocalContentManager.isDirectory(vf)) continue;
                rootName = rmd.getName();
                break;
            }
        }
        if (rootName == null) {
            throw new IllegalStateException("No roots can accept children");
        }
        item.setRootName(rootName);
        return item;
    }

    @Override
    public RepositoryContentMetadata getContentMetadataForAdd(RepositoryItemMetadata toAdd, InputStream contentIS) throws IOException {
        RepositoryContentMetadata result = new RepositoryContentMetadata(this.getOfficialContentMetadata());
        RepositoryRootMetadata rmd = result.getRepositoryRootMetadata(toAdd.getRootName());
        if (rmd == null) {
            throw new IllegalArgumentException("Unknown root name " + toAdd.getRootName());
        }
        RepositoryItemMetadata remove = rmd.getItemMetadata(toAdd.getRelativePathElements());
        if (remove != null) {
            Collection<RepositoryItemMetadata> content = rmd.getContent();
            if (remove.isDirectory()) {
                Iterator<RepositoryItemMetadata> it = content.iterator();
                while (it.hasNext()) {
                    if (!it.next().isChildOf(remove)) continue;
                    it.remove();
                }
            }
            content.remove(remove);
        }
        rmd.getContent().add(toAdd);
        this.pendingStreams.put(toAdd, contentIS);
        return result;
    }

    @Override
    public VirtualFile getVirtualFileForItem(RepositoryItemMetadata item) throws IOException {
        VirtualFile vf = this.vfCache.get(item.getRootName());
        VirtualFile parent = null;
        List<String> path = item.getRelativePathElements();
        Iterator<String> i$ = path.iterator();
        while (i$.hasNext()) {
            parent = vf;
            String element = i$.next();
            if ((vf = parent.getChild(element)) != null) continue;
            throw new IllegalStateException("No child " + element + " under " + parent);
        }
        return vf;
    }

    @Override
    public RepositoryContentMetadata getContentMetadataForRemove(String repositoryRoot, String relativePath) throws IOException {
        RepositoryContentMetadata cmd = new RepositoryContentMetadata(this.getOfficialContentMetadata());
        RepositoryRootMetadata root = cmd.getRepositoryRootMetadata(repositoryRoot);
        if (root == null) {
            throw new IllegalArgumentException(repositoryRoot + " is not a child of any known roots");
        }
        RepositoryItemMetadata remove = root.getItemMetadata(RepositoryItemMetadata.getPathElements(relativePath));
        if (remove != null) {
            Collection<RepositoryItemMetadata> items = root.getContent();
            if (remove.isDirectory()) {
                Iterator<RepositoryItemMetadata> it = items.iterator();
                while (it.hasNext()) {
                    if (!it.next().isChildOf(remove)) continue;
                    it.remove();
                }
            }
            items.remove(remove);
        }
        return cmd;
    }

    protected abstract Closeable mountRepositoryRoot(URI var1, VirtualFile var2);

    protected abstract T createSynchronizationActionContext(SynchronizationId<?> var1, RepositoryContentMetadata var2);

    protected abstract TwoPhaseCommitAction<T> createPullFromClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createPushToClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createPushStreamToClusterAction(ContentModification var1, InputStream var2);

    protected abstract TwoPhaseCommitAction<T> createRemoveFromClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createRemoveToClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createPrepareRmdirToClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createPrepareRmdirFromClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createMkdirToClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createMkdirFromClusterAction(ContentModification var1, boolean var2);

    protected abstract TwoPhaseCommitAction<T> createDirectoryTimestampMismatchAction(ContentModification var1, boolean var2);

    protected T getSynchronizationActionContext() {
        return this.currentSynchronizationActionContext;
    }

    protected Map<String, VirtualFile> getRootVirtualFiles() {
        return Collections.unmodifiableMap(this.vfCache);
    }

    protected VirtualFile getRootVirtualFileForModification(ContentModification mod) {
        return this.vfCache.get(mod.getRootName());
    }

    private TwoPhaseCommitAction<T> createRemovalMetadataAction(ContentModification mod, boolean localLed) {
        if (localLed) {
            return new RemovalMetadataInsertionAction<T>(this.getSynchronizationActionContext(), mod);
        }
        return new NoOpSynchronizationAction<T>(this.getSynchronizationActionContext(), mod);
    }

    private void updateContentMetadata(RepositoryContentMetadata newOfficial) {
        if (!newOfficial.equals(this.officialContentMetadata)) {
            try {
                this.contentMetadataPersister.store(this.storeName, newOfficial);
            }
            catch (Exception e) {
                this.log.error((Object)("Caught exception persisting " + RepositoryContentMetadata.class.getSimpleName()), (Throwable)e);
            }
            this.officialContentMetadata = newOfficial;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"updateContentMetadata(): updated official metadata");
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"updateContentMetadata(): content is unchanged");
        }
        this.currentContentMetadata = null;
    }

    private void createItemMetadataFromScan(RepositoryRootMetadata rmd, RepositoryRootMetadata existingRMD, VirtualFile file, VirtualFile root) throws IOException {
        RepositoryItemMetadata existing;
        String originator;
        boolean directory = AbstractLocalContentManager.isDirectory(file);
        long timestamp = file.getLastModified();
        List<String> pathElements = AbstractLocalContentManager.getRelativePath(file, root);
        RepositoryItemMetadata md = new RepositoryItemMetadata(pathElements, timestamp, originator = (existing = existingRMD == null ? null : existingRMD.getItemMetadata(pathElements)) == null ? this.localNodeName : existing.getOriginatingNode(), directory, false);
        if (!md.equals(existing)) {
            md.setOriginatingNode(this.localNodeName);
        }
        rmd.getContent().add(md);
        if (directory) {
            for (VirtualFile child : file.getChildren()) {
                this.createItemMetadataFromScan(rmd, existingRMD, child, root);
            }
        }
    }

    private void validateSynchronization(SynchronizationId<?> id) {
        if (id == null) {
            throw new IllegalArgumentException("Null id");
        }
        if (this.currentSynchronizationActionContext == null) {
            throw new IllegalStateException("No active synchronization");
        }
        SynchronizationId<?> ours = ((SynchronizationActionContext)this.currentSynchronizationActionContext).getId();
        if (!id.equals(ours)) {
            throw new IllegalStateException(id + " does not match the current synchronization " + ours);
        }
    }

    private static boolean isDirectory(VirtualFile file) throws IOException {
        return file.isDirectory();
    }

    private static List<String> getRelativePath(VirtualFile file, VirtualFile root) throws IOException {
        VirtualFile now;
        ArrayList<String> reversed = new ArrayList<String>();
        for (now = file; now != null && !now.equals(root); now = now.getParent()) {
            reversed.add(now.getName());
        }
        if (now == null) {
            throw new IllegalArgumentException(file + " is not a child of " + root);
        }
        ArrayList<String> forward = new ArrayList<String>(reversed.size());
        for (int i = reversed.size() - 1; i > -1; --i) {
            forward.add((String)reversed.get(i));
        }
        return forward;
    }
}

