/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl.scriptassert;

import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.validation.ConstraintDeclarationException;

public class ScriptEvaluator {
    private final ScriptEngine engine;

    public ScriptEvaluator(ScriptEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(String script, Object obj, String objectAlias) {
        if (this.engineAllowsParallelAccessFromMultipleThreads()) {
            return this.doEvaluate(script, obj, objectAlias);
        }
        ScriptEngine scriptEngine = this.engine;
        synchronized (scriptEngine) {
            return this.doEvaluate(script, obj, objectAlias);
        }
    }

    private boolean doEvaluate(String script, Object obj, String objectAlias) {
        Object evaluationResult;
        this.engine.put(objectAlias, obj);
        try {
            evaluationResult = this.engine.eval(script);
        }
        catch (ScriptException e) {
            throw new ConstraintDeclarationException("Error during execution of script \"" + script + "\" occured.", (Throwable)e);
        }
        if (evaluationResult == null) {
            throw new ConstraintDeclarationException("Script \"" + script + "\" returned null, but must return either true or false.");
        }
        if (!(evaluationResult instanceof Boolean)) {
            throw new ConstraintDeclarationException("Script \"" + script + "\" returned " + evaluationResult + " (of type " + evaluationResult.getClass().getCanonicalName() + "), but must return either true or false.");
        }
        return Boolean.TRUE.equals(evaluationResult);
    }

    private boolean engineAllowsParallelAccessFromMultipleThreads() {
        String threadingType = (String)this.engine.getFactory().getParameter("THREADING");
        return "THREAD-ISOLATED".equals(threadingType) || "STATELESS".equals(threadingType);
    }
}

