/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLImpl;
import org.jboss.security.acl.config.ACLBaseDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLConfiguration {
    private final Map<String, ACLBaseDefinition> definitions = new HashMap<String, ACLBaseDefinition>();

    public void addDefinition(Object definition) {
        if (definition instanceof ACLBaseDefinition) {
            ACLBaseDefinition aclDefinition = (ACLBaseDefinition)definition;
            this.definitions.put(aclDefinition.getResource(), aclDefinition);
        }
    }

    public Set<ACL> getConfiguredACLs() {
        HashSet<ACL> configuredACLs = new HashSet<ACL>();
        for (ACLBaseDefinition definition : this.definitions.values()) {
            Set<ACLEntry> entries = this.getEntries(definition, new ArrayList<String>());
            ACLImpl acl = new ACLImpl(definition.getResource(), entries);
            configuredACLs.add(acl);
        }
        return configuredACLs;
    }

    private Set<ACLEntry> getEntries(ACLBaseDefinition definition, List<String> visitedACLs) {
        if (visitedACLs.contains(definition.getResource())) {
            throw new RuntimeException("Circular dependency between ACLs has been detected");
        }
        visitedACLs.add(definition.getResource());
        if (definition.getBaseResource() != null) {
            ACLBaseDefinition superDefinition = this.definitions.get(definition.getBaseResource());
            if (superDefinition != null) {
                Set<ACLEntry> superEntries = this.getEntries(superDefinition, visitedACLs);
                Set<ACLEntry> entries = definition.getEntries();
                entries.addAll(superEntries);
                return entries;
            }
            throw new RuntimeException("Parent ACL not found: " + definition.getBaseResource());
        }
        return definition.getEntries();
    }
}

