/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.lang.reflect.InvocationTargetException;
import javax.resource.spi.ResourceAdapter;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.resource.deployment.ConfigPropertyHandler;
import org.jboss.resource.deployment.DummyResourceAdapter;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.RARDeploymentMetaData;

public class ResourceAdapterFactory {
    public static final String DUMMY_RA_CLASS = DummyResourceAdapter.class.getName();

    public static ResourceAdapter createResourceAdapter(RARDeploymentMetaData ramd) throws Exception {
        ResourceAdapter adapter = ResourceAdapterFactory.createResourceAdapter(ramd.getConnectorMetaData());
        ConfigPropertyHandler configPropertyHandler = new ConfigPropertyHandler(adapter, adapter.getClass(), "ResourceAdapter: ");
        for (ConfigPropertyMetaData cpmd : ramd.getRaXmlMetaData().getProperties()) {
            ResourceAdapterFactory.applyProperty(configPropertyHandler, cpmd, adapter.getClass());
        }
        return adapter;
    }

    public static ResourceAdapter createResourceAdapter(ConnectorMetaData cmd) throws Exception {
        Class<?> raClass;
        String className = cmd.getRAClass();
        if (className == null) {
            className = DUMMY_RA_CLASS;
        }
        if (!ResourceAdapter.class.isAssignableFrom(raClass = Thread.currentThread().getContextClassLoader().loadClass(className))) {
            throw new DeploymentException(raClass.getName() + " is not a resource adapter class");
        }
        ResourceAdapter result = (ResourceAdapter)raClass.newInstance();
        ConfigPropertyHandler configPropertyHandler = new ConfigPropertyHandler(result, raClass, "ResourceAdapter: ");
        for (ConfigPropertyMetaData cpmd : cmd.getProperties()) {
            ResourceAdapterFactory.applyProperty(configPropertyHandler, cpmd, raClass);
        }
        return result;
    }

    private static void applyProperty(ConfigPropertyHandler configPropertyHandler, ConfigPropertyMetaData cpmd, Class clz) throws Exception {
        try {
            configPropertyHandler.handle(cpmd);
        }
        catch (InvocationTargetException e) {
            DeploymentException.rethrowAsDeploymentException((String)("Error for resource adapter class " + clz.getName() + " setting property " + cpmd), (Throwable)e.getTargetException());
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Error for resource adapter class " + clz.getName() + " accessing property setter " + cpmd), (Throwable)t);
        }
    }
}

