/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarDataModel<E>
extends DataModel<E> {
    private int _rowIndex = -1;
    private E _data;

    public ScalarDataModel() {
    }

    public ScalarDataModel(E scalar) {
        this.setWrappedData(scalar);
    }

    @Override
    public int getRowCount() {
        return this._data != null ? 1 : -1;
    }

    @Override
    public E getRowData() {
        if (this._data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._data;
    }

    @Override
    public int getRowIndex() {
        return this._rowIndex;
    }

    @Override
    public Object getWrappedData() {
        return this._data;
    }

    @Override
    public boolean isRowAvailable() {
        return this._data != null && this._rowIndex == 0;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this._data != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    @Override
    public void setWrappedData(Object data) {
        this._data = data;
        int rowIndex = this._data != null ? 0 : -1;
        this.setRowIndex(rowIndex);
    }
}

